/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.serialization.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemListTypeAdapter
extends TypeAdapter<List<Item>> {
    public void write(JsonWriter out, List<Item> items) throws IOException {
        if (items == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (Item item : items) {
            String key = ItemHelper.trimItemName(item.getDescriptionId());
            out.value(key);
        }
        out.endArray();
    }

    public List<Item> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList<Item> result = new ArrayList<Item>();
        in.beginArray();
        while (in.hasNext()) {
            String itemKey = in.nextString();
            ResourceLocation identifier = ResourceLocation.tryParse((String)(itemKey = ItemHelper.trimItemName(itemKey)));
            if (BuiltInRegistries.ITEM.containsKey(identifier)) {
                result.add((Item)BuiltInRegistries.ITEM.get(identifier));
                continue;
            }
            Debug.logWarning("Invalid item name: " + itemKey);
        }
        in.endArray();
        return result;
    }
}

