/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import com.player2.playerengine.automaton.api.utils.BlockOptionalMeta;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class BlockOptionalMetaLookup {
    private final BlockOptionalMeta[] boms;

    public BlockOptionalMetaLookup(BlockOptionalMeta ... boms) {
        this.boms = boms;
    }

    public BlockOptionalMetaLookup(class_3218 world, class_2248 ... blocks) {
        this.boms = (BlockOptionalMeta[])Stream.of(blocks).map(block -> new BlockOptionalMeta(world, (class_2248)block)).toArray(BlockOptionalMeta[]::new);
    }

    public BlockOptionalMetaLookup(class_3218 world, List<class_2248> blocks) {
        this.boms = (BlockOptionalMeta[])blocks.stream().map(block -> new BlockOptionalMeta(world, (class_2248)block)).toArray(BlockOptionalMeta[]::new);
    }

    public BlockOptionalMetaLookup(class_3218 world, String ... blocks) {
        this.boms = (BlockOptionalMeta[])Stream.of(blocks).map(block -> new BlockOptionalMeta(world, (String)block)).toArray(BlockOptionalMeta[]::new);
    }

    public boolean has(class_2248 block) {
        for (BlockOptionalMeta bom : this.boms) {
            if (bom.getBlock() != block) continue;
            return true;
        }
        return false;
    }

    public boolean has(class_2680 state) {
        for (BlockOptionalMeta bom : this.boms) {
            if (!bom.matches(state)) continue;
            return true;
        }
        return false;
    }

    public boolean has(class_1799 stack) {
        for (BlockOptionalMeta bom : this.boms) {
            if (!bom.matches(stack)) continue;
            return true;
        }
        return false;
    }

    public List<BlockOptionalMeta> blocks() {
        return Arrays.asList(this.boms);
    }

    public String toString() {
        return String.format("BlockOptionalMetaLookup{%s}", Arrays.toString(this.boms));
    }
}

