/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.command.defaults;

import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.cache.IRememberedInventory;
import com.player2.playerengine.automaton.api.command.Command;
import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.command.exception.CommandInvalidStateException;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ChestsCommand
extends Command {
    public ChestsCommand() {
        super("chests");
    }

    @Override
    public void execute(class_2168 source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
        args.requireMax(0);
        Set<Map.Entry<class_2338, IRememberedInventory>> entries = baritone.getEntityContext().worldData().getContainerMemory().getRememberedInventories().entrySet();
        if (entries.isEmpty()) {
            throw new CommandInvalidStateException("No remembered inventories");
        }
        for (Map.Entry<class_2338, IRememberedInventory> entry : entries) {
            BetterBlockPos pos = new BetterBlockPos(entry.getKey());
            IRememberedInventory inv = entry.getValue();
            this.logDirect(source, pos.toString());
            for (class_1799 item : inv.getContents()) {
                class_5250 component = (class_5250)item.method_7964();
                component.method_27693(String.format(" x %d", item.method_7947()));
                this.logDirect(source, new class_2561[]{component});
            }
        }
    }

    @Override
    public Stream<String> tabComplete(String label, IArgConsumer args) {
        return Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "Display remembered inventories";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("The chests command lists remembered inventories, I guess?", "", "Usage:", "> chests");
    }
}

