/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils.player;

import com.player2.playerengine.automaton.api.entity.IInteractionManagerProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInteractionManager;
import com.player2.playerengine.automaton.api.utils.IInteractionController;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_3965;

public class EntityInteractionController
implements IInteractionController {
    private final class_1309 player;
    private int sequence;

    public EntityInteractionController(class_1309 player) {
        this.player = player;
    }

    @Override
    public boolean hasBrokenBlock() {
        return this.getInteractionManager().hasBrokenBlock();
    }

    @Override
    public boolean onPlayerDamageBlock(class_2338 pos, class_2350 side) {
        LivingEntityInteractionManager interactionManager = this.getInteractionManager();
        if (interactionManager.isMining()) {
            int progress = interactionManager.getBlockBreakingProgress();
            if (progress >= 10) {
                this.getInteractionManager().processBlockBreakingAction(interactionManager.getMiningPos(), class_2846.class_2847.field_12973, side, this.player.method_37908().method_31600(), this.sequence++);
            }
            return true;
        }
        return false;
    }

    @Override
    public void resetBlockRemoving() {
        LivingEntityInteractionManager interactionManager = this.getInteractionManager();
        if (interactionManager.isMining()) {
            this.getInteractionManager().processBlockBreakingAction(interactionManager.getMiningPos(), class_2846.class_2847.field_12971, class_2350.field_11036, this.player.method_37908().method_31600(), this.sequence++);
        }
    }

    @Override
    public class_1934 getGameType() {
        return class_1934.field_9215;
    }

    @Override
    public class_1269 processRightClickBlock(class_1309 player, class_1937 world, class_1268 hand, class_3965 result) {
        return this.getInteractionManager().interactBlock(this.player, this.player.method_37908(), this.player.method_5998(hand), hand, result);
    }

    @Override
    public class_1269 processRightClick(class_1309 player, class_1937 world, class_1268 hand) {
        return this.getInteractionManager().interactItem(this.player, this.player.method_37908(), this.player.method_5998(hand), hand);
    }

    @Override
    public boolean clickBlock(class_2338 loc, class_2350 face) {
        class_2680 state = this.player.method_37908().method_8320(loc);
        if (state.method_26215()) {
            return false;
        }
        this.getInteractionManager().processBlockBreakingAction(loc, class_2846.class_2847.field_12968, face, this.player.method_37908().method_31600(), this.sequence++);
        return this.getInteractionManager().isMining() || this.player.method_37908().method_22347(loc);
    }

    public LivingEntityInteractionManager getInteractionManager() {
        LivingEntityInteractionManager livingEntityInteractionManager;
        class_1309 class_13092 = this.player;
        if (class_13092 instanceof IInteractionManagerProvider) {
            IInteractionManagerProvider managerProvider = (IInteractionManagerProvider)class_13092;
            livingEntityInteractionManager = managerProvider.getInteractionManager();
        } else {
            livingEntityInteractionManager = null;
        }
        return livingEntityInteractionManager;
    }

    @Override
    public void setHittingBlock(boolean hittingBlock) {
    }

    @Override
    public double getBlockReachDistance() {
        return 4.5;
    }
}

