/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.control.InputControls;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceStructureBlockTask;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3965;

public class SafeNetherPortalTask
extends Task {
    private final TimerGame wait = new TimerGame(1.0);
    private boolean keyReset = false;
    private boolean finished = false;
    private List<class_2338> positions = null;
    private List<class_2350> directions = null;
    private class_2350.class_2351 axis = null;

    @Override
    protected void onStart() {
        this.controller.getBaritone().getInputOverrideHandler().clearAllKeys();
        this.wait.reset();
    }

    @Override
    protected Task onTick() {
        if (!this.wait.elapsed()) {
            return null;
        }
        PlayerEngineController mod = this.controller;
        if (!this.keyReset) {
            this.keyReset = true;
            mod.getBaritone().getInputOverrideHandler().clearAllKeys();
        }
        if (mod.getPlayer().method_51848() < 10) {
            if (this.positions != null && this.directions != null) {
                boolean passed;
                class_2338 pos1 = mod.getPlayer().method_23312().method_30513(this.axis, 1);
                class_2338 pos2 = mod.getPlayer().method_23312().method_30513(this.axis, -1);
                if (mod.getWorld().method_8320(pos1).method_26215() || mod.getWorld().method_8320(pos1).method_26204().equals(class_2246.field_10114)) {
                    passed = false;
                    for (class_2350 dir : class_2350.values()) {
                        if (!mod.getWorld().method_8320(pos1.method_10084().method_10093(dir)).method_26204().equals(class_2246.field_10316)) continue;
                        passed = true;
                        break;
                    }
                    if (passed) {
                        return new ReplaceSafeBlock(pos1);
                    }
                }
                if (mod.getWorld().method_8320(pos2).method_26215() || mod.getWorld().method_8320(pos2).method_26204().equals(class_2246.field_10114)) {
                    passed = false;
                    for (class_2350 dirx : class_2350.values()) {
                        if (!mod.getWorld().method_8320(pos2.method_10084().method_10093(dirx)).method_26204().equals(class_2246.field_10316)) continue;
                        passed = true;
                        break;
                    }
                    if (passed) {
                        return new ReplaceSafeBlock(pos2);
                    }
                }
            }
            this.finished = true;
            this.setDebugState("We are not in a portal");
            return null;
        }
        class_2680 state = mod.getWorld().method_8320(mod.getPlayer().method_24515());
        if (this.positions != null && this.directions != null) {
            for (class_2338 pos : this.positions) {
                for (class_2350 dirxx : this.directions) {
                    class_2338 newPos = pos.method_10074().method_10093(dirxx);
                    if (!mod.getWorld().method_8320(newPos).method_26215() && !mod.getWorld().method_8320(newPos).method_26204().equals(class_2246.field_10114)) continue;
                    this.setDebugState("Changing block...");
                    return new ReplaceSafeBlock(newPos);
                }
            }
            this.finished = true;
            this.setDebugState("Portal is safe");
            return null;
        }
        if (state.method_26204().equals(class_2246.field_10316)) {
            this.axis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12529);
            this.positions = new ArrayList<class_2338>();
            this.positions.add(mod.getPlayer().method_24515());
            for (class_2350 dirxxx : class_2350.values()) {
                if (dirxxx.method_10166().method_10178()) continue;
                class_2338 pos = mod.getPlayer().method_24515().method_10093(dirxxx);
                if (!mod.getWorld().method_8320(pos).method_26204().equals(class_2246.field_10316)) continue;
                this.positions.add(pos);
            }
            this.directions = List.of(class_2350.field_11039, class_2350.field_11034);
            if (this.axis == class_2350.class_2351.field_11048) {
                this.directions = List.of(class_2350.field_11043, class_2350.field_11035);
            }
        } else {
            this.finished = true;
            this.setDebugState("We are not standing inside a nether portal block");
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        InputControls controls = this.controller.getInputControls();
        controls.release(Input.MOVE_FORWARD);
        controls.release(Input.SNEAK);
        controls.release(Input.CLICK_LEFT);
        this.controller.getBaritone().getInputOverrideHandler().clearAllKeys();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof SafeNetherPortalTask;
    }

    @Override
    protected String toDebugString() {
        return "Making nether portal safe";
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    private static class ReplaceSafeBlock
    extends Task {
        private final class_2338 pos;
        private boolean finished = false;

        public ReplaceSafeBlock(class_2338 pos) {
            this.pos = pos;
        }

        @Override
        protected void onStart() {
            this.controller.getBaritone().getInputOverrideHandler().clearAllKeys();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected Task onTick() {
            PlayerEngineController mod = this.controller;
            if (mod.getWorld().method_8320(this.pos).method_26215()) {
                this.setDebugState("Placing block...");
                return new PlaceStructureBlockTask(this.pos);
            }
            if (!this.controller.getWorld().method_8320(this.pos).method_26204().equals(class_2246.field_10114)) {
                this.finished = true;
                return null;
            }
            LookHelper.lookAt(mod, this.pos);
            class_239 class_2392 = mod.getPlayer().method_5745(3.0, 0.0f, true);
            if (class_2392 instanceof class_3965) {
                class_3965 blockHitResult = (class_3965)class_2392;
                if (mod.getWorld().method_8320(blockHitResult.method_17777()).method_26204().equals(class_2246.field_10316)) {
                    this.setDebugState("Getting closer to target...");
                    mod.getInputControls().hold(Input.MOVE_FORWARD);
                    mod.getInputControls().hold(Input.SNEAK);
                    return null;
                }
            }
            this.setDebugState("Breaking block");
            mod.getInputControls().release(Input.MOVE_FORWARD);
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().hold(Input.CLICK_LEFT);
            return null;
        }

        @Override
        protected void onStop(Task interruptTask) {
            InputControls controls = this.controller.getInputControls();
            controls.release(Input.MOVE_FORWARD);
            controls.release(Input.SNEAK);
            controls.release(Input.CLICK_LEFT);
            this.controller.getBaritone().getInputOverrideHandler().clearAllKeys();
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean isEqual(Task other) {
            if (!(other instanceof ReplaceSafeBlock)) return false;
            ReplaceSafeBlock same = (ReplaceSafeBlock)other;
            if (!same.pos.equals((Object)this.pos)) return false;
            return true;
        }

        @Override
        protected String toDebugString() {
            return "Making sure " + String.valueOf(this.pos) + " is safe";
        }
    }
}

