/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.entity.IInteractionManagerProvider;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.eventbus.EventBus;
import com.player2.playerengine.eventbus.Subscription;
import com.player2.playerengine.eventbus.events.BlockPlaceEvent;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import org.apache.commons.lang3.ArrayUtils;

public class PlaceBlockNearbyTask
extends Task {
    private final class_2248[] toPlace;
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private final TimeoutWanderTask wander = new TimeoutWanderTask(5.0f);
    private final TimerGame randomlookTimer = new TimerGame(0.25);
    private final Predicate<class_2338> canPlaceHere;
    private class_2338 justPlaced;
    private class_2338 tryPlace;
    private Subscription<BlockPlaceEvent> onBlockPlaced;

    public PlaceBlockNearbyTask(Predicate<class_2338> canPlaceHere, class_2248 ... toPlace) {
        this.toPlace = toPlace;
        this.canPlaceHere = canPlaceHere;
    }

    public PlaceBlockNearbyTask(class_2248 ... toPlace) {
        this((class_2338 blockPos) -> true, toPlace);
    }

    @Override
    protected void onStart() {
        this.progressChecker.reset();
        this.controller.getBaritone().getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, false);
        this.onBlockPlaced = EventBus.subscribe(BlockPlaceEvent.class, evt -> {
            if (ArrayUtils.contains((Object[])this.toPlace, (Object)evt.blockState.method_26204())) {
                this.stopPlacing();
            }
        });
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        class_1799 cursorStack = StorageHelper.getItemStackInCursorSlot(this.controller);
        class_2338 current = this.getCurrentlyLookingBlockPlace(mod);
        if (current != null && this.canPlaceHere.test(current)) {
            this.setDebugState("Placing since we can...");
            if (mod.getSlotHandler().forceEquipItem(ItemHelper.blocksToItems(this.toPlace)) && this.place(mod, current)) {
                return null;
            }
        }
        if (this.wander.isActive() && !this.wander.isFinished()) {
            this.setDebugState("Wandering, will try to place again later.");
            this.progressChecker.reset();
            return this.wander;
        }
        if (!this.progressChecker.check(mod)) {
            Debug.logMessage("Failed placing, wandering and trying again.");
            LookHelper.randomOrientation(this.controller);
            if (this.tryPlace != null) {
                mod.getBlockScanner().requestBlockUnreachable(this.tryPlace);
                this.tryPlace = null;
            }
            return this.wander;
        }
        if (this.tryPlace == null || !WorldHelper.canReach(this.controller, this.tryPlace)) {
            this.tryPlace = this.locateClosePlacePos(mod);
        }
        if (this.tryPlace != null) {
            this.setDebugState("Trying to place at " + String.valueOf(this.tryPlace));
            this.justPlaced = this.tryPlace;
            return new PlaceBlockTask(this.tryPlace, this.toPlace);
        }
        if (this.randomlookTimer.elapsed()) {
            this.randomlookTimer.reset();
            LookHelper.randomOrientation(this.controller);
        }
        this.setDebugState("Wandering until we randomly place or find a good place spot.");
        return new TimeoutWanderTask();
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.stopPlacing();
        EventBus.unsubscribe(this.onBlockPlaced);
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof PlaceBlockNearbyTask) {
            PlaceBlockNearbyTask task = (PlaceBlockNearbyTask)other;
            bl = Arrays.equals(task.toPlace, this.toPlace);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Place " + Arrays.toString(this.toPlace) + " nearby";
    }

    @Override
    public boolean isFinished() {
        return this.justPlaced != null && ArrayUtils.contains((Object[])this.toPlace, (Object)this.controller.getWorld().method_8320(this.justPlaced).method_26204());
    }

    public class_2338 getPlaced() {
        return this.justPlaced;
    }

    private class_2338 getCurrentlyLookingBlockPlace(PlayerEngineController mod) {
        class_239 class_2392 = class_310.method_1551().field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 bhit = (class_3965)class_2392;
            class_2338 bpos = bhit.method_17777();
            IEntityContext ctx = mod.getBaritone().getEntityContext();
            if (MovementHelper.canPlaceAgainst(ctx, bpos)) {
                class_2338 placePos = bhit.method_17777().method_10081(bhit.method_17780().method_10163());
                if (WorldHelper.isInsidePlayer(this.controller, placePos)) {
                    return null;
                }
                if (WorldHelper.canPlace(this.controller, placePos)) {
                    return placePos;
                }
            }
        }
        return null;
    }

    private boolean blockEquipped() {
        return StorageHelper.isEquipped(this.controller, ItemHelper.blocksToItems(this.toPlace));
    }

    private boolean place(PlayerEngineController mod, class_2338 targetPlace) {
        if (!mod.getExtraBaritoneSettings().isInteractionPaused() && this.blockEquipped()) {
            mod.getInputControls().hold(Input.SNEAK);
            class_239 mouseOver = class_310.method_1551().field_1765;
            if (mouseOver != null && mouseOver.method_17783() == class_239.class_240.field_1332) {
                class_1268 hand = class_1268.field_5808;
                if (((IInteractionManagerProvider)mod.getEntity()).getInteractionManager().interactBlock(mod.getPlayer(), (class_1937)mod.getWorld(), mod.getPlayer().method_6047(), hand, (class_3965)mouseOver) == class_1269.field_5812 && mod.getPlayer().method_5715()) {
                    mod.getPlayer().method_6104(hand);
                    this.justPlaced = targetPlace;
                    Debug.logMessage("PRESSED");
                    return true;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void stopPlacing() {
        this.controller.getInputControls().release(Input.SNEAK);
        this.controller.getBaritone().getBuilderProcess().onLostControl();
    }

    private class_2338 locateClosePlacePos(PlayerEngineController mod) {
        int range = 7;
        class_2338 best = null;
        double smallestScore = Double.POSITIVE_INFINITY;
        class_2338 start = mod.getPlayer().method_24515().method_10069(-range, -range, -range);
        class_2338 end = mod.getPlayer().method_24515().method_10069(range, range, range);
        for (class_2338 blockPos : WorldHelper.scanRegion(start, end)) {
            boolean solid = WorldHelper.isSolidBlock(this.controller, blockPos);
            boolean inside = WorldHelper.isInsidePlayer(this.controller, blockPos);
            if (solid && !WorldHelper.canBreak(this.controller, blockPos) || !this.canPlaceHere.test(blockPos) || !WorldHelper.canReach(this.controller, blockPos) || !WorldHelper.canPlace(this.controller, blockPos)) continue;
            boolean hasBelow = WorldHelper.isSolidBlock(this.controller, blockPos.method_10074());
            double distSq = BlockPosVer.getSquaredDistance(blockPos, (class_2374)mod.getPlayer().method_19538());
            double d = distSq + (double)(solid ? 4 : 0) + (double)(hasBelow ? 0 : 10);
            int n = inside ? 3 : 0;
            double score = d + (double)n;
            if (!(score < smallestScore)) continue;
            best = blockPos;
            smallestScore = score;
        }
        return best;
    }
}

