/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.StlHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2680;

public class CollectCropTask
extends ResourceTask {
    private final ItemTarget cropToCollect;
    private final class_1792[] cropSeed;
    private final Predicate<class_2338> canBreak;
    private final class_2248[] cropBlock;
    private final Set<class_2338> emptyCropland = new HashSet<class_2338>();
    private final Task collectSeedTask;
    private final HashSet<class_2338> wasFullyGrown = new HashSet();

    public CollectCropTask(ItemTarget cropToCollect, class_2248[] cropBlock, class_1792[] cropSeed, Predicate<class_2338> canBreak) {
        super(cropToCollect);
        this.cropToCollect = cropToCollect;
        this.cropSeed = cropSeed;
        this.canBreak = canBreak;
        this.cropBlock = cropBlock;
        this.collectSeedTask = new PickupDroppedItemTask(new ItemTarget(cropSeed, 1), true);
    }

    public CollectCropTask(ItemTarget cropToCollect, class_2248[] cropBlock, class_1792 ... cropSeed) {
        this(cropToCollect, cropBlock, cropSeed, (class_2338 canBreak) -> true);
    }

    public CollectCropTask(ItemTarget cropToCollect, class_2248 cropBlock, class_1792 ... cropSeed) {
        this(cropToCollect, new class_2248[]{cropBlock}, cropSeed);
    }

    public CollectCropTask(class_1792 cropItem, int count, class_2248 cropBlock, class_1792 ... cropSeed) {
        this(new ItemTarget(cropItem, count), cropBlock, cropSeed);
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (this.hasEmptyCrops(mod) && mod.getModSettings().shouldReplantCrops() && !mod.getItemStorage().hasItem(this.cropSeed)) {
            Optional<class_1542> closest;
            if (this.collectSeedTask.isActive() && !this.collectSeedTask.isFinished()) {
                this.setDebugState("Picking up dropped seeds");
                return this.collectSeedTask;
            }
            if (mod.getEntityTracker().itemDropped(this.cropSeed) && (closest = mod.getEntityTracker().getClosestItemDrop(mod.getPlayer().method_19538(), this.cropSeed)).isPresent() && closest.get().method_24516((class_1297)mod.getPlayer(), 7.0)) {
                return this.collectSeedTask;
            }
        }
        if (this.shouldReplantNow(mod)) {
            this.setDebugState("Replanting...");
            this.emptyCropland.removeIf(blockPos -> !this.isEmptyCrop(mod, (class_2338)blockPos));
            assert (!this.emptyCropland.isEmpty());
            return new DoToClosestBlockTask(blockPos -> new InteractWithBlockTask(new ItemTarget(this.cropSeed, 1), class_2350.field_11036, blockPos.method_10074(), true), pos -> this.emptyCropland.stream().min(StlHelper.compareValues(block -> BlockPosVer.getSquaredDistance(block, (class_2374)pos))), this.emptyCropland::contains, class_2246.field_10362);
        }
        Predicate<class_2338> validCrop = blockPos -> !this.canBreak.test((class_2338)blockPos) ? false : (mod.getModSettings().shouldReplantCrops() && !this.isMature(mod, (class_2338)blockPos) ? false : (mod.getWorld().method_8320(blockPos).method_26204() == class_2246.field_10293 ? this.isMature(mod, (class_2338)blockPos) : true));
        if (this.isInWrongDimension(mod) && !mod.getBlockScanner().anyFound(validCrop, this.cropBlock)) {
            return this.getToCorrectDimensionTask(mod);
        }
        this.setDebugState("Breaking crops.");
        return new DoToClosestBlockTask(blockPos -> {
            this.emptyCropland.add((class_2338)blockPos);
            return new DestroyBlockTask((class_2338)blockPos);
        }, validCrop, this.cropBlock);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return this.shouldReplantNow(this.controller) ? false : super.isFinished();
    }

    private boolean shouldReplantNow(PlayerEngineController mod) {
        return mod.getModSettings().shouldReplantCrops() && this.hasEmptyCrops(mod) && mod.getItemStorage().hasItem(this.cropSeed);
    }

    private boolean hasEmptyCrops(PlayerEngineController mod) {
        for (class_2338 pos : this.emptyCropland) {
            if (!this.isEmptyCrop(mod, pos)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmptyCrop(PlayerEngineController mod, class_2338 pos) {
        return WorldHelper.isAir(mod.getWorld().method_8320(pos).method_26204());
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (!(other instanceof CollectCropTask)) {
            bl = false;
        } else {
            CollectCropTask task = (CollectCropTask)other;
            bl = Arrays.equals(task.cropSeed, this.cropSeed) && Arrays.equals(task.cropBlock, this.cropBlock) && task.cropToCollect.equals(this.cropToCollect);
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting crops: " + String.valueOf(this.cropToCollect);
    }

    private boolean isMature(PlayerEngineController mod, class_2338 blockPos) {
        if (mod.getChunkTracker().isChunkLoaded(blockPos) && WorldHelper.canReach(this.controller, blockPos)) {
            class_2680 s = mod.getWorld().method_8320(blockPos);
            class_2248 class_22482 = s.method_26204();
            if (class_22482 instanceof class_2302) {
                class_2302 crop = (class_2302)class_22482;
                boolean mature = crop.method_9825(s);
                if (this.wasFullyGrown.contains(blockPos)) {
                    if (!mature) {
                        this.wasFullyGrown.remove(blockPos);
                    }
                } else if (mature) {
                    this.wasFullyGrown.add(blockPos);
                }
                return mature;
            }
            return false;
        }
        return this.wasFullyGrown.contains(blockPos);
    }
}

