/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.CraftInTableTask;
import com.player2.playerengine.tasks.container.SmeltInFurnaceTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public class CollectGoldIngotTask
extends ResourceTask {
    private final int count;

    public CollectGoldIngotTask(int count) {
        super(class_1802.field_8695, count);
        this.count = count;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (WorldHelper.getCurrentDimension(mod) == Dimension.OVERWORLD) {
            return new SmeltInFurnaceTask(new SmeltTarget(new ItemTarget(class_1802.field_8695, this.count), new ItemTarget(class_1802.field_33402, this.count), new class_1792[0]));
        }
        if (WorldHelper.getCurrentDimension(mod) == Dimension.NETHER) {
            int nuggs = mod.getItemStorage().getItemCount(class_1802.field_8397);
            int nuggs_needed = this.count * 9 - mod.getItemStorage().getItemCount(class_1802.field_8695) * 9;
            if (nuggs >= nuggs_needed) {
                ItemTarget n = new ItemTarget(class_1802.field_8397);
                CraftingRecipe recipe = CraftingRecipe.newShapedRecipe("gold_ingot", new ItemTarget[]{n, n, n, n, n, n, n, n, n}, 1);
                return new CraftInTableTask(new RecipeTarget(class_1802.field_8695, this.count, recipe));
            }
            return new MineAndCollectTask(new ItemTarget(class_1802.field_8397, this.count * 9), new class_2248[]{class_2246.field_23077}, MiningRequirement.WOOD);
        }
        return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectGoldIngotTask && ((CollectGoldIngotTask)other).count == this.count;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " gold.";
    }
}

