/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceObsidianBucketTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.tasks.resources.SatisfyMiningRequirementTask;
import com.player2.playerengine.tasks.resources.TradeWithPiglinsTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.time.TimerGame;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3959;

public class CollectObsidianTask
extends ResourceTask {
    private final TimerGame placeWaterTimeout = new TimerGame(6.0);
    private final MovementProgressChecker lavaTimeout = new MovementProgressChecker();
    private final Set<class_2338> lavaBlacklist = new HashSet<class_2338>();
    private final int count;
    private Task forceCompleteTask = null;
    private class_2338 lavaWaitCurrentPos;
    private PlaceObsidianBucketTask placeObsidianTask;

    public CollectObsidianTask(int count) {
        super(class_1802.field_8281, count);
        this.count = count;
    }

    private static class_2338 getLavaStructurePos(class_2338 lavaPos) {
        return lavaPos.method_10069(1, 1, 0);
    }

    private static class_2338 getLavaWaterPos(class_2338 lavaPos) {
        return lavaPos.method_10084();
    }

    private static class_2338 getGoodObsidianPosition(PlayerEngineController mod) {
        class_2338 start = mod.getPlayer().method_24515().method_10069(-3, -3, -3);
        class_2338 end = mod.getPlayer().method_24515().method_10069(3, 3, 3);
        for (class_2338 pos : WorldHelper.scanRegion(start, end)) {
            if (WorldHelper.canBreak(mod, pos) && WorldHelper.canPlace(mod, pos)) continue;
            return null;
        }
        return mod.getPlayer().method_24515();
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
        mod.getBehaviour().setRayTracingFluidHandling(class_3959.class_242.field_1345);
        mod.getBehaviour().avoidBlockPlacing(pos -> this.lavaWaitCurrentPos != null ? pos.equals((Object)this.lavaWaitCurrentPos) || pos.equals((Object)CollectObsidianTask.getLavaWaterPos(this.lavaWaitCurrentPos)) : false);
        mod.getBehaviour().avoidBlockBreaking(pos -> this.lavaWaitCurrentPos != null ? pos.equals((Object)CollectObsidianTask.getLavaStructurePos(this.lavaWaitCurrentPos)) : false);
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        class_2338 goodPos;
        if (this.lavaWaitCurrentPos != null && mod.getChunkTracker().isChunkLoaded(this.lavaWaitCurrentPos) && mod.getWorld().method_8320(this.lavaWaitCurrentPos).method_26204() != class_2246.field_10164) {
            this.lavaWaitCurrentPos = null;
        }
        if (!StorageHelper.miningRequirementMet(this.controller, MiningRequirement.DIAMOND)) {
            this.setDebugState("Getting diamond pickaxe first");
            return new SatisfyMiningRequirementTask(MiningRequirement.DIAMOND);
        }
        if (this.forceCompleteTask != null && this.forceCompleteTask.isActive() && !this.forceCompleteTask.isFinished()) {
            return this.forceCompleteTask;
        }
        Predicate<class_2338> goodObsidian = blockPos -> blockPos.method_19769((class_2374)mod.getPlayer().method_19538(), 800.0) && WorldHelper.canBreak(mod, blockPos);
        if (mod.getBlockScanner().anyFound(goodObsidian, class_2246.field_10540) || mod.getEntityTracker().itemDropped(class_1802.field_8281)) {
            this.setDebugState("Mining/Collecting obsidian");
            this.placeObsidianTask = null;
            return new MineAndCollectTask(new ItemTarget(class_1802.field_8281, this.count), new class_2248[]{class_2246.field_10540}, MiningRequirement.DIAMOND);
        }
        if (WorldHelper.getCurrentDimension(mod) == Dimension.NETHER) {
            double AVERAGE_GOLD_PER_OBSIDIAN = 11.475;
            int gold_buffer = (int)(11.475 * (double)this.count);
            this.setDebugState("We can't place water, so we're trading for obsidian");
            return new TradeWithPiglinsTask(gold_buffer, class_1802.field_8281, this.count);
        }
        if (this.placeObsidianTask == null) {
            goodPos = CollectObsidianTask.getGoodObsidianPosition(mod);
            if (goodPos == null) {
                this.setDebugState("Walking until we find a spot to place obsidian");
                return new TimeoutWanderTask();
            }
            this.placeObsidianTask = new PlaceObsidianBucketTask(goodPos);
        }
        if (this.placeObsidianTask != null && !mod.getItemStorage().hasItem(class_1802.field_8187) && !this.placeObsidianTask.getPos().method_19769((class_2374)mod.getPlayer().method_19538(), 4.0) && (goodPos = CollectObsidianTask.getGoodObsidianPosition(mod)) != null) {
            Debug.logMessage("(nudged obsidian target closer)");
            this.placeObsidianTask = new PlaceObsidianBucketTask(goodPos);
        }
        this.setDebugState("Placing Obsidian");
        return this.placeObsidianTask;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof CollectObsidianTask) {
            CollectObsidianTask task = (CollectObsidianTask)other;
            bl = task.count == this.count;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect " + this.count + " blocks of obsidian";
    }
}

