/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.CraftInTableTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.RecipeTarget;
import net.minecraft.class_1792;

public abstract class CraftWithMatchingMaterialsTask
extends ResourceTask {
    private final ItemTarget target;
    private final CraftingRecipe recipe;
    private final boolean[] sameMask;
    private final ItemTarget sameResourceTarget;
    private final int sameResourceRequiredCount;
    private final int sameResourcePerRecipe;

    public CraftWithMatchingMaterialsTask(ItemTarget target, CraftingRecipe recipe, boolean[] sameMask) {
        super(target);
        this.target = target;
        this.recipe = recipe;
        this.sameMask = sameMask;
        int sameResourceRequiredCount = 0;
        ItemTarget sameResourceTarget = null;
        if (recipe.getSlotCount() != sameMask.length) {
            Debug.logError("Invalid CraftWithMatchingMaterialsTask constructor parameters: Recipe size must equal \"sameMask\" size.");
        }
        for (int i = 0; i < recipe.getSlotCount(); ++i) {
            if (!sameMask[i]) continue;
            ++sameResourceRequiredCount;
            sameResourceTarget = recipe.getSlot(i);
        }
        this.sameResourceTarget = sameResourceTarget;
        int craftsNeeded = (int)(1.0 + Math.floor((double)(target.getTargetCount() / recipe.outputCount()) - 0.001));
        this.sameResourcePerRecipe = sameResourceRequiredCount;
        this.sameResourceRequiredCount = sameResourceRequiredCount * craftsNeeded;
    }

    private static CraftingRecipe generateSameRecipe(CraftingRecipe diverseRecipe, class_1792 sameItem, boolean[] sameMask) {
        ItemTarget[] result = new ItemTarget[diverseRecipe.getSlotCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = sameMask[i] ? new ItemTarget(sameItem, 1) : diverseRecipe.getSlot(i);
        }
        return CraftingRecipe.newShapedRecipe(result, diverseRecipe.outputCount());
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        int canCraftTotal = 0;
        int majorityCraftCount = 0;
        class_1792 majorityCraftItem = null;
        for (class_1792 class_17922 : this.sameResourceTarget.getMatches()) {
            int count = this.getExpectedTotalCountOfSameItem(mod, class_17922);
            int canCraft = count / this.sameResourcePerRecipe * this.recipe.outputCount();
            canCraftTotal += canCraft;
            if (canCraft <= majorityCraftCount) continue;
            majorityCraftCount = canCraft;
            majorityCraftItem = class_17922;
        }
        int currentTargetCount = mod.getItemStorage().getItemCount(this.target);
        int currentTargetsRequired = this.target.getTargetCount() - currentTargetCount;
        if (canCraftTotal < currentTargetsRequired) {
            return this.getAllSameResourcesTask(mod);
        }
        int trueCanCraftTotal = 0;
        for (class_1792 sameCheckx : this.sameResourceTarget.getMatches()) {
            int trueCount = mod.getItemStorage().getItemCount(sameCheckx);
            int trueCanCraft = trueCount / this.sameResourcePerRecipe * this.recipe.outputCount();
            trueCanCraftTotal += trueCanCraft;
        }
        if (trueCanCraftTotal < currentTargetsRequired) {
            return this.getSpecificSameResourceTask(mod, this.sameResourceTarget.getMatches());
        }
        CraftingRecipe craftingRecipe = CraftWithMatchingMaterialsTask.generateSameRecipe(this.recipe, majorityCraftItem, this.sameMask);
        int var20 = Math.min(majorityCraftCount, this.target.getTargetCount());
        class_1792 output = this.getSpecificItemCorrespondingToMajorityResource(majorityCraftItem);
        var20 = Math.min(this.target.getTargetCount(), var20 + mod.getItemStorage().getItemCount(output));
        RecipeTarget recipeTarget = new RecipeTarget(output, var20, craftingRecipe);
        return this.recipe.isBig() ? new CraftInTableTask(recipeTarget) : new CraftInInventoryTask(recipeTarget);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    protected Task getAllSameResourcesTask(PlayerEngineController mod) {
        ItemTarget infinityVersion = new ItemTarget(this.sameResourceTarget, 999999);
        return TaskCatalogue.getItemTask(infinityVersion);
    }

    protected int getExpectedTotalCountOfSameItem(PlayerEngineController mod, class_1792 sameItem) {
        return mod.getItemStorage().getItemCount(sameItem);
    }

    protected Task getSpecificSameResourceTask(PlayerEngineController mod, class_1792[] toGet) {
        Debug.logError("Uh oh!!! getSpecificSameResourceTask should be implemented!!!! Now we're stuck.");
        return null;
    }

    protected abstract class_1792 getSpecificItemCorrespondingToMajorityResource(class_1792 var1);
}

