/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.tasks.resources.CollectFoodTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.ItemPriorityCalculator;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.slots.Slot;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2242;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2271;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2439;
import net.minecraft.class_2680;

public class CollectFoodPriorityCalculator
extends ItemPriorityCalculator {
    private final PlayerEngineController mod;
    private final double foodUnits;

    public CollectFoodPriorityCalculator(PlayerEngineController mod, double foodUnits) {
        super(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.mod = mod;
        this.foodUnits = foodUnits;
    }

    @Override
    public double calculatePriority(int count) {
        double distance = this.getDistance(this.mod);
        double multiplier = 1.0;
        double foodPotential = CollectFoodTask.calculateFoodPotential(this.mod);
        if (Double.isInfinite(distance) && foodPotential < this.foodUnits) {
            return 0.1;
        }
        Optional<class_2338> hay = this.mod.getBlockScanner().getNearestBlock(class_2246.field_10359);
        if (hay.isPresent() && WorldHelper.inRangeXZ(hay.get(), this.mod.getPlayer().method_24515(), 75.0) || this.mod.getEntityTracker().itemDropped(class_1802.field_17528)) {
            multiplier = 50.0;
        }
        if (foodPotential > this.foodUnits) {
            if (foodPotential > this.foodUnits + 20.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return distance > 10.0 && hay.isEmpty() ? Double.NEGATIVE_INFINITY : 17.0 / distance * 30.0 / (double)count / 2.0 * multiplier;
        }
        if (foodPotential < 10.0) {
            multiplier = Math.max(11.0 / foodPotential, 22.0);
        }
        return 33.0 / distance * 37.0 * multiplier;
    }

    private double getDistance(PlayerEngineController mod) {
        double dist;
        class_1309 clientPlayerEntity = mod.getPlayer();
        for (class_1792 class_17922 : CollectFoodTask.ITEMS_TO_PICK_UP) {
            dist = this.pickupTaskOrNull(mod, class_17922);
            if (dist == Double.NEGATIVE_INFINITY) continue;
            return dist;
        }
        for (CollectFoodTask.CookableFoodTarget cookableFoodTarget : CollectFoodTask.COOKABLE_FOODS) {
            dist = this.pickupTaskOrNull(mod, cookableFoodTarget.getRaw(), 20.0);
            if (dist == Double.NEGATIVE_INFINITY) {
                dist = this.pickupTaskOrNull(mod, cookableFoodTarget.getCooked(), 40.0);
            }
            if (dist == Double.NEGATIVE_INFINITY) continue;
            return dist;
        }
        double d = this.pickupBlockTaskOrNull(mod, class_2246.field_10359, class_1802.field_17528, 300.0);
        if (d != Double.NEGATIVE_INFINITY) {
            return d;
        }
        for (CollectFoodTask.CropTarget target : CollectFoodTask.CROPS) {
            double t = this.pickupBlockTaskOrNull(mod, target.cropBlock, target.cropItem, blockPos -> {
                class_2680 s = mod.getWorld().method_8320(blockPos);
                class_2248 b = s.method_26204();
                if (b instanceof class_2302) {
                    boolean isWheat;
                    boolean bl = isWheat = !(b instanceof class_2439) && !(b instanceof class_2271) && !(b instanceof class_2242);
                    if (isWheat) {
                        if (!mod.getChunkTracker().isChunkLoaded((class_2338)blockPos)) {
                            return false;
                        }
                        class_2302 crop = (class_2302)b;
                        return crop.method_9825(s);
                    }
                }
                return WorldHelper.canBreak(mod, blockPos);
            }, 96.0);
            if (t == Double.NEGATIVE_INFINITY) continue;
            return t;
        }
        double bestScore = 0.0;
        class_1297 bestEntity = null;
        Predicate<class_1297> notBaby = entity -> {
            class_1309 livingEntity;
            if (!(entity instanceof class_1309) || !(livingEntity = (class_1309)entity).method_6109()) {
                // empty if block
            }
            return false;
        };
        for (CollectFoodTask.CookableFoodTarget cookable : CollectFoodTask.COOKABLE_FOODS) {
            double sqDistance;
            int hungerPerformance;
            double score;
            Optional<class_1297> nearest;
            if (!mod.getEntityTracker().entityFound(cookable.mobToKill) || (nearest = mod.getEntityTracker().getClosestEntity(mod.getPlayer().method_19538(), notBaby, cookable.mobToKill)).isEmpty() || !((score = 100.0 * (double)(hungerPerformance = cookable.getCookedUnits()) / (sqDistance = nearest.get().method_5858((class_1297)mod.getPlayer()))) > bestScore)) continue;
            bestScore = score;
            bestEntity = nearest.get();
        }
        if (bestEntity != null) {
            return bestEntity.method_5739((class_1297)clientPlayerEntity);
        }
        double berryPickup = this.pickupBlockTaskOrNull(mod, class_2246.field_16999, class_1802.field_16998, 96.0);
        return berryPickup != Double.NEGATIVE_INFINITY ? berryPickup : Double.POSITIVE_INFINITY;
    }

    private double pickupBlockTaskOrNull(PlayerEngineController mod, class_2248 blockToCheck, class_1792 itemToGrab, double maxRange) {
        return this.pickupBlockTaskOrNull(mod, blockToCheck, itemToGrab, toAccept -> true, maxRange);
    }

    private double pickupBlockTaskOrNull(PlayerEngineController mod, class_2248 blockToCheck, class_1792 itemToGrab, Predicate<class_2338> accept, double maxRange) {
        Predicate<class_2338> acceptPlus = blockPos -> !WorldHelper.canBreak(mod, blockPos) ? false : accept.test((class_2338)blockPos);
        Optional<Object> nearestBlock = mod.getBlockScanner().getNearestBlock(mod.getPlayer().method_19538(), acceptPlus, blockToCheck);
        if (nearestBlock.isPresent() && !nearestBlock.get().method_19769((class_2374)mod.getPlayer().method_19538(), maxRange)) {
            nearestBlock = Optional.empty();
        }
        Optional<Object> nearestDrop = Optional.empty();
        if (mod.getEntityTracker().itemDropped(itemToGrab)) {
            nearestDrop = mod.getEntityTracker().getClosestItemDrop(mod.getPlayer().method_19538(), itemToGrab);
        }
        if (nearestDrop.isPresent()) {
            return ((class_1542)nearestDrop.get()).method_5739((class_1297)mod.getPlayer());
        }
        return nearestBlock.isPresent() ? Math.sqrt(mod.getPlayer().method_5707(WorldHelper.toVec3d((class_2338)nearestBlock.get()))) : Double.NEGATIVE_INFINITY;
    }

    private double pickupTaskOrNull(PlayerEngineController mod, class_1792 itemToGrab) {
        return this.pickupTaskOrNull(mod, itemToGrab, Double.POSITIVE_INFINITY);
    }

    private double pickupTaskOrNull(PlayerEngineController mod, class_1792 itemToGrab, double maxRange) {
        Optional<Object> nearestDrop = Optional.empty();
        if (mod.getEntityTracker().itemDropped(itemToGrab)) {
            nearestDrop = mod.getEntityTracker().getClosestItemDrop(mod.getPlayer().method_19538(), itemToGrab);
        }
        if (nearestDrop.isPresent() && ((class_1542)nearestDrop.get()).method_24516((class_1297)mod.getPlayer(), maxRange)) {
            class_1799 stack;
            Optional<Slot> slot;
            if (mod.getItemStorage().getSlotsThatCanFitInPlayerInventory(((class_1542)nearestDrop.get()).method_6983(), false).isEmpty() && (slot = StorageHelper.getGarbageSlot(mod)).isPresent() && ItemVer.isFood((stack = StorageHelper.getItemStackInSlot(slot.get())).method_7909())) {
                int inventoryCost = ItemVer.getFoodComponent(stack.method_7909()).getHunger() * stack.method_7947();
                double hunger = 0.0;
                if (ItemVer.isFood(itemToGrab)) {
                    hunger = ItemVer.getFoodComponent(itemToGrab).getHunger();
                } else if (itemToGrab.equals(class_1802.field_8861)) {
                    hunger += (double)ItemVer.getFoodComponent(class_1802.field_8229).getHunger() / 3.0;
                } else {
                    mod.log("unknown food item: " + String.valueOf(itemToGrab));
                }
                int groundCost = (int)(hunger * (double)((class_1542)nearestDrop.get()).method_6983().method_7947());
                if (inventoryCost > groundCost) {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            return ((class_1542)nearestDrop.get()).method_5739((class_1297)mod.getPlayer());
        }
        return Double.NEGATIVE_INFINITY;
    }
}

