/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.util.Debug;
import dev.architectury.event.events.common.ChunkEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2812;

public class SimpleChunkTracker {
    private final PlayerEngineController mod;
    private final Set<class_1923> loaded = new HashSet<class_1923>();

    public SimpleChunkTracker(PlayerEngineController mod) {
        this.mod = mod;
        ChunkEvent.LOAD_DATA.register((chunk, level, data) -> this.onLoad(chunk.method_12004()));
        ChunkEvent.SAVE_DATA.register((chunk, level, data) -> this.onUnload(chunk.method_12004()));
    }

    private void onLoad(class_1923 pos) {
        this.loaded.add(pos);
    }

    private void onUnload(class_1923 pos) {
        this.loaded.remove(pos);
    }

    public boolean isChunkLoaded(class_1923 pos) {
        return !(this.mod.getWorld().method_8497(pos.field_9181, pos.field_9180) instanceof class_2812);
    }

    public boolean isChunkLoaded(class_2338 pos) {
        return this.isChunkLoaded(new class_1923(pos));
    }

    public List<class_1923> getLoadedChunks() {
        ArrayList<class_1923> result = new ArrayList<class_1923>(this.loaded);
        return result.stream().filter(this::isChunkLoaded).distinct().collect(Collectors.toList());
    }

    public boolean scanChunk(class_1923 chunk, Predicate<class_2338> onBlockStop) {
        if (!this.isChunkLoaded(chunk)) {
            return false;
        }
        int bottomY = this.mod.getWorld().method_31607();
        int topY = this.mod.getWorld().method_31600();
        for (int xx = chunk.method_8326(); xx <= chunk.method_8327(); ++xx) {
            for (int yy = bottomY; yy <= topY; ++yy) {
                for (int zz = chunk.method_8328(); zz <= chunk.method_8329(); ++zz) {
                    if (!onBlockStop.test(new class_2338(xx, yy, zz))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void scanChunk(class_1923 chunk, Consumer<class_2338> onBlock) {
        this.scanChunk(chunk, (class_2338 block) -> {
            onBlock.accept((class_2338)block);
            return false;
        });
    }

    public void reset(PlayerEngineController mod) {
        Debug.logInternal("CHUNKS RESET");
        this.loaded.clear();
    }
}

