/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.player2.playerengine.automaton.KeepName;
import com.player2.playerengine.automaton.command.defaults.DefaultCommands;
import com.player2.playerengine.automaton.entity.CustomFishingBobberEntity;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@KeepName
public final class PlayerEngine {
    public static final Logger LOGGER = LogManager.getLogger((String)"PlayerEngine");
    public static final String MOD_ID = "playerengine";
    public static final String MOD_NAME = "PlayerEngine";
    public static final TagKey<Item> EMPTY_BUCKETS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)PlayerEngine.id("empty_buckets"));
    public static final TagKey<Item> WATER_BUCKETS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)PlayerEngine.id("water_buckets"));
    private static final ThreadPoolExecutor threadPool;
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES;
    public static RegistrySupplier<EntityType<CustomFishingBobberEntity>> FISHING_BOBBER;

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static ThreadPoolExecutor getExecutor() {
        return threadPool;
    }

    public static void onInitialize() {
        DefaultCommands.registerAll();
        ENTITY_TYPES.register();
    }

    static {
        ENTITY_TYPES = DeferredRegister.create((String)MOD_ID, (ResourceKey)Registries.ENTITY_TYPE);
        FISHING_BOBBER = ENTITY_TYPES.register("custom_fishing_bobber", () -> EntityType.Builder.of(CustomFishingBobberEntity::new, (MobCategory)MobCategory.CREATURE).sized(EntityType.FISHING_BOBBER.getWidth(), EntityType.FISHING_BOBBER.getHeight()).clientTrackingRange(64).updateInterval(1).build("custom_fishing_bobber"));
        AtomicInteger threadCounter = new AtomicInteger(0);
        threadPool = new ThreadPoolExecutor(4, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> new Thread(r, "PlayerEngine Worker " + threadCounter.incrementAndGet()));
    }
}

