/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.container.CraftInTableTask;
import com.player2.playerengine.tasks.container.SmeltInFurnaceTask;
import com.player2.playerengine.tasks.container.UpgradeInSmithingTableTask;
import com.player2.playerengine.tasks.resources.CarveThenCollectTask;
import com.player2.playerengine.tasks.resources.CollectAmethystBlockTask;
import com.player2.playerengine.tasks.resources.CollectBedTask;
import com.player2.playerengine.tasks.resources.CollectBlazeRodsTask;
import com.player2.playerengine.tasks.resources.CollectBlockByOneTask;
import com.player2.playerengine.tasks.resources.CollectBucketLiquidTask;
import com.player2.playerengine.tasks.resources.CollectCoarseDirtTask;
import com.player2.playerengine.tasks.resources.CollectCocoaBeansTask;
import com.player2.playerengine.tasks.resources.CollectCropTask;
import com.player2.playerengine.tasks.resources.CollectDripstoneBlockTask;
import com.player2.playerengine.tasks.resources.CollectEggsTask;
import com.player2.playerengine.tasks.resources.CollectFlintTask;
import com.player2.playerengine.tasks.resources.CollectFlowerTask;
import com.player2.playerengine.tasks.resources.CollectGoldIngotTask;
import com.player2.playerengine.tasks.resources.CollectGoldNuggetsTask;
import com.player2.playerengine.tasks.resources.CollectHayBlockTask;
import com.player2.playerengine.tasks.resources.CollectHoneycombTask;
import com.player2.playerengine.tasks.resources.CollectIronIngotTask;
import com.player2.playerengine.tasks.resources.CollectMagmaCreamTask;
import com.player2.playerengine.tasks.resources.CollectMilkTask;
import com.player2.playerengine.tasks.resources.CollectNetherBricksTask;
import com.player2.playerengine.tasks.resources.CollectObsidianTask;
import com.player2.playerengine.tasks.resources.CollectPlanksTask;
import com.player2.playerengine.tasks.resources.CollectRedSandstoneTask;
import com.player2.playerengine.tasks.resources.CollectSandstoneTask;
import com.player2.playerengine.tasks.resources.CollectSaplingsTask;
import com.player2.playerengine.tasks.resources.CollectSticksTask;
import com.player2.playerengine.tasks.resources.CollectStrippedLogTask;
import com.player2.playerengine.tasks.resources.CollectWheatSeedsTask;
import com.player2.playerengine.tasks.resources.CollectWheatTask;
import com.player2.playerengine.tasks.resources.CollectWoolTask;
import com.player2.playerengine.tasks.resources.GetSmithingTemplateTask;
import com.player2.playerengine.tasks.resources.KillAndLootTask;
import com.player2.playerengine.tasks.resources.KillEndermanTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.tasks.resources.ShearAndCollectBlockTask;
import com.player2.playerengine.tasks.resources.wood.CollectBoatTask;
import com.player2.playerengine.tasks.resources.wood.CollectFenceGateTask;
import com.player2.playerengine.tasks.resources.wood.CollectFenceTask;
import com.player2.playerengine.tasks.resources.wood.CollectHangingSignTask;
import com.player2.playerengine.tasks.resources.wood.CollectSignTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenButtonTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenDoorTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenPressurePlateTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenSlabTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenStairsTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenTrapDoorTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.WoodType;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;

public class TaskCatalogue {
    private static final HashMap<String, Item[]> nameToItemMatches = new HashMap();
    private static final HashMap<String, CataloguedResource> nameToResourceTask = new HashMap();
    private static final HashMap<Item, CataloguedResource> itemToResourceTask = new HashMap();
    private static final HashSet<Item> resourcesObtainable = new HashSet();

    private static CataloguedResource put(String name, Item[] matches, Function<Integer, ResourceTask> getTask) {
        ArrayList<Item> supportedMatches = new ArrayList<Item>();
        for (Item item : matches) {
            supportedMatches.add(item);
        }
        matches = supportedMatches.toArray(new Item[0]);
        CataloguedResource result = new CataloguedResource(matches, getTask);
        Block[] blocks = ItemHelper.itemsToBlocks(matches);
        if (blocks.length != 0) {
            result.mineIfPresent();
        }
        result.forceDimension(Dimension.OVERWORLD);
        if (nameToResourceTask.containsKey(name)) {
            return result;
        }
        nameToResourceTask.put(name, result);
        nameToItemMatches.put(name, matches);
        resourcesObtainable.addAll(Arrays.asList(matches));
        if (matches.length == 1) {
            if (itemToResourceTask.containsKey(matches[0])) {
                throw new IllegalStateException("Tried cataloguing " + matches[0].getDescriptionId() + " twice!");
            }
            itemToResourceTask.put(matches[0], result);
        }
        return result;
    }

    public static Item[] getItemMatches(String name) {
        return !nameToItemMatches.containsKey(name) ? new Item[]{} : nameToItemMatches.get(name);
    }

    public static boolean isObtainable(Item item) {
        return resourcesObtainable.contains(item);
    }

    public static ItemTarget getItemTarget(String name, int count) {
        return new ItemTarget(name, count);
    }

    public static CataloguedResourceTask getSquashedItemTask(ItemTarget ... targets) {
        return new CataloguedResourceTask(true, targets);
    }

    public static ResourceTask getItemTask(String name, int count) {
        if (!TaskCatalogue.taskExists(name)) {
            Debug.logWarning("Task " + name + " does not exist. Error possibly.");
            Debug.logStack();
            return null;
        }
        return nameToResourceTask.get(name).getResource(count);
    }

    public static ResourceTask getItemTask(Item item, int count) {
        if (!TaskCatalogue.taskExists(item)) {
            Debug.logWarning("Task " + String.valueOf(item) + " does not exist. Error possibly.");
            Debug.logStack();
            return null;
        }
        return itemToResourceTask.get(item).getResource(count);
    }

    public static ResourceTask getItemTask(ItemTarget target) {
        if (target.isCatalogueItem()) {
            return TaskCatalogue.getItemTask(target.getCatalogueName(), target.getTargetCount());
        }
        return target.getMatches().length == 1 ? TaskCatalogue.getItemTask(target.getMatches()[0], target.getTargetCount()) : TaskCatalogue.getSquashedItemTask(target);
    }

    public static boolean taskExists(String name) {
        return nameToResourceTask.containsKey(name);
    }

    public static boolean taskExists(Item item) {
        return itemToResourceTask.containsKey(item);
    }

    public static Collection<String> resourceNames() {
        return nameToResourceTask.keySet();
    }

    private static CataloguedResource simple(String name, Item[] matches, Function<Integer, ResourceTask> getTask) {
        return TaskCatalogue.put(name, matches, getTask);
    }

    private static CataloguedResource simple(String name, Item matches, Function<Integer, ResourceTask> getTask) {
        return TaskCatalogue.simple(name, new Item[]{matches}, getTask);
    }

    private static CataloguedResource mine(String name, MiningRequirement requirement, Item[] toMine, Item ... targets) {
        Block[] toMineBlocks = new Block[toMine.length];
        for (int i = 0; i < toMine.length; ++i) {
            toMineBlocks[i] = Block.byItem((Item)toMine[i]);
        }
        return TaskCatalogue.mine(name, requirement, toMineBlocks, targets);
    }

    private static CataloguedResource mine(String name, MiningRequirement requirement, Block[] toMine, Item ... targets) {
        return TaskCatalogue.put(name, targets, count -> new MineAndCollectTask(new ItemTarget(targets, (int)count), toMine, requirement)).dontMineIfPresent();
    }

    private static CataloguedResource mine(String name, MiningRequirement requirement, Block toMine, Item target) {
        return TaskCatalogue.mine(name, requirement, new Block[]{toMine}, target);
    }

    private static CataloguedResource mine(String name, Block toMine, Item target) {
        return TaskCatalogue.mine(name, MiningRequirement.HAND, toMine, target);
    }

    private static CataloguedResource mine(String name, Item target) {
        return TaskCatalogue.mine(name, Block.byItem((Item)target), target);
    }

    private static CataloguedResource shear(String name, Block[] toShear, Item ... targets) {
        return TaskCatalogue.put(name, targets, count -> new ShearAndCollectBlockTask(new ItemTarget[]{new ItemTarget(targets, (int)count)}, toShear)).dontMineIfPresent();
    }

    private static CataloguedResource shear(String name, Block toShear, Item ... targets) {
        return TaskCatalogue.shear(name, new Block[]{toShear}, targets);
    }

    private static CataloguedResource shapedRecipe2x2(String name, Item match, int outputCount, String s0, String s1, String s2, String s3) {
        CraftingRecipe recipe = CraftingRecipe.newShapedRecipe(name, new ItemTarget[]{TaskCatalogue.t(s0), TaskCatalogue.t(s1), TaskCatalogue.t(s2), TaskCatalogue.t(s3)}, outputCount);
        return TaskCatalogue.put(name, new Item[]{match}, count -> new CraftInInventoryTask(new RecipeTarget(match, (int)count, recipe)));
    }

    private static CataloguedResource shapedRecipe3x3(String name, Item match, int outputCount, String s0, String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8) {
        CraftingRecipe recipe = CraftingRecipe.newShapedRecipe(name, new ItemTarget[]{TaskCatalogue.t(s0), TaskCatalogue.t(s1), TaskCatalogue.t(s2), TaskCatalogue.t(s3), TaskCatalogue.t(s4), TaskCatalogue.t(s5), TaskCatalogue.t(s6), TaskCatalogue.t(s7), TaskCatalogue.t(s8)}, outputCount);
        return TaskCatalogue.put(name, new Item[]{match}, count -> new CraftInTableTask(new RecipeTarget(match, (int)count, recipe)));
    }

    private static CataloguedResource shapedRecipe2x2Block(String name, Item match, String material) {
        return TaskCatalogue.shapedRecipe2x2(name, match, 1, material, material, material, material);
    }

    private static CataloguedResource shapedRecipe2x2Block(String name, Item match, int outputCount, String material) {
        return TaskCatalogue.shapedRecipe2x2(name, match, outputCount, material, material, material, material);
    }

    private static CataloguedResource shapedRecipe3x3Block(String name, Item match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 1, material, material, material, material, material, material, material, material, material);
    }

    private static CataloguedResource shapedRecipeSlab(String name, Item match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 6, null, null, null, null, null, null, material, material, material);
    }

    private static CataloguedResource shapedRecipeStairs(String name, Item match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 4, material, null, null, material, material, null, material, material, material);
    }

    private static CataloguedResource shapedRecipeWall(String name, Item match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 6, material, material, material, material, material, material, null, null, null);
    }

    private static CataloguedResource smelt(String name, Item[] matches, String materials, Item ... optionalMaterials) {
        return TaskCatalogue.put(name, matches, count -> new SmeltInFurnaceTask(new SmeltTarget(new ItemTarget(matches, (int)count), new ItemTarget(materials, (int)count), optionalMaterials)));
    }

    private static CataloguedResource smelt(String name, Item match, String materials, Item ... optionalMaterials) {
        return TaskCatalogue.smelt(name, new Item[]{match}, materials, optionalMaterials);
    }

    private static CataloguedResource smith(String name, Item[] matches, String materials, String tool) {
        return TaskCatalogue.put(name, matches, count -> new UpgradeInSmithingTableTask(new ItemTarget(tool, (int)count), new ItemTarget(materials, (int)count), new ItemTarget(matches, (int)count)));
    }

    private static CataloguedResource smith(String name, Item match, String materials, String tool) {
        return TaskCatalogue.smith(name, new Item[]{match}, materials, tool);
    }

    private static CataloguedResource mob(String name, Item[] matches, Class mobClass) {
        return TaskCatalogue.put(name, matches, count -> new KillAndLootTask(mobClass, new ItemTarget(matches, (int)count)));
    }

    private static CataloguedResource mob(String name, Item match, Class mobClass) {
        return TaskCatalogue.mob(name, new Item[]{match}, mobClass);
    }

    private static void mobCook(String uncookedName, String cookedName, Item uncooked, Item cooked, Class mobClass) {
        TaskCatalogue.mob(uncookedName, uncooked, mobClass);
        TaskCatalogue.smelt(cookedName, cooked, uncookedName, new Item[0]);
    }

    private static void mobCook(String uncookedName, Item uncooked, Item cooked, Class mobClass) {
        TaskCatalogue.mobCook(uncookedName, "cooked_" + uncookedName, uncooked, cooked, mobClass);
    }

    private static CataloguedResource crop(String name, Item[] matches, Block[] cropBlocks, Item[] cropSeeds) {
        return TaskCatalogue.put(name, matches, count -> new CollectCropTask(new ItemTarget(matches, (int)count), cropBlocks, cropSeeds));
    }

    public static CataloguedResource crop(String name, Item match, Block cropBlock, Item cropSeed) {
        return TaskCatalogue.crop(name, new Item[]{match}, new Block[]{cropBlock}, new Item[]{cropSeed});
    }

    private static void colorfulTasks(String baseName, Function<ItemHelper.ColorfulItems, Item> getMatch, BiFunction<ItemHelper.ColorfulItems, Integer, ResourceTask> getTask) {
        for (DyeColor dCol : DyeColor.values()) {
            MapColor mCol = dCol.getMapColor();
            ItemHelper.ColorfulItems color = ItemHelper.getColorfulItems(mCol);
            String prefix = color.colorName;
            TaskCatalogue.put(prefix + "_" + prefix, new Item[]{getMatch.apply(color)}, count -> (ResourceTask)getTask.apply(color, (Integer)count));
        }
    }

    private static CataloguedResource[] woodTasks(Function<ItemHelper.WoodItems, String> getCatalogueName, Function<ItemHelper.WoodItems, Item> getMatch, BiFunction<ItemHelper.WoodItems, Integer, ResourceTask> getTask, boolean requireNetherForNetherStuff) {
        ArrayList<CataloguedResource> result = new ArrayList<CataloguedResource>();
        for (WoodType woodType : WoodType.values()) {
            ItemHelper.WoodItems woodItems = ItemHelper.getWoodItems(woodType);
            Item match = getMatch.apply(woodItems);
            String cataloguedName = getCatalogueName.apply(woodItems);
            if (match == null) continue;
            boolean isNether = woodItems.isNetherWood();
            CataloguedResource t = TaskCatalogue.put(cataloguedName, new Item[]{match}, count -> (ResourceTask)getTask.apply(woodItems, (Integer)count));
            if (requireNetherForNetherStuff && isNether) {
                t.forceDimension(Dimension.NETHER);
            }
            result.add(t);
        }
        return (CataloguedResource[])result.toArray(CataloguedResource[]::new);
    }

    private static CataloguedResource[] woodTasks(String baseName, Function<ItemHelper.WoodItems, Item> getMatch, BiFunction<ItemHelper.WoodItems, Integer, ResourceTask> getTask, boolean requireNetherForNetherStuff) {
        return TaskCatalogue.woodTasks((ItemHelper.WoodItems woodItem) -> woodItem.prefix + "_" + woodItem.prefix, getMatch, getTask, requireNetherForNetherStuff);
    }

    private static CataloguedResource[] woodTasks(String baseName, Function<ItemHelper.WoodItems, Item> getMatch, BiFunction<ItemHelper.WoodItems, Integer, ResourceTask> getTask) {
        return TaskCatalogue.woodTasks(baseName, getMatch, getTask, false);
    }

    private static void tools(String toolMaterialName, String material, Item pickaxeItem, Item shovelItem, Item swordItem, Item axeItem, Item hoeItem) {
        String s = "stick";
        String o = null;
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_pickaxe", pickaxeItem, 1, material, material, material, o, s, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_shovel", shovelItem, 1, o, material, o, o, s, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_sword", swordItem, 1, o, material, o, o, material, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_axe", axeItem, 1, material, material, o, material, s, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_hoe", hoeItem, 1, material, material, o, o, s, o, o, s, o);
    }

    private static void armor(String armorMaterialName, String material, Item helmetItem, Item chestplateItem, Item leggingsItem, Item bootsItem) {
        String o = null;
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_helmet", helmetItem, 1, material, material, material, material, o, material, o, o, o);
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_chestplate", chestplateItem, 1, material, o, material, material, material, material, material, material, material);
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_leggings", leggingsItem, 1, material, material, material, material, o, material, material, o, material);
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_boots", bootsItem, 1, o, o, o, material, o, material, material, o, material);
    }

    private static void alias(String newName, String original) {
        if (nameToResourceTask.containsKey(original) && nameToItemMatches.containsKey(original)) {
            nameToResourceTask.put(newName, nameToResourceTask.get(original));
            nameToItemMatches.put(newName, nameToItemMatches.get(original));
        } else {
            Debug.logWarning("Invalid resource: " + original + ". Will not create alias.");
        }
    }

    private static ItemTarget t(String cataloguedName) {
        return new ItemTarget(cataloguedName);
    }

    static {
        String p = "planks";
        String s = "stick";
        String o = null;
        TaskCatalogue.mine("log", MiningRequirement.HAND, ItemHelper.LOG, ItemHelper.LOG).anyDimension();
        TaskCatalogue.woodTasks("log", (ItemHelper.WoodItems wood) -> wood.log, (ItemHelper.WoodItems wood, Integer count) -> new MineAndCollectTask(wood.log, (int)count, new Block[]{Block.byItem((Item)wood.log)}, MiningRequirement.HAND), true);
        TaskCatalogue.mine("dirt", MiningRequirement.HAND, new Block[]{Blocks.DIRT, Blocks.GRASS_BLOCK, Blocks.DIRT_PATH}, Items.DIRT);
        TaskCatalogue.simple("cobblestone", Items.COBBLESTONE, CollectBlockByOneTask.CollectCobblestoneTask::new).dontMineIfPresent();
        TaskCatalogue.simple("cobbled_deepslate", Items.COBBLED_DEEPSLATE, CollectBlockByOneTask.CollectCobbledDeepslateTask::new).dontMineIfPresent();
        TaskCatalogue.mine("andesite", MiningRequirement.WOOD, Blocks.ANDESITE, Items.ANDESITE);
        TaskCatalogue.mine("granite", MiningRequirement.WOOD, Blocks.GRANITE, Items.GRANITE);
        TaskCatalogue.mine("diorite", MiningRequirement.WOOD, Blocks.DIORITE, Items.DIORITE);
        TaskCatalogue.mine("calcite", MiningRequirement.WOOD, Blocks.CALCITE, Items.CALCITE);
        TaskCatalogue.mine("tuff", MiningRequirement.WOOD, Blocks.TUFF, Items.TUFF);
        TaskCatalogue.mine("netherrack", MiningRequirement.WOOD, Blocks.NETHERRACK, Items.NETHERRACK).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("magma_block", MiningRequirement.WOOD, Blocks.MAGMA_BLOCK, Items.MAGMA_BLOCK).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("blackstone", MiningRequirement.WOOD, Blocks.BLACKSTONE, Items.BLACKSTONE).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("basalt", MiningRequirement.WOOD, Blocks.BASALT, Items.BASALT).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("soul_sand", Items.SOUL_SAND).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("soul_soil", Items.SOUL_SOIL).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("glowstone_dust", Blocks.GLOWSTONE, Items.GLOWSTONE_DUST).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("coal", MiningRequirement.WOOD, new Block[]{Blocks.COAL_ORE, Blocks.DEEPSLATE_COAL_ORE}, Items.COAL);
        TaskCatalogue.mine("raw_iron", MiningRequirement.STONE, new Block[]{Blocks.IRON_ORE, Blocks.DEEPSLATE_IRON_ORE}, Items.RAW_IRON);
        TaskCatalogue.mine("raw_gold", MiningRequirement.IRON, new Block[]{Blocks.GOLD_ORE, Blocks.DEEPSLATE_GOLD_ORE}, Items.RAW_GOLD);
        TaskCatalogue.mine("raw_copper", MiningRequirement.STONE, new Block[]{Blocks.COPPER_ORE, Blocks.DEEPSLATE_COPPER_ORE}, Items.RAW_COPPER);
        TaskCatalogue.mine("diamond", MiningRequirement.IRON, new Block[]{Blocks.DIAMOND_ORE, Blocks.DEEPSLATE_DIAMOND_ORE}, Items.DIAMOND);
        TaskCatalogue.mine("emerald", MiningRequirement.IRON, new Block[]{Blocks.EMERALD_ORE, Blocks.DEEPSLATE_EMERALD_ORE}, Items.EMERALD);
        TaskCatalogue.mine("redstone", MiningRequirement.IRON, new Block[]{Blocks.REDSTONE_ORE, Blocks.DEEPSLATE_REDSTONE_ORE}, Items.REDSTONE);
        TaskCatalogue.mine("lapis_lazuli", MiningRequirement.STONE, new Block[]{Blocks.LAPIS_ORE, Blocks.DEEPSLATE_LAPIS_ORE}, Items.LAPIS_LAZULI);
        TaskCatalogue.alias("lapis", "lapis_lazuli");
        TaskCatalogue.mine("amethyst_shard", MiningRequirement.WOOD, Blocks.AMETHYST_CLUSTER, Items.AMETHYST_SHARD);
        TaskCatalogue.mine("pointed_dripstone", MiningRequirement.WOOD, Blocks.POINTED_DRIPSTONE, Items.POINTED_DRIPSTONE);
        TaskCatalogue.mine("sand", Blocks.SAND, Items.SAND);
        TaskCatalogue.mine("red_sand", Blocks.RED_SAND, Items.RED_SAND);
        TaskCatalogue.mine("gravel", Blocks.GRAVEL, Items.GRAVEL);
        TaskCatalogue.mine("clay_ball", Blocks.CLAY, Items.CLAY_BALL);
        TaskCatalogue.mine("ancient_debris", MiningRequirement.DIAMOND, Blocks.ANCIENT_DEBRIS, Items.ANCIENT_DEBRIS).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("gilded_blackstone", MiningRequirement.STONE, Blocks.GILDED_BLACKSTONE, Items.GILDED_BLACKSTONE).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("oak_sapling", Blocks.OAK_LEAVES, Items.OAK_SAPLING);
        TaskCatalogue.mine("spruce_sapling", Blocks.SPRUCE_LEAVES, Items.SPRUCE_SAPLING);
        TaskCatalogue.mine("birch_sapling", Blocks.BIRCH_LEAVES, Items.BIRCH_SAPLING);
        TaskCatalogue.mine("jungle_sapling", Blocks.JUNGLE_LEAVES, Items.JUNGLE_SAPLING);
        TaskCatalogue.mine("acacia_sapling", Blocks.ACACIA_LEAVES, Items.ACACIA_SAPLING);
        TaskCatalogue.mine("dark_oak_sapling", Blocks.DARK_OAK_LEAVES, Items.DARK_OAK_SAPLING);
        TaskCatalogue.mine("mangrove_propagule", Blocks.MANGROVE_PROPAGULE, Items.MANGROVE_PROPAGULE);
        TaskCatalogue.mine("cherry_sapling", Blocks.CHERRY_LEAVES, Items.CHERRY_SAPLING);
        TaskCatalogue.simple("sapling", ItemHelper.SAPLINGS, CollectSaplingsTask::new);
        TaskCatalogue.simple("sandstone", Items.SANDSTONE, CollectSandstoneTask::new).dontMineIfPresent();
        TaskCatalogue.simple("red_sandstone", Items.RED_SANDSTONE, CollectRedSandstoneTask::new).dontMineIfPresent();
        TaskCatalogue.simple("coarse_dirt", Items.COARSE_DIRT, CollectCoarseDirtTask::new).dontMineIfPresent();
        TaskCatalogue.simple("amethyst_block", Items.AMETHYST_BLOCK, CollectAmethystBlockTask::new).dontMineIfPresent();
        TaskCatalogue.simple("dripstone_block", Items.DRIPSTONE_BLOCK, CollectDripstoneBlockTask::new).dontMineIfPresent();
        TaskCatalogue.simple("flint", Items.FLINT, CollectFlintTask::new);
        TaskCatalogue.simple("obsidian", Items.OBSIDIAN, CollectObsidianTask::new).dontMineIfPresent();
        TaskCatalogue.simple("wool", ItemHelper.WOOL, CollectWoolTask::new);
        TaskCatalogue.simple("egg", Items.EGG, CollectEggsTask::new);
        TaskCatalogue.mob("bone", Items.BONE, Skeleton.class);
        TaskCatalogue.mob("gunpowder", Items.GUNPOWDER, Creeper.class);
        TaskCatalogue.simple("ender_pearl", Items.ENDER_PEARL, KillEndermanTask::new);
        TaskCatalogue.mob("spider_eye", Items.SPIDER_EYE, Spider.class);
        TaskCatalogue.mob("leather", Items.LEATHER, Cow.class);
        TaskCatalogue.mob("feather", Items.FEATHER, Chicken.class);
        TaskCatalogue.mob("rotten_flesh", Items.ROTTEN_FLESH, Zombie.class);
        TaskCatalogue.mob("rabbit_foot", Items.RABBIT_FOOT, Rabbit.class);
        TaskCatalogue.mob("rabbit_hide", Items.RABBIT_HIDE, Rabbit.class);
        TaskCatalogue.mob("slime_ball", Items.SLIME_BALL, Slime.class);
        TaskCatalogue.mob("wither_skeleton_skull", Items.WITHER_SKELETON_SKULL, WitherSkeleton.class).forceDimension(Dimension.NETHER);
        TaskCatalogue.mob("ink_sac", Items.INK_SAC, Squid.class);
        TaskCatalogue.mob("glow_ink_sac", Items.GLOW_INK_SAC, GlowSquid.class);
        TaskCatalogue.mob("string", Items.STRING, Spider.class);
        TaskCatalogue.mine("sugar_cane", Items.SUGAR_CANE);
        TaskCatalogue.mine("brown_mushroom", MiningRequirement.HAND, new Block[]{Blocks.BROWN_MUSHROOM, Blocks.BROWN_MUSHROOM_BLOCK}, Items.BROWN_MUSHROOM);
        TaskCatalogue.mine("red_mushroom", MiningRequirement.HAND, new Block[]{Blocks.RED_MUSHROOM, Blocks.RED_MUSHROOM_BLOCK}, Items.RED_MUSHROOM);
        TaskCatalogue.mine("mushroom", MiningRequirement.HAND, new Block[]{Blocks.BROWN_MUSHROOM, Blocks.BROWN_MUSHROOM_BLOCK, Blocks.RED_MUSHROOM, Blocks.RED_MUSHROOM_BLOCK}, Items.BROWN_MUSHROOM, Items.RED_MUSHROOM);
        TaskCatalogue.mine("melon_slice", MiningRequirement.HAND, Blocks.MELON, Items.MELON_SLICE);
        TaskCatalogue.mine("pumpkin", MiningRequirement.HAND, Blocks.PUMPKIN, Items.PUMPKIN);
        TaskCatalogue.mine("bell", MiningRequirement.WOOD, Blocks.BELL, Items.BELL);
        TaskCatalogue.mine("nether_wart", MiningRequirement.HAND, Blocks.NETHER_WART, Items.NETHER_WART).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("crimson_fungus", MiningRequirement.HAND, Blocks.CRIMSON_FUNGUS, Items.CRIMSON_FUNGUS).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("warped_fungus", MiningRequirement.HAND, Blocks.WARPED_FUNGUS, Items.WARPED_FUNGUS).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("crimson_roots", MiningRequirement.HAND, Blocks.CRIMSON_ROOTS, Items.CRIMSON_ROOTS).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("warped_roots", MiningRequirement.HAND, Blocks.WARPED_ROOTS, Items.WARPED_ROOTS).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("weeping_vines", MiningRequirement.HAND, Blocks.WEEPING_VINES, Items.WEEPING_VINES).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("twisting_vines", MiningRequirement.HAND, Blocks.TWISTING_VINES, Items.TWISTING_VINES).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("nether_wart_block", MiningRequirement.HAND, Blocks.NETHER_WART_BLOCK, Items.NETHER_WART_BLOCK).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("warped_wart_block", MiningRequirement.HAND, Blocks.WARPED_WART_BLOCK, Items.WARPED_WART_BLOCK).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("shroomlight", MiningRequirement.HAND, Blocks.SHROOMLIGHT, Items.SHROOMLIGHT).forceDimension(Dimension.NETHER);
        TaskCatalogue.simple("blaze_rod", Items.BLAZE_ROD, CollectBlazeRodsTask::new).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("quartz", MiningRequirement.WOOD, Blocks.NETHER_QUARTZ_ORE, Items.QUARTZ).forceDimension(Dimension.NETHER);
        TaskCatalogue.simple("cocoa_beans", Items.COCOA_BEANS, CollectCocoaBeansTask::new);
        TaskCatalogue.shear("cobweb", Blocks.COBWEB, Items.COBWEB).dontMineIfPresent();
        TaskCatalogue.colorfulTasks("wool", color -> color.wool, (color, count) -> new CollectWoolTask(color.color, (int)count));
        TaskCatalogue.shear("leaves", ItemHelper.itemsToBlocks(ItemHelper.LEAVES), ItemHelper.LEAVES).dontMineIfPresent();
        for (CataloguedResource resource : TaskCatalogue.woodTasks("leaves", woodItems -> woodItems.leaves, (woodItems, count) -> woodItems.isNetherWood() ? new MineAndCollectTask(woodItems.leaves, (int)count, new Block[]{Block.byItem((Item)woodItems.leaves)}, MiningRequirement.HAND).forceDimension(Dimension.NETHER) : new ShearAndCollectBlockTask(woodItems.leaves, (int)count, Block.byItem((Item)woodItems.leaves)))) {
            resource.dontMineIfPresent();
        }
        TaskCatalogue.mine("bamboo", Blocks.BAMBOO, Items.BAMBOO);
        TaskCatalogue.shear("vine", Blocks.VINE, Items.VINE).dontMineIfPresent();
        TaskCatalogue.shear("grass", Blocks.GRASS_BLOCK, Items.GRASS_BLOCK).dontMineIfPresent();
        TaskCatalogue.shear("lily_pad", Blocks.LILY_PAD, Items.LILY_PAD).dontMineIfPresent();
        TaskCatalogue.shear("tall_grass", Blocks.TALL_GRASS, Items.TALL_GRASS).dontMineIfPresent();
        TaskCatalogue.shear("fern", Blocks.FERN, Items.FERN).dontMineIfPresent();
        TaskCatalogue.shear("large_fern", Blocks.LARGE_FERN, Items.LARGE_FERN).dontMineIfPresent();
        TaskCatalogue.shear("dead_bush", Blocks.DEAD_BUSH, Items.DEAD_BUSH).dontMineIfPresent();
        TaskCatalogue.shear("glow_lichen", Blocks.GLOW_LICHEN, Items.GLOW_LICHEN).dontMineIfPresent();
        TaskCatalogue.simple("flower", ItemHelper.FLOWER, CollectFlowerTask::new);
        TaskCatalogue.mine("allium", Items.ALLIUM);
        TaskCatalogue.mine("azure_bluet", Items.AZURE_BLUET);
        TaskCatalogue.mine("blue_orchid", Items.BLUE_ORCHID);
        TaskCatalogue.mine("cactus", Items.CACTUS);
        TaskCatalogue.mine("cornflower", Items.CORNFLOWER);
        TaskCatalogue.mine("dandelion", Items.DANDELION);
        TaskCatalogue.mine("lilac", Items.LILAC);
        TaskCatalogue.mine("lily_of_the_valley", Items.LILY_OF_THE_VALLEY);
        TaskCatalogue.mine("orange_tulip", Items.ORANGE_TULIP);
        TaskCatalogue.mine("oxeye_daisy", Items.OXEYE_DAISY);
        TaskCatalogue.mine("pink_tulip", Items.PINK_TULIP);
        TaskCatalogue.mine("poppy", Items.POPPY);
        TaskCatalogue.mine("peony", Items.PEONY);
        TaskCatalogue.mine("red_tulip", Items.RED_TULIP);
        TaskCatalogue.mine("rose_bush", Items.ROSE_BUSH);
        TaskCatalogue.mine("sunflower", Items.SUNFLOWER);
        TaskCatalogue.mine("white_tulip", Items.WHITE_TULIP);
        TaskCatalogue.simple("wheat", Items.WHEAT, CollectWheatTask::new);
        TaskCatalogue.crop("carrot", Items.CARROT, Blocks.CARROTS, Items.CARROT);
        TaskCatalogue.crop("potato", Items.POTATO, Blocks.POTATOES, Items.POTATO);
        TaskCatalogue.crop("poisonous_potato", Items.POISONOUS_POTATO, Blocks.POTATOES, Items.POTATO);
        TaskCatalogue.crop("beetroot", Items.BEETROOT, Blocks.BEETROOTS, Items.BEETROOT_SEEDS);
        TaskCatalogue.simple("wheat_seeds", Items.WHEAT_SEEDS, CollectWheatSeedsTask::new);
        TaskCatalogue.crop("beetroot_seeds", Items.BEETROOT_SEEDS, Blocks.BEETROOTS, Items.BEETROOT_SEEDS);
        TaskCatalogue.simple("netherite_upgrade_smithing_template", Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE, GetSmithingTemplateTask::new);
        TaskCatalogue.alias("netherite_upgrade", "netherite_upgrade_smithing_template");
        TaskCatalogue.simple("planks", ItemHelper.PLANKS, CollectPlanksTask::new).dontMineIfPresent();
        for (CataloguedResource woodCatalogue : TaskCatalogue.woodTasks("planks", (ItemHelper.WoodItems wood) -> wood.planks, (ItemHelper.WoodItems wood, Integer count) -> {
            CollectPlanksTask result = new CollectPlanksTask(wood.planks, (int)count);
            if (wood.isNetherWood()) {
                result.logsInNether();
            }
            return result;
        }, true)) {
            woodCatalogue.dontMineIfPresent();
        }
        TaskCatalogue.simple("stripped_logs", ItemHelper.STRIPPED_LOGS, CollectStrippedLogTask::new).dontMineIfPresent();
        for (CataloguedResource woodCatalogue : TaskCatalogue.woodTasks("stripped_logs", wood -> wood.strippedLog, (wood, count) -> new CollectStrippedLogTask(wood.strippedLog, (int)count))) {
            woodCatalogue.dontMineIfPresent();
        }
        TaskCatalogue.simple("stick", Items.STICK, CollectSticksTask::new);
        TaskCatalogue.smelt("stone", Items.STONE, "cobblestone", new Item[0]).dontMineIfPresent();
        TaskCatalogue.smelt("deepslate", Items.DEEPSLATE, "cobbled_deepslate", new Item[0]).dontMineIfPresent();
        TaskCatalogue.smelt("smooth_stone", Items.SMOOTH_STONE, "stone", new Item[0]);
        TaskCatalogue.smelt("smooth_quartz", Items.SMOOTH_QUARTZ, "quartz_block", new Item[0]);
        TaskCatalogue.smelt("smooth_basalt", Items.SMOOTH_BASALT, "basalt", new Item[0]);
        TaskCatalogue.smelt("glass", Items.GLASS, "sand", new Item[0]).dontMineIfPresent();
        TaskCatalogue.simple("iron_ingot", Items.IRON_INGOT, CollectIronIngotTask::new).forceDimension(Dimension.OVERWORLD);
        TaskCatalogue.smelt("copper_ingot", Items.COPPER_INGOT, "raw_copper", Items.COPPER_ORE);
        TaskCatalogue.smelt("charcoal", Items.CHARCOAL, "log", new Item[0]);
        TaskCatalogue.smelt("brick", Items.BRICK, "clay_ball", new Item[0]);
        TaskCatalogue.smelt("nether_brick", Items.NETHER_BRICK, "netherrack", new Item[0]);
        TaskCatalogue.smelt("green_dye", Items.GREEN_DYE, "cactus", new Item[0]);
        TaskCatalogue.simple("gold_ingot", Items.GOLD_INGOT, CollectGoldIngotTask::new).anyDimension();
        TaskCatalogue.shapedRecipe3x3Block("iron_block", Items.IRON_BLOCK, "iron_ingot");
        TaskCatalogue.shapedRecipe3x3Block("gold_block", Items.GOLD_BLOCK, "gold_ingot");
        TaskCatalogue.shapedRecipe3x3Block("copper_block", Items.COPPER_BLOCK, "copper_ingot");
        TaskCatalogue.shapedRecipe3x3Block("raw_iron_block", Items.RAW_IRON_BLOCK, "raw_iron");
        TaskCatalogue.shapedRecipe3x3Block("raw_gold_block", Items.RAW_GOLD_BLOCK, "raw_gold");
        TaskCatalogue.shapedRecipe3x3Block("raw_copper_block", Items.RAW_COPPER_BLOCK, "raw_copper");
        TaskCatalogue.shapedRecipe3x3Block("diamond_block", Items.DIAMOND_BLOCK, "diamond");
        TaskCatalogue.shapedRecipe3x3Block("redstone_block", Items.REDSTONE_BLOCK, "redstone");
        TaskCatalogue.shapedRecipe3x3Block("coal_block", Items.COAL_BLOCK, "coal");
        TaskCatalogue.shapedRecipe3x3Block("emerald_block", Items.EMERALD_BLOCK, "emerald");
        TaskCatalogue.shapedRecipe3x3Block("lapis_block", Items.LAPIS_BLOCK, "lapis_lazuli");
        TaskCatalogue.shapedRecipe3x3Block("slime_block", Items.SLIME_BLOCK, "slime_ball");
        TaskCatalogue.shapedRecipe3x3Block("melon", Items.MELON, "melon_slice").dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("glowstone", Items.GLOWSTONE, "glowstone_dust").dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("clay", Items.CLAY, "clay_ball").dontMineIfPresent();
        TaskCatalogue.smelt("netherite_scrap", Items.NETHERITE_SCRAP, "ancient_debris", new Item[0]);
        TaskCatalogue.shapedRecipe3x3("netherite_ingot", Items.NETHERITE_INGOT, 1, "netherite_scrap", "netherite_scrap", "netherite_scrap", "netherite_scrap", "gold_ingot", "gold_ingot", "gold_ingot", "gold_ingot", o);
        TaskCatalogue.simple("gold_nugget", Items.GOLD_NUGGET, CollectGoldNuggetsTask::new);
        String str8 = "gold_nugget";
        TaskCatalogue.shapedRecipe3x3("glistering_melon_slice", Items.GLISTERING_MELON_SLICE, 1, str8, str8, str8, str8, "melon_slice", str8, str8, str8, str8);
        TaskCatalogue.shapedRecipe2x2("sugar", Items.SUGAR, 1, "sugar_cane", o, o, o);
        TaskCatalogue.shapedRecipe2x2("bone_meal", Items.BONE_MEAL, 3, "bone", o, o, o);
        TaskCatalogue.shapedRecipe2x2("melon_seeds", Items.MELON_SEEDS, 1, "melon_slice", o, o, o);
        TaskCatalogue.shapedRecipe2x2("bamboo_planks", Items.BAMBOO_PLANKS, 2, "bamboo_block", o, o, o);
        TaskCatalogue.shapedRecipe3x3Block("bamboo_block", Items.BAMBOO_BLOCK, "bamboo");
        TaskCatalogue.simple("hay_block", Items.HAY_BLOCK, CollectHayBlockTask::new).dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("polished_andesite", Items.POLISHED_ANDESITE, 4, "andesite");
        TaskCatalogue.shapedRecipe2x2Block("polished_diorite", Items.POLISHED_DIORITE, 4, "diorite");
        TaskCatalogue.shapedRecipe2x2Block("polished_granite", Items.POLISHED_GRANITE, 4, "granite");
        TaskCatalogue.shapedRecipe2x2Block("quartz_block", Items.QUARTZ_BLOCK, "quartz");
        TaskCatalogue.shapedRecipe2x2Block("polished_blackstone", Items.POLISHED_BLACKSTONE, 4, "blackstone");
        TaskCatalogue.shapedRecipe2x2Block("polished_blackstone_bricks", Items.POLISHED_BLACKSTONE_BRICKS, 4, "polished_blackstone");
        TaskCatalogue.shapedRecipe2x2Block("polished_basalt", Items.POLISHED_BASALT, 4, "basalt");
        TaskCatalogue.shapedRecipe2x2Block("polished_deepslate", Items.POLISHED_DEEPSLATE, 4, "cobbled_deepslate");
        TaskCatalogue.shapedRecipe2x2Block("deepslate_bricks", Items.DEEPSLATE_BRICKS, 4, "polished_deepslate");
        TaskCatalogue.shapedRecipe2x2Block("deepslate_tiles", Items.DEEPSLATE_TILES, 4, "deepslate_bricks");
        TaskCatalogue.shapedRecipe2x2Block("cut_copper", Items.CUT_COPPER, 4, "copper_block");
        TaskCatalogue.shapedRecipe2x2Block("cut_sandstone", Items.CUT_SANDSTONE, 4, "sandstone");
        TaskCatalogue.shapedRecipe2x2Block("cut_red_sandstone", Items.CUT_RED_SANDSTONE, 4, "red_sandstone");
        TaskCatalogue.shapedRecipe2x2Block("quartz_bricks", Items.QUARTZ_BRICKS, 4, "quartz_block");
        TaskCatalogue.shapedRecipe2x2("quartz_pillar", Items.QUARTZ_PILLAR, 4, "quartz_block", o, "quartz_block", o);
        TaskCatalogue.shapedRecipe2x2Block("stone_bricks", Items.STONE_BRICKS, 4, "stone");
        TaskCatalogue.shapedRecipe2x2("mossy_stone_bricks", Items.MOSSY_STONE_BRICKS, 1, "stone_bricks", "vine", o, o);
        TaskCatalogue.shapedRecipe2x2("mossy_cobblestone", Items.MOSSY_COBBLESTONE, 1, "cobblestone", "vine", o, o);
        TaskCatalogue.simple("nether_bricks", Items.NETHER_BRICKS, CollectNetherBricksTask::new).dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("red_nether_bricks", Items.RED_NETHER_BRICKS, 4, "nether_wart");
        TaskCatalogue.smelt("cracked_stone_bricks", Items.CRACKED_STONE_BRICKS, "stone_bricks", new Item[0]);
        TaskCatalogue.smelt("cracked_nether_bricks", Items.CRACKED_NETHER_BRICKS, "nether_bricks", new Item[0]);
        TaskCatalogue.smelt("cracked_polished_blackstone_bricks", Items.CRACKED_POLISHED_BLACKSTONE_BRICKS, "polished_blackstone_bricks", new Item[0]);
        TaskCatalogue.smelt("cracked_deepslate_bricks", Items.CRACKED_DEEPSLATE_BRICKS, "deepslate_bricks", new Item[0]);
        TaskCatalogue.smelt("cracked_deepslate_tiles", Items.CRACKED_DEEPSLATE_TILES, "deepslate_tiles", new Item[0]);
        TaskCatalogue.smelt("smooth_sandstone", Items.SMOOTH_SANDSTONE, "sandstone", new Item[0]);
        TaskCatalogue.smelt("smooth_red_sandstone", Items.SMOOTH_RED_SANDSTONE, "red_sandstone", new Item[0]);
        String B = "nether_bricks";
        String str13 = "nether_brick";
        TaskCatalogue.shapedRecipe3x3("nether_brick_fence", Items.NETHER_BRICK_FENCE, 6, o, o, o, B, str13, B, B, str13, B);
        TaskCatalogue.shapedRecipe3x3("brush", Items.BRUSH, 1, o, "feather", o, o, "copper_ingot", o, o, s, o);
        TaskCatalogue.shapedRecipe3x3("paper", Items.PAPER, 3, "sugar_cane", "sugar_cane", "sugar_cane", o, o, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("book", Items.BOOK, 1, "paper", "paper", "paper", "leather");
        TaskCatalogue.shapedRecipe2x2("writable_book", Items.WRITABLE_BOOK, 1, "book", "ink_sac", o, "feather");
        TaskCatalogue.alias("book_and_quill", "writable_book");
        TaskCatalogue.shapedRecipe3x3("bowl", Items.BOWL, 4, p, o, p, o, p, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("blaze_powder", Items.BLAZE_POWDER, 2, "blaze_rod", o, o, o);
        TaskCatalogue.shapedRecipe2x2("ender_eye", Items.ENDER_EYE, 1, "blaze_powder", "ender_pearl", o, o);
        TaskCatalogue.alias("eye_of_ender", "ender_eye");
        TaskCatalogue.shapedRecipe2x2("fermented_spider_eye", Items.FERMENTED_SPIDER_EYE, 1, "brown_mushroom", "sugar", o, "spider_eye");
        TaskCatalogue.shapedRecipe3x3("fire_charge", Items.FIRE_CHARGE, 3, o, "blaze_powder", o, o, "coal", o, o, "gunpowder", o);
        TaskCatalogue.shapedRecipe2x2("flower_banner_pattern", Items.FLOWER_BANNER_PATTERN, 1, "paper", "oxeye_daisy", o, o);
        TaskCatalogue.simple("magma_cream", Items.MAGMA_CREAM, CollectMagmaCreamTask::new);
        TaskCatalogue.shapedRecipeSlab("cobblestone_slab", Items.COBBLESTONE_SLAB, "cobblestone");
        TaskCatalogue.shapedRecipeStairs("cobblestone_stairs", Items.COBBLESTONE_STAIRS, "cobblestone");
        TaskCatalogue.shapedRecipeWall("cobblestone_wall", Items.COBBLESTONE_WALL, "cobblestone");
        TaskCatalogue.shapedRecipeSlab("stone_slab", Items.STONE_SLAB, "stone");
        TaskCatalogue.shapedRecipeStairs("stone_stairs", Items.STONE_STAIRS, "stone");
        TaskCatalogue.shapedRecipeSlab("smooth_stone_slab", Items.SMOOTH_STONE_SLAB, "smooth_stone");
        TaskCatalogue.shapedRecipeSlab("stone_brick_slab", Items.STONE_BRICK_SLAB, "stone_bricks");
        TaskCatalogue.shapedRecipeStairs("stone_brick_stairs", Items.STONE_BRICK_STAIRS, "stone_bricks");
        TaskCatalogue.shapedRecipeWall("stone_brick_wall", Items.STONE_BRICK_WALL, "stone_bricks");
        TaskCatalogue.shapedRecipeSlab("mossy_stone_brick_slab", Items.MOSSY_STONE_BRICK_SLAB, "mossy_stone_bricks");
        TaskCatalogue.shapedRecipeStairs("mossy_stone_brick_stairs", Items.MOSSY_STONE_BRICK_STAIRS, "mossy_stone_bricks");
        TaskCatalogue.shapedRecipeWall("mossy_stone_brick_wall", Items.MOSSY_STONE_BRICK_WALL, "mossy_stone_bricks");
        TaskCatalogue.shapedRecipeSlab("mossy_cobblestone_slab", Items.MOSSY_COBBLESTONE_SLAB, "mossy_cobblestone");
        TaskCatalogue.shapedRecipeStairs("mossy_cobblestone_stairs", Items.MOSSY_COBBLESTONE_STAIRS, "mossy_cobblestone");
        TaskCatalogue.shapedRecipeWall("mossy_cobblestone_wall", Items.MOSSY_COBBLESTONE_WALL, "mossy_cobblestone");
        TaskCatalogue.shapedRecipeSlab("andesite_slab", Items.ANDESITE_SLAB, "andesite");
        TaskCatalogue.shapedRecipeStairs("andesite_stairs", Items.ANDESITE_STAIRS, "andesite");
        TaskCatalogue.shapedRecipeWall("andesite_wall", Items.ANDESITE_WALL, "andesite");
        TaskCatalogue.shapedRecipeSlab("granite_slab", Items.GRANITE_SLAB, "granite");
        TaskCatalogue.shapedRecipeStairs("granite_stairs", Items.GRANITE_STAIRS, "granite");
        TaskCatalogue.shapedRecipeWall("granite_wall", Items.GRANITE_WALL, "granite");
        TaskCatalogue.shapedRecipeSlab("diorite_slab", Items.DIORITE_SLAB, "diorite");
        TaskCatalogue.shapedRecipeStairs("diorite_stairs", Items.DIORITE_STAIRS, "diorite");
        TaskCatalogue.shapedRecipeWall("diorite_wall", Items.DIORITE_WALL, "diorite");
        TaskCatalogue.shapedRecipeSlab("polished_andesite_slab", Items.POLISHED_ANDESITE_SLAB, "polished_andesite");
        TaskCatalogue.shapedRecipeStairs("polished_andesite_stairs", Items.POLISHED_ANDESITE_STAIRS, "polished_andesite");
        TaskCatalogue.shapedRecipeSlab("polished_granite_slab", Items.POLISHED_GRANITE_SLAB, "polished_granite");
        TaskCatalogue.shapedRecipeStairs("polished_granite_stairs", Items.POLISHED_GRANITE_STAIRS, "polished_granite");
        TaskCatalogue.shapedRecipeSlab("polished_diorite_slab", Items.POLISHED_DIORITE_SLAB, "polished_diorite");
        TaskCatalogue.shapedRecipeStairs("polished_diorite_stairs", Items.POLISHED_DIORITE_STAIRS, "polished_diorite");
        TaskCatalogue.shapedRecipeSlab("sandstone_slab", Items.SANDSTONE_SLAB, "sandstone");
        TaskCatalogue.shapedRecipeStairs("sandstone_stairs", Items.SANDSTONE_STAIRS, "sandstone");
        TaskCatalogue.shapedRecipeWall("sandstone_wall", Items.SANDSTONE_WALL, "sandstone");
        TaskCatalogue.shapedRecipeSlab("cut_sandstone_slab", Items.CUT_STANDSTONE_SLAB, "cut_sandstone");
        TaskCatalogue.shapedRecipeSlab("smooth_sandstone_slab", Items.SMOOTH_SANDSTONE_SLAB, "smooth_sandstone");
        TaskCatalogue.shapedRecipeStairs("smooth_sandstone_stairs", Items.SMOOTH_SANDSTONE_STAIRS, "smooth_sandstone");
        TaskCatalogue.shapedRecipeSlab("red_sandstone_slab", Items.RED_SANDSTONE_SLAB, "red_sandstone");
        TaskCatalogue.shapedRecipeStairs("red_sandstone_stairs", Items.RED_SANDSTONE_STAIRS, "red_sandstone");
        TaskCatalogue.shapedRecipeWall("red_sandstone_wall", Items.RED_SANDSTONE_WALL, "red_sandstone");
        TaskCatalogue.shapedRecipeSlab("cut_red_sandstone_slab", Items.CUT_RED_SANDSTONE_SLAB, "cut_red_sandstone");
        TaskCatalogue.shapedRecipeSlab("smooth_red_sandstone_slab", Items.SMOOTH_RED_SANDSTONE_SLAB, "smooth_red_sandstone");
        TaskCatalogue.shapedRecipeStairs("smooth_red_sandstone_stairs", Items.SMOOTH_RED_SANDSTONE_STAIRS, "smooth_red_sandstone");
        TaskCatalogue.shapedRecipeSlab("nether_brick_slab", Items.NETHER_BRICK_SLAB, "nether_bricks");
        TaskCatalogue.shapedRecipeStairs("nether_brick_stairs", Items.NETHER_BRICK_STAIRS, "nether_bricks");
        TaskCatalogue.shapedRecipeWall("nether_brick_wall", Items.NETHER_BRICK_WALL, "nether_bricks");
        TaskCatalogue.shapedRecipeSlab("red_nether_brick_slab", Items.RED_NETHER_BRICK_SLAB, "red_nether_bricks");
        TaskCatalogue.shapedRecipeStairs("red_nether_brick_stairs", Items.RED_NETHER_BRICK_STAIRS, "red_nether_bricks");
        TaskCatalogue.shapedRecipeWall("red_nether_brick_wall", Items.RED_NETHER_BRICK_WALL, "red_nether_bricks");
        TaskCatalogue.shapedRecipeSlab("quartz_slab", Items.QUARTZ_SLAB, "quartz_block");
        TaskCatalogue.shapedRecipeStairs("quartz_stairs", Items.QUARTZ_STAIRS, "quartz_block");
        TaskCatalogue.shapedRecipeSlab("smooth_quartz_slab", Items.SMOOTH_QUARTZ_SLAB, "smooth_quartz");
        TaskCatalogue.shapedRecipeStairs("smooth_quartz_stairs", Items.SMOOTH_QUARTZ_STAIRS, "smooth_quartz");
        TaskCatalogue.shapedRecipeSlab("blackstone_slab", Items.BLACKSTONE_SLAB, "blackstone");
        TaskCatalogue.shapedRecipeStairs("blackstone_stairs", Items.BLACKSTONE_STAIRS, "blackstone");
        TaskCatalogue.shapedRecipeWall("blackstone_wall", Items.BLACKSTONE_WALL, "blackstone");
        TaskCatalogue.shapedRecipeSlab("polished_blackstone_slab", Items.POLISHED_BLACKSTONE_SLAB, "polished_blackstone");
        TaskCatalogue.shapedRecipeStairs("polished_blackstone_stairs", Items.POLISHED_BLACKSTONE_STAIRS, "polished_blackstone");
        TaskCatalogue.shapedRecipeWall("polished_blackstone_wall", Items.POLISHED_BLACKSTONE_WALL, "polished_blackstone");
        TaskCatalogue.shapedRecipeSlab("polished_blackstone_brick_slab", Items.POLISHED_BLACKSTONE_BRICK_SLAB, "polished_blackstone_bricks");
        TaskCatalogue.shapedRecipeStairs("polished_blackstone_brick_stairs", Items.POLISHED_BLACKSTONE_BRICK_STAIRS, "polished_blackstone_bricks");
        TaskCatalogue.shapedRecipeWall("polished_blackstone_brick_wall", Items.POLISHED_BLACKSTONE_BRICK_WALL, "polished_blackstone_bricks");
        TaskCatalogue.shapedRecipeSlab("cut_copper_slab", Items.CUT_COPPER_SLAB, "cut_copper");
        TaskCatalogue.shapedRecipeStairs("cut_copper_stairs", Items.CUT_COPPER_STAIRS, "cut_copper");
        TaskCatalogue.shapedRecipeSlab("cobbled_deepslate_slab", Items.COBBLED_DEEPSLATE_SLAB, "cobbled_deepslate");
        TaskCatalogue.shapedRecipeStairs("cobbled_deepslate_stairs", Items.COBBLED_DEEPSLATE_STAIRS, "cobbled_deepslate");
        TaskCatalogue.shapedRecipeWall("cobbled_deepslate_wall", Items.COBBLED_DEEPSLATE_WALL, "cobbled_deepslate");
        TaskCatalogue.shapedRecipeSlab("polished_deepslate_slab", Items.POLISHED_DEEPSLATE_SLAB, "polished_deepslate");
        TaskCatalogue.shapedRecipeStairs("polished_deepslate_stairs", Items.POLISHED_DEEPSLATE_STAIRS, "polished_deepslate");
        TaskCatalogue.shapedRecipeWall("polished_deepslate_wall", Items.POLISHED_DEEPSLATE_WALL, "polished_deepslate");
        TaskCatalogue.shapedRecipeSlab("deepslate_brick_slab", Items.DEEPSLATE_BRICK_SLAB, "deepslate_bricks");
        TaskCatalogue.shapedRecipeStairs("deepslate_brick_stairs", Items.DEEPSLATE_BRICK_STAIRS, "deepslate_bricks");
        TaskCatalogue.shapedRecipeWall("deepslate_brick_wall", Items.DEEPSLATE_BRICK_WALL, "deepslate_bricks");
        TaskCatalogue.shapedRecipeSlab("deepslate_tile_slab", Items.DEEPSLATE_TILE_SLAB, "deepslate_tiles");
        TaskCatalogue.shapedRecipeStairs("deepslate_tile_stairs", Items.DEEPSLATE_TILE_STAIRS, "deepslate_tiles");
        TaskCatalogue.shapedRecipeWall("deepslate_tile_wall", Items.DEEPSLATE_TILE_WALL, "deepslate_tiles");
        TaskCatalogue.shapedRecipe2x2("chiseled_sandstone", Items.CHISELED_SANDSTONE, 1, "sandstone_slab", o, "sandstone_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_red_sandstone", Items.CHISELED_RED_SANDSTONE, 1, "red_sandstone_slab", o, "red_sandstone_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_stone_bricks", Items.CHISELED_STONE_BRICKS, 1, "stone_brick_slab", o, "stone_brick_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_nether_bricks", Items.CHISELED_NETHER_BRICKS, 1, "nether_brick_slab", o, "nether_brick_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_quartz_block", Items.CHISELED_QUARTZ_BLOCK, 1, "quartz_slab", o, "quartz_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_deepslate", Items.CHISELED_DEEPSLATE, 1, "cobbled_deepslate_slab", o, "cobbled_deepslate_slab", o);
        TaskCatalogue.tools("wooden", "planks", Items.WOODEN_PICKAXE, Items.WOODEN_SHOVEL, Items.WOODEN_SWORD, Items.WOODEN_AXE, Items.WOODEN_HOE);
        TaskCatalogue.tools("stone", "cobblestone", Items.STONE_PICKAXE, Items.STONE_SHOVEL, Items.STONE_SWORD, Items.STONE_AXE, Items.STONE_HOE);
        TaskCatalogue.tools("iron", "iron_ingot", Items.IRON_PICKAXE, Items.IRON_SHOVEL, Items.IRON_SWORD, Items.IRON_AXE, Items.IRON_HOE);
        TaskCatalogue.tools("golden", "gold_ingot", Items.GOLDEN_PICKAXE, Items.GOLDEN_SHOVEL, Items.GOLDEN_SWORD, Items.GOLDEN_AXE, Items.GOLDEN_HOE);
        TaskCatalogue.tools("diamond", "diamond", Items.DIAMOND_PICKAXE, Items.DIAMOND_SHOVEL, Items.DIAMOND_SWORD, Items.DIAMOND_AXE, Items.DIAMOND_HOE);
        TaskCatalogue.armor("leather", "leather", Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS);
        TaskCatalogue.armor("iron", "iron_ingot", Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS);
        TaskCatalogue.armor("golden", "gold_ingot", Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS);
        TaskCatalogue.armor("diamond", "diamond", Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS);
        TaskCatalogue.smith("netherite_helmet", Items.NETHERITE_HELMET, "netherite_ingot", "diamond_helmet");
        TaskCatalogue.smith("netherite_chestplate", Items.NETHERITE_CHESTPLATE, "netherite_ingot", "diamond_chestplate");
        TaskCatalogue.smith("netherite_leggings", Items.NETHERITE_LEGGINGS, "netherite_ingot", "diamond_leggings");
        TaskCatalogue.smith("netherite_boots", Items.NETHERITE_BOOTS, "netherite_ingot", "diamond_boots");
        TaskCatalogue.smith("netherite_pickaxe", Items.NETHERITE_PICKAXE, "netherite_ingot", "diamond_pickaxe");
        TaskCatalogue.smith("netherite_axe", Items.NETHERITE_AXE, "netherite_ingot", "diamond_axe");
        TaskCatalogue.smith("netherite_shovel", Items.NETHERITE_SHOVEL, "netherite_ingot", "diamond_shovel");
        TaskCatalogue.smith("netherite_sword", Items.NETHERITE_SWORD, "netherite_ingot", "diamond_sword");
        TaskCatalogue.smith("netherite_hoe", Items.NETHERITE_HOE, "netherite_ingot", "diamond_hoe");
        TaskCatalogue.shapedRecipe3x3("bow", Items.BOW, 1, "string", s, o, "string", o, s, "string", s, o);
        TaskCatalogue.shapedRecipe3x3("arrow", Items.ARROW, 4, "flint", o, o, s, o, o, "feather", o, o);
        String str7 = "iron_ingot";
        TaskCatalogue.shapedRecipe3x3("bucket", Items.BUCKET, 1, str7, o, str7, o, str7, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("flint_and_steel", Items.FLINT_AND_STEEL, 1, str7, o, o, "flint");
        TaskCatalogue.shapedRecipe2x2("shears", Items.SHEARS, 1, str7, o, o, str7);
        TaskCatalogue.shapedRecipe2x2("iron_nugget", Items.IRON_NUGGET, 9, str7, o, o, o);
        TaskCatalogue.shapedRecipe3x3("compass", Items.COMPASS, 1, o, str7, o, str7, "redstone", str7, o, str7, o);
        TaskCatalogue.shapedRecipe3x3("shield", Items.SHIELD, 1, p, str7, p, p, p, p, o, p, o);
        String str12 = "gold_ingot";
        TaskCatalogue.shapedRecipe3x3("clock", Items.CLOCK, 1, o, str12, o, str12, "redstone", str12, o, str12, o);
        TaskCatalogue.simple("water_bucket", Items.WATER_BUCKET, CollectBucketLiquidTask.CollectWaterBucketTask::new);
        TaskCatalogue.simple("lava_bucket", Items.LAVA_BUCKET, CollectBucketLiquidTask.CollectLavaBucketTask::new);
        String a = "paper";
        TaskCatalogue.shapedRecipe3x3("map", Items.MAP, 1, a, a, a, a, "compass", a, a, a, a);
        TaskCatalogue.shapedRecipe3x3("fishing_rod", Items.FISHING_ROD, 1, o, o, s, o, s, "string", s, o, "string");
        TaskCatalogue.shapedRecipe2x2("carrot_on_a_stick", Items.CARROT_ON_A_STICK, 1, "fishing_rod", "carrot", o, o);
        TaskCatalogue.shapedRecipe2x2("warped_fungus_on_a_stick", Items.WARPED_FUNGUS_ON_A_STICK, 1, "fishing_rod", "warped_fungus", o, o);
        TaskCatalogue.shapedRecipe3x3("spyglass", Items.SPYGLASS, 1, o, "amethyst_shard", o, o, "copper_ingot", o, o, "copper_ingot", o);
        TaskCatalogue.shapedRecipe3x3("glass_bottle", Items.GLASS_BOTTLE, 3, "glass", o, "glass", o, "glass", o, o, o, o);
        String str6 = "leather";
        TaskCatalogue.shapedRecipe3x3("leather_horse_armor", Items.LEATHER_HORSE_ARMOR, 1, str6, o, str6, str6, str6, str6, str6, o, str6);
        TaskCatalogue.alias("wooden_pick", "wooden_pickaxe");
        TaskCatalogue.alias("stone_pick", "stone_pickaxe");
        TaskCatalogue.alias("iron_pick", "iron_pickaxe");
        TaskCatalogue.alias("gold_pick", "golden_pickaxe");
        TaskCatalogue.alias("diamond_pick", "diamond_pickaxe");
        TaskCatalogue.alias("netherite_pick", "netherite_pickaxe");
        TaskCatalogue.simple("boat", ItemHelper.WOOD_BOAT, CollectBoatTask::new);
        TaskCatalogue.woodTasks("boat", woodItems -> woodItems.boat, (woodItems, count) -> new CollectBoatTask(woodItems.boat, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.shapedRecipe3x3("lead", Items.LEAD, 1, "string", "string", o, "string", "slime_ball", o, o, o, "string");
        TaskCatalogue.simple("honeycomb", Items.HONEYCOMB, CollectHoneycombTask::new);
        String h = "honeycomb";
        TaskCatalogue.shapedRecipe2x2Block("honeycomb_block", Items.HONEYCOMB_BLOCK, h);
        TaskCatalogue.shapedRecipe2x2("candle", Items.CANDLE, 1, "string", o, h, o);
        TaskCatalogue.shapedRecipe3x3("beehive", Items.BEEHIVE, 1, p, p, p, h, h, h, p, p, p);
        TaskCatalogue.shapedRecipe2x2("crafting_table", Items.CRAFTING_TABLE, 1, p, p, p, p).dontMineIfPresent();
        TaskCatalogue.shapedRecipe3x3("smithing_table", Items.SMITHING_TABLE, 1, "iron_ingot", "iron_ingot", o, p, p, o, p, p, o);
        TaskCatalogue.shapedRecipe3x3("grindstone", Items.GRINDSTONE, 1, s, "stone_slab", s, p, o, p, o, o, o);
        TaskCatalogue.simple("wooden_pressure_plate", ItemHelper.WOOD_PRESSURE_PLATE, CollectWoodenPressurePlateTask::new);
        TaskCatalogue.woodTasks("pressure_plate", woodItems -> woodItems.pressurePlate, (woodItems, count) -> new CollectWoodenPressurePlateTask(woodItems.pressurePlate, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_button", ItemHelper.WOOD_BUTTON, CollectWoodenButtonTask::new);
        TaskCatalogue.woodTasks("button", woodItems -> woodItems.button, (woodItems, count) -> new CraftInInventoryTask(new RecipeTarget(woodItems.button, 1, CraftingRecipe.newShapedRecipe(woodItems.prefix + "_button", new ItemTarget[]{new ItemTarget(woodItems.planks, 1), null, null, null}, 1))));
        TaskCatalogue.shapedRecipe2x2("stone_pressure_plate", Items.STONE_PRESSURE_PLATE, 1, o, o, "stone", "stone");
        TaskCatalogue.shapedRecipe2x2("stone_button", Items.STONE_BUTTON, 1, "stone", o, o, o);
        TaskCatalogue.shapedRecipe2x2("polished_blackstone_pressure_plate", Items.POLISHED_BLACKSTONE_PRESSURE_PLATE, 1, o, o, "polished_blackstone", "polished_blackstone");
        TaskCatalogue.shapedRecipe2x2("polished_blackstone_button", Items.POLISHED_BLACKSTONE_BUTTON, 1, "polished_blackstone", o, o, o);
        TaskCatalogue.simple("sign", ItemHelper.WOOD_SIGN, CollectSignTask::new).dontMineIfPresent();
        TaskCatalogue.woodTasks("sign", woodItems -> woodItems.sign, (woodItems, count) -> new CollectSignTask(woodItems.sign, woodItems.prefix + "_planks", (int)count));
        String str5 = "cobblestone";
        TaskCatalogue.shapedRecipe3x3("furnace", Items.FURNACE, 1, str5, str5, str5, str5, o, str5, str5, str5, str5).dontMineIfPresent();
        TaskCatalogue.shapedRecipe3x3("dropper", Items.DROPPER, 1, str5, str5, str5, str5, o, str5, str5, "redstone", str5);
        TaskCatalogue.shapedRecipe3x3("dispenser", Items.DISPENSER, 1, str5, str5, str5, str5, "bow", str5, str5, "redstone", str5);
        TaskCatalogue.shapedRecipe3x3("brewing_stand", Items.BREWING_STAND, 1, o, o, o, o, "blaze_rod", o, str5, str5, str5);
        TaskCatalogue.shapedRecipe3x3("piston", Items.PISTON, 1, p, p, p, str5, "iron_ingot", str5, str5, "redstone", str5);
        TaskCatalogue.shapedRecipe3x3("observer", Items.OBSERVER, 1, str5, str5, str5, "redstone", "redstone", "quartz", str5, str5, str5);
        TaskCatalogue.shapedRecipe2x2("lever", Items.LEVER, 1, s, o, str5, o);
        TaskCatalogue.simple("hanging_sign", ItemHelper.WOOD_HANGING_SIGN, CollectHangingSignTask::new).dontMineIfPresent();
        TaskCatalogue.woodTasks("hanging_sign", woodItems -> woodItems.hangingSign, (woodItems, count) -> new CollectHangingSignTask(woodItems.hangingSign, woodItems.prefix + "_stripped_logs", (int)count));
        TaskCatalogue.shapedRecipe3x3("chest", Items.CHEST, 1, p, p, p, p, o, p, p, p, p).dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2("torch", Items.TORCH, 4, "coal", o, s, o);
        TaskCatalogue.simple("bed", ItemHelper.BED, CollectBedTask::new);
        TaskCatalogue.colorfulTasks("bed", colors -> colors.bed, (colors, count) -> new CollectBedTask(colors.bed, colors.colorName + "_wool", (int)count));
        String str4 = "iron_ingot";
        String str11 = "iron_block";
        String m = "smooth_stone";
        TaskCatalogue.shapedRecipe3x3("anvil", Items.ANVIL, 1, str11, str11, str11, o, str4, o, str4, str4, str4);
        TaskCatalogue.shapedRecipe3x3("cauldron", Items.CAULDRON, 1, str4, o, str4, str4, o, str4, str4, str4, str4);
        TaskCatalogue.shapedRecipe3x3("minecart", Items.MINECART, 1, o, o, o, str4, o, str4, str4, str4, str4);
        TaskCatalogue.shapedRecipe3x3("iron_door", Items.IRON_DOOR, 3, str4, str4, o, str4, str4, o, str4, str4, o);
        TaskCatalogue.shapedRecipe3x3("iron_bars", Items.IRON_BARS, 16, str4, str4, str4, str4, str4, str4, o, o, o);
        TaskCatalogue.shapedRecipe3x3("blast_furnace", Items.BLAST_FURNACE, 1, str4, str4, str4, str4, "furnace", str4, m, m, m);
        TaskCatalogue.shapedRecipe2x2Block("iron_trapdoor", Items.IRON_TRAPDOOR, str4);
        TaskCatalogue.shapedRecipe3x3("armor_stand", Items.ARMOR_STAND, 1, s, s, s, o, s, o, s, "smooth_stone_slab", s);
        String str3 = "obsidian";
        TaskCatalogue.shapedRecipe3x3("enchanting_table", Items.ENCHANTING_TABLE, 1, o, "book", o, "diamond", str3, "diamond", str3, str3, str3);
        TaskCatalogue.shapedRecipe3x3("ender_chest", Items.ENDER_CHEST, 1, str3, str3, str3, str3, "ender_eye", str3, str3, str3, str3).dontMineIfPresent();
        str3 = "brick";
        TaskCatalogue.shapedRecipe3x3("decorated_pot", Items.DECORATED_POT, 1, o, str3, o, str3, o, str3, o, str3, o);
        TaskCatalogue.shapedRecipe3x3("flower_pot", Items.FLOWER_POT, 1, str3, o, str3, o, str3, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2Block("bricks", Items.BRICKS, str3);
        TaskCatalogue.shapedRecipeSlab("brick_slab", Items.BRICK_SLAB, str3);
        TaskCatalogue.shapedRecipeStairs("brick_stairs", Items.BRICK_STAIRS, str3);
        TaskCatalogue.shapedRecipeStairs("brick_wall", Items.BRICK_WALL, "brick");
        TaskCatalogue.shapedRecipe3x3("ladder", Items.LADDER, 3, s, o, s, s, s, s, s, o, s);
        TaskCatalogue.shapedRecipe3x3("jukebox", Items.JUKEBOX, 1, p, p, p, p, "diamond", p, p, p, p);
        TaskCatalogue.shapedRecipe3x3("note_block", Items.NOTE_BLOCK, 1, p, p, p, p, "redstone", p, p, p, p);
        TaskCatalogue.shapedRecipe3x3("redstone_lamp", Items.REDSTONE_LAMP, 1, o, "redstone", o, "redstone", "glowstone", "redstone", o, "redstone", o);
        TaskCatalogue.shapedRecipe3x3("bookshelf", Items.BOOKSHELF, 1, p, p, p, "book", "book", "book", p, p, p);
        TaskCatalogue.shapedRecipe2x2("loom", Items.LOOM, 1, "string", "string", p, p);
        String str2 = "glass";
        TaskCatalogue.shapedRecipe3x3("glass_pane", Items.GLASS_PANE, 16, str2, str2, str2, str2, str2, str2, o, o, o).dontMineIfPresent();
        TaskCatalogue.simple("carved_pumpkin", Items.CARVED_PUMPKIN, (Integer count) -> new CarveThenCollectTask(Items.CARVED_PUMPKIN, (int)count, Blocks.CARVED_PUMPKIN, Items.PUMPKIN, Blocks.PUMPKIN, Items.SHEARS));
        TaskCatalogue.shapedRecipe2x2("jack_o_lantern", Items.JACK_O_LANTERN, 1, "carved_pumpkin", o, "torch", o);
        TaskCatalogue.shapedRecipe3x3("target", Items.TARGET, 1, o, "redstone", o, "redstone", "hay_block", "redstone", o, "redstone", o);
        TaskCatalogue.shapedRecipe3x3("campfire", Items.CAMPFIRE, 1, o, s, o, s, "coal", s, "log", "log", "log");
        TaskCatalogue.shapedRecipe3x3("soul_campfire", Items.SOUL_CAMPFIRE, 1, o, s, o, s, "soul_soil", s, "log", "log", "log");
        TaskCatalogue.shapedRecipe3x3("soul_torch", Items.SOUL_TORCH, 4, o, "coal", o, o, s, o, o, "soul_soil", o);
        String l = "log";
        TaskCatalogue.shapedRecipe3x3("smoker", Items.SMOKER, 1, o, l, o, l, "furnace", l, o, l, o);
        String str1 = "iron_nugget";
        TaskCatalogue.shapedRecipe3x3("lantern", Items.LANTERN, 1, str1, str1, str1, str1, "torch", str1, str1, str1, str1);
        TaskCatalogue.shapedRecipe3x3("soul_lantern", Items.SOUL_LANTERN, 1, str1, str1, str1, str1, "soul_torch", str1, str1, str1, str1);
        TaskCatalogue.shapedRecipe3x3("chain", Items.CHAIN, 1, o, str1, o, o, "iron_ingot", o, o, str1, o);
        String c = "chiseled_stone_bricks";
        TaskCatalogue.shapedRecipe3x3("lodestone", Items.LODESTONE, 1, c, c, c, c, "netherite_ingot", c, c, c, c);
        TaskCatalogue.shapedRecipe3x3("lightning_rod", Items.LIGHTNING_ROD, 1, o, "copper_ingot", o, o, "copper_ingot", o, o, "copper_ingot", o);
        TaskCatalogue.shapedRecipe3x3("tinted_glass", Items.TINTED_GLASS, 2, o, "amethyst_shard", o, "amethyst_shard", "glass", "amethyst_shard", o, "amethyst_shard", o);
        TaskCatalogue.simple("wooden_stairs", ItemHelper.WOOD_STAIRS, CollectWoodenStairsTask::new);
        TaskCatalogue.woodTasks("stairs", woodItems -> woodItems.stairs, (woodItems, count) -> new CollectWoodenStairsTask(woodItems.stairs, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_slab", ItemHelper.WOOD_SLAB, CollectWoodenSlabTask::new);
        TaskCatalogue.woodTasks("slab", woodItems -> woodItems.slab, (woodItems, count) -> new CollectWoodenSlabTask(woodItems.slab, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_door", ItemHelper.WOOD_DOOR, CollectWoodenDoorTask::new);
        TaskCatalogue.woodTasks("door", woodItems -> woodItems.door, (woodItems, count) -> new CollectWoodenDoorTask(woodItems.door, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_trapdoor", ItemHelper.WOOD_TRAPDOOR, CollectWoodenTrapDoorTask::new);
        TaskCatalogue.woodTasks("trapdoor", woodItems -> woodItems.trapdoor, (woodItems, count) -> new CollectWoodenTrapDoorTask(woodItems.trapdoor, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_fence", ItemHelper.WOOD_FENCE, CollectFenceTask::new);
        TaskCatalogue.woodTasks("fence", woodItems -> woodItems.fence, (woodItems, count) -> new CollectFenceTask(woodItems.fence, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_fence_gate", ItemHelper.WOOD_FENCE_GATE, CollectFenceGateTask::new);
        TaskCatalogue.woodTasks("fence_gate", woodItems -> woodItems.fenceGate, (woodItems, count) -> new CollectFenceGateTask(woodItems.fenceGate, woodItems.prefix + "_planks", (int)count));
        String r = "wooden_slab";
        TaskCatalogue.shapedRecipe3x3("chiseled_bookshelf", Items.CHISELED_BOOKSHELF, 1, p, p, p, r, r, r, p, p, p).dontMineIfPresent();
        TaskCatalogue.shapedRecipe3x3("barrel", Items.BARREL, 1, p, r, p, p, o, p, p, r, p);
        TaskCatalogue.shapedRecipe3x3("cartography_table", Items.CARTOGRAPHY_TABLE, 1, "paper", "paper", o, p, p, o, p, p, o);
        TaskCatalogue.shapedRecipe3x3("composter", Items.COMPOSTER, 1, r, o, r, r, o, r, r, r, r);
        TaskCatalogue.shapedRecipe3x3("fletching_table", Items.FLETCHING_TABLE, 1, "flint", "flint", o, p, p, o, p, p, o);
        TaskCatalogue.shapedRecipe3x3("lectern", Items.LECTERN, 1, r, r, r, o, "bookshelf", o, o, r, o);
        TaskCatalogue.alias("door", "wooden_door");
        TaskCatalogue.alias("trapdoor", "wooden_trapdoor");
        TaskCatalogue.alias("fence", "wooden_fence");
        TaskCatalogue.alias("fence_gate", "wooden_fence_gate");
        TaskCatalogue.shapedRecipe2x2("heavy_weighted_pressure_plate", Items.HEAVY_WEIGHTED_PRESSURE_PLATE, 1, "iron_ingot", "iron_ingot", o, o);
        TaskCatalogue.shapedRecipe2x2("light_weighted_pressure_plate", Items.LIGHT_WEIGHTED_PRESSURE_PLATE, 1, "gold_ingot", "gold_ingot", o, o);
        TaskCatalogue.shapedRecipe3x3("daylight_detector", Items.DAYLIGHT_DETECTOR, 1, "glass", "glass", "glass", "quartz", "quartz", "quartz", "wooden_slab", "wooden_slab", "wooden_slab");
        TaskCatalogue.shapedRecipe3x3("tripwire_hook", Items.TRIPWIRE_HOOK, 2, "iron_ingot", o, o, "stick", o, o, "planks", o, o);
        TaskCatalogue.shapedRecipe2x2("trapped_chest", Items.TRAPPED_CHEST, 1, "chest", "tripwire_hook", o, o);
        TaskCatalogue.shapedRecipe3x3("crossbow", Items.CROSSBOW, 1, s, "iron_ingot", s, "string", "tripwire_hook", "string", o, s, o);
        String t = "gunpowder";
        String n = "sand";
        TaskCatalogue.shapedRecipe3x3("tnt", Items.TNT, 1, t, n, t, n, t, n, t, n, t);
        TaskCatalogue.shapedRecipe2x2("sticky_piston", Items.STICKY_PISTON, 1, "slime_ball", o, "piston", o);
        TaskCatalogue.shapedRecipe2x2("redstone_torch", Items.REDSTONE_TORCH, 1, "redstone", o, s, o);
        TaskCatalogue.shapedRecipe3x3("repeater", Items.REPEATER, 1, "redstone_torch", "redstone", "redstone_torch", "stone", "stone", "stone", o, o, o);
        TaskCatalogue.shapedRecipe3x3("comparator", Items.COMPARATOR, 1, o, "redstone_torch", o, "redstone_torch", "quartz", "redstone_torch", "stone", "stone", "stone");
        String i = "iron_ingot";
        String str10 = "gold_ingot";
        TaskCatalogue.shapedRecipe3x3("rail", Items.RAIL, 16, i, o, i, i, s, i, i, o, i);
        TaskCatalogue.shapedRecipe3x3("powered_rail", Items.POWERED_RAIL, 6, str10, o, str10, str10, s, str10, str10, "redstone", str10);
        TaskCatalogue.shapedRecipe3x3("detector_rail", Items.DETECTOR_RAIL, 6, i, o, i, i, "stone_pressure_plate", i, i, "redstone", i);
        TaskCatalogue.shapedRecipe3x3("activator_rail", Items.ACTIVATOR_RAIL, 6, i, s, i, i, "redstone_torch", i, i, s, i);
        TaskCatalogue.shapedRecipe3x3("hopper", Items.HOPPER, 1, i, o, i, i, "chest", i, o, i, o);
        TaskCatalogue.shapedRecipe3x3("painting", Items.PAINTING, 1, s, s, s, s, "wool", s, s, s, s);
        TaskCatalogue.shapedRecipe3x3("item_frame", Items.ITEM_FRAME, 1, s, s, s, s, "leather", s, s, s, s);
        TaskCatalogue.shapedRecipe2x2("glow_item_frame", Items.GLOW_ITEM_FRAME, 1, "item_frame", "glow_ink_sac", o, o);
        TaskCatalogue.shapedRecipe2x2("chest_minecart", Items.CHEST_MINECART, 1, "chest", o, "minecart", o);
        TaskCatalogue.shapedRecipe2x2("furnace_minecart", Items.FURNACE_MINECART, 1, "furnace", o, "minecart", o);
        TaskCatalogue.shapedRecipe2x2("hopper_minecart", Items.HOPPER_MINECART, 1, "hopper", o, "minecart", o);
        TaskCatalogue.shapedRecipe2x2("tnt_minecart", Items.TNT_MINECART, 1, "tnt", o, "minecart", o);
        TaskCatalogue.alias("minecart_with_chest", "chest_minecart");
        TaskCatalogue.alias("minecart_with_furnace", "furnace_minecart");
        TaskCatalogue.alias("minecart_with_hopper", "hopper_minecart");
        TaskCatalogue.alias("minecart_with_tnt", "tnt_minecart");
        TaskCatalogue.mobCook("porkchop", Items.PORKCHOP, Items.COOKED_PORKCHOP, Pig.class);
        TaskCatalogue.mobCook("beef", Items.BEEF, Items.COOKED_BEEF, Cow.class);
        TaskCatalogue.mobCook("chicken", Items.CHICKEN, Items.COOKED_CHICKEN, Chicken.class);
        TaskCatalogue.mobCook("mutton", Items.MUTTON, Items.COOKED_MUTTON, Sheep.class);
        TaskCatalogue.mobCook("rabbit", Items.RABBIT, Items.COOKED_RABBIT, Rabbit.class);
        TaskCatalogue.mobCook("salmon", Items.SALMON, Items.COOKED_SALMON, Salmon.class);
        TaskCatalogue.mobCook("cod", Items.COD, Items.COOKED_COD, Cod.class);
        TaskCatalogue.simple("milk", Items.MILK_BUCKET, CollectMilkTask::new);
        TaskCatalogue.mine("apple", Blocks.OAK_LEAVES, Items.APPLE);
        TaskCatalogue.smelt("baked_potato", Items.BAKED_POTATO, "potato", new Item[0]);
        TaskCatalogue.shapedRecipe2x2("mushroom_stew", Items.MUSHROOM_STEW, 1, "red_mushroom", "brown_mushroom", "bowl", o);
        TaskCatalogue.shapedRecipe2x2("suspicious_stew", Items.SUSPICIOUS_STEW, 1, "red_mushroom", "brown_mushroom", "bowl", "flower");
        TaskCatalogue.shapedRecipe3x3("bread", Items.BREAD, 1, "wheat", "wheat", "wheat", o, o, o, o, o, o);
        TaskCatalogue.shapedRecipe3x3("cookie", Items.COOKIE, 8, "wheat", "cocoa_beans", "wheat", o, o, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("pumpkin_pie", Items.PUMPKIN_PIE, 1, "pumpkin", "sugar", o, "egg");
        TaskCatalogue.shapedRecipe3x3("cake", Items.CAKE, 1, "milk", "milk", "milk", "sugar", "egg", "sugar", "wheat", "wheat", "wheat").dontMineIfPresent();
        String g = "gold_nugget";
        TaskCatalogue.shapedRecipe3x3("golden_carrot", Items.GOLDEN_CARROT, 1, g, g, g, g, "carrot", g, g, g, g);
        String str9 = "gold_ingot";
        TaskCatalogue.shapedRecipe3x3("golden_apple", Items.GOLDEN_APPLE, 1, str9, str9, str9, str9, "apple", str9, str9, str9, str9);
        TaskCatalogue.shapedRecipe3x3("rabbit_stew", Items.RABBIT_STEW, 1, o, "cooked_rabbit", o, "carrot", "baked_potato", "mushroom", o, "bowl", o);
        String b = "beetroot";
        TaskCatalogue.shapedRecipe3x3("beetroot_soup", Items.BEETROOT_SOUP, 1, b, b, b, b, b, b, o, "bowl", o);
    }

    private static class CataloguedResource {
        private final Item[] targets;
        private final Function<Integer, ResourceTask> getResource;
        private boolean mineIfPresent;
        private boolean forceDimension = false;
        private Dimension targetDimension;

        public CataloguedResource(Item[] targets, Function<Integer, ResourceTask> getResource) {
            this.targets = targets;
            this.getResource = getResource;
        }

        public CataloguedResource mineIfPresent() {
            this.mineIfPresent = true;
            return this;
        }

        public CataloguedResource dontMineIfPresent() {
            this.mineIfPresent = false;
            return this;
        }

        public CataloguedResource forceDimension(Dimension dimension) {
            this.forceDimension = true;
            this.targetDimension = dimension;
            return this;
        }

        public CataloguedResource anyDimension() {
            this.forceDimension = false;
            return this;
        }

        public ResourceTask getResource(int count) {
            ResourceTask result = this.getResource.apply(count);
            if (this.mineIfPresent) {
                result = result.mineIfPresent(ItemHelper.itemsToBlocks(this.targets));
            }
            if (this.forceDimension) {
                result = result.forceDimension(this.targetDimension);
            }
            return result;
        }
    }
}

