/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.command.datatypes;

import com.player2.playerengine.automaton.api.command.datatypes.IDatatypeContext;
import com.player2.playerengine.automaton.api.command.datatypes.IDatatypeFor;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.command.helpers.TabCompleteHelper;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public enum BlockById implements IDatatypeFor<Block>
{
    INSTANCE;


    @Override
    public Block get(IDatatypeContext ctx) throws CommandException {
        ResourceLocation id = ResourceLocation.tryParse((String)ctx.getConsumer().getString());
        Block block = BuiltInRegistries.BLOCK.getOptional(id).orElse(null);
        if (block == null) {
            throw new IllegalArgumentException("no block found by that id");
        }
        return block;
    }

    @Override
    public Stream<String> tabComplete(IDatatypeContext ctx) throws CommandException {
        return new TabCompleteHelper().append(BuiltInRegistries.BLOCK.keySet().stream().map(Object::toString)).filterPrefixNamespaced(ctx.getConsumer().getString()).sortAlphabetically().stream();
    }
}

