/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.component;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class EntityComponentKey<C> {
    private final Map<UUID, C> storage = new HashMap<UUID, C>();
    private final Function<LivingEntity, C> factory;

    public EntityComponentKey(Function<LivingEntity, C> factory) {
        this.factory = factory;
    }

    @Nullable
    public C getNullable(Object object) {
        if (object instanceof LivingEntity) {
            LivingEntity provider = (LivingEntity)object;
            return this.storage.get(provider.getUUID()) == null ? null : (C)this.storage.get(provider.getUUID());
        }
        return null;
    }

    public final C get(Object object) {
        if (object instanceof LivingEntity) {
            LivingEntity provider = (LivingEntity)object;
            return (C)this.storage.computeIfAbsent(provider.getUUID(), u -> this.factory.apply(provider));
        }
        throw new NoSuchElementException();
    }

    public final Optional<C> maybeGet(@Nullable Object object) {
        if (object instanceof LivingEntity) {
            LivingEntity provider = (LivingEntity)object;
            return this.storage.get(provider.getUUID()) == null ? Optional.empty() : Optional.of(this.storage.get(provider.getUUID()));
        }
        return Optional.empty();
    }
}

