/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api;

import com.player2.playerengine.automaton.utils.DirUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;

public class TokenStorage {
    private static final Path PATH = DirUtil.getGameDir().resolve("playerengine_token_storage.dat");
    private static final TokenStorage INSTANCE = new TokenStorage();
    private CompoundTag tokensStored = new CompoundTag();

    private TokenStorage() {
        this.load();
    }

    static String getToken(String username) {
        return TokenStorage.getInstance().tokensStored.getString(username);
    }

    static void storeToken(String username, String token) {
        System.out.println("[PlayerEngineTokenStorage]: stored the token for player " + username);
        TokenStorage.getInstance().tokensStored.putString(username, token);
        TokenStorage.getInstance().save();
    }

    private void load() {
        if (Files.exists(PATH, new LinkOption[0])) {
            try {
                this.tokensStored = NbtIo.readCompressed((Path)PATH.toFile().toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (IOException var1) {
                var1.printStackTrace();
            }
        }
    }

    private void save() {
        System.out.println("[PlayerEngineTokenStorage]: save() called");
        try {
            NbtIo.writeCompressed((CompoundTag)this.tokensStored, (Path)PATH.toFile().toPath());
            System.out.println("[PlayerEngineTokenStorage]: Writing to file...");
        }
        catch (IOException var1) {
            System.err.println("[PlayerEngineTokenStorage]: Writing to file FAILED");
            var1.printStackTrace();
        }
    }

    private static TokenStorage getInstance() {
        return INSTANCE;
    }
}

