/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.auth;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.player2.playerengine.player2api.auth.AuthKey;
import com.player2.playerengine.player2api.auth.TokenStorage;
import com.player2.playerengine.player2api.utils.HTTPUtils;
import com.player2.playerengine.player2api.utils.HttpApiException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuthenticationManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String WEB_API_URL = "https://api.player2.game";
    private static final String LOCAL_API_URL = "http://127.0.0.1:4315";
    private static final AuthenticationManager INSTANCE = new AuthenticationManager();
    private static final ExecutorService authExecutor = Executors.newCachedThreadPool();
    private static final ScheduledExecutorService pollingExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Map<AuthKey, CompletableFuture<String>> ongoingAuths = new ConcurrentHashMap<AuthKey, CompletableFuture<String>>();
    private final Map<AuthKey, ScheduledFuture<?>> pollingTasks = new ConcurrentHashMap();

    public static AuthenticationManager getInstance() {
        return INSTANCE;
    }

    public static ExecutorService getExecutor() {
        return authExecutor;
    }

    public static ExecutorService getPollingExecutor() {
        return pollingExecutor;
    }

    public void invalidateToken(Player player, String clientId) {
        AuthKey authKey = new AuthKey(player.getUUID(), clientId);
        LOGGER.info("Invalidating token for {}", (Object)authKey);
        TokenStorage.storeToken(player.getName().getString(), clientId, "");
        this.authenticate(player, clientId);
    }

    public CompletableFuture<String> authenticate(Player player, String clientId) {
        AuthKey authKey = new AuthKey(player.getUUID(), clientId);
        String username = player.getName().getString();
        if (this.ongoingAuths.containsKey(authKey)) {
            return this.ongoingAuths.get(authKey);
        }
        String storedToken = TokenStorage.getToken(username, clientId);
        if (storedToken != null && !storedToken.isEmpty()) {
            LOGGER.info("Found stored token for {}", (Object)authKey);
            return CompletableFuture.completedFuture(storedToken);
        }
        CompletableFuture<String> authFuture = new CompletableFuture<String>();
        this.ongoingAuths.put(authKey, authFuture);
        authExecutor.submit(() -> {
            try {
                try {
                    LOGGER.info("Attempting local login for {}", (Object)authKey);
                    Map<String, JsonElement> response = HTTPUtils.sendRequest(LOCAL_API_URL, "/v1/login/web/" + clientId, true, new JsonObject(), null);
                    String p2Key = response.get("p2Key").getAsString();
                    if (p2Key != null) {
                        LOGGER.info("Local login successful for {}", (Object)authKey);
                        this.completeAuth(player, clientId, p2Key, authFuture);
                        return;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Local login for {} failed, proceeding to web auth. Error: {}", (Object)authKey, (Object)e.getMessage());
                }
                LOGGER.info("Starting web device flow for {}", (Object)authKey);
                JsonObject deviceCodeRequestBody = new JsonObject();
                deviceCodeRequestBody.addProperty("client_id", clientId);
                Map<String, JsonElement> deviceCodeResponse = HTTPUtils.sendRequest(WEB_API_URL, "/v1/login/device/new", true, deviceCodeRequestBody, null);
                String deviceCode = deviceCodeResponse.get("deviceCode").getAsString();
                String verificationUriComplete = deviceCodeResponse.get("verificationUriComplete").getAsString();
                int interval = deviceCodeResponse.get("interval").getAsInt();
                player.sendSystemMessage((Component)Component.literal((String)String.format("To use AI features from mod '%s', please authorize here: %s", clientId, verificationUriComplete)).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, verificationUriComplete))));
                this.startPolling(player, clientId, deviceCode, interval, authFuture);
            }
            catch (Exception e) {
                LOGGER.error("Authentication failed for {}", (Object)authKey, (Object)e);
                player.sendSystemMessage((Component)Component.literal((String)("Authentication process for mod '" + clientId + "' failed.")));
                authFuture.completeExceptionally(e);
                this.ongoingAuths.remove(authKey);
            }
        });
        return authFuture;
    }

    private void startPolling(Player player, String clientId, String deviceCode, int interval, CompletableFuture<String> authFuture) {
        AuthKey authKey = new AuthKey(player.getUUID(), clientId);
        ScheduledFuture<?> pollingTask = pollingExecutor.scheduleAtFixedRate(() -> {
            try {
                JsonObject tokenRequestBody = new JsonObject();
                tokenRequestBody.addProperty("client_id", clientId);
                tokenRequestBody.addProperty("device_code", deviceCode);
                tokenRequestBody.addProperty("grant_type", "urn:ietf:params:oauth:grant-type:device_code");
                Map<String, JsonElement> response = HTTPUtils.sendRequest(WEB_API_URL, "/v1/login/device/token", true, tokenRequestBody, null);
                String p2Key = response.get("p2Key").getAsString();
                if (p2Key != null) {
                    LOGGER.info("Device flow polling successful for {}", (Object)authKey);
                    this.completeAuth(player, clientId, p2Key, authFuture);
                }
            }
            catch (HttpApiException e) {
                if (!e.getMessage().contains("authorization_pending")) {
                    LOGGER.error("Error during polling for {}", (Object)authKey, (Object)e);
                    authFuture.completeExceptionally(e);
                    this.stopPolling(authKey);
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error during polling for {}", (Object)authKey, (Object)e);
                authFuture.completeExceptionally(e);
                this.stopPolling(authKey);
            }
        }, 0L, interval, TimeUnit.SECONDS);
        this.pollingTasks.put(authKey, pollingTask);
    }

    private void completeAuth(Player player, String clientId, String token, CompletableFuture<String> authFuture) {
        AuthKey authKey = new AuthKey(player.getUUID(), clientId);
        String username = player.getName().getString();
        TokenStorage.storeToken(username, clientId, token);
        player.sendSystemMessage((Component)Component.literal((String)("Authentication for mod '" + clientId + "' successful!")));
        authFuture.complete(token);
        this.stopPolling(authKey);
        this.ongoingAuths.remove(authKey);
    }

    private void stopPolling(AuthKey authKey) {
        ScheduledFuture<?> task = this.pollingTasks.remove(authKey);
        if (task != null) {
            task.cancel(true);
        }
    }
}

