/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.base;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.ITaskCanForce;
import com.player2.playerengine.tasks.base.TaskChain;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import java.util.function.Predicate;

public abstract class Task {
    public PlayerEngineController controller;
    private String oldDebugState = "";
    private String debugState = "";
    private Task sub = null;
    private boolean first = true;
    private boolean stopped = false;
    private boolean active = false;

    public void tick(TaskChain parentChain) {
        this.controller = parentChain.controller;
        parentChain.addTaskToChain(this);
        if (this.first) {
            Debug.logInternal("Task START: " + String.valueOf(this));
            this.active = true;
            this.onStart();
            this.first = false;
            this.stopped = false;
        }
        if (!this.stopped) {
            Task newSub = this.onTick();
            if (!this.oldDebugState.equals(this.debugState)) {
                Debug.logInternal(this.toString());
                this.oldDebugState = this.debugState;
            }
            if (newSub != null) {
                if (!newSub.isEqual(this.sub) && this.canBeInterrupted(this.sub, newSub)) {
                    if (this.sub != null) {
                        this.sub.stop(newSub);
                    }
                    this.sub = newSub;
                }
                this.sub.tick(parentChain);
            } else if (this.sub != null && this.canBeInterrupted(this.sub, null)) {
                this.sub.stop();
                this.sub = null;
            }
        }
    }

    public void reset() {
        this.first = true;
        this.active = false;
        this.stopped = false;
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(Task interruptTask) {
        if (this.active) {
            Debug.logInternal("Task STOP: " + String.valueOf(this) + ", interrupted by " + String.valueOf(interruptTask));
            if (!this.first) {
                this.onStop(interruptTask);
            }
            if (this.sub != null && !this.sub.stopped()) {
                this.sub.stop(interruptTask);
            }
            this.first = true;
            this.active = false;
            this.stopped = true;
        }
    }

    public void fail(String reason) {
        this.stop();
        Debug.logMessage("Task FAILED: " + reason);
    }

    public void interrupt(Task interruptTask) {
        if (this.active) {
            if (!this.first) {
                this.onStop(interruptTask);
            }
            if (this.sub != null && !this.sub.stopped()) {
                this.sub.interrupt(interruptTask);
            }
            this.first = true;
        }
    }

    protected void setDebugState(String state) {
        if (state == null) {
            state = "";
        }
        this.debugState = state;
    }

    public boolean isFinished() {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean stopped() {
        return this.stopped;
    }

    protected abstract void onStart();

    protected abstract Task onTick();

    protected abstract void onStop(Task var1);

    protected abstract boolean isEqual(Task var1);

    protected abstract String toDebugString();

    public String toString() {
        return "<" + this.toDebugString() + "> " + this.debugState;
    }

    public boolean equals(Object obj) {
        boolean bl;
        if (obj instanceof Task) {
            Task task = (Task)obj;
            bl = this.isEqual(task);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean thisOrChildSatisfies(Predicate<Task> pred) {
        Task t = this;
        while (t != null) {
            if (pred.test(t)) {
                return true;
            }
            t = t.sub;
        }
        return false;
    }

    public boolean thisOrChildAreTimedOut() {
        return this.thisOrChildSatisfies(task -> task instanceof TimeoutWanderTask);
    }

    private boolean canBeInterrupted(Task subTask, Task toInterruptWith) {
        return subTask == null ? true : subTask.thisOrChildSatisfies(task -> {
            if (task instanceof ITaskCanForce) {
                ITaskCanForce canForce = (ITaskCanForce)((Object)task);
                if (toInterruptWith != null && toInterruptWith.controller == null) {
                    toInterruptWith.controller = this.controller;
                }
                return !canForce.shouldForce(toInterruptWith);
            }
            return true;
        });
    }

    public String getTaskTree() {
        StringBuilder builder = new StringBuilder("Main task:\n");
        Task cur = this;
        while (cur != null) {
            builder.append(cur.toDebugString());
            cur = cur.sub;
            if (cur == null) continue;
            builder.append("\nFor that doing:\n");
        }
        return builder.toString();
    }
}

