/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.base;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.TaskChain;
import com.player2.playerengine.util.Debug;
import java.util.ArrayList;

public class TaskRunner {
    private final ArrayList<TaskChain> chains = new ArrayList();
    private final PlayerEngineController mod;
    private boolean active;
    private TaskChain cachedCurrentTaskChain = null;
    public String statusReport = " (no chain running) ";

    public TaskRunner(PlayerEngineController mod) {
        this.mod = mod;
        this.active = false;
    }

    public void tick() {
        if (this.active && PlayerEngineController.inGame()) {
            TaskChain maxChain = null;
            float maxPriority = Float.NEGATIVE_INFINITY;
            for (TaskChain chain : this.chains) {
                float priority;
                if (!chain.isActive() || !((priority = chain.getPriority()) > maxPriority)) continue;
                maxPriority = priority;
                maxChain = chain;
            }
            if (this.cachedCurrentTaskChain != null && maxChain != this.cachedCurrentTaskChain) {
                this.cachedCurrentTaskChain.onInterrupt(maxChain);
            }
            this.cachedCurrentTaskChain = maxChain;
            if (maxChain != null) {
                this.statusReport = "Chain: " + maxChain.getName() + ", priority: " + maxPriority;
                maxChain.tick();
            } else {
                this.statusReport = " (no chain running) ";
            }
        } else {
            this.statusReport = " (no chain running) ";
        }
    }

    public void addTaskChain(TaskChain chain) {
        this.chains.add(chain);
    }

    public void enable() {
        if (!this.active) {
            this.mod.getBehaviour().push();
            this.mod.getBehaviour().setPauseOnLostFocus(false);
        }
        this.active = true;
    }

    public void disable() {
        if (this.active) {
            this.mod.getBehaviour().pop();
        }
        for (TaskChain chain : this.chains) {
            chain.stop();
        }
        this.active = false;
        Debug.logMessage("Stopped");
    }

    public boolean isActive() {
        return this.active;
    }

    public TaskChain getCurrentTaskChain() {
        return this.cachedCurrentTaskChain;
    }

    public PlayerEngineController getMod() {
        return this.mod;
    }
}

