/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.compound.ConstructNetherPortalBucketTask;
import com.player2.playerengine.tasks.construction.compound.ConstructNetherPortalObsidianTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;

public class EnterNetherPortalTask
extends Task {
    private final Task getPortalTask;
    private final Dimension targetDimension;
    private final TimerGame portalTimeout = new TimerGame(10.0);
    private final TimeoutWanderTask wanderTask = new TimeoutWanderTask(5.0f);
    private final Predicate<BlockPos> goodPortal;
    private boolean leftPortal;

    public EnterNetherPortalTask(Task getPortalTask, Dimension targetDimension, Predicate<BlockPos> goodPortal) {
        if (targetDimension == Dimension.END) {
            throw new IllegalArgumentException("Can't build a nether portal to the end.");
        }
        this.getPortalTask = getPortalTask;
        this.targetDimension = targetDimension;
        this.goodPortal = goodPortal;
    }

    public EnterNetherPortalTask(Dimension targetDimension, Predicate<BlockPos> goodPortal) {
        this(null, targetDimension, goodPortal);
    }

    public EnterNetherPortalTask(Task getPortalTask, Dimension targetDimension) {
        this(getPortalTask, targetDimension, blockPos -> true);
    }

    public EnterNetherPortalTask(Dimension targetDimension) {
        this(null, targetDimension);
    }

    @Override
    protected void onStart() {
        this.leftPortal = false;
        this.portalTimeout.reset();
        this.wanderTask.resetWander();
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
            this.setDebugState("Exiting portal for a bit.");
            this.portalTimeout.reset();
            this.leftPortal = true;
            return this.wanderTask;
        }
        if (mod.getWorld().getBlockState(mod.getPlayer().blockPosition()).getBlock() == Blocks.NETHER_PORTAL) {
            if (this.portalTimeout.elapsed() && !this.leftPortal) {
                return this.wanderTask;
            }
            this.setDebugState("Waiting inside portal");
            mod.getBaritone().getExploreProcess().onLostControl();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getMineProcess().onLostControl();
            mod.getBaritone().getFarmProcess().onLostControl();
            mod.getBaritone().getGetToBlockProcess();
            mod.getBaritone().getBuilderProcess();
            mod.getBaritone().getFollowProcess();
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
            return null;
        }
        this.portalTimeout.reset();
        Predicate<BlockPos> standablePortal = blockPos -> {
            if (mod.getWorld().getBlockState(blockPos).getBlock() == Blocks.NETHER_PORTAL) {
                return this.goodPortal.test((BlockPos)blockPos);
            }
            if (!mod.getChunkTracker().isChunkLoaded((BlockPos)blockPos)) {
                return this.goodPortal.test((BlockPos)blockPos);
            }
            BlockPos below = blockPos.below();
            boolean canStand = WorldHelper.isSolidBlock(this.controller, below) && !mod.getBlockScanner().isBlockAtPosition(below, Blocks.NETHER_PORTAL);
            return canStand && this.goodPortal.test((BlockPos)blockPos);
        };
        if (mod.getBlockScanner().anyFound(standablePortal, Blocks.NETHER_PORTAL)) {
            this.setDebugState("Going to found portal");
            return new DoToClosestBlockTask(blockPos -> new GetToBlockTask((BlockPos)blockPos, false), standablePortal, Blocks.NETHER_PORTAL);
        }
        if (!mod.getBlockScanner().anyFound(standablePortal, Blocks.NETHER_PORTAL)) {
            this.setDebugState("Making new nether portal.");
            return WorldHelper.getCurrentDimension(this.controller) == Dimension.OVERWORLD ? new ConstructNetherPortalBucketTask() : new ConstructNetherPortalObsidianTask();
        }
        this.setDebugState("Getting our portal");
        return this.getPortalTask;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return WorldHelper.getCurrentDimension(this.controller) == this.targetDimension;
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof EnterNetherPortalTask)) {
            bl = false;
        } else {
            EnterNetherPortalTask task = (EnterNetherPortalTask)other;
            bl = Objects.equals(task.getPortalTask, this.getPortalTask) && Objects.equals((Object)task.targetDimension, (Object)this.targetDimension);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Entering nether portal";
    }
}

