/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface LookHelper {
    public static Optional<Rotation> getReach(PlayerEngineController controller, BlockPos target, Direction side) {
        Optional<Rotation> reachableRotation;
        IEntityContext context = controller.getBaritone().getEntityContext();
        if (side == null) {
            reachableRotation = RotationUtils.reachable(context.entity(), target, context.playerController().getBlockReachDistance());
        } else {
            Vec3 cameraPos;
            Vec3 vecToPlayerPos;
            double dotProduct;
            Vec3i sideVector = side.getNormal();
            Vec3 centerOffset = new Vec3(0.5 + (double)sideVector.getX() * 0.5, 0.5 + (double)sideVector.getY() * 0.5, 0.5 + (double)sideVector.getZ() * 0.5);
            Vec3 sidePoint = centerOffset.add((double)target.getX(), (double)target.getY(), (double)target.getZ());
            reachableRotation = RotationUtils.reachableOffset((Entity)context.entity(), target, sidePoint, context.playerController().getBlockReachDistance(), false);
            if (reachableRotation.isPresent() && (dotProduct = (vecToPlayerPos = (cameraPos = context.entity().getEyePosition(1.0f)).subtract(sidePoint)).normalize().dot(new Vec3((double)sideVector.getX(), (double)sideVector.getY(), (double)sideVector.getZ()))) < 0.0) {
                return Optional.empty();
            }
        }
        return reachableRotation;
    }

    public static Optional<Rotation> getReach(PlayerEngineController controller, BlockPos target) {
        Debug.logInternal("Target: " + String.valueOf(target));
        return LookHelper.getReach(controller, target, null);
    }

    public static EntityHitResult raycast(Entity from, Entity to, double reachDistance) {
        Vec3 start = LookHelper.getCameraPos(from);
        Vec3 end = LookHelper.getCameraPos(to);
        Vec3 direction = end.subtract(start).normalize().scale(reachDistance);
        AABB box = to.getBoundingBox();
        return ProjectileUtil.getEntityHitResult((Entity)from, (Vec3)start, (Vec3)start.add(direction), (AABB)box, entity -> entity.equals((Object)to), (double)0.0);
    }

    public static boolean seesPlayer(Entity entity, Entity player, double maxRange, Vec3 entityOffset, Vec3 playerOffset) {
        return LookHelper.seesPlayerOffset(entity, player, maxRange, entityOffset, playerOffset) || LookHelper.seesPlayerOffset(entity, player, maxRange, entityOffset, playerOffset.add(0.0, -1.0, 0.0));
    }

    public static boolean seesPlayer(Entity entity, Entity player, double maxRange) {
        return LookHelper.seesPlayer(entity, player, maxRange, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
    }

    public static boolean cleanLineOfSight(Entity entity, Vec3 start, Vec3 end, double maxRange) {
        BlockHitResult blockHitResult = LookHelper.raycast(entity, start, end, maxRange);
        return blockHitResult.getType() == HitResult.Type.MISS;
    }

    public static boolean cleanLineOfSight(Entity entity, Vec3 end, double maxRange) {
        Vec3 start = LookHelper.getCameraPos(entity);
        return LookHelper.cleanLineOfSight(entity, start, end, maxRange);
    }

    public static boolean cleanLineOfSight(PlayerEngineController controller, Vec3 end, double maxRange) {
        LivingEntity clientPlayerEntity = controller.getPlayer();
        return LookHelper.cleanLineOfSight((Entity)clientPlayerEntity, end, maxRange);
    }

    public static boolean cleanLineOfSight(Entity entity, BlockPos block, double maxRange) {
        Vec3 targetPosition = WorldHelper.toVec3d(block);
        BlockHitResult hitResult = LookHelper.raycast(entity, LookHelper.getCameraPos(entity), targetPosition, maxRange);
        if (hitResult == null) {
            return true;
        }
        switch (hitResult.getType().ordinal()) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    public static Vec3 toVec3d(Rotation rotation) throws NullPointerException {
        Objects.requireNonNull(rotation, "Rotation cannot be null");
        return LookHelper.calcLookDirectionFromRotation(rotation);
    }

    public static Vec3 calcLookDirectionFromRotation(Rotation rotation) {
        float flatZ = Mth.cos((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float flatX = Mth.sin((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchBase = -Mth.cos((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        float pitchHeight = Mth.sin((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        return new Vec3((double)(flatX * pitchBase), (double)pitchHeight, (double)(flatZ * pitchBase));
    }

    public static BlockHitResult raycast(Entity entity, Vec3 start, Vec3 end, double maxRange) {
        Vec3 direction = end.subtract(start);
        if (direction.lengthSqr() > maxRange * maxRange) {
            direction = direction.normalize().scale(maxRange);
            end = start.add(direction);
        }
        Level world = entity.level();
        ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        return world.clip(context);
    }

    public static BlockHitResult raycast(Entity entity, Vec3 end, double maxRange) {
        Vec3 start = LookHelper.getCameraPos(entity);
        return LookHelper.raycast(entity, start, end, maxRange);
    }

    public static Rotation getLookRotation(Entity entity) {
        float pitch = entity.getXRot();
        float yaw = entity.getYRot();
        return new Rotation(yaw, pitch);
    }

    public static Rotation getLookRotation(PlayerEngineController mod) {
        LivingEntity clientPlayerEntity = mod.getEntity();
        return clientPlayerEntity == null ? new Rotation(0.0f, 0.0f) : LookHelper.getLookRotation((Entity)clientPlayerEntity);
    }

    public static Vec3 getCameraPos(Entity entity) {
        boolean isPlayerSneaking = entity instanceof LivingEntity && entity.isShiftKeyDown();
        return isPlayerSneaking ? RayTraceUtils.inferSneakingEyePosition(entity) : entity.getEyePosition(1.0f);
    }

    public static Vec3 getCameraPos(PlayerEngineController mod) {
        IEntityContext playerContext = mod.getBaritone().getEntityContext();
        return playerContext.entity().getEyePosition(1.0f);
    }

    public static double getLookCloseness(Entity entity, Vec3 pos) {
        Vec3 rotDirection = entity.getForward();
        Vec3 lookStart = LookHelper.getCameraPos(entity);
        Vec3 deltaToPos = pos.subtract(lookStart);
        Vec3 deltaDirection = deltaToPos.normalize();
        return rotDirection.dot(deltaDirection);
    }

    private static boolean seesPlayerOffset(Entity entity, Entity player, double maxRange, Vec3 offsetEntity, Vec3 offsetPlayer) {
        Vec3 entityCameraPos = LookHelper.getCameraPos(entity).add(offsetEntity);
        Vec3 playerCameraPos = LookHelper.getCameraPos(player).add(offsetPlayer);
        return LookHelper.cleanLineOfSight(entity, entityCameraPos, playerCameraPos, maxRange);
    }

    public static void randomOrientation(PlayerEngineController mod) {
        float randomRotationX = (float)(Math.random() * 360.0);
        float randomRotationY = -90.0f + (float)(Math.random() * 180.0);
        Rotation r = new Rotation(randomRotationX, randomRotationY);
        LookHelper.lookAt(mod, r);
    }

    public static boolean isLookingAt(PlayerEngineController mod, Rotation rotation) {
        return rotation.isReallyCloseTo(LookHelper.getLookRotation(mod));
    }

    public static boolean isLookingAt(PlayerEngineController mod, BlockPos pos) {
        return mod.getBaritone().getEntityContext().isLookingAt(pos);
    }

    public static boolean isLookingAt(Entity entity, Vec3 toLookAt, double angleThreshold) {
        Vec3 targetLook;
        Vec3 head = entity.position().add(new Vec3(0.0, (double)entity.getEyeHeight(), 0.0));
        Rotation rotation = new Rotation(entity.getYRot(), entity.getXRot());
        Vec3 look = LookHelper.calcLookDirectionFromRotation(rotation);
        double dot = look.dot(targetLook = toLookAt.subtract(head).normalize());
        double angle = Math.toDegrees(Math.acos(dot));
        return Math.abs(angle) < angleThreshold;
    }

    public static void lookAt(PlayerEngineController mod, Rotation rotation, boolean withBaritone) {
        if (withBaritone) {
            mod.getBaritone().getLookBehavior().updateTarget(rotation, true);
        }
        mod.getPlayer().setYRot(rotation.getYaw());
        mod.getPlayer().setXRot(rotation.getPitch());
    }

    public static void lookAt(PlayerEngineController mod, Rotation rotation) {
        mod.getBaritone().getLookBehavior().updateTarget(rotation, true);
        LivingEntity player = mod.getBaritone().getEntityContext().entity();
        player.setYRot(rotation.getYaw());
        player.setXRot(rotation.getPitch());
    }

    public static void lookAt(PlayerEngineController mod, Vec3 toLook, boolean withBaritone) {
        if (mod == null || toLook == null) {
            throw new IllegalArgumentException("mod and toLook cannot be null");
        }
        Rotation targetRotation = LookHelper.getLookRotation(mod, toLook);
        LookHelper.lookAt(mod, targetRotation, withBaritone);
    }

    public static void lookAt(PlayerEngineController mod, Vec3 toLook) {
        if (mod == null || toLook == null) {
            throw new IllegalArgumentException("mod and toLook cannot be null");
        }
        Rotation targetRotation = LookHelper.getLookRotation(mod, toLook);
        LookHelper.lookAt(mod, targetRotation, true);
    }

    public static void lookAt(PlayerEngineController mod, BlockPos toLook, Direction side, boolean withBaritone) {
        double centerX = (double)toLook.getX() + 0.5;
        double centerY = (double)toLook.getY() + 0.5;
        double centerZ = (double)toLook.getZ() + 0.5;
        if (side != null) {
            double offsetX = (double)side.getNormal().getX() * 0.5;
            double offsetY = (double)side.getNormal().getY() * 0.5;
            double offsetZ = (double)side.getNormal().getZ() * 0.5;
            centerX += offsetX;
            centerY += offsetY;
            centerZ += offsetZ;
        }
        Vec3 target = new Vec3(centerX, centerY, centerZ);
        LookHelper.lookAt(mod, target, withBaritone);
    }

    public static void lookAt(PlayerEngineController mod, BlockPos toLook, Direction side) {
        double centerX = (double)toLook.getX() + 0.5;
        double centerY = (double)toLook.getY() + 0.5;
        double centerZ = (double)toLook.getZ() + 0.5;
        if (side != null) {
            double offsetX = (double)side.getNormal().getX() * 0.5;
            double offsetY = (double)side.getNormal().getY() * 0.5;
            double offsetZ = (double)side.getNormal().getZ() * 0.5;
            centerX += offsetX;
            centerY += offsetY;
            centerZ += offsetZ;
        }
        Vec3 target = new Vec3(centerX, centerY, centerZ);
        LookHelper.lookAt(mod, target, true);
    }

    public static void lookAt(PlayerEngineController mod, BlockPos toLook, boolean withBaritone) {
        LookHelper.lookAt(mod, toLook, null, withBaritone);
    }

    public static void lookAt(PlayerEngineController mod, BlockPos toLook) {
        LookHelper.lookAt(mod, toLook, null, true);
    }

    public static Rotation getLookRotation(PlayerEngineController mod, Vec3 toLook) {
        Vec3 playerHead = mod.getBaritone().getEntityContext().headPos();
        Rotation playerRotations = mod.getBaritone().getEntityContext().entityRotations();
        return RotationUtils.calcRotationFromVec3d(playerHead, toLook, playerRotations);
    }

    public static Rotation getLookRotation(PlayerEngineController mod, BlockPos toLook) {
        Vec3 targetPosition = WorldHelper.toVec3d(toLook);
        return LookHelper.getLookRotation(mod, targetPosition);
    }
}

