/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.process.MineProcess;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.multiversion.MethodWrapper;
import com.player2.playerengine.multiversion.world.WorldVer;
import com.player2.playerengine.util.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CartographyTableBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LoomBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface WorldHelper {
    public static Vec3 toVec3d(BlockPos pos) {
        return pos == null ? null : new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
    }

    public static Vec3 toVec3d(Vec3i pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static Vec3i toVec3i(Vec3 pos) {
        return new Vec3i((int)pos.x(), (int)pos.y(), (int)pos.z());
    }

    public static BlockPos toBlockPos(Vec3 pos) {
        return new BlockPos((int)pos.x(), (int)pos.y(), (int)pos.z());
    }

    public static boolean isSourceBlock(PlayerEngineController controller, BlockPos pos, boolean onlyAcceptStill) {
        ServerLevel world = controller.getWorld();
        BlockState s = world.getBlockState(pos);
        if (s.getBlock() instanceof LiquidBlock) {
            if (!s.getFluidState().isSource() && onlyAcceptStill) {
                return false;
            }
            int level = s.getFluidState().getAmount();
            BlockState above = world.getBlockState(pos.above());
            return above.getBlock() instanceof LiquidBlock ? false : level == 8;
        }
        return false;
    }

    public static double distanceXZSquared(Vec3 from, Vec3 to) {
        Vec3 delta = to.subtract(from);
        return delta.x * delta.x + delta.z * delta.z;
    }

    public static double distanceXZ(Vec3 from, Vec3 to) {
        return Math.sqrt(WorldHelper.distanceXZSquared(from, to));
    }

    public static boolean inRangeXZ(Vec3 from, Vec3 to, double range) {
        return WorldHelper.distanceXZSquared(from, to) < range * range;
    }

    public static boolean inRangeXZ(BlockPos from, BlockPos to, double range) {
        return WorldHelper.inRangeXZ(WorldHelper.toVec3d(from), WorldHelper.toVec3d(to), range);
    }

    public static boolean inRangeXZ(Entity entity, Vec3 to, double range) {
        return WorldHelper.inRangeXZ(entity.position(), to, range);
    }

    public static boolean inRangeXZ(Entity entity, BlockPos to, double range) {
        return WorldHelper.inRangeXZ(entity, WorldHelper.toVec3d(to), range);
    }

    public static boolean inRangeXZ(Entity entity, Entity to, double range) {
        return WorldHelper.inRangeXZ(entity, to.position(), range);
    }

    public static Dimension getCurrentDimension(PlayerEngineController controller) {
        ServerLevel world = controller.getWorld();
        if (world == null) {
            return Dimension.OVERWORLD;
        }
        if (world.dimensionType().ultraWarm()) {
            return Dimension.NETHER;
        }
        return world.dimensionType().natural() ? Dimension.OVERWORLD : Dimension.END;
    }

    public static boolean isSolidBlock(PlayerEngineController controller, BlockPos pos) {
        ServerLevel world = controller.getWorld();
        return world.getBlockState(pos).isRedstoneConductor((BlockGetter)world, pos);
    }

    public static BlockPos getBedHead(PlayerEngineController controller, BlockPos posWithBed) {
        ServerLevel world = controller.getWorld();
        BlockState state = world.getBlockState(posWithBed);
        if (state.getBlock() instanceof BedBlock) {
            Direction facing = (Direction)state.getValue((Property)BedBlock.FACING);
            return ((BedPart)world.getBlockState(posWithBed).getValue((Property)BedBlock.PART)).equals((Object)BedPart.HEAD) ? posWithBed : posWithBed.relative(facing);
        }
        return null;
    }

    public static BlockPos getBedFoot(PlayerEngineController controller, BlockPos posWithBed) {
        ServerLevel world = controller.getWorld();
        BlockState state = world.getBlockState(posWithBed);
        if (state.getBlock() instanceof BedBlock) {
            Direction facing = (Direction)state.getValue((Property)BedBlock.FACING);
            return ((BedPart)world.getBlockState(posWithBed).getValue((Property)BedBlock.PART)).equals((Object)BedPart.FOOT) ? posWithBed : posWithBed.relative(facing.getOpposite());
        }
        return null;
    }

    public static int getGroundHeight(PlayerEngineController controller, int x, int z) {
        ServerLevel world = controller.getWorld();
        for (int y = world.getMaxBuildHeight(); y >= world.getMinBuildHeight(); --y) {
            BlockPos check = new BlockPos(x, y, z);
            if (!WorldHelper.isSolidBlock(controller, check)) continue;
            return y;
        }
        return -1;
    }

    public static BlockPos getADesertTemple(PlayerEngineController controller) {
        ServerLevel world = controller.getWorld();
        List<BlockPos> stonePressurePlates = controller.getBlockScanner().getKnownLocations(Blocks.STONE_PRESSURE_PLATE);
        if (!stonePressurePlates.isEmpty()) {
            for (BlockPos pos : stonePressurePlates) {
                if (world.getBlockState(pos).getBlock() != Blocks.STONE_PRESSURE_PLATE || world.getBlockState(pos.below()).getBlock() != Blocks.CUT_SANDSTONE || world.getBlockState(pos.below(2)).getBlock() != Blocks.TNT) continue;
                return pos;
            }
        }
        return null;
    }

    public static boolean isUnopenedChest(PlayerEngineController controller, BlockPos pos) {
        return controller.getItemStorage().getContainerAtPosition(pos).isEmpty();
    }

    public static int getGroundHeight(PlayerEngineController controller, int x, int z, Block ... groundBlocks) {
        ServerLevel world = controller.getWorld();
        HashSet<Block> possibleBlocks = new HashSet<Block>(Arrays.asList(groundBlocks));
        for (int y = world.getMaxBuildHeight(); y >= world.getMinBuildHeight(); --y) {
            BlockPos check = new BlockPos(x, y, z);
            if (!possibleBlocks.contains(world.getBlockState(check).getBlock())) continue;
            return y;
        }
        return -1;
    }

    public static boolean canBreak(PlayerEngineController controller, BlockPos pos) {
        boolean prevInteractionPaused = controller.getExtraBaritoneSettings().isInteractionPaused();
        controller.getExtraBaritoneSettings().setInteractionPaused(false);
        boolean canBreak = controller.getWorld().getBlockState(pos).getDestroySpeed((BlockGetter)controller.getWorld(), pos) >= 0.0f && !controller.getExtraBaritoneSettings().shouldAvoidBreaking(pos) && MineProcess.plausibleToBreak(new CalculationContext(controller.getBaritone()), pos) && WorldHelper.canReach(controller, pos);
        controller.getExtraBaritoneSettings().setInteractionPaused(prevInteractionPaused);
        return canBreak;
    }

    public static boolean isInNetherPortal(PlayerEngineController controller) {
        LivingEntity player = controller.getPlayer();
        return player != null && player.portalProcess != null && player.portalProcess.isInsidePortalThisTick();
    }

    public static boolean canPlace(PlayerEngineController controller, BlockPos pos) {
        return !controller.getExtraBaritoneSettings().shouldAvoidPlacingAt(pos) && WorldHelper.canReach(controller, pos);
    }

    public static boolean canReach(PlayerEngineController controller, BlockPos pos) {
        return controller.getModSettings().shouldAvoidOcean() && controller.getPlayer().getY() > 47.0 && controller.getChunkTracker().isChunkLoaded(pos) && WorldHelper.isOcean((Holder<Biome>)controller.getWorld().getBiome(pos)) && pos.getY() < 64 && WorldHelper.getGroundHeight(controller, pos.getX(), pos.getZ(), Blocks.WATER) > pos.getY() ? false : !controller.getBlockScanner().isUnreachable(pos);
    }

    public static boolean isOcean(Holder<Biome> b) {
        return WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.OCEAN) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.COLD_OCEAN) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.DEEP_COLD_OCEAN) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.DEEP_OCEAN) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.DEEP_FROZEN_OCEAN) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.DEEP_LUKEWARM_OCEAN) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.LUKEWARM_OCEAN) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.WARM_OCEAN) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.FROZEN_OCEAN);
    }

    public static boolean isAir(PlayerEngineController controller, BlockPos pos) {
        return controller.getBlockScanner().isBlockAtPosition(pos, Blocks.AIR, Blocks.CAVE_AIR, Blocks.VOID_AIR);
    }

    public static boolean isAir(Block block) {
        return block == Blocks.AIR || block == Blocks.CAVE_AIR || block == Blocks.VOID_AIR;
    }

    public static boolean isInteractableBlock(PlayerEngineController controller, BlockPos pos) {
        Block block = controller.getWorld().getBlockState(pos).getBlock();
        return block instanceof ChestBlock || block instanceof EnderChestBlock || block instanceof CraftingTableBlock || block instanceof AbstractFurnaceBlock || block instanceof LoomBlock || block instanceof CartographyTableBlock || block instanceof EnchantingTableBlock || block instanceof RedStoneOreBlock || block instanceof BarrelBlock;
    }

    public static boolean isInsidePlayer(PlayerEngineController controller, BlockPos pos) {
        return pos.closerToCenterThan((Position)controller.getPlayer().position(), 2.0);
    }

    public static Iterable<BlockPos> getBlocksTouchingPlayer(LivingEntity player) {
        return WorldHelper.getBlocksTouchingBox(player.getBoundingBox());
    }

    public static Iterable<BlockPos> getBlocksTouchingBox(AABB box) {
        BlockPos min = new BlockPos((int)box.minX, (int)box.minY, (int)box.minZ);
        BlockPos max = new BlockPos((int)box.maxX, (int)box.maxY, (int)box.maxZ);
        return WorldHelper.scanRegion(min, max);
    }

    public static Iterable<BlockPos> scanRegion(final BlockPos start, final BlockPos end) {
        return () -> new Iterator<BlockPos>(){
            int x;
            int y;
            int z;
            {
                this.x = start.getX();
                this.y = start.getY();
                this.z = start.getZ();
            }

            @Override
            public boolean hasNext() {
                return this.y <= end.getY() && this.z <= end.getZ() && this.x <= end.getX();
            }

            @Override
            public BlockPos next() {
                BlockPos result = new BlockPos(this.x, this.y, this.z);
                ++this.x;
                if (this.x > end.getX()) {
                    this.x = start.getX();
                    ++this.z;
                    if (this.z > end.getZ()) {
                        this.z = start.getZ();
                        ++this.y;
                    }
                }
                return result;
            }
        };
    }

    public static boolean fallingBlockSafeToBreak(PlayerEngineController controller, BlockPos pos) {
        BlockStateInterface bsi = new BlockStateInterface(controller.getBaritone().getEntityContext());
        ServerLevel clientWorld = controller.getWorld();
        if (clientWorld == null) {
            throw new AssertionError();
        }
        while (WorldHelper.isFallingBlock(controller, pos)) {
            if (MovementHelper.avoidBreaking(bsi, pos.getX(), pos.getY(), pos.getZ(), clientWorld.getBlockState(pos), controller.getBaritoneSettings())) {
                return false;
            }
            pos = pos.above();
        }
        return true;
    }

    public static boolean isFallingBlock(PlayerEngineController controller, BlockPos pos) {
        ServerLevel clientWorld = controller.getWorld();
        if (clientWorld == null) {
            throw new AssertionError();
        }
        return clientWorld.getBlockState(pos).getBlock() instanceof FallingBlock;
    }

    public static Entity getSpawnerEntity(PlayerEngineController controller, BlockPos pos) {
        Entity entity;
        BlockEntity blockEntity;
        ServerLevel world = controller.getWorld();
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof SpawnerBlock && (blockEntity = world.getBlockEntity(pos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity blockEntity2 = (SpawnerBlockEntity)blockEntity;
            entity = MethodWrapper.getRenderedEntity(blockEntity2.getSpawner(), (Level)world, pos);
        } else {
            entity = null;
        }
        return entity;
    }

    public static boolean isChest(PlayerEngineController controller, BlockPos block) {
        Block b = controller.getWorld().getBlockState(block).getBlock();
        return WorldHelper.isChest(b);
    }

    public static boolean isChest(Block b) {
        return b instanceof ChestBlock || b instanceof EnderChestBlock;
    }

    public static boolean isBlock(PlayerEngineController controller, BlockPos pos, Block block) {
        return controller.getWorld().getBlockState(pos).getBlock() == block;
    }

    public static boolean canSleep(PlayerEngineController controller) {
        ServerLevel world = controller.getWorld();
        if (world != null) {
            if (world.isThundering() && world.isRaining()) {
                return true;
            }
            int time = WorldHelper.getTimeOfDay(controller);
            return 12542 <= time && time <= 23992;
        }
        return false;
    }

    public static int getTimeOfDay(PlayerEngineController controller) {
        ServerLevel world = controller.getWorld();
        return world != null ? (int)(world.getDayTime() % 24000L) : 0;
    }

    public static boolean isVulnerable(LivingEntity player) {
        int armor = player.getArmorValue();
        float health = player.getHealth();
        if (armor <= 15 && health < 3.0f) {
            return true;
        }
        return armor < 10 && health < 10.0f ? true : armor < 5 && health < 18.0f;
    }

    public static boolean isSurroundedByHostiles(PlayerEngineController controller) {
        List<LivingEntity> hostiles = controller.getEntityTracker().getHostiles();
        return WorldHelper.isSurrounded(controller, hostiles);
    }

    public static boolean isSurrounded(PlayerEngineController controller, List<LivingEntity> entities) {
        LivingEntity player = controller.getPlayer();
        BlockPos playerPos = player.blockPosition();
        int MIN_SIDES_TO_SURROUND = 2;
        ArrayList<Direction> uniqueSides = new ArrayList<Direction>();
        for (Entity entity : entities) {
            BlockPos entityPos;
            double angle;
            boolean isUnique;
            if (!entity.closerThan((Entity)player, 8.0) || !(isUnique = !uniqueSides.contains(WorldHelper.getHorizontalDirectionFromYaw(angle = WorldHelper.calculateAngle(playerPos, entityPos = entity.blockPosition()))))) continue;
            uniqueSides.add(WorldHelper.getHorizontalDirectionFromYaw(angle));
        }
        return uniqueSides.size() >= 2;
    }

    private static double calculateAngle(BlockPos origin, BlockPos target) {
        double translatedX = target.getX() - origin.getX();
        double translatedZ = target.getZ() - origin.getZ();
        double angleRad = Math.atan2(translatedZ, translatedX);
        double angleDeg = Math.toDegrees(angleRad);
        if ((angleDeg -= 90.0) < 0.0) {
            angleDeg += 360.0;
        }
        return angleDeg;
    }

    private static Direction getHorizontalDirectionFromYaw(double yaw) {
        if ((yaw %= 360.0) < 0.0) {
            yaw += 360.0;
        }
        if (!(yaw >= 45.0 && yaw < 135.0 || yaw >= -315.0 && yaw < -225.0)) {
            if (!(yaw >= 135.0 && yaw < 225.0 || yaw >= -225.0 && yaw < -135.0)) {
                return !(yaw >= 225.0 && yaw < 315.0 || yaw >= -135.0 && yaw < -45.0) ? Direction.SOUTH : Direction.EAST;
            }
            return Direction.NORTH;
        }
        return Direction.WEST;
    }
}

