/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.player2api.AgentSideEffects;
import com.player2.playerengine.player2api.Player2APIService;
import com.player2.playerengine.player2api.auth.AuthenticationManager;
import dev.architectury.event.events.common.LifecycleEvent;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCCommands {
    public static final Logger LOGGER = LogManager.getLogger((String)"PlayerEngine");

    public static void onInit() {
        LifecycleEvent.SERVER_STARTING.register(server -> {
            LOGGER.info("Server starting, registering MC commands");
            MCCommands.register(server);
        });
    }

    public static void register(MinecraftServer server) {
        CommandDispatcher dispatcher = server.m_129892_().m_82094_();
        MCCommands.registerFromDispatch((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private static void registerFromDispatch(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"playerengine").then(MCCommands.registerRelog())).then(MCCommands.registerHelp()));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerHelp() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"help").executes(context -> {
            LOGGER.info("help command");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            AgentSideEffects.broadcastChatToPlayer(player.m_9236_().m_7654_(), "help: TODO: fillin ", player);
            return 1;
        });
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerRelog() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"relog").executes(context -> {
            for (Player2APIService service : PlayerEngineController.staticAPIServices.values()) {
                LOGGER.info("relog command");
                String clientId = service.getClientId();
                ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
                AuthenticationManager.getInstance().invalidateToken((Player)player, clientId);
            }
            return 1;
        });
    }
}

