/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;

public class LivingEntityHungerManager {
    private int foodLevel = 20;
    private float foodSaturationLevel = 20.0f;
    private float exhaustion;
    private int foodTickTimer;
    private int prevFoodLevel = 20;

    public void add(int food, float saturationModifier) {
        this.foodLevel = Math.min(food + this.foodLevel, 20);
        this.foodSaturationLevel = Math.min(this.foodSaturationLevel + (float)food * saturationModifier * 2.0f, (float)this.foodLevel);
    }

    public void eat(Item item) {
        if (item.m_41472_()) {
            FoodProperties foodComponent = item.m_41473_();
            this.add(foodComponent.m_38744_(), foodComponent.m_38745_());
        }
    }

    public void update(LivingEntity player) {
        boolean bl;
        Difficulty difficulty = player.m_9236_().m_46791_();
        this.prevFoodLevel = this.foodLevel;
        if (this.exhaustion > 4.0f) {
            this.exhaustion -= 4.0f;
            if (this.foodSaturationLevel > 0.0f) {
                this.foodSaturationLevel = Math.max(this.foodSaturationLevel - 1.0f, 0.0f);
            } else if (difficulty != Difficulty.PEACEFUL) {
                this.foodLevel = Math.max(this.foodLevel - 1, 0);
            }
        }
        if ((bl = player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_)) && this.foodSaturationLevel > 0.0f && this.canFoodHeal(player) && this.foodLevel >= 20) {
            ++this.foodTickTimer;
            if (this.foodTickTimer >= 10) {
                float f = Math.min(this.foodSaturationLevel, 6.0f);
                player.m_5634_(f / 6.0f);
                this.addExhaustion(f);
                this.foodTickTimer = 0;
            }
        } else if (bl && this.foodLevel >= 18 && this.canFoodHeal(player)) {
            ++this.foodTickTimer;
            if (this.foodTickTimer >= 80) {
                player.m_5634_(1.0f);
                this.addExhaustion(6.0f);
                this.foodTickTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.foodTickTimer;
            if (this.foodTickTimer >= 80) {
                if (player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || player.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.m_6469_(player.m_269291_().m_269064_(), 1.0f);
                }
                this.foodTickTimer = 0;
            }
        } else {
            this.foodTickTimer = 0;
        }
    }

    public void readNbt(CompoundTag nbt) {
        if (nbt.m_128425_("foodLevel", 99)) {
            this.foodLevel = nbt.m_128451_("foodLevel");
            this.foodTickTimer = nbt.m_128451_("foodTickTimer");
            this.foodSaturationLevel = nbt.m_128457_("foodSaturationLevel");
            this.exhaustion = nbt.m_128457_("foodExhaustionLevel");
        }
    }

    public void writeNbt(CompoundTag nbt) {
        nbt.m_128405_("foodLevel", this.foodLevel);
        nbt.m_128405_("foodTickTimer", this.foodTickTimer);
        nbt.m_128350_("foodSaturationLevel", this.foodSaturationLevel);
        nbt.m_128350_("foodExhaustionLevel", this.exhaustion);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public int getPrevFoodLevel() {
        return this.prevFoodLevel;
    }

    public boolean isNotFull() {
        return this.foodLevel < 20;
    }

    public void addExhaustion(float exhaustion) {
        this.exhaustion = Math.min(this.exhaustion + exhaustion, 40.0f);
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    public float getSaturationLevel() {
        return this.foodSaturationLevel;
    }

    public void setFoodLevel(int foodLevel) {
        this.foodLevel = foodLevel;
    }

    public void setSaturationLevel(float saturationLevel) {
        this.foodSaturationLevel = saturationLevel;
    }

    public void setExhaustion(float exhaustion) {
        this.exhaustion = exhaustion;
    }

    public boolean canFoodHeal(LivingEntity entity) {
        return entity.m_21223_() > 0.0f && entity.m_21223_() < entity.m_21233_();
    }
}

