/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.command.defaults;

import com.player2.playerengine.automaton.KeepName;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.command.Command;
import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.datatypes.EntityClassById;
import com.player2.playerengine.automaton.api.command.datatypes.IDatatypeFor;
import com.player2.playerengine.automaton.api.command.datatypes.NearbyPlayer;
import com.player2.playerengine.automaton.api.command.exception.CommandErrorMessageException;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.command.helpers.TabCompleteHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class FollowCommand
extends Command {
    public FollowCommand() {
        super("follow");
    }

    @Override
    public void execute(CommandSourceStack source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
        FollowGroup group;
        args.requireMin(1);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        ArrayList<EntityType> classes = new ArrayList<EntityType>();
        if (args.hasExactlyOne()) {
            group = args.getEnum(FollowGroup.class);
            baritone.getFollowProcess().follow(group.filter);
        } else {
            args.requireMin(2);
            group = null;
            FollowList list = args.getEnum(FollowList.class);
            while (args.hasAny()) {
                Object gotten = args.getDatatypeFor(list.datatype);
                if (gotten instanceof EntityType) {
                    classes.add((EntityType)gotten);
                    continue;
                }
                if (gotten == null) continue;
                entities.add((Entity)gotten);
            }
            baritone.getFollowProcess().follow(classes.isEmpty() ? entities::contains : e -> classes.stream().anyMatch(c -> e.m_6095_().equals(c)));
        }
        if (group != null) {
            this.logDirect(source, String.format("Following all %s", group.name().toLowerCase(Locale.US)));
        } else if (classes.isEmpty()) {
            if (entities.isEmpty()) {
                throw new NoEntitiesException();
            }
            this.logDirect(source, "Following these entities:");
            entities.stream().map(Entity::toString).forEach(message -> this.logDirect(source, (String)message));
        } else {
            this.logDirect(source, "Following these types of entities:");
            classes.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256780_).m_7981_(arg_0)).map(Objects::requireNonNull).map(ResourceLocation::toString).forEach(message -> this.logDirect(source, (String)message));
        }
    }

    @Override
    public Stream<String> tabComplete(String label, IArgConsumer args) throws CommandException {
        IDatatypeFor<?> followType;
        if (args.hasExactlyOne()) {
            return new TabCompleteHelper().append(FollowGroup.class).append(FollowList.class).filterPrefix(args.getString()).stream();
        }
        try {
            followType = args.getEnum(FollowList.class).datatype;
        }
        catch (NullPointerException var5) {
            return Stream.empty();
        }
        while (args.has(2)) {
            if (args.peekDatatypeOrNull(followType) == null) {
                return Stream.empty();
            }
            args.get();
        }
        return args.tabCompleteDatatype(followType);
    }

    @Override
    public String getShortDesc() {
        return "Follow entity things";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("The follow command makes an entity follow other entities of certain kinds.", "", "Usage:", "> follow entities - Follows all entities.", "> follow entity <entity1> <entity2> <...> - Follow certain entities (for example 'skeleton', 'horse' etc.)", "> follow players - Follow players", "> follow player <username1> <username2> <...> - Follow certain players");
    }

    @KeepName
    private static enum FollowGroup {
        ENTITIES(LivingEntity.class::isInstance),
        PLAYERS(Player.class::isInstance);

        final Predicate<Entity> filter;

        private FollowGroup(Predicate<Entity> filter) {
            this.filter = filter;
        }
    }

    @KeepName
    private static enum FollowList {
        ENTITY(EntityClassById.INSTANCE),
        PLAYER(NearbyPlayer.INSTANCE);

        final IDatatypeFor<?> datatype;

        private FollowList(IDatatypeFor<?> datatype) {
            this.datatype = datatype;
        }
    }

    public static class NoEntitiesException
    extends CommandErrorMessageException {
        protected NoEntitiesException() {
            super("No valid entities in range!");
        }
    }
}

