/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementPillar;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementTraverse;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.ArrayUtils;

public class MovementAscend
extends Movement {
    private int ticksWithoutPlacement = 0;

    public MovementAscend(IBaritone baritone, BetterBlockPos src, BetterBlockPos dest) {
        super(baritone, src, dest, MovementAscend.buildPositionsToBreak(baritone.getEntityContext().entity(), src, dest), MovementAscend.buildPositionsToPlace(baritone.getEntityContext().entity(), src, dest));
    }

    private static BetterBlockPos buildPositionsToPlace(LivingEntity entity, BetterBlockPos src, BetterBlockPos dest) {
        int diffX = dest.x - src.x;
        int diffZ = dest.z - src.z;
        assert (Math.abs(diffX) <= 1 && Math.abs(diffZ) <= 1);
        int requiredSideSpace = CalculationContext.getRequiredSideSpace(entity.m_6972_(Pose.STANDING));
        int placeX = dest.x + diffX * requiredSideSpace;
        int placeZ = dest.z + diffZ * requiredSideSpace;
        return new BetterBlockPos(placeX, src.y, placeZ);
    }

    private static BetterBlockPos[] buildPositionsToBreak(LivingEntity entity, BetterBlockPos src, BetterBlockPos dest) {
        BetterBlockPos[] ceiling = MovementPillar.buildPositionsToBreak((Entity)entity, src);
        BetterBlockPos[] wall = MovementTraverse.buildPositionsToBreak((Entity)entity, src.up(), dest);
        return (BetterBlockPos[])ArrayUtils.addAll((Object[])ceiling, (Object[])wall);
    }

    @Override
    public void reset() {
        super.reset();
        this.ticksWithoutPlacement = 0;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementAscend.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        BetterBlockPos prior = new BetterBlockPos(this.src.m_121996_((Vec3i)this.getDirection()).m_7494_());
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.src.up()), (Object)((Object)this.dest), (Object)((Object)prior), (Object)((Object)prior.up()));
    }

    public static void cost(CalculationContext context, int x, int y, int z, int destX, int destZ, MutableMoveResult result) {
        int diffX = destX - x;
        int diffZ = destZ - z;
        assert (Math.abs(diffX) <= 1 && Math.abs(diffZ) <= 1);
        int placeX = destX + diffX * context.requiredSideSpace;
        int placeZ = destZ + diffZ * context.requiredSideSpace;
        BlockState toPlace = context.get(placeX, y, placeZ);
        double additionalPlacementCost = 0.0;
        if (!MovementHelper.canWalkOn(context.bsi, placeX, y, placeZ, toPlace, context.baritone.settings())) {
            additionalPlacementCost = context.costOfPlacingAt(placeX, y, placeZ, toPlace);
            if (additionalPlacementCost >= 1000000.0) {
                return;
            }
            if (!MovementHelper.isReplaceable(placeX, y, placeZ, toPlace, context.bsi)) {
                return;
            }
            boolean foundPlaceOption = false;
            for (int i = 0; i < 5; ++i) {
                int againstX = placeX + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].m_122429_();
                int againstY = y + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].m_122430_();
                int againstZ = placeZ + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].m_122431_();
                if (placeX - againstX == diffX && placeZ - againstZ == diffZ || !context.canPlaceAgainst(againstX, againstY, againstZ)) continue;
                foundPlaceOption = true;
                break;
            }
            if (!foundPlaceOption) {
                return;
            }
        }
        double miningTicks = 0.0;
        BlockState srcDown = context.get(x, y - 1, z);
        if (srcDown.m_60734_() != Blocks.f_50155_ && srcDown.m_60734_() != Blocks.f_50191_) {
            boolean jumpingToBottomSlab;
            boolean inLiquid = MovementHelper.isLiquid(srcDown);
            for (int dx = -context.requiredSideSpace; dx <= context.requiredSideSpace; ++dx) {
                for (int dz = -context.requiredSideSpace; dz <= context.requiredSideSpace; ++dz) {
                    int x1 = x + dx;
                    int y1 = y + context.height;
                    int z1 = z + dz;
                    BlockState aboveHead = context.get(x1, y1, z1);
                    if (!(context.get(x1, y1 + 1, z1).m_60734_() instanceof FallingBlock) || !MovementHelper.canWalkThrough(context.bsi, x1, y1 - 1, z1, context.baritone.settings()) && aboveHead.m_60734_() instanceof FallingBlock) {
                        if (!((miningTicks += MovementHelper.getMiningDurationTicks(context, x1, y1, z1, aboveHead, false)) >= 1000000.0 || (inLiquid |= MovementHelper.isWater(aboveHead)) && miningTicks > 0.0)) {
                            continue;
                        }
                        return;
                    }
                    return;
                }
            }
            boolean jumpingFromBottomSlab = !inLiquid && MovementHelper.isBottomSlab(srcDown);
            boolean bl = jumpingToBottomSlab = !inLiquid && MovementHelper.isBottomSlab(toPlace);
            if (!jumpingFromBottomSlab || jumpingToBottomSlab) {
                double walk;
                if (jumpingToBottomSlab) {
                    if (jumpingFromBottomSlab) {
                        walk = Math.max(JUMP_ONE_BLOCK_COST, 4.63284688441047);
                        walk += context.jumpPenalty;
                    } else {
                        walk = 4.63284688441047;
                    }
                } else if (inLiquid) {
                    walk = context.waterWalkSpeed / 4.63284688441047 * Math.max(JUMP_ONE_BLOCK_COST, 4.63284688441047);
                } else {
                    walk = Math.max(JUMP_ONE_BLOCK_COST, 4.63284688441047 / (double)toPlace.m_60734_().m_49961_());
                    walk += context.jumpPenalty;
                }
                double totalCost = walk + additionalPlacementCost;
                if (!((totalCost += miningTicks) >= 1000000.0)) {
                    for (int dxz = -context.requiredSideSpace; dxz <= context.requiredSideSpace; ++dxz) {
                        for (int dy = 0; dy < context.height; ++dy) {
                            miningTicks = MovementHelper.getMiningDurationTicks(context, placeX + dxz * diffZ, y + dy + 1, placeZ + dxz * diffX, dy == context.height - 1);
                            if (!((totalCost += miningTicks) >= 1000000.0) && (!(miningTicks > 0.0) || !inLiquid)) continue;
                            return;
                        }
                    }
                    result.oxygenCost = context.oxygenCost(walk / 3.0, context.get(x, y + context.height - 1, z));
                    result.oxygenCost += context.oxygenCost(walk / 3.0, context.get(x, y + context.height, z));
                    result.oxygenCost += context.oxygenCost(walk / 3.0, context.get(destX, y + context.height - 1, destZ));
                    result.cost = totalCost;
                }
            }
        }
    }

    @Override
    public MovementState updateState(MovementState state) {
        if (this.ctx.feetPos().y < this.src.y) {
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        if (!this.ctx.feetPos().equals((Object)this.dest) && !this.ctx.feetPos().equals(this.dest.m_121955_((Vec3i)this.getDirection().m_7495_()))) {
            BlockState jumpingOnto = BlockStateInterface.get(this.ctx, this.positionToPlace);
            if (!MovementHelper.canWalkOn(this.ctx, this.positionToPlace, jumpingOnto)) {
                ++this.ticksWithoutPlacement;
                if (MovementHelper.attemptToPlaceABlock(state, this.baritone, this.positionToPlace, false, true) == MovementHelper.PlaceResult.READY_TO_PLACE) {
                    state.setInput(Input.SNEAK, true);
                    if (this.ctx.entity().m_6144_()) {
                        state.setInput(Input.CLICK_RIGHT, true);
                    }
                }
                if (this.ticksWithoutPlacement > 10) {
                    state.setInput(Input.MOVE_BACK, true);
                }
                return state;
            }
            MovementHelper.moveTowards(this.ctx, state, this.dest);
            if (MovementHelper.isBottomSlab(jumpingOnto) && !MovementHelper.isBottomSlab(BlockStateInterface.get(this.ctx, this.src.down()))) {
                return state;
            }
            if (!this.baritone.settings().assumeStep.get().booleanValue() && !this.canStopJumping()) {
                int xAxis = Math.abs(this.src.m_123341_() - this.dest.m_123341_());
                int zAxis = Math.abs(this.src.m_123343_() - this.dest.m_123343_());
                double flatDistToNext = (double)xAxis * Math.abs((double)this.dest.m_123341_() + 0.5 - this.ctx.entity().m_20185_()) + (double)zAxis * Math.abs((double)this.dest.m_123343_() + 0.5 - this.ctx.entity().m_20189_());
                double sideDist = (double)zAxis * Math.abs((double)this.dest.m_123341_() + 0.5 - this.ctx.entity().m_20185_()) + (double)xAxis * Math.abs((double)this.dest.m_123343_() + 0.5 - this.ctx.entity().m_20189_());
                double lateralMotion = (double)xAxis * this.ctx.entity().m_20184_().f_82481_ + (double)zAxis * this.ctx.entity().m_20184_().f_82479_;
                if (Math.abs(lateralMotion) > 0.1) {
                    return state;
                }
                if (this.headBonkClear()) {
                    return state.setInput(Input.JUMP, true);
                }
                return !(flatDistToNext > 1.2) && !(sideDist > 0.2) ? state.setInput(Input.JUMP, true) : state;
            }
            return state;
        }
        return state.setStatus(MovementStatus.SUCCESS);
    }

    private boolean canStopJumping() {
        BetterBlockPos srcUp = this.src.up();
        double entityY = this.ctx.entity().m_20186_();
        if (entityY < (double)srcUp.y) {
            return false;
        }
        return entityY <= (double)srcUp.y + 0.1 ? !MovementHelper.isWater(this.ctx.world().m_8055_((BlockPos)srcUp)) : true;
    }

    public boolean headBonkClear() {
        BetterBlockPos startUp = this.src.up(Mth.m_14167_((float)this.ctx.entity().m_20206_()));
        for (int i = 0; i < 4; ++i) {
            BetterBlockPos check = startUp.offset(Direction.m_122407_((int)i));
            if (MovementHelper.canWalkThrough(this.ctx, check)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return state.getStatus() != MovementStatus.RUNNING || this.ticksWithoutPlacement == 0;
    }
}

