/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.process;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalBlock;
import com.player2.playerengine.automaton.api.pathing.goals.GoalComposite;
import com.player2.playerengine.automaton.api.process.IFarmProcess;
import com.player2.playerengine.automaton.api.process.PathingCommand;
import com.player2.playerengine.automaton.api.process.PathingCommandType;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.api.utils.interfaces.IGoalRenderPos;
import com.player2.playerengine.automaton.cache.WorldScanner;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.process.BuilderProcess;
import com.player2.playerengine.automaton.utils.BaritoneProcessHelper;
import com.player2.playerengine.automaton.utils.NotificationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class FarmProcess
extends BaritoneProcessHelper
implements IFarmProcess {
    private boolean active;
    private List<BlockPos> locations;
    private int tickCount;
    private int range;
    private BlockPos center;
    private static final List<Item> FARMLAND_PLANTABLE = Arrays.asList(Items.f_42733_, Items.f_42578_, Items.f_42404_, Items.f_42577_, Items.f_42620_, Items.f_42619_);
    private static final List<Item> PICKUP_DROPPED = Arrays.asList(Items.f_42733_, Items.f_42732_, Items.f_42578_, Items.f_42575_, Blocks.f_50186_.m_5456_(), Items.f_42404_, Items.f_42405_, Items.f_42577_, Blocks.f_50133_.m_5456_(), Items.f_42620_, Items.f_42619_, Items.f_42588_, Blocks.f_50130_.m_5456_(), Blocks.f_50128_.m_5456_());

    public FarmProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void farm(int range, BlockPos pos) {
        this.center = pos == null ? this.baritone.getEntityContext().feetPos() : pos;
        this.range = range;
        this.active = true;
        this.locations = null;
    }

    private boolean readyForHarvest(Level world, BlockPos pos, BlockState state) {
        for (Harvest harvest : Harvest.values()) {
            if (harvest.block != state.m_60734_()) continue;
            return harvest.readyToHarvest(world, pos, state, this.baritone.settings());
        }
        return false;
    }

    private boolean isPlantable(ItemStack stack) {
        return FARMLAND_PLANTABLE.contains(stack.m_41720_());
    }

    private boolean isBoneMeal(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_().equals(Items.f_42499_);
    }

    private boolean isNetherWart(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_().equals(Items.f_42588_);
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        ArrayList<Block> scan = new ArrayList<Block>();
        for (Harvest harvest : Harvest.values()) {
            scan.add(harvest.block);
        }
        if (this.baritone.settings().replantCrops.get().booleanValue()) {
            scan.add(Blocks.f_50093_);
            if (this.baritone.settings().replantNetherWart.get().booleanValue()) {
                scan.add(Blocks.f_50135_);
            }
        }
        if (this.baritone.settings().mineGoalUpdateInterval.get() != 0 && this.tickCount++ % this.baritone.settings().mineGoalUpdateInterval.get() == 0) {
            PlayerEngine.getExecutor().execute(() -> {
                this.locations = WorldScanner.INSTANCE.scanChunkRadius(this.ctx, scan, 256, 10, 10);
            });
        }
        if (this.locations == null) {
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<BlockPos> toBreak = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openFarmland = new ArrayList<BlockPos>();
        ArrayList<BlockPos> bonemealable = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openSoulsand = new ArrayList<BlockPos>();
        for (BlockPos blockPos : this.locations) {
            BonemealableBlock ig;
            if (this.range != 0 && blockPos.m_123331_((Vec3i)this.center) > (double)(this.range * this.range)) continue;
            BlockState state = this.ctx.world().m_8055_(blockPos);
            boolean airAbove = this.ctx.world().m_8055_(blockPos.m_7494_()).m_60734_() instanceof AirBlock;
            if (state.m_60734_() == Blocks.f_50093_) {
                if (!airAbove) continue;
                openFarmland.add(blockPos);
                continue;
            }
            if (state.m_60734_() == Blocks.f_50135_) {
                if (!airAbove) continue;
                openSoulsand.add(blockPos);
                continue;
            }
            if (this.readyForHarvest((Level)this.ctx.world(), blockPos, state)) {
                toBreak.add(blockPos);
                continue;
            }
            if (!(state.m_60734_() instanceof BonemealableBlock) || !(ig = (BonemealableBlock)state.m_60734_()).m_7370_((LevelReader)this.ctx.world(), blockPos, state, true) || !ig.m_214167_((Level)this.ctx.world(), this.ctx.world().f_46441_, blockPos, state)) continue;
            bonemealable.add(blockPos);
        }
        this.baritone.getInputOverrideHandler().clearAllKeys();
        for (BlockPos blockPos : toBreak) {
            Optional<Rotation> rot = RotationUtils.reachable(this.ctx, blockPos);
            if (!rot.isPresent() || !isSafeToCancel) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            MovementHelper.switchToBestToolFor(this.ctx, this.ctx.world().m_8055_(blockPos));
            if (this.ctx.isLookingAt(blockPos)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<BlockPos> both = new ArrayList<BlockPos>(openFarmland);
        both.addAll(openSoulsand);
        for (BlockPos posxx : both) {
            HitResult result;
            boolean soulsand = openSoulsand.contains(posxx);
            Optional<Rotation> rot = RotationUtils.reachableOffset((Entity)this.ctx.entity(), posxx, new Vec3((double)posxx.m_123341_() + 0.5, (double)(posxx.m_123342_() + 1), (double)posxx.m_123343_() + 0.5), this.ctx.playerController().getBlockReachDistance(), false);
            if (!rot.isPresent() || !isSafeToCancel || !this.baritone.getInventoryBehavior().throwaway(true, soulsand ? this::isNetherWart : this::isPlantable) || !((result = RayTraceUtils.rayTraceTowards((Entity)this.ctx.entity(), rot.get(), this.ctx.playerController().getBlockReachDistance())) instanceof BlockHitResult) || ((BlockHitResult)result).m_82434_() != Direction.UP) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            if (this.ctx.isLookingAt(posxx)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        for (BlockPos posxxx : bonemealable) {
            Optional<Rotation> rot = RotationUtils.reachable(this.ctx, posxxx);
            if (!rot.isPresent() || !isSafeToCancel || !this.baritone.getInventoryBehavior().throwaway(true, this::isBoneMeal)) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            if (this.ctx.isLookingAt(posxxx)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        if (calcFailed) {
            this.logDirect("Farm failed");
            if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnFarmFail.get().booleanValue()) {
                NotificationHelper.notify("Farm failed", true);
            }
            this.onLostControl();
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<IGoalRenderPos> arrayList = new ArrayList<IGoalRenderPos>();
        for (BlockPos posxxxx : toBreak) {
            arrayList.add(new BuilderProcess.GoalBreak(posxxxx));
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isPlantable)) {
            for (BlockPos posxxxx : openFarmland) {
                arrayList.add(new GoalBlock(posxxxx.m_7494_()));
            }
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isNetherWart)) {
            for (BlockPos posxxxx : openSoulsand) {
                arrayList.add(new GoalBlock(posxxxx.m_7494_()));
            }
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isBoneMeal)) {
            for (BlockPos posxxxx : bonemealable) {
                arrayList.add(new GoalBlock(posxxxx));
            }
        }
        for (ItemEntity item : this.ctx.world().m_6443_(ItemEntity.class, this.ctx.entity().m_20191_().m_82400_(30.0), Entity::m_20096_)) {
            if (!PICKUP_DROPPED.contains(item.m_32055_().m_41720_())) continue;
            arrayList.add(new GoalBlock(BlockPos.m_274561_((double)item.m_20185_(), (double)(item.m_20186_() + 0.1), (double)item.m_20189_())));
        }
        return arrayList.isEmpty() ? new PathingCommand(null, PathingCommandType.REQUEST_PAUSE) : new PathingCommand(new GoalComposite(arrayList.toArray(new Goal[0])), PathingCommandType.SET_GOAL_AND_PATH);
    }

    @Override
    public void onLostControl() {
        this.active = false;
    }

    @Override
    public String displayName0() {
        return "Farming";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Harvest {
        WHEAT((CropBlock)Blocks.f_50092_),
        CARROTS((CropBlock)Blocks.f_50249_),
        POTATOES((CropBlock)Blocks.f_50250_),
        BEETROOT((CropBlock)Blocks.f_50444_),
        PUMPKIN(Blocks.f_50133_, state -> true),
        MELON(Blocks.f_50186_, state -> true),
        NETHERWART(Blocks.f_50200_, state -> (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) >= 3),
        SUGARCANE(Blocks.f_50130_, null){

            @Override
            public boolean readyToHarvest(Level world, BlockPos pos, BlockState state, Settings settings) {
                return settings.replantCrops.get() != false ? world.m_8055_(pos.m_7495_()).m_60734_() instanceof SugarCaneBlock : true;
            }
        }
        ,
        CACTUS(Blocks.f_50128_, null){

            @Override
            public boolean readyToHarvest(Level world, BlockPos pos, BlockState state, Settings settings) {
                return settings.replantCrops.get() != false ? world.m_8055_(pos.m_7495_()).m_60734_() instanceof CactusBlock : true;
            }
        };

        public final Block block;
        public final Predicate<BlockState> readyToHarvest;

        private Harvest(CropBlock blockCrops) {
            this((Block)blockCrops, arg_0 -> ((CropBlock)blockCrops).m_52307_(arg_0));
        }

        private Harvest(Block block, Predicate<BlockState> readyToHarvest) {
            this.block = block;
            this.readyToHarvest = readyToHarvest;
        }

        public boolean readyToHarvest(Level world, BlockPos pos, BlockState state, Settings settings) {
            return this.readyToHarvest.test(state);
        }
    }
}

