/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ToolSet {
    private final Map<Block, Double> breakStrengthCache = new HashMap<Block, Double>();
    private final Function<Block, Double> backendCalculation;
    private final LivingEntity player;
    private final IBaritone baritone;

    public ToolSet(LivingEntity player) {
        this.player = player;
        this.baritone = IBaritone.KEY.get(player);
        if (this.baritone.settings().considerPotionEffects.get().booleanValue()) {
            double amplifier = this.potionAmplifier();
            Function<Double, Double> amplify = x -> amplifier * x;
            this.backendCalculation = amplify.compose(this::getBestDestructionTime);
        } else {
            this.backendCalculation = this::getBestDestructionTime;
        }
    }

    public double getStrVsBlock(BlockState state) {
        return this.breakStrengthCache.computeIfAbsent(state.m_60734_(), this.backendCalculation);
    }

    private int getMaterialCost(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof TieredItem ? 1 : -1;
    }

    public boolean hasSilkTouch(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0;
    }

    public int getBestSlot(Block b, boolean preferSilkTouch) {
        return this.getBestSlot(b, preferSilkTouch, false);
    }

    public int getBestSlot(Block b, boolean preferSilkTouch, boolean pathingCalculation) {
        if (b.m_49966_().m_60734_().m_155943_() == 0.0f) {
            return ((IInventoryProvider)this.player).getLivingInventory().selectedSlot;
        }
        if (this.baritone.settings().disableAutoTool.get().booleanValue() && pathingCalculation) {
            return ((IInventoryProvider)this.player).getLivingInventory().selectedSlot;
        }
        int best = 0;
        double highestSpeed = Double.NEGATIVE_INFINITY;
        int lowestCost = Integer.MIN_VALUE;
        boolean bestSilkTouch = false;
        BlockState blockState = b.m_49966_();
        for (int i = 0; i < 9; ++i) {
            int cost;
            ItemStack itemStack = ((IInventoryProvider)this.player).getLivingInventory().m_8020_(i);
            if (!this.baritone.settings().useSwordToMine.get().booleanValue() && itemStack.m_41720_() instanceof SwordItem || this.baritone.settings().itemSaver.get().booleanValue() && itemStack.m_41773_() >= itemStack.m_41776_() && itemStack.m_41776_() > 1) continue;
            double speed = ToolSet.calculateSpeedVsBlock(itemStack, blockState);
            boolean silkTouch = this.hasSilkTouch(itemStack);
            if (speed > highestSpeed) {
                highestSpeed = speed;
                best = i;
                lowestCost = this.getMaterialCost(itemStack);
                bestSilkTouch = silkTouch;
                continue;
            }
            if (speed != highestSpeed || ((cost = this.getMaterialCost(itemStack)) >= lowestCost || !silkTouch && bestSilkTouch) && (!preferSilkTouch || bestSilkTouch || !silkTouch)) continue;
            highestSpeed = speed;
            best = i;
            lowestCost = cost;
            bestSilkTouch = silkTouch;
        }
        return best;
    }

    private double getBestDestructionTime(Block b) {
        ItemStack stack = ((IInventoryProvider)this.player).getLivingInventory().m_8020_(this.getBestSlot(b, false, true));
        return ToolSet.calculateSpeedVsBlock(stack, b.m_49966_()) * this.avoidanceMultiplier(b);
    }

    private double avoidanceMultiplier(Block b) {
        return this.baritone.settings().blocksToAvoidBreaking.get().contains(b.m_204297_().m_203334_()) ? 0.1 : 1.0;
    }

    public static double calculateSpeedVsBlock(ItemStack item, BlockState state) {
        int effLevel;
        float hardness = state.m_60800_(null, null);
        if (hardness < 0.0f) {
            return -1.0;
        }
        float speed = item.m_41691_(state);
        if (speed > 1.0f && (effLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)item)) > 0 && !item.m_41619_()) {
            speed += (float)(effLevel * effLevel + 1);
        }
        return state.m_60834_() && (item.m_41619_() || !item.m_41735_(state)) ? (double)(speed / 100.0f) : (double)((speed /= hardness) / 30.0f);
    }

    private double potionAmplifier() {
        MobEffectInstance fatigueEffect;
        double speed = 1.0;
        MobEffectInstance hasteEffect = this.player.m_21124_(MobEffects.f_19598_);
        if (hasteEffect != null) {
            speed *= 1.0 + (double)(hasteEffect.m_19564_() + 1) * 0.2;
        }
        if ((fatigueEffect = this.player.m_21124_(MobEffects.f_19599_)) != null) {
            switch (fatigueEffect.m_19564_()) {
                case 0: {
                    speed *= 0.3;
                    break;
                }
                case 1: {
                    speed *= 0.09;
                    break;
                }
                case 2: {
                    speed *= 0.0027;
                    break;
                }
                default: {
                    speed *= 8.1E-4;
                }
            }
        }
        return speed;
    }
}

