/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils.player;

import com.player2.playerengine.automaton.api.entity.IInteractionManagerProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInteractionManager;
import com.player2.playerengine.automaton.api.utils.IInteractionController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class EntityInteractionController
implements IInteractionController {
    private final LivingEntity player;
    private int sequence;

    public EntityInteractionController(LivingEntity player) {
        this.player = player;
    }

    @Override
    public boolean hasBrokenBlock() {
        return this.getInteractionManager().hasBrokenBlock();
    }

    @Override
    public boolean onPlayerDamageBlock(BlockPos pos, Direction side) {
        LivingEntityInteractionManager interactionManager = this.getInteractionManager();
        if (interactionManager.isMining()) {
            int progress = interactionManager.getBlockBreakingProgress();
            if (progress >= 10) {
                this.getInteractionManager().processBlockBreakingAction(interactionManager.getMiningPos(), ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, side, this.player.m_9236_().m_151558_(), this.sequence++);
            }
            return true;
        }
        return false;
    }

    @Override
    public void resetBlockRemoving() {
        LivingEntityInteractionManager interactionManager = this.getInteractionManager();
        if (interactionManager.isMining()) {
            this.getInteractionManager().processBlockBreakingAction(interactionManager.getMiningPos(), ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, Direction.UP, this.player.m_9236_().m_151558_(), this.sequence++);
        }
    }

    @Override
    public GameType getGameType() {
        return GameType.SURVIVAL;
    }

    @Override
    public InteractionResult processRightClickBlock(LivingEntity player, Level world, InteractionHand hand, BlockHitResult result) {
        return this.getInteractionManager().interactBlock(this.player, this.player.m_9236_(), this.player.m_21120_(hand), hand, result);
    }

    @Override
    public InteractionResult processRightClick(LivingEntity player, Level world, InteractionHand hand) {
        return this.getInteractionManager().interactItem(this.player, this.player.m_9236_(), this.player.m_21120_(hand), hand);
    }

    @Override
    public boolean clickBlock(BlockPos loc, Direction face) {
        BlockState state = this.player.m_9236_().m_8055_(loc);
        if (state.m_60795_()) {
            return false;
        }
        this.getInteractionManager().processBlockBreakingAction(loc, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, face, this.player.m_9236_().m_151558_(), this.sequence++);
        return this.getInteractionManager().isMining() || this.player.m_9236_().m_46859_(loc);
    }

    public LivingEntityInteractionManager getInteractionManager() {
        LivingEntityInteractionManager livingEntityInteractionManager;
        LivingEntity livingEntity = this.player;
        if (livingEntity instanceof IInteractionManagerProvider) {
            IInteractionManagerProvider managerProvider = (IInteractionManagerProvider)livingEntity;
            livingEntityInteractionManager = managerProvider.getInteractionManager();
        } else {
            livingEntityInteractionManager = null;
        }
        return livingEntityInteractionManager;
    }

    @Override
    public void setHittingBlock(boolean hittingBlock) {
    }

    @Override
    public double getBlockReachDistance() {
        return 4.5;
    }
}

