/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.chains.SingleTaskChain;
import com.player2.playerengine.tasks.base.ITaskOverridesGrounded;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.tasks.movement.MLGBucketTask;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;

public class MLGBucketFallChain
extends SingleTaskChain
implements ITaskOverridesGrounded {
    private final TimerGame tryCollectWaterTimer = new TimerGame(4.0);
    private final TimerGame pickupRepeatTimer = new TimerGame(0.25);
    private MLGBucketTask lastMLG = null;
    private boolean wasPickingUp = false;
    private boolean doingChorusFruit = false;

    public MLGBucketFallChain(TaskRunner runner) {
        super(runner);
    }

    @Override
    protected void onTaskFinish(PlayerEngineController mod) {
    }

    @Override
    public float getPriority() {
        if (!PlayerEngineController.inGame()) {
            return Float.NEGATIVE_INFINITY;
        }
        PlayerEngineController mod = this.controller;
        if (this.isFalling(mod)) {
            this.tryCollectWaterTimer.reset();
            this.setTask(new MLGBucketTask());
            this.lastMLG = (MLGBucketTask)this.mainTask;
            return 100.0f;
        }
        if (!this.tryCollectWaterTimer.elapsed() && mod.getItemStorage().hasItem(Items.f_42446_) && !mod.getItemStorage().hasItem(Items.f_42447_) && this.lastMLG != null) {
            boolean isPlacedWater;
            BlockPos placed = this.lastMLG.getWaterPlacedPos();
            try {
                isPlacedWater = mod.getWorld().m_8055_(placed).m_60734_() == Blocks.f_49990_;
            }
            catch (Exception var6) {
                isPlacedWater = false;
            }
            if (placed != null && placed.m_203195_((Position)mod.getPlayer().m_20182_(), 5.5) && isPlacedWater) {
                mod.getBehaviour().push();
                mod.getBehaviour().setRayTracingFluidHandling(ClipContext.Fluid.SOURCE_ONLY);
                Optional<Rotation> reach = LookHelper.getReach(this.controller, placed, Direction.UP);
                if (reach.isPresent()) {
                    mod.getBaritone().getLookBehavior().updateTarget(reach.get(), true);
                    if (mod.getBaritone().getEntityContext().isLookingAt(placed) && mod.getSlotHandler().forceEquipItem(Items.f_42446_)) {
                        if (this.pickupRepeatTimer.elapsed()) {
                            this.pickupRepeatTimer.reset();
                            mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                            this.wasPickingUp = true;
                        } else if (this.wasPickingUp) {
                            this.wasPickingUp = false;
                        }
                    }
                } else {
                    this.setTask(TaskCatalogue.getItemTask(Items.f_42447_, 1));
                }
                mod.getBehaviour().pop();
                return 60.0f;
            }
        }
        if (this.wasPickingUp) {
            this.wasPickingUp = false;
            this.lastMLG = null;
        }
        if (mod.getPlayer().m_21023_(MobEffects.f_19620_) && ((MobEffectInstance)mod.getPlayer().m_21221_().get(MobEffects.f_19620_)).m_19557_() <= 70 && mod.getItemStorage().hasItemInventoryOnly(Items.f_42730_) && !mod.getItemStorage().hasItemInventoryOnly(Items.f_42447_)) {
            this.doingChorusFruit = true;
            mod.getSlotHandler().forceEquipItem(Items.f_42730_);
            mod.getInputControls().hold(Input.CLICK_RIGHT);
            mod.getExtraBaritoneSettings().setInteractionPaused(true);
        } else if (this.doingChorusFruit) {
            this.doingChorusFruit = false;
            mod.getInputControls().release(Input.CLICK_RIGHT);
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
        }
        this.lastMLG = null;
        return Float.NEGATIVE_INFINITY;
    }

    @Override
    public String getName() {
        return "MLG Water Bucket Fall Chain";
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public boolean doneMLG() {
        return this.lastMLG == null;
    }

    public boolean isChorusFruiting() {
        return this.doingChorusFruit;
    }

    public boolean isFalling(PlayerEngineController mod) {
        if (!mod.getModSettings().shouldAutoMLGBucket()) {
            return false;
        }
        if (!(mod.getPlayer().m_6069_() || mod.getPlayer().m_20069_() || mod.getPlayer().m_20096_() || mod.getPlayer().m_6147_())) {
            double ySpeed = mod.getPlayer().m_20184_().f_82480_;
            return ySpeed < -0.7;
        }
        return false;
    }
}

