/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.behavior.PathingBehavior;
import com.player2.playerengine.chains.SingleTaskChain;
import com.player2.playerengine.control.KillAura;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.tasks.construction.ProjectileProtectionWallTask;
import com.player2.playerengine.tasks.entity.KillEntitiesTask;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.tasks.movement.DodgeProjectilesTask;
import com.player2.playerengine.tasks.movement.RunAwayFromCreepersTask;
import com.player2.playerengine.tasks.movement.RunAwayFromHostilesTask;
import com.player2.playerengine.tasks.speedrun.DragonBreathTracker;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.baritone.CachedProjectile;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import com.player2.playerengine.util.helpers.EntityHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.ProjectileHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.slots.PlayerSlot;
import com.player2.playerengine.util.slots.Slot;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class MobDefenseChain
extends SingleTaskChain {
    private static final double DANGER_KEEP_DISTANCE = 30.0;
    private static final double CREEPER_KEEP_DISTANCE = 10.0;
    private static final double ARROW_KEEP_DISTANCE_HORIZONTAL = 2.0;
    private static final double ARROW_KEEP_DISTANCE_VERTICAL = 10.0;
    private static final double SAFE_KEEP_DISTANCE = 8.0;
    private static final List<Class<? extends Entity>> ignoredMobs = List.of(Warden.class, WitherBoss.class, EnderMan.class, Blaze.class, WitherSkeleton.class, Hoglin.class, Zoglin.class, PiglinBrute.class, Vindicator.class, MagmaCube.class);
    private static boolean shielding = false;
    private final DragonBreathTracker dragonBreathTracker = new DragonBreathTracker();
    private final KillAura killAura = new KillAura();
    private Entity targetEntity;
    private boolean doingFunkyStuff = false;
    private boolean wasPuttingOutFire = false;
    private CustomBaritoneGoalTask runAwayTask;
    private float prevHealth = 20.0f;
    private boolean needsChangeOnAttack = false;
    private Entity lockedOnEntity = null;
    private float cachedLastPriority;

    public MobDefenseChain(TaskRunner runner) {
        super(runner);
    }

    public static double getCreeperSafety(Vec3 pos, Creeper creeper) {
        double distance = creeper.m_20238_(pos);
        float fuse = creeper.m_32320_(1.0f);
        return fuse <= 0.001f ? distance : distance * 0.2;
    }

    private static void startShielding(PlayerEngineController mod) {
        ItemStack handItem;
        shielding = true;
        ((PathingBehavior)mod.getBaritone().getPathingBehavior()).requestPause();
        mod.getExtraBaritoneSettings().setInteractionPaused(true);
        if (!mod.getPlayer().m_21254_() && ItemVer.isFood(handItem = StorageHelper.getItemStackInSlot(PlayerSlot.getEquipSlot(mod.getInventory())))) {
            for (ItemStack spaceSlot : mod.getItemStorage().getItemStacksPlayerInventory(false)) {
                if (!spaceSlot.m_41619_()) continue;
                mod.getSlotHandler().clickSlot(PlayerSlot.getEquipSlot(mod.getInventory()), 0, ClickType.QUICK_MOVE);
                return;
            }
            Optional<Slot> garbage = StorageHelper.getGarbageSlot(mod);
            garbage.ifPresent(slot -> mod.getSlotHandler().forceEquipItem(StorageHelper.getItemStackInSlot(slot).m_41720_()));
        }
        mod.getInputControls().hold(Input.SNEAK);
        mod.getInputControls().hold(Input.CLICK_RIGHT);
    }

    private static int getDangerousnessScore(List<LivingEntity> toDealWithList) {
        int numberOfProblematicEntities = toDealWithList.size();
        for (LivingEntity toDealWith : toDealWithList) {
            if (toDealWith instanceof EnderMan || toDealWith instanceof Slime || toDealWith instanceof Blaze) {
                ++numberOfProblematicEntities;
                continue;
            }
            if (!(toDealWith instanceof Drowned) || toDealWith.m_20158_() != Items.f_42713_) continue;
            numberOfProblematicEntities += 5;
        }
        return numberOfProblematicEntities;
    }

    @Override
    public float getPriority() {
        this.cachedLastPriority = this.getPriorityInner();
        if (this.getCurrentTask() == null) {
            this.cachedLastPriority = 0.0f;
        }
        this.prevHealth = this.controller.getPlayer().m_21223_();
        return this.cachedLastPriority;
    }

    private void stopShielding(PlayerEngineController mod) {
        if (shielding) {
            Optional<Slot> toMoveTo;
            ItemStack cursor = StorageHelper.getItemStackInCursorSlot(this.controller);
            if (ItemVer.isFood(cursor) && (toMoveTo = mod.getItemStorage().getSlotThatCanFitInPlayerInventory(cursor, false).or(() -> StorageHelper.getGarbageSlot(mod))).isPresent()) {
                Slot garbageSlot = toMoveTo.get();
                mod.getSlotHandler().clickSlot(garbageSlot, 0, ClickType.PICKUP);
            }
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.CLICK_RIGHT);
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
            shielding = false;
        }
    }

    public boolean isShielding() {
        return shielding || this.killAura.isShielding();
    }

    private boolean escapeDragonBreath(PlayerEngineController mod) {
        this.dragonBreathTracker.updateBreath(mod);
        for (BlockPos playerIn : WorldHelper.getBlocksTouchingPlayer(mod.getPlayer())) {
            if (!this.dragonBreathTracker.isTouchingDragonBreath(playerIn)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getPriorityInner() {
        Object shieldSlot;
        BlockPos fireBlock;
        if (!PlayerEngineController.inGame()) {
            return Float.NEGATIVE_INFINITY;
        }
        PlayerEngineController mod = this.controller;
        if (!mod.getModSettings().isMobDefense()) {
            return Float.NEGATIVE_INFINITY;
        }
        if (mod.getWorld().m_46791_() == Difficulty.PEACEFUL) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.needsChangeOnAttack && (mod.getPlayer().m_21223_() < this.prevHealth || this.killAura.attackedLastTick)) {
            this.needsChangeOnAttack = false;
        }
        if ((fireBlock = this.isInsideFireAndOnFire(mod)) != null) {
            this.putOutFire(mod, fireBlock);
            this.wasPuttingOutFire = true;
        } else {
            mod.getBaritone().getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, false);
            this.wasPuttingOutFire = false;
        }
        Optional<Entity> universallyDangerous = this.getUniversallyDangerousMob(mod);
        if (universallyDangerous.isPresent() && mod.getPlayer().m_21223_() <= 10.0f) {
            this.runAwayTask = new RunAwayFromHostilesTask(30.0, true);
            this.runAwayTask.controller = this.controller;
            this.setTask(this.runAwayTask);
            return 70.0f;
        }
        this.doingFunkyStuff = false;
        Slot offhandSlot = PlayerSlot.getOffhandSlot(mod.getInventory());
        Item offhandItem = StorageHelper.getItemStackInSlot(offhandSlot).m_41720_();
        Creeper blowingUp = this.getClosestFusingCreeper(mod);
        if (blowingUp != null && blowingUp.m_20270_((Entity)mod.getEntity()) <= 16.0f) {
            if (mod.getFoodChain().needsToEat() && !(mod.getPlayer().m_21223_() < 9.0f) || !MobDefenseChain.hasShield(mod) || mod.getEntityTracker().entityFound(ThrownPotion.class) || !mod.getBaritone().getPathingBehavior().isSafeToCancel() || !((double)blowingUp.m_32320_((float)blowingUp.m_32310_()) > 0.5)) {
                this.doingFunkyStuff = true;
                this.runAwayTask = new RunAwayFromCreepersTask(10.0);
                this.runAwayTask.controller = this.controller;
                this.setTask(this.runAwayTask);
                return 50.0f + blowingUp.m_32320_(1.0f) * 50.0f;
            }
            LookHelper.lookAt(mod, blowingUp.m_146892_());
            shieldSlot = StorageHelper.getItemStackInSlot(offhandSlot);
            if (shieldSlot.m_41720_() != Items.f_42740_) {
                mod.getSlotHandler().forceEquipItemToOffhand(Items.f_42740_);
            } else {
                MobDefenseChain.startShielding(mod);
            }
        }
        shieldSlot = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (shieldSlot) {
            if (mod.getModSettings().isDodgeProjectiles() && MobDefenseChain.hasShield(mod) && mod.getBaritone().getPathingBehavior().isSafeToCancel() && !mod.getEntityTracker().entityFound(ThrownPotion.class) && this.isProjectileClose(mod)) {
                ItemStack shieldSlot2 = StorageHelper.getItemStackInSlot(new Slot(mod.getInventory().offHand, 0));
                if (shieldSlot2.m_41720_() != Items.f_42740_) {
                    mod.getSlotHandler().forceEquipItemToOffhand(Items.f_42740_);
                } else {
                    MobDefenseChain.startShielding(mod);
                }
                return 60.0f;
            }
            if (blowingUp == null && !this.isProjectileClose(mod)) {
                this.stopShielding(mod);
            }
        }
        if (!mod.getFoodChain().needsToEat() && !mod.getMLGBucketChain().isFalling(mod) && mod.getMLGBucketChain().doneMLG() && !mod.getMLGBucketChain().isChorusFruiting()) {
            this.doForceField(mod);
            if (mod.getPlayer().m_21223_() <= 10.0f && !MobDefenseChain.hasShield(mod)) {
                if (StorageHelper.getNumberOfThrowawayBlocks(mod) > 0 && !mod.getFoodChain().needsToEat() && mod.getModSettings().isDodgeProjectiles() && this.isProjectileClose(mod)) {
                    this.doingFunkyStuff = true;
                    this.setTask(new ProjectileProtectionWallTask(mod));
                    return 65.0f;
                }
                if (this.isProjectileClose(mod)) {
                    this.runAwayTask = new DodgeProjectilesTask(2.0, 10.0);
                    this.runAwayTask.controller = this.controller;
                    this.setTask(this.runAwayTask);
                    return 65.0f;
                }
            }
            if (!this.isInDanger(mod) || this.escapeDragonBreath(mod) || mod.getFoodChain().isShouldStop() || this.targetEntity != null && !WorldHelper.isSurroundedByHostiles(mod)) {
                if (mod.getModSettings().shouldDealWithAnnoyingHostiles()) {
                    List<LivingEntity> hostiles = mod.getEntityTracker().getHostiles();
                    ArrayList<LivingEntity> toDealWithList = new ArrayList<LivingEntity>();
                    Object object = BaritoneHelper.MINECRAFT_LOCK;
                    synchronized (object) {
                        for (LivingEntity hostile : hostiles) {
                            if (hostile == mod.getEntity()) continue;
                            boolean isRangedOrPoisonous = hostile instanceof Skeleton || hostile instanceof Witch || hostile instanceof Pillager || hostile instanceof Piglin || hostile instanceof Stray || hostile instanceof CaveSpider;
                            int annoyingRange = 10;
                            if (isRangedOrPoisonous) {
                                annoyingRange = 20;
                                if (!MobDefenseChain.hasShield(mod)) {
                                    annoyingRange = 35;
                                }
                            }
                            if (!hostile.m_19950_((Entity)mod.getPlayer(), (double)annoyingRange) || !LookHelper.seesPlayer((Entity)hostile, (Entity)mod.getPlayer(), annoyingRange)) continue;
                            boolean isIgnored = false;
                            for (Class<? extends Entity> ignored : ignoredMobs) {
                                if (!ignored.isInstance(hostile)) continue;
                                isIgnored = true;
                                break;
                            }
                            if (isIgnored) {
                                if (!(mod.getPlayer().m_21223_() <= 10.0f)) continue;
                                toDealWithList.add(hostile);
                                continue;
                            }
                            toDealWithList.add(hostile);
                        }
                    }
                    toDealWithList.sort(Comparator.comparingDouble(entity -> mod.getPlayer().m_20270_((Entity)entity)));
                    if (!toDealWithList.isEmpty()) {
                        Entity toKill;
                        int shield;
                        float damage;
                        TieredItem bestWeapon = MobDefenseChain.getBestWeapon(mod);
                        int armor = mod.getPlayer().m_21230_();
                        int canDealWith = (int)Math.ceil((double)armor * 3.6 / 20.0 + (double)(damage = bestWeapon == null ? 0.0f : bestWeapon.m_43314_().m_6631_() + 1.0f) * 0.8 + (double)(shield = MobDefenseChain.hasShield(mod) && bestWeapon != null ? 3 : 0));
                        if (canDealWith < MobDefenseChain.getDangerousnessScore(toDealWithList) && !this.needsChangeOnAttack) {
                            this.runAwayTask = new RunAwayFromHostilesTask(30.0, true);
                            this.runAwayTask.controller = this.controller;
                            this.setTask(this.runAwayTask);
                            return 80.0f;
                        }
                        if (!(this.mainTask instanceof KillEntitiesTask)) {
                            this.needsChangeOnAttack = true;
                        }
                        this.runAwayTask = null;
                        this.lockedOnEntity = toKill = (Entity)toDealWithList.get(0);
                        this.setTask(new KillEntitiesTask(toKill.getClass()));
                        return 65.0f;
                    }
                }
                if (this.runAwayTask != null && !this.runAwayTask.isFinished()) {
                    this.setTask(this.runAwayTask);
                    return this.cachedLastPriority;
                }
                this.runAwayTask = null;
                if (this.needsChangeOnAttack && this.lockedOnEntity != null && this.lockedOnEntity.m_6084_()) {
                    this.setTask(new KillEntitiesTask(this.lockedOnEntity.getClass()));
                    return 65.0f;
                }
                this.needsChangeOnAttack = false;
                this.lockedOnEntity = null;
                return 0.0f;
            }
            this.runAwayTask = new RunAwayFromHostilesTask(30.0, true);
            this.runAwayTask.controller = this.controller;
            this.setTask(this.runAwayTask);
            return 70.0f;
        }
        this.killAura.stopShielding(mod);
        this.stopShielding(mod);
        return Float.NEGATIVE_INFINITY;
    }

    private static boolean hasShield(PlayerEngineController mod) {
        return mod.getItemStorage().hasItem(Items.f_42740_) || mod.getItemStorage().hasItemInOffhand(mod, Items.f_42740_);
    }

    public static TieredItem getBestWeapon(PlayerEngineController mod) {
        Item[] WEAPONS = new Item[]{Items.f_42393_, Items.f_42396_, Items.f_42388_, Items.f_42391_, Items.f_42383_, Items.f_42386_, Items.f_42430_, Items.f_42433_, Items.f_42425_, Items.f_42428_, Items.f_42420_, Items.f_42423_};
        TieredItem bestSword = null;
        for (Item item : WEAPONS) {
            if (!mod.getItemStorage().hasItem(item)) continue;
            bestSword = (TieredItem)item;
            break;
        }
        return bestSword;
    }

    private BlockPos isInsideFireAndOnFire(PlayerEngineController mod) {
        BlockPos[] toCheck;
        boolean onFire = mod.getPlayer().m_6060_();
        if (!onFire) {
            return null;
        }
        BlockPos p = mod.getPlayer().m_20183_();
        for (BlockPos check : toCheck = new BlockPos[]{p, p.m_7918_(1, 0, 0), p.m_7918_(1, 0, -1), p.m_7918_(0, 0, -1), p.m_7918_(-1, 0, -1), p.m_7918_(-1, 0, 0), p.m_7918_(-1, 0, 1), p.m_7918_(0, 0, 1), p.m_7918_(1, 0, 1)}) {
            Block b = mod.getWorld().m_8055_(check).m_60734_();
            if (!(b instanceof BaseFireBlock)) continue;
            return check;
        }
        return null;
    }

    private void putOutFire(PlayerEngineController mod, BlockPos pos) {
        Optional<Rotation> reach = LookHelper.getReach(mod, pos);
        if (reach.isPresent()) {
            IBaritone b = mod.getBaritone();
            if (LookHelper.isLookingAt(mod, pos)) {
                ((PathingBehavior)b.getPathingBehavior()).requestPause();
                b.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
                return;
            }
            LookHelper.lookAt(this.controller, reach.get());
        }
    }

    private void doForceField(PlayerEngineController mod) {
        this.killAura.tickStart();
        List<Entity> entities = mod.getEntityTracker().getCloseEntities();
        try {
            for (Entity entity : entities) {
                if (entity == mod.getPlayer()) continue;
                boolean shouldForce = false;
                if (mod.getBehaviour().shouldExcludeFromForcefield(entity)) continue;
                if (entity instanceof Mob) {
                    if (EntityHelper.isProbablyHostileToPlayer(mod, entity) && LookHelper.seesPlayer(entity, (Entity)mod.getPlayer(), 10.0)) {
                        shouldForce = true;
                    }
                } else if (entity instanceof LargeFireball) {
                    shouldForce = true;
                }
                if (!shouldForce) continue;
                this.killAura.applyAura(entity);
            }
        }
        catch (Exception var6) {
            var6.printStackTrace();
        }
        this.killAura.tickEnd(mod);
    }

    private Creeper getClosestFusingCreeper(PlayerEngineController mod) {
        double worstSafety = Double.POSITIVE_INFINITY;
        Creeper target = null;
        try {
            for (Creeper creeper : mod.getEntityTracker().getTrackedEntities(Creeper.class)) {
                double safety;
                if (creeper == null || (double)creeper.m_32320_(1.0f) < 0.04 || !((safety = MobDefenseChain.getCreeperSafety(mod.getPlayer().m_20182_(), creeper)) < worstSafety)) continue;
                target = creeper;
            }
            return target;
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | ConcurrentModificationException var10) {
            Debug.logWarning("Weird Exception caught and ignored while scanning for creepers: " + var10.getMessage());
            return target;
        }
    }

    private boolean isProjectileClose(PlayerEngineController mod) {
        List<CachedProjectile> projectiles = mod.getEntityTracker().getProjectiles();
        try {
            for (CachedProjectile projectile : projectiles) {
                LivingEntity clientPlayerEntity;
                boolean isGhastBall;
                if (!(projectile.position.m_82557_(mod.getPlayer().m_20182_()) < 150.0)) continue;
                boolean bl = isGhastBall = projectile.projectileType == LargeFireball.class;
                if (isGhastBall) {
                    Optional<Entity> ghastBall = mod.getEntityTracker().getClosestEntity(LargeFireball.class);
                    Optional<Entity> ghast = mod.getEntityTracker().getClosestEntity(Ghast.class);
                    if (ghastBall.isPresent() && ghast.isPresent() && this.runAwayTask == null && mod.getBaritone().getPathingBehavior().isSafeToCancel()) {
                        ((PathingBehavior)mod.getBaritone().getPathingBehavior()).requestPause();
                        LookHelper.lookAt(mod, ghast.get().m_146892_());
                    }
                    return false;
                }
                if (projectile.projectileType == DragonFireball.class || (projectile.projectileType == Arrow.class || projectile.projectileType == SpectralArrow.class || projectile.projectileType == SmallFireball.class) && (clientPlayerEntity = mod.getPlayer()).m_20238_(projectile.position) < clientPlayerEntity.m_20238_(projectile.position.m_82549_(projectile.velocity))) continue;
                Vec3 expectedHit = ProjectileHelper.calculateArrowClosestApproach(projectile, mod.getPlayer().m_20182_());
                Vec3 delta = mod.getPlayer().m_20182_().m_82546_(expectedHit);
                double horizontalDistanceSq = delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_;
                double verticalDistance = Math.abs(delta.f_82480_);
                if (!(horizontalDistanceSq < 4.0) || !(verticalDistance < 10.0)) continue;
                if (mod.getBaritone().getPathingBehavior().isSafeToCancel() && MobDefenseChain.hasShield(mod)) {
                    ((PathingBehavior)mod.getBaritone().getPathingBehavior()).requestPause();
                    LookHelper.lookAt(mod, projectile.position.m_82520_(0.0, 0.3, 0.0));
                }
                return true;
            }
        }
        catch (ConcurrentModificationException var12) {
            Debug.logWarning(var12.getMessage());
        }
        for (Skeleton skeleton : mod.getEntityTracker().getTrackedEntities(Skeleton.class)) {
            if (skeleton.m_20270_((Entity)mod.getPlayer()) > 10.0f || !skeleton.m_142582_((Entity)mod.getPlayer()) || skeleton.m_21252_() <= 15) continue;
            return true;
        }
        return false;
    }

    private Optional<Entity> getUniversallyDangerousMob(PlayerEngineController mod) {
        Class[] dangerousMobs = new Class[]{Warden.class, WitherBoss.class, WitherSkeleton.class, Hoglin.class, Zoglin.class, PiglinBrute.class, Vindicator.class};
        double range = 6.0;
        for (Class dangerous : dangerousMobs) {
            Optional<Entity> entity = mod.getEntityTracker().getClosestEntity(dangerous);
            if (!entity.isPresent() || !(entity.get().m_20280_((Entity)mod.getPlayer()) < range * range) || !EntityHelper.isAngryAtPlayer(mod, entity.get())) continue;
            return entity;
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInDanger(PlayerEngineController mod) {
        boolean witchNearby = mod.getEntityTracker().entityFound(Witch.class);
        double safeKeepDistance = 8.0;
        float health = mod.getPlayer().m_21223_();
        if (health <= 10.0f && witchNearby) {
            safeKeepDistance = 30.0;
        }
        if (mod.getPlayer().m_21023_(MobEffects.f_19615_) || mod.getPlayer().m_21023_(MobEffects.f_19614_) && witchNearby) {
            safeKeepDistance = 30.0;
        }
        if (WorldHelper.isVulnerable(mod.getPlayer())) {
            try {
                LivingEntity player = mod.getPlayer();
                List<LivingEntity> hostiles = mod.getEntityTracker().getHostiles();
                Object object = BaritoneHelper.MINECRAFT_LOCK;
                synchronized (object) {
                    for (Entity entity : hostiles) {
                        if (!entity.m_19950_((Entity)player, safeKeepDistance) || mod.getBehaviour().shouldExcludeFromForcefield(entity) || !EntityHelper.isAngryAtPlayer(mod, entity) || entity == mod.getPlayer()) continue;
                        return true;
                    }
                }
            }
            catch (Exception var13) {
                Debug.logWarning("Weird multithread exception. Will fix later. " + var13.getMessage());
            }
        }
        return false;
    }

    public void setTargetEntity(Entity entity) {
        this.targetEntity = entity;
    }

    public void resetTargetEntity() {
        this.targetEntity = null;
    }

    public void setForceFieldRange(double range) {
        this.killAura.setRange(range);
    }

    public void resetForceField() {
        this.killAura.setRange(Double.POSITIVE_INFINITY);
    }

    public boolean isDoingAcrobatics() {
        return this.doingFunkyStuff;
    }

    public boolean isPuttingOutFire() {
        return this.wasPuttingOutFire;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void onTaskFinish(PlayerEngineController mod) {
    }

    @Override
    public String getName() {
        return "Mob Defense";
    }
}

