/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.player2.playerengine.automaton.utils.DirUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ChatclefConfigPersistantState {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = DirUtil.getConfigDir().resolve("chatclef_config.json");
    private static ChatclefConfigPersistantState config = ChatclefConfigPersistantState.load();
    private boolean sttHintEnabled = true;

    public static boolean isSttHintEnabled() {
        return ChatclefConfigPersistantState.instance().sttHintEnabled;
    }

    public static void updateSttHint(boolean value) {
        System.out.println("[ChatclefConfigPersistantState]: updateSttHint called with: " + value);
        ChatclefConfigPersistantState.instance().sttHintEnabled = value;
        ChatclefConfigPersistantState.save();
    }

    private static ChatclefConfigPersistantState load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                System.out.println("[ChatclefConfigPersistantState]: Reading from file...");
                return (ChatclefConfigPersistantState)GSON.fromJson(json, ChatclefConfigPersistantState.class);
            }
            catch (IOException var1) {
                var1.printStackTrace();
            }
        }
        System.out.println("[ChatclefConfigPersistantState]: Could not load file, using default.");
        return new ChatclefConfigPersistantState();
    }

    private static void save() {
        System.out.println("[ChatclefConfigPersistantState]: save() called");
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
            System.out.println("[ChatclefConfigPersistantState]: Writing to file...");
        }
        catch (IOException var1) {
            System.err.println("[ChatclefConfigPersistantState]: Writing to file FAILED");
            var1.printStackTrace();
        }
    }

    private static ChatclefConfigPersistantState instance() {
        return config;
    }
}

