/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction.build_structure;

import com.mojang.datafixers.util.Either;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.player2api.ConversationHistory;
import com.player2.playerengine.player2api.LLMCompleter;
import com.player2.playerengine.player2api.Player2APIService;
import com.player2.playerengine.player2api.Prompts;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.build_structure.StructureFromCode;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BuildStructureTask
extends Task {
    private static final int maxNumErrors = 2;
    private static Logger LOGGER = LogManager.getLogger();
    private boolean isDone = false;
    private String description;
    private PlayerEngineController mod;
    private Player2APIService service;
    private int numErrors;
    private Task actuallyRunningTask;
    private ConversationHistory history;
    private LLMCompleter completer;

    public BuildStructureTask(String description, PlayerEngineController mod) {
        this.description = description;
        this.mod = mod;
        this.service = mod.getPlayer2APIService();
        this.numErrors = 0;
        this.history = new ConversationHistory(Prompts.getBuildStructurePrompt());
        this.history.addUserMessage(String.format("Build with the following description: (%s)", description), this.service);
        this.completer = new LLMCompleter();
    }

    @Override
    protected void onStart() {
        this.actuallyRunningTask = new RequestLLMCode();
    }

    @Override
    protected Task onTick() {
        if (this.numErrors > 2) {
            LOGGER.info("Too many errors, finishing.");
            this.isDone = true;
            return null;
        }
        if (this.actuallyRunningTask == null || !this.actuallyRunningTask.isFinished()) {
            return this.actuallyRunningTask;
        }
        if (this.actuallyRunningTask instanceof RequestLLMCode) {
            LOGGER.info("Requesting llm code for description={}", (Object)this.description);
            Either<String, String> result = ((RequestLLMCode)this.actuallyRunningTask).llmResult.get();
            result.mapBoth(code -> {
                LOGGER.info("LLM returned code={}", code);
                this.actuallyRunningTask = new BuildFromCode((String)code);
                return null;
            }, errStr -> {
                ++this.numErrors;
                String tryAgainMessage = String.format("When trying to call the llm with the description, got this error: \n(%s)\n. Try again and generate code using the same description:\n(%s)", errStr, this.description);
                this.history.addUserMessage(tryAgainMessage, this.service);
                LOGGER.info(tryAgainMessage);
                this.actuallyRunningTask = new RequestLLMCode();
                return null;
            });
            return this.actuallyRunningTask;
        }
        if (this.actuallyRunningTask instanceof BuildFromCode) {
            Optional<String> result = ((BuildFromCode)this.actuallyRunningTask).result.get();
            result.ifPresentOrElse(errStr -> {
                String code = ((BuildFromCode)this.actuallyRunningTask).code;
                this.history.addAssistantMessage(code, this.service);
                String tryAgainMessage = String.format("The code was executed, but got error \n(%s)\nTry again and generate code with the same description:\n(%s). | REMEMBER: do NOT use any math functions such as Math.sin, Math.abs, etc. Do NOT make functions, as these will not be parsed.", errStr, this.description);
                LOGGER.info(tryAgainMessage);
                this.history.addUserMessage(tryAgainMessage, this.service);
                this.actuallyRunningTask = new RequestLLMCode();
            }, () -> {
                this.isDone = true;
                this.actuallyRunningTask = null;
            });
            return this.actuallyRunningTask;
        }
        LOGGER.error("actually running task in buildStructureTask set to incorrect type");
        return null;
    }

    @Override
    public boolean isFinished() {
        return this.isDone;
    }

    @Override
    protected boolean isEqual(Task other) {
        if (!(other instanceof BuildStructureTask)) {
            return false;
        }
        BuildStructureTask o = (BuildStructureTask)other;
        return o.description == this.description;
    }

    @Override
    protected void onStop(Task next) {
    }

    @Override
    protected String toDebugString() {
        return "BuildingStructure(" + this.description + ")";
    }

    private class RequestLLMCode
    extends Task {
        Optional<Either<String, String>> llmResult = Optional.empty();

        private RequestLLMCode() {
        }

        @Override
        protected boolean isEqual(Task var1) {
            return var1 instanceof RequestLLMCode && ((RequestLLMCode)var1).llmResult == this.llmResult;
        }

        @Override
        protected void onStart() {
            BuildStructureTask.this.completer.processToString(BuildStructureTask.this.service, BuildStructureTask.this.history, codeResult -> {
                LOGGER.info("LLM generated code={}", codeResult);
                this.llmResult = Optional.of(Either.left((Object)codeResult));
            }, errStr -> {
                LOGGER.info("LLM Transport Error={}", errStr);
                this.llmResult = Optional.of(Either.right((Object)errStr));
            }, false);
        }

        @Override
        protected void onStop(Task var1) {
        }

        @Override
        protected Task onTick() {
            return null;
        }

        @Override
        protected String toDebugString() {
            return String.format("Thinking about how to build structure with description (%s)", BuildStructureTask.this.description);
        }

        @Override
        public boolean isFinished() {
            return this.llmResult.isPresent();
        }
    }

    private class BuildFromCode
    extends Task {
        String code;
        private ExecutorService buildThread;
        Optional<Optional<String>> result = Optional.empty();

        public BuildFromCode(String code) {
            this.code = code;
            this.buildThread = Executors.newSingleThreadExecutor();
            this.buildThread.submit(() -> StructureFromCode.buildStructureFromCode(code, setBlockData -> {
                LOGGER.info("setBlock(x={}, y={}, z={}, blockName={})", (Object)setBlockData.x, (Object)setBlockData.y, (Object)setBlockData.z, (Object)setBlockData.blockName);
                ResourceLocation id = new ResourceLocation("minecraft", setBlockData.blockName);
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
                BuildStructureTask.this.mod.getWorld().m_7731_(new BlockPos(setBlockData.x, setBlockData.y, setBlockData.z), block.m_49966_(), 3);
            }, errStr -> {
                this.result = Optional.of(Optional.of(errStr));
            }, () -> {
                this.result = Optional.of(Optional.empty());
            }, BuildStructureTask.this.mod));
        }

        @Override
        protected boolean isEqual(Task var1) {
            return false;
        }

        @Override
        protected void onStart() {
        }

        @Override
        protected void onStop(Task var1) {
            this.buildThread.shutdownNow();
        }

        @Override
        protected Task onTick() {
            return null;
        }

        @Override
        public boolean isFinished() {
            return this.result.isPresent();
        }

        @Override
        protected String toDebugString() {
            return String.format("Currently building the structure from description (%s)", BuildStructureTask.this.description);
        }
    }
}

