/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.entity;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.AbstractDoToEntityTask;
import com.player2.playerengine.util.Debug;
import java.util.Optional;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.Items;

public class ShearSheepTask
extends AbstractDoToEntityTask {
    public ShearSheepTask() {
        super(0.0, -1.0, -1.0);
    }

    @Override
    protected boolean isSubEqual(AbstractDoToEntityTask other) {
        return other instanceof ShearSheepTask;
    }

    @Override
    protected Task onEntityInteract(PlayerEngineController mod, Entity entity) {
        if (!mod.getItemStorage().hasItem(Items.f_42574_)) {
            Debug.logWarning("Failed to shear sheep because you have no shears.");
            return null;
        }
        if (mod.getSlotHandler().forceEquipItem(Items.f_42574_)) {
            ((Sheep)entity).m_5851_(SoundSource.PLAYERS);
            mod.getPlayer().m_21205_().m_41622_(1, mod.getPlayer(), e -> {});
        }
        return null;
    }

    @Override
    protected Optional<Entity> getEntityTarget(PlayerEngineController mod) {
        return mod.getEntityTracker().getClosestEntity(mod.getPlayer().m_20182_(), entity -> {
            boolean bl;
            if (!(entity instanceof Sheep)) {
                bl = false;
            } else {
                Sheep sheep = (Sheep)entity;
                bl = sheep.m_6220_() && !sheep.m_29875_();
            }
            return bl;
        }, Sheep.class);
    }

    @Override
    protected String toDebugString() {
        return "Shearing Sheep";
    }
}

