/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.misc;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.LootContainerTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;

public class RavageRuinedPortalsTask
extends Task {
    public final Item[] LOOT = new Item[]{Items.f_42749_, Items.f_42484_, Items.f_41999_, Items.f_42613_, Items.f_42409_, Items.f_42587_, Items.f_42436_, Items.f_42433_, Items.f_42434_, Items.f_42432_, Items.f_42431_, Items.f_42430_, Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_, Items.f_42546_, Items.f_42677_, Items.f_42417_, Items.f_42524_, Items.f_42150_, Items.f_42652_, Items.f_41912_, Items.f_42777_, Items.f_42437_};
    private List<BlockPos> notRuinedPortalChests = new ArrayList<BlockPos>();
    private Task lootTask;

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
    }

    @Override
    protected Task onTick() {
        if (this.lootTask != null && this.lootTask.isActive() && !this.lootTask.isFinished()) {
            return this.lootTask;
        }
        Optional<BlockPos> closest = this.locateClosestUnopenedRuinedPortalChest(this.controller);
        if (closest.isPresent()) {
            this.lootTask = new LootContainerTask(closest.get(), List.of(this.LOOT));
            return this.lootTask;
        }
        return new TimeoutWanderTask();
    }

    @Override
    protected void onStop(Task task) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task task) {
        return task instanceof RavageRuinedPortalsTask;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Ravaging Ruined Portals";
    }

    private boolean canBeLootablePortalChest(PlayerEngineController mod, BlockPos blockPos) {
        if (mod.getWorld().m_8055_(blockPos.m_6630_(1)).m_60734_() != Blocks.f_49990_ && blockPos.m_123342_() >= 50) {
            for (BlockPos check : WorldHelper.scanRegion(blockPos.m_7918_(-4, -2, -4), blockPos.m_7918_(4, 2, 4))) {
                if (mod.getWorld().m_8055_(check).m_60734_() != Blocks.f_50134_) continue;
                return true;
            }
            this.notRuinedPortalChests.add(blockPos);
            return false;
        }
        return false;
    }

    private Optional<BlockPos> locateClosestUnopenedRuinedPortalChest(PlayerEngineController mod) {
        return WorldHelper.getCurrentDimension(this.controller) != Dimension.OVERWORLD ? Optional.empty() : mod.getBlockScanner().getNearestBlock(blockPos -> !this.notRuinedPortalChests.contains(blockPos) && WorldHelper.isUnopenedChest(this.controller, blockPos) && this.canBeLootablePortalChest(mod, (BlockPos)blockPos), Blocks.f_50087_);
    }
}

