/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.GetToEntityTask;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class FollowPlayerTask
extends Task {
    private final String playerName;
    private final double followDistance;

    public FollowPlayerTask(String playerName, double followDistance) {
        this.playerName = playerName;
        this.followDistance = followDistance;
    }

    public FollowPlayerTask(String playerName) {
        this(playerName, 2.0);
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        Optional<Vec3> lastPos = mod.getEntityTracker().getPlayerMostRecentPosition(this.playerName);
        if (lastPos.isEmpty()) {
            this.setDebugState("No player found/detected. Doing nothing until player loads into render distance.");
            return null;
        }
        Vec3 target = lastPos.get();
        if (target.m_82509_((Position)mod.getPlayer().m_20182_(), 1.0) && !mod.getEntityTracker().isPlayerLoaded(this.playerName)) {
            mod.logWarning("Failed to get to player \"" + this.playerName + "\". We moved to where we last saw them but now have no idea where they are.");
            this.stop();
            return null;
        }
        Optional<Player> player = mod.getEntityTracker().getPlayerEntity(this.playerName);
        return player.isEmpty() ? new GetToBlockTask(new BlockPos((int)target.f_82479_, (int)target.f_82480_, (int)target.f_82481_), false) : new GetToEntityTask((Entity)player.get(), this.followDistance);
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof FollowPlayerTask)) {
            bl = false;
        } else {
            FollowPlayerTask task = (FollowPlayerTask)other;
            bl = task.playerName.equals(this.playerName) && Math.abs(this.followDistance - task.followDistance) < 0.1;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Going to player " + this.playerName;
    }
}

