/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalYLevel;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;

public class GetToYTask
extends CustomBaritoneGoalTask {
    private final int yLevel;
    private final Dimension dimension;

    public GetToYTask(int ylevel, Dimension dimension) {
        this.yLevel = ylevel;
        this.dimension = dimension;
    }

    public GetToYTask(int ylevel) {
        this(ylevel, null);
    }

    @Override
    protected Task onTick() {
        return this.dimension != null && WorldHelper.getCurrentDimension(this.controller) != this.dimension ? new DefaultGoToDimensionTask(this.dimension) : super.onTick();
    }

    @Override
    protected Goal newGoal(PlayerEngineController mod) {
        return new GoalYLevel(this.yLevel);
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof GetToYTask) {
            GetToYTask task = (GetToYTask)other;
            bl = task.yLevel == this.yLevel;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Going to y=" + this.yLevel + (String)(this.dimension != null ? "in dimension" + String.valueOf((Object)this.dimension) : "");
    }
}

