/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.movement.GetCloseToBlockTask;
import com.player2.playerengine.tasks.movement.SearchChunkForBlockTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CollectHoneycombTask
extends ResourceTask {
    private final boolean campfire;
    private final int count;
    private BlockPos nest;

    public CollectHoneycombTask(int targetCount) {
        super(Items.f_42784_, targetCount);
        this.campfire = true;
        this.count = targetCount;
    }

    public CollectHoneycombTask(int targetCount, boolean useCampfire) {
        super(Items.f_42784_, targetCount);
        this.campfire = useCampfire;
        this.count = targetCount;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        Optional<BlockPos> getNearestNest;
        if (this.nest == null && (getNearestNest = mod.getBlockScanner().getNearestBlock(Blocks.f_50717_)).isPresent()) {
            this.nest = getNearestNest.get();
        }
        if (this.nest == null) {
            if (this.campfire && !mod.getItemStorage().hasItemInventoryOnly(Items.f_42781_)) {
                this.setDebugState("Can't find nest, getting campfire first...");
                return new CataloguedResourceTask(new ItemTarget(Items.f_42781_, 1));
            }
            this.setDebugState("Alright, we're searching");
            return new SearchChunkForBlockTask(Blocks.f_50717_);
        }
        if (this.campfire && !this.isCampfireUnderNest(mod, this.nest)) {
            if (!mod.getItemStorage().hasItemInventoryOnly(Items.f_42781_)) {
                this.setDebugState("Getting a campfire");
                return new CataloguedResourceTask(new ItemTarget(Items.f_42781_, 1));
            }
            this.setDebugState("Placing campfire");
            return new PlaceBlockTask(this.nest.m_6625_(2), Blocks.f_50683_);
        }
        if (!mod.getItemStorage().hasItemInventoryOnly(Items.f_42574_)) {
            this.setDebugState("Getting shears");
            return new CataloguedResourceTask(new ItemTarget(Items.f_42574_, 1));
        }
        if ((Integer)mod.getWorld().m_8055_(this.nest).m_61143_((Property)BlockStateProperties.f_61421_) != 5) {
            if (!this.nest.m_203195_((Position)mod.getPlayer().m_20182_(), 20.0)) {
                this.setDebugState("Getting close to nest");
                return new GetCloseToBlockTask(this.nest);
            }
            this.setDebugState("Waiting for nest to get honey...");
            return null;
        }
        return new InteractWithBlockTask(Items.f_42574_, this.nest);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectHoneycombTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " Honeycombs " + (this.campfire ? "Peacefully" : "Recklessly");
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    private boolean isCampfireUnderNest(PlayerEngineController mod, BlockPos pos) {
        for (BlockPos underPos : WorldHelper.scanRegion(pos.m_6625_(6), pos.m_7495_())) {
            if (mod.getWorld().m_8055_(underPos).m_60734_() != Blocks.f_50683_) continue;
            return true;
        }
        return false;
    }
}

