/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.AbstractDoToEntityTask;
import com.player2.playerengine.util.Debug;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CollectMilkTask
extends ResourceTask {
    private final int count;

    public CollectMilkTask(int targetCount) {
        super(Items.f_42455_, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (!mod.getItemStorage().hasItem(Items.f_42446_)) {
            return TaskCatalogue.getItemTask(Items.f_42446_, 1);
        }
        return !mod.getEntityTracker().entityFound(Cow.class) && this.isInWrongDimension(mod) ? this.getToCorrectDimensionTask(mod) : new MilkCowTask();
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectMilkTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " milk buckets.";
    }

    static class MilkCowTask
    extends AbstractDoToEntityTask {
        public MilkCowTask() {
            super(0.0, -1.0, -1.0);
        }

        @Override
        protected boolean isSubEqual(AbstractDoToEntityTask other) {
            return other instanceof MilkCowTask;
        }

        @Override
        protected Task onEntityInteract(PlayerEngineController mod, Entity entity) {
            if (!mod.getItemStorage().hasItem(Items.f_42446_)) {
                Debug.logWarning("Failed to milk cow because you have no bucket.");
                return null;
            }
            if (mod.getSlotHandler().forceEquipItem(Items.f_42446_)) {
                mod.getInventory().m_6836_(mod.getInventory().selectedSlot, new ItemStack((ItemLike)Items.f_42455_));
            }
            return null;
        }

        @Override
        protected Optional<Entity> getEntityTarget(PlayerEngineController mod) {
            return mod.getEntityTracker().getClosestEntity(mod.getPlayer().m_20182_(), Cow.class);
        }

        @Override
        protected String toDebugString() {
            return "Milking Cow";
        }
    }
}

