/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.GetToXZTask;
import com.player2.playerengine.tasks.speedrun.WaitForDragonAndPearlTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonLandingApproachPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonLandingPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class KillEnderDragonWithBedsTask
extends Task {
    private final WaitForDragonAndPearlTask whenNotPerchingTask;
    TimerGame placeBedTimer = new TimerGame(0.6);
    TimerGame waiTimer = new TimerGame(0.3);
    TimerGame waitBeforePlaceTimer = new TimerGame(0.5);
    boolean waited = false;
    double prevDist = 100.0;
    private BlockPos endPortalTop;
    private Task freePortalTopTask = null;
    private Task placeObsidianTask = null;
    private boolean dragonDead = false;

    public KillEnderDragonWithBedsTask() {
        this.whenNotPerchingTask = new WaitForDragonAndPearlTask();
    }

    public static BlockPos locateExitPortalTop(PlayerEngineController mod) {
        if (!mod.getChunkTracker().isChunkLoaded(new BlockPos(0, 64, 0))) {
            return null;
        }
        int height = WorldHelper.getGroundHeight(mod, 0, 0, Blocks.f_50752_);
        return height != -1 ? new BlockPos(0, height, 0) : null;
    }

    @Override
    protected void onStart() {
        this.controller.getBehaviour().avoidBlockPlacing(pos -> pos.m_123343_() == 0 && Math.abs(pos.m_123341_()) < 5);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (this.endPortalTop == null) {
            this.endPortalTop = KillEnderDragonWithBedsTask.locateExitPortalTop(mod);
            if (this.endPortalTop != null) {
                this.whenNotPerchingTask.setExitPortalTop(this.endPortalTop);
            }
        }
        if (this.endPortalTop == null) {
            this.setDebugState("Searching for end portal top.");
            return new GetToXZTask(0, 0);
        }
        BlockPos obsidianTarget = this.endPortalTop.m_7494_().m_121945_(Direction.NORTH);
        if (!mod.getWorld().m_8055_(obsidianTarget).m_60734_().equals(Blocks.f_50080_)) {
            if (WorldHelper.inRangeXZ(mod.getPlayer().m_20182_(), new Vec3(0.0, 0.0, 0.0), 10.0)) {
                if (this.placeObsidianTask == null) {
                    this.placeObsidianTask = new PlaceBlockTask(obsidianTarget, Blocks.f_50080_);
                }
                return this.placeObsidianTask;
            }
            return new GetToXZTask(0, 0);
        }
        BlockState stateAtPortal = mod.getWorld().m_8055_(this.endPortalTop.m_7494_());
        if (!(stateAtPortal.m_60795_() || stateAtPortal.m_60734_().equals(Blocks.f_50083_) || Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.BED)).toList().contains(stateAtPortal.m_60734_()))) {
            if (this.freePortalTopTask == null) {
                this.freePortalTopTask = new DestroyBlockTask(this.endPortalTop.m_7494_());
            }
            return this.freePortalTopTask;
        }
        if (this.dragonDead) {
            this.setDebugState("Waiting for overworld portal to spawn.");
            return new GetToBlockTask(this.endPortalTop.m_6625_(4).m_122024_());
        }
        if (!mod.getEntityTracker().entityFound(EnderDragon.class) || this.dragonDead) {
            this.setDebugState("No dragon found.");
            if (!WorldHelper.inRangeXZ((Entity)mod.getPlayer(), this.endPortalTop, 1.0)) {
                this.setDebugState("Going to end portal top at" + this.endPortalTop.toString() + ".");
                return new GetToBlockTask(this.endPortalTop);
            }
        }
        for (EnderDragon dragon : mod.getEntityTracker().getTrackedEntities(EnderDragon.class)) {
            boolean perching;
            DragonPhaseInstance dragonPhase = dragon.m_31157_().m_31415_();
            if (dragonPhase.m_7309_() == EnderDragonPhase.f_31386_) {
                Debug.logMessage("Dragon is dead.");
                if (mod.getPlayer().m_146909_() != -90.0f) {
                    mod.getPlayer().m_146926_(-90.0f);
                }
                this.dragonDead = true;
                return null;
            }
            boolean bl = perching = dragonPhase instanceof DragonLandingPhase || dragonPhase instanceof DragonLandingApproachPhase || dragonPhase.m_7080_();
            if (dragon.m_20186_() < (double)(this.endPortalTop.m_123342_() + 2)) {
                perching = false;
            }
            this.whenNotPerchingTask.setPerchState(perching);
            if (this.whenNotPerchingTask.isActive() && !this.whenNotPerchingTask.isFinished()) {
                this.setDebugState("Dragon not perching, performing special behavior...");
                return this.whenNotPerchingTask;
            }
            if (!perching) continue;
            return this.performOneCycle(mod, dragon);
        }
        mod.getFoodChain().shouldStop(false);
        return this.whenNotPerchingTask;
    }

    private Task performOneCycle(PlayerEngineController mod, EnderDragon dragon) {
        mod.getFoodChain().shouldStop(true);
        if (mod.getInputControls().isHeldDown(Input.SNEAK)) {
            mod.getInputControls().release(Input.SNEAK);
        }
        mod.getSlotHandler().forceEquipItemToOffhand(Items.f_41852_);
        BlockPos endPortalTop = KillEnderDragonWithBedsTask.locateExitPortalTop(mod).m_7494_();
        BlockPos obsidian = null;
        Direction dir = null;
        for (Direction direction : new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}) {
            if (!mod.getWorld().m_8055_(endPortalTop.m_121945_(direction)).m_60734_().equals(Blocks.f_50080_)) continue;
            obsidian = endPortalTop.m_121945_(direction);
            dir = direction.m_122424_();
            break;
        }
        if (dir == null) {
            mod.log("no obisidan? :(");
            return null;
        }
        Direction offsetDir = dir.m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.WEST;
        BlockPos targetBlock = endPortalTop.m_6625_(3).m_5484_(offsetDir, 3).m_121945_(dir);
        double d = this.distanceIgnoreY(WorldHelper.toVec3d(targetBlock), mod.getPlayer().m_20182_());
        if (!(d > 0.7) && mod.getPlayer().m_20183_().m_7495_().m_123342_() <= endPortalTop.m_123342_() - 4) {
            if (!this.waited) {
                this.waited = true;
                this.waitBeforePlaceTimer.reset();
            }
            if (!this.waitBeforePlaceTimer.elapsed()) {
                mod.log(this.waitBeforePlaceTimer.getDuration() + " waiting...");
                return null;
            }
            LookHelper.lookAt(mod, obsidian, dir);
            BlockPos bedHead = WorldHelper.getBedHead(mod, endPortalTop);
            mod.getSlotHandler().forceEquipItem(ItemHelper.BED);
            if (bedHead == null) {
                if (this.placeBedTimer.elapsed() && Math.abs(dragon.m_20186_() - (double)endPortalTop.m_123342_()) < 10.0) {
                    mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                    this.waiTimer.reset();
                }
                return null;
            }
            if (!this.waiTimer.elapsed()) {
                return null;
            }
            Vec3 dragonHeadPos = dragon.f_31080_.m_20191_().m_82399_();
            Vec3 bedHeadPos = WorldHelper.toVec3d(bedHead);
            double dist = dragonHeadPos.m_82554_(bedHeadPos);
            double distXZ = this.distanceIgnoreY(dragonHeadPos, bedHeadPos);
            EnderDragonPart body = dragon.m_31156_()[2];
            double destroyDistance = Math.abs(body.m_20191_().m_82340_(Direction.Axis.Y) - bedHeadPos.m_7098_());
            boolean tooClose = destroyDistance < 1.1;
            boolean skip = destroyDistance > 3.0 && dist > 4.5 && distXZ > 2.5;
            mod.log(destroyDistance + " : " + destroyDistance + " : " + dist);
            if ((dist < 1.5 || this.prevDist < distXZ && destroyDistance < 4.0 && this.prevDist < 2.9 || destroyDistance < 2.0 && dist < 4.0 || destroyDistance < 1.7 && dist < 4.5 || tooClose || destroyDistance < 2.4 && distXZ < 3.7 || destroyDistance < 3.5 && distXZ < 2.4) && !skip) {
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                this.placeBedTimer.reset();
            }
            this.prevDist = distXZ;
            return null;
        }
        mod.log("" + d);
        return new GetToBlockTask(targetBlock);
    }

    public double distanceIgnoreY(Vec3 vec, Vec3 vec1) {
        double d = vec.f_82479_ - vec1.f_82479_;
        double f = vec.f_82481_ - vec1.f_82481_;
        return Math.sqrt(d * d + f * f);
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getFoodChain().shouldStop(false);
    }

    @Override
    public boolean isFinished() {
        return super.isFinished();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof KillEnderDragonWithBedsTask;
    }

    @Override
    protected String toDebugString() {
        return "Bedding the Ender Dragon";
    }
}

