/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.speedrun.KillEnderDragonWithBedsTask;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class OneCycleTask
extends Task {
    TimerGame placeBedTimer = new TimerGame(0.6);
    TimerGame waiTimer = new TimerGame(0.3);
    double prevDist = 100.0;

    @Override
    protected Task onTick() {
        List<EnderDragon> dragons;
        PlayerEngineController mod = this.controller;
        mod.getFoodChain().shouldStop(true);
        mod.getSlotHandler().forceEquipItemToOffhand(Items.f_41852_);
        if (mod.getInputControls().isHeldDown(Input.SNEAK)) {
            mod.getInputControls().release(Input.SNEAK);
        }
        if ((dragons = mod.getEntityTracker().getTrackedEntities(EnderDragon.class)).size() != 1) {
            mod.log("No dragon? :(");
        }
        for (EnderDragon dragon : dragons) {
            BlockPos endPortalTop = KillEnderDragonWithBedsTask.locateExitPortalTop(mod).m_7494_();
            BlockPos obsidian = null;
            Direction dir = null;
            for (Direction direction : new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}) {
                if (!mod.getWorld().m_8055_(endPortalTop.m_121945_(direction)).m_60734_().equals(Blocks.f_50080_)) continue;
                obsidian = endPortalTop.m_121945_(direction);
                dir = direction.m_122424_();
                break;
            }
            if (dir == null) {
                mod.log("no obisidan? :(");
                return null;
            }
            Direction offsetDir = dir.m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.WEST;
            BlockPos targetBlock = endPortalTop.m_6625_(3).m_5484_(offsetDir, 3).m_121945_(dir);
            double d = this.distanceIgnoreY(WorldHelper.toVec3d(targetBlock), mod.getPlayer().m_20182_());
            if (d > 0.7) {
                mod.log("" + d);
                return new GetToBlockTask(targetBlock);
            }
            LookHelper.lookAt(mod, obsidian, dir);
            BlockPos bedHead = WorldHelper.getBedHead(mod, endPortalTop);
            BlockPos bedTargetPosition = endPortalTop.m_7494_();
            mod.getSlotHandler().forceEquipItem(ItemHelper.BED);
            if (bedHead == null) {
                if (!this.placeBedTimer.elapsed() || !(Math.abs(dragon.m_20186_() - (double)endPortalTop.m_123342_()) < 10.0)) continue;
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                this.waiTimer.reset();
                continue;
            }
            if (!this.waiTimer.elapsed()) {
                return null;
            }
            Vec3 dragonHeadPos = dragon.f_31080_.m_20191_().m_82399_();
            Vec3 bedHeadPos = WorldHelper.toVec3d(bedHead);
            double dist = dragonHeadPos.m_82554_(bedHeadPos);
            double distXZ = this.distanceIgnoreY(dragonHeadPos, bedHeadPos);
            EnderDragonPart body = dragon.m_31156_()[2];
            double destroyDistance = Math.abs(body.m_20191_().m_82340_(Direction.Axis.Y) - bedHeadPos.m_7098_());
            boolean tooClose = destroyDistance < 1.1;
            boolean skip = destroyDistance > 3.0 && dist > 4.5 && distXZ > 2.5;
            mod.log(destroyDistance + " : " + destroyDistance + " : " + dist);
            if ((dist < 1.5 || this.prevDist < distXZ && destroyDistance < 4.0 && this.prevDist < 2.9 || destroyDistance < 2.0 && dist < 4.0 || destroyDistance < 1.7 && dist < 4.5 || tooClose || destroyDistance < 2.4 && distXZ < 3.7 || destroyDistance < 3.5 && distXZ < 2.4) && !skip) {
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                this.placeBedTimer.reset();
            }
            this.prevDist = distXZ;
            double d2 = dragonHeadPos.m_7098_() - (double)bedHead.m_123342_();
        }
        return null;
    }

    public double distanceIgnoreY(Vec3 vec, Vec3 vec1) {
        double d = vec.f_82479_ - vec1.f_82479_;
        double f = vec.f_82481_ - vec1.f_82481_;
        return Math.sqrt(d * d + f * f);
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return this.controller.getEntityTracker().getTrackedEntities(EnderDragon.class).isEmpty();
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected boolean isEqual(Task other) {
        return false;
    }

    @Override
    protected String toDebugString() {
        return "One cycling bby";
    }
}

