/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun.beatgame;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.commands.BlockScanner;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.GetRidOfExtraWaterBucketTask;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.SafeNetherPortalTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.tasks.construction.PlaceObsidianBucketTask;
import com.player2.playerengine.tasks.container.CraftInTableTask;
import com.player2.playerengine.tasks.container.LootContainerTask;
import com.player2.playerengine.tasks.container.SmeltInFurnaceTask;
import com.player2.playerengine.tasks.container.SmeltInSmokerTask;
import com.player2.playerengine.tasks.misc.EquipArmorTask;
import com.player2.playerengine.tasks.misc.PlaceBedAndSetSpawnTask;
import com.player2.playerengine.tasks.misc.SleepThroughNightTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.GetToXZTask;
import com.player2.playerengine.tasks.movement.GetWithinRangeOfBlockTask;
import com.player2.playerengine.tasks.movement.GoToStrongholdPortalTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.movement.SearchChunkForBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.CollectBlazeRodsTask;
import com.player2.playerengine.tasks.resources.CollectBucketLiquidTask;
import com.player2.playerengine.tasks.resources.CollectFoodTask;
import com.player2.playerengine.tasks.resources.CollectMeatTask;
import com.player2.playerengine.tasks.resources.GetBuildingMaterialsTask;
import com.player2.playerengine.tasks.resources.KillEndermanTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.tasks.resources.TradeWithPiglinsTask;
import com.player2.playerengine.tasks.speedrun.BeatMinecraftConfig;
import com.player2.playerengine.tasks.speedrun.DragonBreathTracker;
import com.player2.playerengine.tasks.speedrun.KillEnderDragonTask;
import com.player2.playerengine.tasks.speedrun.KillEnderDragonWithBedsTask;
import com.player2.playerengine.tasks.speedrun.beatgame.UselessItems;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.CollectFoodPriorityCalculator;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.DistanceItemPriorityCalculator;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.ItemPriorityCalculator;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.StaticItemPriorityCalculator;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.ActionPriorityTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.CraftItemPriorityTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.MineBlockPriorityTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.PriorityTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.RecraftableItemPriorityTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.ResourcePriorityTask;
import com.player2.playerengine.trackers.EntityTracker;
import com.player2.playerengine.trackers.storage.ItemStorageTracker;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.Pair;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.helpers.ConfigHelper;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.slots.Slot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;

public class BeatMinecraftTask
extends Task {
    private static final Item[] COLLECT_EYE_ARMOR = new Item[]{Items.f_42473_, Items.f_42474_, Items.f_42475_};
    private static final Item[] COLLECT_IRON_ARMOR = ItemHelper.IRON_ARMORS;
    private static final Item[] COLLECT_EYE_ARMOR_END = ItemHelper.DIAMOND_ARMORS;
    private static final ItemTarget[] COLLECT_EYE_GEAR_MIN = BeatMinecraftTask.combine(ItemTarget.of(Items.f_42388_), ItemTarget.of(Items.f_42390_));
    private static final int END_PORTAL_FRAME_COUNT = 12;
    private static final double END_PORTAL_BED_SPAWN_RANGE = 8.0;
    private static final Predicate<ItemStack> noCurseOfBinding = stack -> !EnchantmentHelper.m_44920_((ItemStack)stack);
    private static BeatMinecraftConfig config;
    private static GoToStrongholdPortalTask locateStrongholdTask;
    private static boolean openingEndPortal;
    private final UselessItems uselessItems;
    private final HashMap<Item, Integer> cachedEndItemDrops = new HashMap();
    private final TimerGame cachedEndItemNothingWaitTime = new TimerGame(10.0);
    private final Task buildMaterialsTask;
    private final PlaceBedAndSetSpawnTask setBedSpawnTask = new PlaceBedAndSetSpawnTask();
    private final Task getOneBedTask = TaskCatalogue.getItemTask("bed", 1);
    private final Task sleepThroughNightTask = new SleepThroughNightTask();
    private final Task killDragonBedStratsTask = new KillEnderDragonWithBedsTask();
    private final DragonBreathTracker dragonBreathTracker = new DragonBreathTracker();
    private final TimerGame timer1 = new TimerGame(5.0);
    private final TimerGame timer2 = new TimerGame(35.0);
    private final TimerGame timer3 = new TimerGame(60.0);
    private final List<PriorityTask> gatherResources = new LinkedList<PriorityTask>();
    private final TimerGame changedTaskTimer = new TimerGame(3.0);
    private final TimerGame forcedTaskTimer = new TimerGame(10.0);
    private final List<BlockPos> blacklistedChests = new LinkedList<BlockPos>();
    private final TimerGame waterPlacedTimer = new TimerGame(1.5);
    private final TimerGame fortressTimer = new TimerGame(20.0);
    private final PlayerEngineController mod;
    private PriorityTask lastGather = null;
    private Task lastTask = null;
    private boolean pickupFurnace = false;
    private boolean pickupSmoker = false;
    private boolean pickupCrafting = false;
    private Task rePickupTask = null;
    private Task searchTask = null;
    private boolean hasRods = false;
    private boolean gotToBiome = false;
    private GetRidOfExtraWaterBucketTask getRidOfExtraWaterBucketTask = null;
    private int repeated = 0;
    private boolean gettingPearls = false;
    private SafeNetherPortalTask safeNetherPortalTask;
    private boolean escaped = false;
    private boolean gotToFortress = false;
    private GetWithinRangeOfBlockTask cachedFortressTask = null;
    private boolean resetFortressTask = false;
    private BlockPos prevPos = null;
    private Task goToNetherTask = new DefaultGoToDimensionTask(Dimension.NETHER);
    private boolean dragonIsDead = false;
    private BlockPos endPortalCenterLocation;
    private boolean ranStrongholdLocator;
    private boolean endPortalOpened;
    private BlockPos bedSpawnLocation;
    private int cachedFilledPortalFrames = 0;
    private boolean enterindEndPortal = false;
    private Task lootTask;
    private boolean collectingEyes;
    private boolean escapingDragonsBreath = false;
    private Task getBedTask;
    private List<TaskChange> taskChanges = new ArrayList<TaskChange>();
    private PriorityTask prevLastGather = null;
    private BlockPos biomePos = null;

    public BeatMinecraftTask(PlayerEngineController mod) {
        this.mod = mod;
        locateStrongholdTask = new GoToStrongholdPortalTask(BeatMinecraftTask.config.targetEyes);
        this.buildMaterialsTask = new GetBuildingMaterialsTask(BeatMinecraftTask.config.buildMaterialCount);
        this.uselessItems = new UselessItems(config);
        if (mod.getWorld().m_46791_() != Difficulty.EASY) {
            mod.logWarning("Detected that the difficulty is other than easy!");
            if (mod.getWorld().m_46791_() == Difficulty.PEACEFUL) {
                mod.logWarning("No mobs spawn on peaceful difficulty, so the bot will not be able to beat the game. Please change it!");
            } else {
                mod.logWarning("This could cause the bot to die sooner, please consider changing it...");
            }
        }
        ItemStorageTracker itemStorage = mod.getItemStorage();
        this.gatherResources.add(new MineBlockPriorityTask(ItemHelper.itemsToBlocks(ItemHelper.LOG), ItemHelper.LOG, MiningRequirement.STONE, new DistanceItemPriorityCalculator(1050.0, 450.0, 5.0, 4, 10), a -> itemStorage.hasItem(Items.f_42428_, Items.f_42386_, Items.f_42433_, Items.f_42391_) && itemStorage.getItemCount(ItemHelper.LOG) < 5));
        this.addOreMiningTasks();
        this.addCollectFoodTask(mod);
        this.addStoneToolsTasks();
        this.addPickaxeTasks(mod);
        this.addDiamondArmorTasks(mod);
        this.addLootChestsTasks(mod);
        this.addPickupImportantItemsTask(mod);
        this.gatherResources.add(new MineBlockPriorityTask(new Block[]{Blocks.f_49994_}, new Item[]{Items.f_42484_}, MiningRequirement.STONE, new DistanceItemPriorityCalculator(17500.0, 7500.0, 5.0, 1, 1), a -> itemStorage.hasItem(Items.f_42426_) && !itemStorage.hasItem(Items.f_42409_)));
        this.gatherResources.add(new MineBlockPriorityTask(ItemHelper.itemsToBlocks(ItemHelper.BED), ItemHelper.BED, MiningRequirement.HAND, new DistanceItemPriorityCalculator(25000.0, 25000.0, 5.0, this.getTargetBeds(mod), this.getTargetBeds(mod))));
        this.gatherResources.add(new CraftItemPriorityTask(200.0, this.getRecipeTarget(Items.f_42740_), a -> itemStorage.hasItem(Items.f_42416_)));
        this.gatherResources.add(new CraftItemPriorityTask(300.0, mod.getCraftingRecipeTracker().getFirstRecipeTarget(Items.f_42446_, 2), a -> itemStorage.getItemCount(Items.f_42416_) >= 6));
        this.gatherResources.add(new CraftItemPriorityTask(100.0, this.getRecipeTarget(Items.f_42409_), a -> itemStorage.hasItem(Items.f_42416_) && itemStorage.hasItem(Items.f_42484_)));
        this.gatherResources.add(new CraftItemPriorityTask(330.0, this.getRecipeTarget(Items.f_42388_), a -> itemStorage.getItemCount(Items.f_42415_) >= 2 && StorageHelper.miningRequirementMet(mod, MiningRequirement.DIAMOND)));
        this.gatherResources.add(new CraftItemPriorityTask(400.0, this.getRecipeTarget(Items.f_42476_), a -> itemStorage.getItemCount(Items.f_42417_) >= 5));
        this.addSleepTask(mod);
        this.gatherResources.add(new ActionPriorityTask(a -> {
            Pair<ResourceTask, Double> pair = new Pair<ResourceTask, Double>(TaskCatalogue.getItemTask(Items.f_42447_, 1), Double.NEGATIVE_INFINITY);
            if (!itemStorage.hasItem(Items.f_42447_) && !BeatMinecraftTask.hasItem(mod, Items.f_42447_)) {
                Optional<BlockPos> optionalPos = mod.getBlockScanner().getNearestBlock(Blocks.f_49990_);
                if (optionalPos.isEmpty()) {
                    return pair;
                }
                double distance = Math.sqrt(BlockPosVer.getSquaredDistance(optionalPos.get(), (Position)mod.getPlayer().m_20182_()));
                if (distance > 55.0) {
                    return pair;
                }
                pair.setRight(10.0 / distance * 77.3);
                return pair;
            }
            return pair;
        }, a -> itemStorage.hasItem(Items.f_42446_), false, true, true));
        this.addSmeltTasks(mod);
        this.addCookFoodTasks(mod);
    }

    public static BeatMinecraftConfig getConfig() {
        if (config == null) {
            Debug.logInternal("Initializing BeatMinecraftConfig");
            config = new BeatMinecraftConfig();
        }
        return config;
    }

    private static List<BlockPos> getFrameBlocks(PlayerEngineController mod, BlockPos endPortalCenter) {
        ArrayList<BlockPos> frameBlocks = new ArrayList<BlockPos>();
        for (BlockPos pos : mod.getBlockScanner().getKnownLocations(Blocks.f_50258_)) {
            if (!pos.m_123314_((Vec3i)endPortalCenter, 20.0)) continue;
            frameBlocks.add(pos);
        }
        Debug.logInternal("Frame blocks: " + String.valueOf(frameBlocks));
        return frameBlocks;
    }

    private static ItemTarget[] combine(ItemTarget[] ... targets) {
        ArrayList<ItemTarget> combinedTargets = new ArrayList<ItemTarget>();
        for (ItemTarget[] targetArray : targets) {
            combinedTargets.addAll(Arrays.asList(targetArray));
        }
        Debug.logInternal("Combined Targets: " + String.valueOf(combinedTargets));
        ItemTarget[] combinedArray = combinedTargets.toArray(new ItemTarget[0]);
        Debug.logInternal("Combined Array: " + Arrays.toString(combinedArray));
        return combinedArray;
    }

    private static boolean isEndPortalFrameFilled(PlayerEngineController mod, BlockPos pos) {
        if (!mod.getChunkTracker().isChunkLoaded(pos)) {
            Debug.logInternal("Chunk is not loaded");
            return false;
        }
        BlockState blockState = mod.getWorld().m_8055_(pos);
        if (blockState.m_60734_() != Blocks.f_50258_) {
            Debug.logInternal("Block is not an End Portal Frame");
            return false;
        }
        boolean isFilled = (Boolean)blockState.m_61143_((Property)EndPortalFrameBlock.f_53043_);
        Debug.logInternal("End Portal Frame is " + (isFilled ? "filled" : "not filled"));
        return isFilled;
    }

    public static boolean isTaskRunning(PlayerEngineController mod, Task task) {
        if (task == null) {
            Debug.logInternal("Task is null");
            return false;
        }
        boolean taskActive = task.isActive();
        boolean taskFinished = task.isFinished();
        Debug.logInternal("Task is not null");
        Debug.logInternal("Task is " + (taskActive ? "active" : "not active"));
        Debug.logInternal("Task is " + (taskFinished ? "finished" : "not finished"));
        return taskActive && !taskFinished;
    }

    public static void throwAwayItems(PlayerEngineController mod, Item ... items) {
        BeatMinecraftTask.throwAwaySlots(mod, mod.getItemStorage().getSlotsWithItemPlayerInventory(false, items));
    }

    public static void throwAwaySlots(PlayerEngineController mod, List<Slot> slots) {
        for (Slot slot : slots) {
            if (Slot.isCursor(slot)) {
                mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, ClickType.PICKUP);
                continue;
            }
            mod.getSlotHandler().clickSlot(slot, 0, ClickType.PICKUP);
        }
    }

    public static boolean hasItem(PlayerEngineController mod, Item item) {
        LivingEntity player = mod.getPlayer();
        LivingEntityInventory inv = mod.getInventory();
        for (List list : List.of(inv.main, inv.armor, inv.offHand)) {
            for (ItemStack itemStack : list) {
                if (!itemStack.m_41720_().equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getCountWithCraftedFromOre(PlayerEngineController mod, Item item) {
        ItemStorageTracker itemStorage = mod.getItemStorage();
        if (item == Items.f_42413_) {
            return itemStorage.getItemCount(item);
        }
        if (item == Items.f_151050_) {
            int count = itemStorage.getItemCount(Items.f_151050_, Items.f_42416_);
            count += itemStorage.getItemCount(Items.f_42446_, Items.f_42447_, Items.f_42448_, Items.f_151057_, Items.f_151055_) * 3;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42740_) ? 1 : 0;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42409_) ? 1 : 0;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42383_) ? 2 : 0;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42385_) ? 3 : 0;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42468_) ? 5 : 0;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42469_) ? 8 : 0;
            return (count += BeatMinecraftTask.hasItem(mod, Items.f_42470_) ? 7 : 0) + (BeatMinecraftTask.hasItem(mod, Items.f_42471_) ? 4 : 0);
        }
        if (item == Items.f_151053_) {
            int count = itemStorage.getItemCount(Items.f_151053_, Items.f_42417_);
            count += BeatMinecraftTask.hasItem(mod, Items.f_42432_) ? 3 : 0;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42476_) ? 5 : 0;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42477_) ? 8 : 0;
            return (count += BeatMinecraftTask.hasItem(mod, Items.f_42478_) ? 7 : 0) + (BeatMinecraftTask.hasItem(mod, Items.f_42479_) ? 4 : 0);
        }
        if (item == Items.f_42415_) {
            int count = itemStorage.getItemCount(Items.f_42415_);
            count += BeatMinecraftTask.hasItem(mod, Items.f_42388_) ? 2 : 0;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42390_) ? 3 : 0;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42472_) ? 5 : 0;
            count += BeatMinecraftTask.hasItem(mod, Items.f_42473_) ? 8 : 0;
            return (count += BeatMinecraftTask.hasItem(mod, Items.f_42474_) ? 7 : 0) + (BeatMinecraftTask.hasItem(mod, Items.f_42475_) ? 4 : 0);
        }
        throw new IllegalStateException("Invalid ore item: " + String.valueOf(item));
    }

    private static Block[] mapOreItemToBlocks(Item item) {
        if (item.equals(Items.f_151050_)) {
            return new Block[]{Blocks.f_152468_, Blocks.f_49996_};
        }
        if (item.equals(Items.f_151053_)) {
            return new Block[]{Blocks.f_152467_, Blocks.f_49995_};
        }
        if (item.equals(Items.f_42415_)) {
            return new Block[]{Blocks.f_152474_, Blocks.f_50089_};
        }
        if (item.equals(Items.f_42413_)) {
            return new Block[]{Blocks.f_152469_, Blocks.f_49997_};
        }
        throw new IllegalStateException("Invalid ore: " + String.valueOf(item));
    }

    private void addSleepTask(PlayerEngineController mod) {
        boolean[] skipNight = new boolean[]{false};
        this.gatherResources.add(new ActionPriorityTask(a -> new PlaceBedAndSetSpawnTask(), () -> {
            if (!WorldHelper.canSleep(mod)) {
                skipNight[0] = false;
                return Double.NEGATIVE_INFINITY;
            }
            if (this.lastTask instanceof PlaceBedAndSetSpawnTask && this.lastTask.isFinished()) {
                skipNight[0] = true;
                mod.log("Failed to sleep :(");
                mod.log("Skipping night");
            }
            if (skipNight[0]) {
                return Double.NEGATIVE_INFINITY;
            }
            Optional<BlockPos> pos = mod.getBlockScanner().getNearestBlock(ItemHelper.itemsToBlocks(ItemHelper.BED));
            return pos.isPresent() && pos.get().m_203195_((Position)mod.getPlayer().m_20182_(), 30.0) ? 1000000.0 : Double.NEGATIVE_INFINITY;
        }));
    }

    private RecipeTarget getRecipeTarget(Item item) {
        ResourceTask task = TaskCatalogue.getItemTask(item, 1);
        if (task instanceof CraftInTableTask) {
            CraftInTableTask craftInTableTask = (CraftInTableTask)task;
            return craftInTableTask.getRecipeTargets()[0];
        }
        if (task instanceof CraftInInventoryTask) {
            CraftInInventoryTask craftInInventoryTask = (CraftInInventoryTask)task;
            return craftInInventoryTask.getRecipeTarget();
        }
        throw new IllegalStateException("Item isn't cataloged");
    }

    private void addPickupImportantItemsTask(PlayerEngineController mod) {
        List<Item> importantItems = List.of(Items.f_42385_, Items.f_42390_, Items.f_42476_, Items.f_42388_, Items.f_42473_, Items.f_42474_, Items.f_42475_, Items.f_42409_);
        this.gatherResources.add(new ActionPriorityTask(mod1 -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, 0.0);
            for (Item item : importantItems) {
                if (item == Items.f_42385_ && mod1.getItemStorage().hasItem(Items.f_42390_) || mod1.getItemStorage().hasItem(item) || !mod1.getEntityTracker().itemDropped(item)) continue;
                pair.setLeft(new PickupDroppedItemTask(item, 1));
                pair.setRight(8000.0);
                return pair;
            }
            return pair;
        }));
    }

    private void addCookFoodTasks(PlayerEngineController mod) {
        this.gatherResources.add(new ActionPriorityTask(a -> {
            double priority;
            Pair<Object, Double> pair = new Pair<Object, Double>(null, Double.NEGATIVE_INFINITY);
            int rawFoodCount = a.getItemStorage().getItemCount(ItemHelper.RAW_FOODS);
            int readyFoodCount = a.getItemStorage().getItemCount(ItemHelper.COOKED_FOODS) + a.getItemStorage().getItemCount(Items.f_42406_);
            double d = priority = rawFoodCount >= 8 ? 450.0 : (double)(rawFoodCount * 25);
            if (this.lastTask instanceof SmeltInSmokerTask) {
                priority = Double.POSITIVE_INFINITY;
            }
            if (readyFoodCount > 5 && priority < Double.POSITIVE_INFINITY) {
                priority = 0.01;
            }
            for (CollectFoodTask.CookableFoodTarget cookable : CollectMeatTask.COOKABLE_MEATS) {
                int rawCount = a.getItemStorage().getItemCount(cookable.getRaw());
                if (rawCount == 0) continue;
                int toSmelt = rawCount + a.getItemStorage().getItemCount(cookable.getCooked());
                SmeltTarget target = new SmeltTarget(new ItemTarget(cookable.cookedFood, toSmelt), new ItemTarget(cookable.rawFood, rawCount), new Item[0]);
                pair.setLeft(new SmeltInSmokerTask(target));
                pair.setRight(priority);
                return pair;
            }
            return pair;
        }, a -> StorageHelper.miningRequirementMet(mod, MiningRequirement.STONE), true, false, false));
    }

    private void addSmeltTasks(PlayerEngineController mod) {
        ItemStorageTracker itemStorage = mod.getItemStorage();
        this.gatherResources.add(new ActionPriorityTask(a -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, Double.NEGATIVE_INFINITY);
            boolean hasSufficientPickaxe = itemStorage.hasItem(Items.f_42385_, Items.f_42390_);
            int neededIron = 11;
            if (itemStorage.hasItem(Items.f_42409_)) {
                --neededIron;
            }
            if (BeatMinecraftTask.hasItem(mod, Items.f_42740_)) {
                --neededIron;
            }
            if (hasSufficientPickaxe) {
                neededIron -= 3;
            }
            int count = itemStorage.getItemCount(Items.f_151050_);
            int includedCount = count + itemStorage.getItemCount(Items.f_42416_);
            if ((hasSufficientPickaxe || includedCount < 3) && (BeatMinecraftTask.hasItem(mod, Items.f_42740_) || includedCount < 1) && includedCount < (neededIron -= Math.min(itemStorage.getItemCount(Items.f_42446_, Items.f_42447_, Items.f_42448_), 2) * 3)) {
                return pair;
            }
            int toSmelt = Math.min(includedCount, neededIron);
            if (toSmelt <= 0) {
                return pair;
            }
            pair.setLeft(new SmeltInFurnaceTask(new SmeltTarget(new ItemTarget(Items.f_42416_, toSmelt), new ItemTarget(Items.f_151050_, toSmelt), new Item[0])));
            pair.setRight(350.0);
            return pair;
        }, a -> itemStorage.hasItem(Items.f_151050_), true, false, false));
        this.gatherResources.add(new ActionPriorityTask(a -> new SmeltInFurnaceTask(new SmeltTarget(new ItemTarget(Items.f_42417_, 5), new ItemTarget(Items.f_151053_, 5), new Item[0])), () -> 140.0, a -> itemStorage.getItemCount(Items.f_151053_, Items.f_42417_) >= 5 && !itemStorage.hasItem(Items.f_42476_), true, true, false));
    }

    private void addLootChestsTasks(PlayerEngineController mod) {
        this.gatherResources.add(new ActionPriorityTask(a -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, Double.NEGATIVE_INFINITY);
            Optional<BlockPos> chest = this.locateClosestUnopenedChest(mod);
            if (chest.isEmpty()) {
                return pair;
            }
            double dst = Math.sqrt(BlockPosVer.getSquaredDistance(chest.get(), (Position)mod.getPlayer().m_20182_()));
            pair.setRight(30.0 / dst * 175.0);
            pair.setLeft(new GetToBlockTask(chest.get().m_7494_()));
            return pair;
        }, a -> true, false, false, true));
        this.gatherResources.add(new ActionPriorityTask(m -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, Double.NEGATIVE_INFINITY);
            Optional<BlockPos> chest = this.locateClosestUnopenedChest(mod);
            if (chest.isEmpty()) {
                return pair;
            }
            if (LookHelper.cleanLineOfSight((Entity)mod.getPlayer(), chest.get(), 10.0) && chest.get().m_203195_((Position)mod.getPlayer().m_146892_(), 5.0)) {
                pair.setLeft(new LootContainerTask(chest.get(), this.lootableItems(mod), noCurseOfBinding));
                pair.setRight(Double.POSITIVE_INFINITY);
            }
            return pair;
        }, a -> true, true, false, true));
    }

    private void addCollectFoodTask(PlayerEngineController mod) {
        LinkedList<Item> food = new LinkedList<Item>(ItemHelper.cookableFoodMap.values());
        food.addAll(ItemHelper.cookableFoodMap.keySet());
        food.addAll(List.of(Items.f_42405_, Items.f_42406_));
        this.gatherResources.add(new ResourcePriorityTask((ItemPriorityCalculator)new CollectFoodPriorityCalculator(mod, (double)BeatMinecraftTask.config.foodUnits), a -> StorageHelper.miningRequirementMet(mod, MiningRequirement.STONE) && mod.getItemStorage().hasItem(Items.f_42425_, Items.f_42383_, Items.f_42388_) && CollectFoodTask.calculateFoodPotential(mod) < (double)BeatMinecraftTask.config.foodUnits, new CollectFoodTask(BeatMinecraftTask.config.foodUnits), ItemTarget.of(food.toArray(new Item[0]))));
        this.gatherResources.add(new ActionPriorityTask(mod12 -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, 0.0);
            pair.setLeft(TaskCatalogue.getItemTask(Items.f_42405_, mod12.getItemStorage().getItemCount(Items.f_42129_) * 9 + mod12.getItemStorage().getItemCount(Items.f_42405_)));
            pair.setRight(10.0);
            if (StorageHelper.calculateInventoryFoodScore(mod) < 5) {
                pair.setRight(270.0);
            }
            return pair;
        }, a -> mod.getItemStorage().hasItem(Items.f_42129_)));
        this.gatherResources.add(new ActionPriorityTask(mod1 -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, 0.0);
            pair.setLeft(TaskCatalogue.getItemTask("bread", mod1.getItemStorage().getItemCount(Items.f_42405_) / 3 + mod1.getItemStorage().getItemCount(Items.f_42406_)));
            pair.setRight(5.0);
            if (StorageHelper.calculateInventoryFoodScore(mod) < 5) {
                pair.setRight(250.0);
            }
            return pair;
        }, a -> mod.getItemStorage().getItemCount(Items.f_42405_) >= 3));
    }

    private void addOreMiningTasks() {
        this.gatherResources.add(this.getOrePriorityTask(Items.f_42413_, MiningRequirement.STONE, 1050, 250, 5, 4, 7));
        this.gatherResources.add(this.getOrePriorityTask(Items.f_151050_, MiningRequirement.STONE, 1050, 250, 5, 11, 11));
        this.gatherResources.add(this.getOrePriorityTask(Items.f_151053_, MiningRequirement.IRON, 1050, 250, 5, 5, 5));
        this.gatherResources.add(this.getOrePriorityTask(Items.f_42415_, MiningRequirement.IRON, 1050, 250, 5, 27, 30));
    }

    private PriorityTask getOrePriorityTask(Item item, MiningRequirement requirement, int multiplier, int unneededMultiplier, int unneededThreshold, int minCount, int maxCount) {
        Block[] blocks = BeatMinecraftTask.mapOreItemToBlocks(item);
        return new MineBlockPriorityTask(blocks, new Item[]{item}, requirement, new DistanceOrePriorityCalculator(item, multiplier, unneededMultiplier, unneededThreshold, minCount, maxCount));
    }

    private void addStoneToolsTasks() {
        this.gatherResources.add(new ResourcePriorityTask((ItemPriorityCalculator)StaticItemPriorityCalculator.of(520), altoClef -> StorageHelper.miningRequirementMet(this.mod, MiningRequirement.STONE), true, true, false, ItemTarget.of(Items.f_42428_, Items.f_42425_, Items.f_42426_, Items.f_42429_)));
        this.gatherResources.add(new CraftItemPriorityTask(300.0, this.getRecipeTarget(Items.f_42425_), a -> StorageHelper.miningRequirementMet(this.mod, MiningRequirement.STONE) && !this.mod.getItemStorage().hasItem(Items.f_42388_, Items.f_42383_)));
        this.gatherResources.add(new CraftItemPriorityTask(300.0, this.getRecipeTarget(Items.f_42428_), a -> StorageHelper.miningRequirementMet(this.mod, MiningRequirement.STONE) && !this.mod.getItemStorage().hasItem(Items.f_42391_, Items.f_42386_)));
    }

    private void addDiamondArmorTasks(PlayerEngineController mod) {
        this.gatherResources.add(new CraftItemPriorityTask(350.0, this.getRecipeTarget(Items.f_42473_), a -> mod.getItemStorage().getItemCount(Items.f_42415_) >= 8));
        this.gatherResources.add(new CraftItemPriorityTask(300.0, this.getRecipeTarget(Items.f_42474_), a -> mod.getItemStorage().getItemCount(Items.f_42415_) >= 7));
        this.gatherResources.add(new CraftItemPriorityTask(220.0, this.getRecipeTarget(Items.f_42475_), a -> mod.getItemStorage().getItemCount(Items.f_42415_) >= 5));
    }

    private void addPickaxeTasks(PlayerEngineController mod) {
        this.gatherResources.add(new ResourcePriorityTask((ItemPriorityCalculator)StaticItemPriorityCalculator.of(400), a -> !mod.getItemStorage().hasItem(Items.f_42422_, Items.f_42427_, Items.f_42385_, Items.f_42390_), ItemTarget.of(Items.f_42422_)));
        this.gatherResources.add(new RecraftableItemPriorityTask(410.0, 10000.0, this.getRecipeTarget(Items.f_42427_), a -> {
            List<Slot> list = mod.getItemStorage().getSlotsWithItemPlayerInventory(false, new Item[0]);
            boolean hasSafeIronPick = false;
            for (Slot slot : list) {
                ItemStack stack;
                if (slot.getInventorySlot() == -1 || StorageHelper.shouldSaveStack(mod, Blocks.f_50069_, stack = mod.getBaritone().getEntityContext().inventory().m_8020_(slot.getInventorySlot())) || !stack.m_41720_().equals(Items.f_42385_)) continue;
                hasSafeIronPick = true;
                break;
            }
            return StorageHelper.miningRequirementMet(mod, MiningRequirement.WOOD) && !mod.getItemStorage().hasItem(Items.f_42427_) && !hasSafeIronPick && !mod.getItemStorage().hasItem(Items.f_42390_);
        }));
        this.gatherResources.add(new CraftItemPriorityTask(420.0, this.getRecipeTarget(Items.f_42385_), a -> !mod.getItemStorage().hasItem(Items.f_42385_, Items.f_42390_) && mod.getItemStorage().getItemCount(Items.f_42416_) >= 3));
        this.gatherResources.add(new CraftItemPriorityTask(430.0, this.getRecipeTarget(Items.f_42390_), a -> mod.getItemStorage().getItemCount(Items.f_42415_) >= 3));
    }

    @Override
    public boolean isFinished() {
        if (WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD && this.dragonIsDead) {
            Debug.logInternal("isFinished - Dragon is dead in the Overworld");
            return true;
        }
        Debug.logInternal("isFinished - Returning false");
        return false;
    }

    private boolean needsBuildingMaterials(PlayerEngineController mod) {
        int materialCount = StorageHelper.getBuildingMaterialCount(mod);
        boolean shouldForce = BeatMinecraftTask.isTaskRunning(mod, this.buildMaterialsTask);
        if (materialCount >= BeatMinecraftTask.config.minBuildMaterialCount && !shouldForce) {
            Debug.logInternal("Building materials not needed");
            return false;
        }
        Debug.logInternal("Building materials needed: " + materialCount);
        Debug.logInternal("Force build materials: " + shouldForce);
        return true;
    }

    private void updateCachedEndItems(PlayerEngineController mod) {
        List<ItemEntity> droppedItems = mod.getEntityTracker().getDroppedItems();
        if (droppedItems.isEmpty() && !this.cachedEndItemNothingWaitTime.elapsed()) {
            Debug.logInternal("No dropped items and cache wait time not elapsed.");
        } else {
            this.cachedEndItemNothingWaitTime.reset();
            this.cachedEndItemDrops.clear();
            for (ItemEntity entity : droppedItems) {
                Item item = entity.m_32055_().m_41720_();
                int count = entity.m_32055_().m_41613_();
                this.cachedEndItemDrops.put(item, this.cachedEndItemDrops.getOrDefault(item, 0) + count);
                Debug.logInternal("Added dropped item: " + String.valueOf(item) + " with count: " + count);
            }
        }
    }

    private List<Item> lootableItems(PlayerEngineController mod) {
        boolean hasEnoughGoldIngots;
        ArrayList<Item> lootable = new ArrayList<Item>();
        lootable.add(Items.f_42410_);
        lootable.add(Items.f_42436_);
        lootable.add(Items.f_42437_);
        lootable.add(Items.f_42677_);
        lootable.add(Items.f_41999_);
        lootable.add(Items.f_42398_);
        lootable.add(Items.f_42413_);
        lootable.addAll(Arrays.stream(ItemHelper.LOG).toList());
        lootable.add(Items.f_42406_);
        boolean isGoldenHelmetEquipped = StorageHelper.isArmorEquipped(mod, Items.f_42476_);
        boolean hasGoldenHelmet = mod.getItemStorage().hasItemInventoryOnly(Items.f_42476_);
        if (!mod.getItemStorage().hasItem(Items.f_42390_, Items.f_42385_)) {
            lootable.add(Items.f_42385_);
        }
        if (mod.getItemStorage().getItemCount(Items.f_42446_, Items.f_42447_, Items.f_42448_) < 2) {
            lootable.add(Items.f_42446_);
        }
        boolean bl = hasEnoughGoldIngots = mod.getItemStorage().getItemCountInventoryOnly(Items.f_42417_) >= 5;
        if (!isGoldenHelmetEquipped && !hasGoldenHelmet) {
            lootable.add(Items.f_42476_);
        }
        if (!hasEnoughGoldIngots && !isGoldenHelmetEquipped && !hasGoldenHelmet || BeatMinecraftTask.config.barterPearlsInsteadOfEndermanHunt) {
            lootable.add(Items.f_42417_);
        }
        lootable.add(Items.f_42409_);
        if (!mod.getItemStorage().hasItemInventoryOnly(Items.f_42409_) && !mod.getItemStorage().hasItemInventoryOnly(Items.f_42613_)) {
            lootable.add(Items.f_42613_);
        }
        if (!mod.getItemStorage().hasItemInventoryOnly(Items.f_42446_) && !mod.getItemStorage().hasItemInventoryOnly(Items.f_42447_)) {
            lootable.add(Items.f_42416_);
        }
        if (!StorageHelper.itemTargetsMetInventory(mod, COLLECT_EYE_GEAR_MIN)) {
            lootable.add(Items.f_42415_);
        }
        if (!mod.getItemStorage().hasItemInventoryOnly(Items.f_42484_)) {
            lootable.add(Items.f_42484_);
        }
        Debug.logInternal("Lootable items: " + String.valueOf(lootable));
        return lootable;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.mod.getExtraBaritoneSettings().canWalkOnEndPortal(false);
        this.mod.getBehaviour().pop();
        Debug.logInternal("Stopped onStop method");
        Debug.logInternal("canWalkOnEndPortal set to false");
        Debug.logInternal("Behaviour popped");
        Debug.logInternal("Stopped tracking BED blocks");
        Debug.logInternal("Stopped tracking TRACK_BLOCKS");
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean isSameTask = other instanceof BeatMinecraftTask;
        if (!isSameTask) {
            Debug.logInternal("The 'other' task is not of type BeatMinecraftTask");
        }
        return isSameTask;
    }

    @Override
    protected String toDebugString() {
        return "Beating the game (Miran version).";
    }

    private boolean endPortalFound(PlayerEngineController mod, BlockPos endPortalCenter) {
        if (endPortalCenter == null) {
            Debug.logInternal("End portal center is null");
            return false;
        }
        return true;
    }

    private boolean endPortalOpened(PlayerEngineController mod, BlockPos endPortalCenter) {
        BlockScanner blockTracker;
        if (this.endPortalOpened && endPortalCenter != null && (blockTracker = mod.getBlockScanner()) != null) {
            boolean isValid = blockTracker.isBlockAtPosition(endPortalCenter, Blocks.f_50257_);
            Debug.logInternal("End Portal is " + (isValid ? "valid" : "invalid"));
            return isValid;
        }
        Debug.logInternal("End Portal is not opened yet");
        return false;
    }

    private boolean spawnSetNearPortal(PlayerEngineController mod, BlockPos endPortalCenter) {
        if (this.bedSpawnLocation == null) {
            Debug.logInternal("Bed spawn location is null");
            return false;
        }
        BlockScanner blockTracker = mod.getBlockScanner();
        boolean isValid = blockTracker.isBlockAtPosition(this.bedSpawnLocation, ItemHelper.itemsToBlocks(ItemHelper.BED));
        Debug.logInternal("Spawn set near portal: " + isValid);
        return isValid;
    }

    private Optional<BlockPos> locateClosestUnopenedChest(PlayerEngineController mod) {
        return !WorldHelper.getCurrentDimension(mod).equals((Object)Dimension.OVERWORLD) ? Optional.empty() : mod.getBlockScanner().getNearestBlock(blockPos -> {
            if (this.blacklistedChests.contains(blockPos)) {
                return false;
            }
            boolean isUnopenedChest = WorldHelper.isUnopenedChest(mod, blockPos);
            boolean isWithinDistance = mod.getPlayer().m_20183_().m_123314_((Vec3i)blockPos, 150.0);
            boolean isLootableChest = this.canBeLootablePortalChest(mod, (BlockPos)blockPos);
            Optional<BlockPos> nearestSpawner = mod.getBlockScanner().getNearestBlock(WorldHelper.toVec3d(blockPos), Blocks.f_50085_);
            if (nearestSpawner.isPresent() && nearestSpawner.get().m_123314_((Vec3i)blockPos, 6.0)) {
                this.blacklistedChests.add((BlockPos)blockPos);
                return false;
            }
            AABB box = new AABB((double)(blockPos.m_123341_() - 5), (double)(blockPos.m_123342_() - 5), (double)(blockPos.m_123343_() - 5), (double)(blockPos.m_123341_() + 5), (double)(blockPos.m_123342_() + 5), (double)(blockPos.m_123343_() + 5));
            Stream<BlockState> states = BlockPos.m_121921_((AABB)box).map(pos -> mod.getWorld().m_8055_(pos));
            if (states.anyMatch(state -> state.m_60734_().equals(Blocks.f_49990_))) {
                this.blacklistedChests.add((BlockPos)blockPos);
                return false;
            }
            Debug.logInternal("isUnopenedChest: " + isUnopenedChest);
            Debug.logInternal("isWithinDistance: " + isWithinDistance);
            Debug.logInternal("isLootableChest: " + isLootableChest);
            return isUnopenedChest && isWithinDistance && isLootableChest;
        }, Blocks.f_50087_);
    }

    @Override
    protected void onStart() {
        this.resetTimers();
        this.mod.getBehaviour().push();
        this.addThrowawayItemsWarning(this.mod);
        this.addProtectedItems(this.mod);
        this.allowWalkingOnEndPortal(this.mod);
        this.avoidDragonBreath(this.mod);
        this.avoidBreakingBed(this.mod);
        this.mod.getBehaviour().avoidBlockBreaking(pos -> this.mod.getWorld().m_8055_(pos).m_60734_().equals(Blocks.f_50142_));
    }

    private void resetTimers() {
        this.timer1.reset();
        this.timer2.reset();
        this.timer3.reset();
    }

    private void addThrowawayItemsWarning(PlayerEngineController mod) {
        String settingsWarningTail = "in \".minecraft/playerengine_settings.json\". @gamer may break if you don't add this! (sorry!)";
        if (!ArrayUtils.contains((Object[])mod.getModSettings().getThrowawayItems(mod), (Object)Items.f_42102_)) {
            Debug.logWarning("\"end_stone\" is not part of your \"throwawayItems\" list " + settingsWarningTail);
        }
        if (!mod.getModSettings().shouldThrowawayUnusedItems()) {
            Debug.logWarning("\"throwawayUnusedItems\" is not set to true " + settingsWarningTail);
        }
    }

    private void addProtectedItems(PlayerEngineController mod) {
        mod.getBehaviour().addProtectedItems(Items.f_42545_, Items.f_42585_, Items.f_42593_, Items.f_42584_, Items.f_41960_, Items.f_42416_, Items.f_42447_, Items.f_42409_, Items.f_42740_, Items.f_42574_, Items.f_42446_, Items.f_42476_, Items.f_42769_, Items.f_41962_);
        mod.getBehaviour().addProtectedItems(ItemHelper.BED);
        mod.getBehaviour().addProtectedItems(ItemHelper.IRON_ARMORS);
        mod.getBehaviour().addProtectedItems(ItemHelper.LOG);
        Debug.logInternal("Protected items added successfully.");
    }

    private void allowWalkingOnEndPortal(PlayerEngineController mod) {
        mod.getBehaviour().allowWalkingOn(blockPos -> {
            if (this.enterindEndPortal && mod.getChunkTracker().isChunkLoaded((BlockPos)blockPos)) {
                boolean isEndPortal;
                BlockState blockState = mod.getWorld().m_8055_(blockPos);
                boolean bl = isEndPortal = blockState.m_60734_() == Blocks.f_50257_;
                if (isEndPortal) {
                    Debug.logInternal("Walking on End Portal at " + blockPos.toString());
                }
                return isEndPortal;
            }
            return false;
        });
    }

    private void avoidDragonBreath(PlayerEngineController mod) {
        mod.getBehaviour().avoidWalkingThrough(blockPos -> {
            Dimension currentDimension = WorldHelper.getCurrentDimension(mod);
            boolean isEndDimension = currentDimension == Dimension.END;
            boolean isTouchingDragonBreath = this.dragonBreathTracker.isTouchingDragonBreath((BlockPos)blockPos);
            if (isEndDimension && !this.escapingDragonsBreath && isTouchingDragonBreath) {
                Debug.logInternal("Avoiding dragon breath at blockPos: " + String.valueOf(blockPos));
                return true;
            }
            return false;
        });
    }

    private void avoidBreakingBed(PlayerEngineController mod) {
        mod.getBehaviour().avoidBlockBreaking(blockPos -> {
            boolean shouldAvoidBreaking;
            if (this.bedSpawnLocation == null) {
                return false;
            }
            BlockPos bedHead = WorldHelper.getBedHead(mod, this.bedSpawnLocation);
            BlockPos bedFoot = WorldHelper.getBedFoot(mod, this.bedSpawnLocation);
            boolean bl = shouldAvoidBreaking = blockPos.equals((Object)bedHead) || blockPos.equals((Object)bedFoot);
            if (shouldAvoidBreaking) {
                Debug.logInternal("Avoiding breaking bed at block position: " + String.valueOf(blockPos));
            }
            return shouldAvoidBreaking;
        });
    }

    private void blackListDangerousBlock(PlayerEngineController mod, Block block) {
        Optional<BlockPos> nearestTracking = mod.getBlockScanner().getNearestBlock(block);
        if (nearestTracking.isPresent()) {
            for (Entity entity : mod.getWorld().m_8583_()) {
                if (mod.getBlockScanner().isUnreachable(nearestTracking.get()) || !(entity instanceof Monster) || !(mod.getPlayer().m_20238_(entity.m_20182_()) < 150.0) || !nearestTracking.get().m_203195_((Position)entity.m_20182_(), 30.0)) continue;
                Debug.logMessage("Blacklisting dangerous " + block.toString());
                mod.getBlockScanner().requestBlockUnreachable(nearestTracking.get(), 0);
            }
        }
    }

    @Override
    protected Task onTick() {
        ItemStorageTracker itemStorage = this.mod.getItemStorage();
        double blockPlacementPenalty = 10.0;
        if (StorageHelper.getNumberOfThrowawayBlocks(this.mod) > 128) {
            blockPlacementPenalty = 5.0;
        } else if (StorageHelper.getNumberOfThrowawayBlocks(this.mod) > 64) {
            blockPlacementPenalty = 7.5;
        }
        this.mod.getBaritoneSettings().blockPlacementPenalty.set(blockPlacementPenalty);
        if (this.mod.getPlayer().m_21205_().m_41720_() instanceof EnderEyeItem && !openingEndPortal) {
            for (ItemStack itemStack : itemStorage.getItemStacksPlayerInventory(true)) {
                Item item = itemStack.m_41720_();
                if (!(item instanceof SwordItem) && !(item instanceof AxeItem)) continue;
                this.mod.getSlotHandler().forceEquipItem(item);
            }
        }
        boolean shouldSwap = false;
        boolean hasInHotbar = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.mod.getBaritone().getEntityContext().inventory().m_8020_(i);
            if (stack.m_41720_().equals(Items.f_42385_) && StorageHelper.shouldSaveStack(this.mod, Blocks.f_50069_, stack)) {
                shouldSwap = true;
            }
            if (!stack.m_41720_().equals(Items.f_42427_)) continue;
            hasInHotbar = true;
        }
        if (shouldSwap && !hasInHotbar && itemStorage.hasItem(Items.f_42427_)) {
            this.mod.getSlotHandler().forceEquipItem(Items.f_42427_);
        }
        boolean eyeGearSatisfied = StorageHelper.isArmorEquippedAll(this.mod, COLLECT_EYE_ARMOR);
        boolean ironGearSatisfied = StorageHelper.isArmorEquippedAll(this.mod, COLLECT_IRON_ARMOR);
        if (itemStorage.hasItem(Items.f_42390_)) {
            this.mod.getBehaviour().setBlockBreakAdditionalPenalty(1.2);
        } else {
            this.mod.getBehaviour().setBlockBreakAdditionalPenalty((Double)this.mod.getBaritoneSettings().blockBreakAdditionalPenalty.defaultValue);
        }
        Predicate<Task> isCraftingTableTask = task -> task instanceof CraftInTableTask;
        for (BlockPos craftingTable : this.mod.getBlockScanner().getKnownLocations(Blocks.f_50091_)) {
            Optional<Entity> witch;
            if (itemStorage.hasItem(Items.f_41960_) && !this.thisOrChildSatisfies(isCraftingTableTask) && !this.mod.getBlockScanner().isUnreachable(craftingTable)) {
                Debug.logMessage("Blacklisting extra crafting table.");
                this.mod.getBlockScanner().requestBlockUnreachable(craftingTable, 0);
            }
            if (this.mod.getBlockScanner().isUnreachable(craftingTable)) continue;
            BlockState craftingTablePosUp = this.mod.getWorld().m_8055_(craftingTable.m_6630_(2));
            if (this.mod.getEntityTracker().entityFound(Witch.class) && (witch = this.mod.getEntityTracker().getClosestEntity(Witch.class)).isPresent() && craftingTable.m_203195_((Position)witch.get().m_20182_(), 15.0)) {
                Debug.logMessage("Blacklisting witch crafting table.");
                this.mod.getBlockScanner().requestBlockUnreachable(craftingTable, 0);
            }
            if (craftingTablePosUp.m_60734_() != Blocks.f_50041_) continue;
            Debug.logMessage("Blacklisting pillage crafting table.");
            this.mod.getBlockScanner().requestBlockUnreachable(craftingTable, 0);
        }
        for (BlockPos smoker : this.mod.getBlockScanner().getKnownLocations(Blocks.f_50619_)) {
            if (!itemStorage.hasItem(Items.f_42769_) || this.mod.getBlockScanner().isUnreachable(smoker)) continue;
            Debug.logMessage("Blacklisting extra smoker.");
            this.mod.getBlockScanner().requestBlockUnreachable(smoker, 0);
        }
        for (BlockPos furnace : this.mod.getBlockScanner().getKnownLocations(Blocks.f_50094_)) {
            if (!itemStorage.hasItem(Items.f_41962_) || this.goToNetherTask.isActive() || this.ranStrongholdLocator || this.mod.getBlockScanner().isUnreachable(furnace)) continue;
            Debug.logMessage("Blacklisting extra furnace.");
            this.mod.getBlockScanner().requestBlockUnreachable(furnace, 0);
        }
        for (BlockPos log : this.mod.getBlockScanner().getKnownLocations(ItemHelper.itemsToBlocks(ItemHelper.LOG))) {
            for (Entity entity : this.mod.getWorld().m_8583_()) {
                if (!(entity instanceof Pillager) || this.mod.getBlockScanner().isUnreachable(log) || !log.m_203195_((Position)entity.m_20182_(), 40.0)) continue;
                Debug.logMessage("Blacklisting pillage log.");
                this.mod.getBlockScanner().requestBlockUnreachable(log, 0);
            }
            if (log.m_123342_() >= 62 || this.mod.getBlockScanner().isUnreachable(log) || ironGearSatisfied || eyeGearSatisfied) continue;
            Debug.logMessage("Blacklisting dangerous log.");
            this.mod.getBlockScanner().requestBlockUnreachable(log, 0);
        }
        if (!ironGearSatisfied && !eyeGearSatisfied) {
            this.blackListDangerousBlock(this.mod, Blocks.f_152469_);
            this.blackListDangerousBlock(this.mod, Blocks.f_49997_);
            this.blackListDangerousBlock(this.mod, Blocks.f_152468_);
            this.blackListDangerousBlock(this.mod, Blocks.f_49996_);
        }
        List<Block> ancientCityBlocks = List.of(Blocks.f_152589_, Blocks.f_220855_, Blocks.f_220856_, Blocks.f_152500_, Blocks.f_220858_, Blocks.f_152560_, Blocks.f_152594_, Blocks.f_50682_, Blocks.f_152559_, Blocks.f_152555_);
        int radius = 5;
        block7: for (BlockPos pos2 : this.mod.getBlockScanner().getKnownLocations(ItemHelper.itemsToBlocks(ItemHelper.WOOL))) {
            for (int x = -5; x < 5; ++x) {
                for (int y = -5; y < 5; ++y) {
                    for (int z = -5; z < 5; ++z) {
                        BlockPos p2 = pos2.m_7918_(x, y, z);
                        Block block = this.mod.getWorld().m_8055_(p2).m_60734_();
                        if (!ancientCityBlocks.contains(block)) continue;
                        Debug.logMessage("Blacklisting ancient city wool " + String.valueOf(pos2));
                        this.mod.getBlockScanner().requestBlockUnreachable(pos2, 0);
                        continue block7;
                    }
                }
            }
        }
        if (locateStrongholdTask.isActive() && WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD && !this.mod.getBaritone().getExploreProcess().isActive() && this.timer1.elapsed()) {
            this.timer1.reset();
        }
        if ((this.getOneBedTask != null && this.getOneBedTask.isActive() || this.sleepThroughNightTask.isActive() && !itemStorage.hasItem(ItemHelper.BED)) && this.getBedTask == null && !this.mod.getBaritone().getExploreProcess().isActive() && this.timer3.elapsed()) {
            this.timer3.reset();
        }
        if (WorldHelper.getCurrentDimension(this.mod) != Dimension.END && itemStorage.hasItem(Items.f_42740_) && !itemStorage.hasItemInOffhand(this.controller, Items.f_42740_)) {
            return new EquipArmorTask(Items.f_42740_);
        }
        if (WorldHelper.getCurrentDimension(this.mod) == Dimension.NETHER) {
            if (itemStorage.hasItem(Items.f_42476_)) {
                return new EquipArmorTask(Items.f_42476_);
            }
            if (itemStorage.hasItem(Items.f_42472_) && !BeatMinecraftTask.hasItem(this.mod, Items.f_42476_)) {
                return new EquipArmorTask(Items.f_42472_);
            }
        } else if (itemStorage.hasItem(Items.f_42472_)) {
            return new EquipArmorTask(Items.f_42472_);
        }
        if (itemStorage.hasItem(Items.f_42473_)) {
            return new EquipArmorTask(Items.f_42473_);
        }
        if (itemStorage.hasItem(Items.f_42474_)) {
            return new EquipArmorTask(Items.f_42474_);
        }
        if (itemStorage.hasItem(Items.f_42475_)) {
            return new EquipArmorTask(Items.f_42475_);
        }
        if (itemStorage.getItemCount(Items.f_41962_) > 1) {
            return new PlaceBlockNearbyTask(p -> this.controller.getWorld().m_8055_(p).m_60734_() != Blocks.f_50091_, Blocks.f_50094_);
        }
        if (itemStorage.getItemCount(Items.f_41960_) > 1) {
            return new PlaceBlockNearbyTask(Blocks.f_50091_);
        }
        BeatMinecraftTask.throwAwayItems(this.mod, Items.f_41830_, Items.f_41831_);
        BeatMinecraftTask.throwAwayItems(this.mod, Items.f_42000_);
        BeatMinecraftTask.throwAwayItems(this.mod, this.uselessItems.uselessItems);
        if (itemStorage.hasItem(Items.f_42427_, Items.f_42385_, Items.f_42390_)) {
            BeatMinecraftTask.throwAwayItems(this.mod, Items.f_42422_);
        }
        if (itemStorage.hasItem(Items.f_42390_)) {
            BeatMinecraftTask.throwAwayItems(this.mod, Items.f_42385_, Items.f_42427_);
        }
        if (itemStorage.hasItem(Items.f_42388_)) {
            BeatMinecraftTask.throwAwayItems(this.mod, Items.f_42425_, Items.f_42383_);
        }
        if (itemStorage.hasItem(Items.f_42476_)) {
            BeatMinecraftTask.throwAwayItems(this.mod, Items.f_151053_, Items.f_42417_);
        }
        if (itemStorage.hasItem(Items.f_42484_) || itemStorage.hasItem(Items.f_42409_)) {
            BeatMinecraftTask.throwAwayItems(this.mod, Items.f_41832_);
        }
        if (itemStorage.hasItem(Items.f_42409_)) {
            BeatMinecraftTask.throwAwayItems(this.mod, Items.f_42484_);
        }
        if (BeatMinecraftTask.isTaskRunning(this.mod, this.getRidOfExtraWaterBucketTask)) {
            return this.getRidOfExtraWaterBucketTask;
        }
        if (itemStorage.getItemCount(Items.f_42447_) > 1) {
            this.getRidOfExtraWaterBucketTask = new GetRidOfExtraWaterBucketTask();
            return this.getRidOfExtraWaterBucketTask;
        }
        if (itemStorage.getItemCount(Items.f_42409_) > 1) {
            BeatMinecraftTask.throwAwayItems(this.mod, Items.f_42409_);
        }
        if (itemStorage.getItemCount(ItemHelper.BED) > this.getTargetBeds(this.mod) && !this.endPortalFound(this.mod, this.endPortalCenterLocation) && WorldHelper.getCurrentDimension(this.mod) != Dimension.END) {
            BeatMinecraftTask.throwAwayItems(this.mod, ItemHelper.BED);
        }
        this.enterindEndPortal = false;
        if (WorldHelper.getCurrentDimension(this.mod) != Dimension.END) {
            this.cachedEndItemNothingWaitTime.reset();
            if (!this.endPortalOpened(this.mod, this.endPortalCenterLocation) && WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD) {
                Optional<BlockPos> endPortal = this.mod.getBlockScanner().getNearestBlock(Blocks.f_50257_);
                if (endPortal.isPresent()) {
                    this.endPortalCenterLocation = endPortal.get();
                    this.endPortalOpened = true;
                } else {
                    this.endPortalCenterLocation = this.doSimpleSearchForEndPortal(this.mod);
                }
            }
            if (BeatMinecraftTask.isTaskRunning(this.mod, this.rePickupTask)) {
                return this.rePickupTask;
            }
            if (!this.endPortalOpened && WorldHelper.getCurrentDimension(this.mod) != Dimension.END && BeatMinecraftTask.config.rePickupCraftingTable && !itemStorage.hasItem(Items.f_41960_) && !this.thisOrChildSatisfies(isCraftingTableTask) && (this.mod.getBlockScanner().anyFound(blockPos -> WorldHelper.canBreak(this.mod, blockPos) && WorldHelper.canReach(this.mod, blockPos), Blocks.f_50091_) || this.mod.getEntityTracker().itemDropped(Items.f_41960_)) && this.pickupCrafting) {
                this.setDebugState("Picking up the crafting table while we are at it.");
                return new MineAndCollectTask(Items.f_41960_, 1, new Block[]{Blocks.f_50091_}, MiningRequirement.HAND);
            }
            if (BeatMinecraftTask.config.rePickupSmoker && !this.endPortalOpened && WorldHelper.getCurrentDimension(this.mod) != Dimension.END && !itemStorage.hasItem(Items.f_42769_) && (this.mod.getBlockScanner().anyFound(blockPos -> WorldHelper.canBreak(this.mod, blockPos) && WorldHelper.canReach(this.mod, blockPos), Blocks.f_50619_) || this.mod.getEntityTracker().itemDropped(Items.f_42769_)) && this.pickupSmoker) {
                this.setDebugState("Picking up the smoker while we are at it.");
                this.rePickupTask = new MineAndCollectTask(Items.f_42769_, 1, new Block[]{Blocks.f_50619_}, MiningRequirement.WOOD);
                return this.rePickupTask;
            }
            if (BeatMinecraftTask.config.rePickupFurnace && !this.endPortalOpened && WorldHelper.getCurrentDimension(this.mod) != Dimension.END && !itemStorage.hasItem(Items.f_41962_) && (this.mod.getBlockScanner().anyFound(blockPos -> WorldHelper.canBreak(this.mod, blockPos) && WorldHelper.canReach(this.mod, blockPos), Blocks.f_50094_) || this.mod.getEntityTracker().itemDropped(Items.f_41962_)) && !this.goToNetherTask.isActive() && !this.ranStrongholdLocator && this.pickupFurnace) {
                this.setDebugState("Picking up the furnace while we are at it.");
                this.rePickupTask = new MineAndCollectTask(Items.f_41962_, 1, new Block[]{Blocks.f_50094_}, MiningRequirement.WOOD);
                return this.rePickupTask;
            }
            this.pickupFurnace = false;
            this.pickupSmoker = false;
            this.pickupCrafting = false;
            if (BeatMinecraftTask.config.sleepThroughNight && !this.endPortalOpened && WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD) {
                if (WorldHelper.canSleep(this.mod)) {
                    if (this.timer2.elapsed()) {
                        this.timer2.reset();
                    }
                    if (this.timer2.getDuration() >= 30.0 && !this.mod.getPlayer().m_5803_()) {
                        if (this.mod.getEntityTracker().itemDropped(ItemHelper.BED) && this.needsBeds(this.mod)) {
                            this.setDebugState("Resetting sleep through night task.");
                            return new PickupDroppedItemTask(new ItemTarget(ItemHelper.BED), true);
                        }
                        if (this.anyBedsFound(this.mod)) {
                            this.setDebugState("Resetting sleep through night task.");
                            return new DoToClosestBlockTask(DestroyBlockTask::new, ItemHelper.itemsToBlocks(ItemHelper.BED));
                        }
                    }
                    this.setDebugState("Sleeping through night");
                    return this.sleepThroughNightTask;
                }
                if (!itemStorage.hasItem(ItemHelper.BED) && (this.mod.getBlockScanner().anyFound(blockPos -> WorldHelper.canBreak(this.mod, blockPos), ItemHelper.itemsToBlocks(ItemHelper.BED)) || BeatMinecraftTask.isTaskRunning(this.mod, this.getOneBedTask))) {
                    this.setDebugState("Getting one bed to sleep in at night.");
                    return this.getOneBedTask;
                }
            }
            boolean needsEyes = !this.endPortalOpened(this.mod, this.endPortalCenterLocation) && WorldHelper.getCurrentDimension(this.mod) != Dimension.END;
            int filledPortalFrames = this.getFilledPortalFrames(this.mod, this.endPortalCenterLocation);
            int eyesNeededMin = needsEyes ? BeatMinecraftTask.config.minimumEyes - filledPortalFrames : 0;
            int eyesNeeded = needsEyes ? BeatMinecraftTask.config.targetEyes - filledPortalFrames : 0;
            int eyes = itemStorage.getItemCount(Items.f_42545_);
            if (eyes >= eyesNeededMin && (this.ranStrongholdLocator || !this.collectingEyes || eyes >= eyesNeeded)) {
                List<Slot> ironArmors;
                Item[] throwGearItems;
                this.collectingEyes = false;
                if (itemStorage.getItemCount(Items.f_42415_) >= 3 && !itemStorage.hasItem(Items.f_42390_, Items.f_42385_)) {
                    return TaskCatalogue.getItemTask(Items.f_42390_, 1);
                }
                if (itemStorage.getItemCount(Items.f_42416_) >= 3 && !itemStorage.hasItem(Items.f_42390_, Items.f_42385_)) {
                    return TaskCatalogue.getItemTask(Items.f_42385_, 1);
                }
                if (!itemStorage.hasItem(Items.f_42390_, Items.f_42385_, Items.f_42427_)) {
                    return TaskCatalogue.getItemTask(Items.f_42427_, 1);
                }
                if (!itemStorage.hasItem(Items.f_42390_, Items.f_42385_, Items.f_42427_, Items.f_42422_)) {
                    return TaskCatalogue.getItemTask(Items.f_42422_, 1);
                }
                if (WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD) {
                    Optional<BlockPos> silverfish;
                    if (itemStorage.hasItem(Items.f_42390_)) {
                        throwGearItems = new Item[]{Items.f_42425_, Items.f_42427_, Items.f_42383_, Items.f_42385_};
                        ironArmors = itemStorage.getSlotsWithItemPlayerInventory(true, COLLECT_IRON_ARMOR);
                        List<Slot> throwGears = itemStorage.getSlotsWithItemPlayerInventory(true, throwGearItems);
                        if (itemStorage.hasItem(Items.f_42409_) || itemStorage.hasItem(Items.f_42613_)) {
                            for (Slot throwGear : throwGears) {
                                if (Slot.isCursor(throwGear)) {
                                    if (!this.mod.getControllerExtras().isBreakingBlock()) {
                                        LookHelper.randomOrientation(this.controller);
                                    }
                                    this.mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, ClickType.PICKUP);
                                    continue;
                                }
                                this.mod.getSlotHandler().clickSlot(throwGear, 0, ClickType.PICKUP);
                            }
                            for (Slot ironArmor : ironArmors) {
                                if (Slot.isCursor(ironArmor)) {
                                    if (!this.mod.getControllerExtras().isBreakingBlock()) {
                                        LookHelper.randomOrientation(this.controller);
                                    }
                                    this.mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, ClickType.PICKUP);
                                    continue;
                                }
                                this.mod.getSlotHandler().clickSlot(ironArmor, 0, ClickType.PICKUP);
                            }
                        }
                    }
                    this.ranStrongholdLocator = true;
                    if (WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD && this.needsBeds(this.mod)) {
                        this.setDebugState("Getting beds before stronghold search.");
                        if (!this.mod.getBaritone().getExploreProcess().isActive() && this.timer1.elapsed()) {
                            this.timer1.reset();
                        }
                        this.getBedTask = this.getBedTask(this.mod);
                        return this.getBedTask;
                    }
                    this.getBedTask = null;
                    if (!itemStorage.hasItem(Items.f_42447_)) {
                        this.setDebugState("Getting water bucket.");
                        return TaskCatalogue.getItemTask(Items.f_42447_, 1);
                    }
                    if (!itemStorage.hasItem(Items.f_42409_)) {
                        this.setDebugState("Getting flint and steel.");
                        return TaskCatalogue.getItemTask(Items.f_42409_, 1);
                    }
                    if (this.needsBuildingMaterials(this.mod)) {
                        this.setDebugState("Collecting building materials.");
                        return this.buildMaterialsTask;
                    }
                    if (!this.endPortalFound(this.mod, this.endPortalCenterLocation)) {
                        this.setDebugState("Locating End Portal...");
                        return locateStrongholdTask;
                    }
                    if (StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.WOOD) && (silverfish = this.mod.getBlockScanner().getNearestBlock(blockPos -> WorldHelper.getSpawnerEntity(this.mod, blockPos) instanceof Silverfish, Blocks.f_50085_)).isPresent()) {
                        this.setDebugState("Breaking silverfish spawner.");
                        return new DestroyBlockTask(silverfish.get());
                    }
                    if (this.endPortalOpened(this.mod, this.endPortalCenterLocation)) {
                        openingEndPortal = false;
                        if (this.needsBuildingMaterials(this.mod)) {
                            this.setDebugState("Collecting building materials.");
                            return this.buildMaterialsTask;
                        }
                        if (BeatMinecraftTask.config.placeSpawnNearEndPortal && itemStorage.hasItem(ItemHelper.BED) && !this.spawnSetNearPortal(this.mod, this.endPortalCenterLocation)) {
                            this.setDebugState("Setting spawn near end portal");
                            return this.setSpawnNearPortalTask(this.mod);
                        }
                        this.setDebugState("Entering End");
                        this.enterindEndPortal = true;
                        if (!this.mod.getExtraBaritoneSettings().isCanWalkOnEndPortal()) {
                            this.mod.getExtraBaritoneSettings().canWalkOnEndPortal(true);
                        }
                        return new DoToClosestBlockTask(blockPos -> new GetToBlockTask(blockPos.m_7494_()), Blocks.f_50257_);
                    }
                    if (itemStorage.hasItem(Items.f_41999_)) {
                        this.setDebugState("Opening End Portal");
                        openingEndPortal = true;
                        return new DoToClosestBlockTask(blockPos -> new InteractWithBlockTask(Items.f_42545_, (BlockPos)blockPos), blockPos -> !BeatMinecraftTask.isEndPortalFrameFilled(this.mod, blockPos), Blocks.f_50258_);
                    }
                    if (!this.mod.getBlockScanner().anyFoundWithinDistance(10.0, Blocks.f_50080_) && !this.mod.getEntityTracker().itemDropped(Items.f_41999_)) {
                        if (this.repeated > 2 && !itemStorage.hasItem(Items.f_42447_)) {
                            return new CollectBucketLiquidTask.CollectWaterBucketTask(1);
                        }
                        if (!this.waterPlacedTimer.elapsed()) {
                            this.setDebugState("" + this.waterPlacedTimer.getDuration());
                            return null;
                        }
                        if (!itemStorage.hasItem(Items.f_42447_)) {
                            ++this.repeated;
                            this.waterPlacedTimer.reset();
                            return null;
                        }
                        this.repeated = 0;
                        return new PlaceObsidianBucketTask(this.mod.getBlockScanner().getNearestBlock(WorldHelper.toVec3d(this.endPortalCenterLocation), blockPos -> !blockPos.m_123314_((Vec3i)this.endPortalCenterLocation, 8.0), Blocks.f_49991_).get());
                    }
                    if (!itemStorage.hasItem(Items.f_42447_)) {
                        return new CollectBucketLiquidTask.CollectWaterBucketTask(1);
                    }
                    if (!this.waterPlacedTimer.elapsed()) {
                        this.setDebugState("waitin " + this.waterPlacedTimer.getDuration());
                        return null;
                    }
                    return TaskCatalogue.getItemTask(Items.f_41999_, 1);
                }
                if (WorldHelper.getCurrentDimension(this.mod) != Dimension.NETHER) {
                    return null;
                }
                throwGearItems = new Item[]{Items.f_42425_, Items.f_42427_, Items.f_42383_, Items.f_42385_};
                ironArmors = itemStorage.getSlotsWithItemPlayerInventory(true, COLLECT_IRON_ARMOR);
                List<Slot> throwGears = itemStorage.getSlotsWithItemPlayerInventory(true, throwGearItems);
                if (itemStorage.hasItem(Items.f_42409_) || itemStorage.hasItem(Items.f_42613_)) {
                    for (Slot throwGearx : throwGears) {
                        if (Slot.isCursor(throwGearx)) {
                            if (!this.mod.getControllerExtras().isBreakingBlock()) {
                                LookHelper.randomOrientation(this.controller);
                            }
                            this.mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, ClickType.PICKUP);
                            continue;
                        }
                        this.mod.getSlotHandler().clickSlot(throwGearx, 0, ClickType.PICKUP);
                    }
                    for (Slot ironArmorx : ironArmors) {
                        if (Slot.isCursor(ironArmorx)) {
                            if (!this.mod.getControllerExtras().isBreakingBlock()) {
                                LookHelper.randomOrientation(this.controller);
                            }
                            this.mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, ClickType.PICKUP);
                            continue;
                        }
                        this.mod.getSlotHandler().clickSlot(ironArmorx, 0, ClickType.PICKUP);
                    }
                }
                this.setDebugState("Locating End Portal...");
                return locateStrongholdTask;
            }
            this.collectingEyes = true;
            return this.getEyesOfEnderTask(this.mod, eyesNeeded);
        }
        if (!this.mod.getWorld().m_7232_(0, 0)) {
            this.setDebugState("Waiting for chunks to load");
            return null;
        }
        this.updateCachedEndItems(this.mod);
        if (!this.mod.getEntityTracker().itemDropped(ItemHelper.BED) || !this.needsBeds(this.mod) && WorldHelper.getCurrentDimension(this.mod) != Dimension.END) {
            if (!itemStorage.hasItem(Items.f_42385_, Items.f_42390_)) {
                if (this.mod.getEntityTracker().itemDropped(Items.f_42385_)) {
                    return new PickupDroppedItemTask(Items.f_42385_, 1);
                }
                if (this.mod.getEntityTracker().itemDropped(Items.f_42390_)) {
                    return new PickupDroppedItemTask(Items.f_42390_, 1);
                }
            }
            if (!itemStorage.hasItem(Items.f_42447_) && this.mod.getEntityTracker().itemDropped(Items.f_42447_)) {
                return new PickupDroppedItemTask(Items.f_42447_, 1);
            }
            for (Item armorCheck : COLLECT_EYE_ARMOR_END) {
                if (StorageHelper.isArmorEquipped(this.mod, armorCheck)) continue;
                if (itemStorage.hasItem(armorCheck)) {
                    this.setDebugState("Equipping armor.");
                    return new EquipArmorTask(armorCheck);
                }
                if (!this.mod.getEntityTracker().itemDropped(armorCheck)) continue;
                return new PickupDroppedItemTask(armorCheck, 1);
            }
            this.dragonBreathTracker.updateBreath(this.mod);
            for (BlockPos playerIn : WorldHelper.getBlocksTouchingPlayer(this.controller.getPlayer())) {
                if (!this.dragonBreathTracker.isTouchingDragonBreath(playerIn)) continue;
                this.setDebugState("ESCAPE dragons breath");
                this.escapingDragonsBreath = true;
                return this.dragonBreathTracker.getRunAwayTask();
            }
            this.escapingDragonsBreath = false;
            if (this.mod.getBlockScanner().anyFound(Blocks.f_50257_)) {
                this.setDebugState("WOOHOO");
                this.dragonIsDead = true;
                this.enterindEndPortal = true;
                if (!this.mod.getExtraBaritoneSettings().isCanWalkOnEndPortal()) {
                    this.mod.getExtraBaritoneSettings().canWalkOnEndPortal(true);
                }
                return new DoToClosestBlockTask(blockPos -> new GetToBlockTask(blockPos.m_7494_()), pos -> Math.abs(pos.m_123341_()) + Math.abs(pos.m_123343_()) <= 1, Blocks.f_50257_);
            }
            if (!itemStorage.hasItem(ItemHelper.BED) && !this.mod.getBlockScanner().anyFound(ItemHelper.itemsToBlocks(ItemHelper.BED))) {
                this.setDebugState("No beds, regular strats.");
                return new KillEnderDragonTask();
            }
            this.setDebugState("Bed strats");
            return this.killDragonBedStratsTask;
        }
        return new PickupDroppedItemTask(new ItemTarget(ItemHelper.BED), true);
    }

    private Task setSpawnNearPortalTask(PlayerEngineController mod) {
        this.bedSpawnLocation = this.setBedSpawnTask.isSpawnSet() ? this.setBedSpawnTask.getBedSleptPos() : null;
        if (BeatMinecraftTask.isTaskRunning(mod, this.setBedSpawnTask)) {
            this.setDebugState("Setting spawnpoint now.");
            return this.setBedSpawnTask;
        }
        if (WorldHelper.inRangeXZ((Entity)mod.getPlayer(), WorldHelper.toVec3d(this.endPortalCenterLocation), 8.0)) {
            return this.setBedSpawnTask;
        }
        this.setDebugState("Approaching portal (to set spawnpoint)");
        return new GetToXZTask(this.endPortalCenterLocation.m_123341_(), this.endPortalCenterLocation.m_123343_());
    }

    private Task getBlazeRodsTask(PlayerEngineController mod, int count) {
        EntityTracker entityTracker = mod.getEntityTracker();
        if (entityTracker.itemDropped(Items.f_42585_)) {
            Debug.logInternal("Blaze Rod dropped, picking it up.");
            return new PickupDroppedItemTask(Items.f_42585_, 1);
        }
        if (entityTracker.itemDropped(Items.f_42593_)) {
            Debug.logInternal("Blaze Powder dropped, picking it up.");
            return new PickupDroppedItemTask(Items.f_42593_, 1);
        }
        Debug.logInternal("No Blaze Rod or Blaze Powder dropped, collecting Blaze Rods.");
        return new CollectBlazeRodsTask(count);
    }

    private Task getEnderPearlTask(PlayerEngineController mod, int count) {
        Optional<Entity> toKill;
        if (mod.getEntityTracker().itemDropped(Items.f_42584_)) {
            return new PickupDroppedItemTask(Items.f_42584_, 1);
        }
        if (BeatMinecraftTask.config.barterPearlsInsteadOfEndermanHunt) {
            return !StorageHelper.isArmorEquipped(mod, Items.f_42476_) ? new EquipArmorTask(Items.f_42476_) : new TradeWithPiglinsTask(32, Items.f_42584_, count);
        }
        boolean endermanFound = mod.getEntityTracker().entityFound(EnderMan.class);
        boolean pearlDropped = mod.getEntityTracker().itemDropped(Items.f_42584_);
        if ((endermanFound || pearlDropped) && (toKill = mod.getEntityTracker().getClosestEntity(EnderMan.class)).isPresent() && mod.getEntityTracker().isEntityReachable(toKill.get())) {
            return new KillEndermanTask(count);
        }
        this.setDebugState("Waiting for endermen to spawn... ");
        return null;
    }

    private int getTargetBeds(PlayerEngineController mod) {
        boolean needsToSetSpawn = BeatMinecraftTask.config.placeSpawnNearEndPortal && !this.spawnSetNearPortal(mod, this.endPortalCenterLocation) && !BeatMinecraftTask.isTaskRunning(mod, this.setBedSpawnTask);
        int bedsInEnd = Arrays.stream(ItemHelper.BED).mapToInt(bed -> this.cachedEndItemDrops.getOrDefault(bed, 0)).sum();
        int targetBeds = BeatMinecraftTask.config.requiredBeds + (needsToSetSpawn ? 1 : 0) - bedsInEnd;
        Debug.logInternal("needsToSetSpawn: " + needsToSetSpawn);
        Debug.logInternal("bedsInEnd: " + bedsInEnd);
        Debug.logInternal("targetBeds: " + targetBeds);
        return targetBeds;
    }

    private boolean needsBeds(PlayerEngineController mod) {
        int totalEndItems = 0;
        for (Item bed : ItemHelper.BED) {
            totalEndItems += this.cachedEndItemDrops.getOrDefault(bed, 0).intValue();
        }
        int itemCount = mod.getItemStorage().getItemCount(ItemHelper.BED);
        int targetBeds = this.getTargetBeds(mod);
        Debug.logInternal("Total End Items: " + totalEndItems);
        Debug.logInternal("Item Count: " + itemCount);
        Debug.logInternal("Target Beds: " + targetBeds);
        boolean needsBeds = itemCount + totalEndItems < targetBeds;
        Debug.logInternal("Needs Beds: " + needsBeds);
        return needsBeds;
    }

    private Task getBedTask(PlayerEngineController mod) {
        int targetBeds = this.getTargetBeds(mod);
        if (!mod.getItemStorage().hasItem(Items.f_42574_) && !this.anyBedsFound(mod)) {
            Debug.logInternal("Getting shears.");
            return TaskCatalogue.getItemTask(Items.f_42574_, 1);
        }
        Debug.logInternal("Getting beds.");
        return TaskCatalogue.getItemTask("bed", targetBeds);
    }

    private boolean anyBedsFound(PlayerEngineController mod) {
        BlockScanner blockTracker = mod.getBlockScanner();
        EntityTracker entityTracker = mod.getEntityTracker();
        boolean bedsFoundInBlocks = blockTracker.anyFound(ItemHelper.itemsToBlocks(ItemHelper.BED));
        boolean bedsFoundInEntities = entityTracker.itemDropped(ItemHelper.BED);
        if (bedsFoundInBlocks) {
            Debug.logInternal("Beds found in blocks");
        }
        if (bedsFoundInEntities) {
            Debug.logInternal("Beds found in entities");
        }
        return bedsFoundInBlocks || bedsFoundInEntities;
    }

    private BlockPos doSimpleSearchForEndPortal(PlayerEngineController mod) {
        List<BlockPos> frames = mod.getBlockScanner().getKnownLocations(Blocks.f_50258_);
        if (frames.size() >= 12) {
            Vec3 average = frames.stream().reduce(Vec3.f_82478_, (accum, bpos) -> accum.m_82520_((double)((int)Math.round((double)bpos.m_123341_() + 0.5)), (double)((int)Math.round((double)bpos.m_123342_() + 0.5)), (double)((int)Math.round((double)bpos.m_123343_() + 0.5))), Vec3::m_82549_).m_82490_(1.0 / (double)frames.size());
            mod.log("Average Position: " + String.valueOf(average));
            return new BlockPos(new Vec3i((int)average.f_82479_, (int)average.f_82480_, (int)average.f_82481_));
        }
        Debug.logInternal("Not enough frames");
        return null;
    }

    private int getFilledPortalFrames(PlayerEngineController mod, BlockPos endPortalCenter) {
        if (endPortalCenter == null) {
            return 0;
        }
        List<BlockPos> frameBlocks = BeatMinecraftTask.getFrameBlocks(mod, endPortalCenter);
        if (frameBlocks.stream().allMatch(blockPos -> mod.getChunkTracker().isChunkLoaded((BlockPos)blockPos))) {
            this.cachedFilledPortalFrames = frameBlocks.stream().mapToInt(blockPos -> {
                boolean isFilled = BeatMinecraftTask.isEndPortalFrameFilled(mod, blockPos);
                if (isFilled) {
                    Debug.logInternal("Portal frame at " + String.valueOf(blockPos) + " is filled.");
                } else {
                    Debug.logInternal("Portal frame at " + String.valueOf(blockPos) + " is not filled.");
                }
                return isFilled ? 1 : 0;
            }).sum();
        }
        return this.cachedFilledPortalFrames;
    }

    private boolean canBeLootablePortalChest(PlayerEngineController mod, BlockPos blockPos) {
        return mod.getWorld().m_8055_(blockPos.m_7494_()).m_60734_() != Blocks.f_49990_ && blockPos.m_123342_() >= 50;
    }

    private Task getEyesOfEnderTask(PlayerEngineController mod, int targetEyes) {
        boolean needsEnderPearls;
        if (mod.getEntityTracker().itemDropped(Items.f_42545_)) {
            this.setDebugState("Picking up Dropped Eyes");
            return new PickupDroppedItemTask(Items.f_42545_, targetEyes);
        }
        int eyeCount = mod.getItemStorage().getItemCount(Items.f_42545_);
        int blazePowderCount = mod.getItemStorage().getItemCount(Items.f_42593_);
        int blazeRodCount = mod.getItemStorage().getItemCount(Items.f_42585_);
        int blazeRodTarget = (int)Math.ceil((double)(targetEyes - eyeCount - blazePowderCount) / 2.0);
        int enderPearlTarget = targetEyes - eyeCount;
        boolean needsBlazeRods = blazeRodCount < blazeRodTarget;
        boolean needsBlazePowder = eyeCount + blazePowderCount < targetEyes;
        boolean bl = needsEnderPearls = mod.getItemStorage().getItemCount(Items.f_42584_) < enderPearlTarget;
        if (needsBlazePowder && !needsBlazeRods) {
            this.setDebugState("Crafting blaze powder");
            return TaskCatalogue.getItemTask(Items.f_42593_, targetEyes - eyeCount);
        }
        if (!needsBlazePowder && !needsEnderPearls) {
            this.setDebugState("Crafting Ender Eyes");
            return TaskCatalogue.getItemTask(Items.f_42545_, targetEyes);
        }
        switch (WorldHelper.getCurrentDimension(mod)) {
            case OVERWORLD: {
                PriorityTask toGather = null;
                double maxPriority = 0.0;
                if (!this.gatherResources.isEmpty()) {
                    if (!this.forcedTaskTimer.elapsed() && BeatMinecraftTask.isTaskRunning(mod, this.lastTask) && this.lastGather != null && this.lastGather.calculatePriority(mod) > 0.0) {
                        return this.lastTask;
                    }
                    if (!this.changedTaskTimer.elapsed() && this.lastTask != null && !this.lastGather.bypassForceCooldown && BeatMinecraftTask.isTaskRunning(mod, this.lastTask)) {
                        return this.lastTask;
                    }
                    if (BeatMinecraftTask.isTaskRunning(mod, this.lastTask) && this.lastGather != null && this.lastGather.shouldForce()) {
                        return this.lastTask;
                    }
                    for (PriorityTask gatherResource : this.gatherResources) {
                        double priority = gatherResource.calculatePriority(mod);
                        if (!(priority > maxPriority)) continue;
                        maxPriority = priority;
                        toGather = gatherResource;
                    }
                }
                if (toGather != null) {
                    boolean sameTask = this.lastGather == toGather;
                    this.setDebugState("Priority: " + String.format(Locale.US, "%.2f", maxPriority) + ", " + String.valueOf(toGather));
                    if (!sameTask && this.prevLastGather == toGather && this.lastTask != null && this.lastGather.calculatePriority(mod) > 0.0 && BeatMinecraftTask.isTaskRunning(mod, this.lastTask)) {
                        mod.logWarning("might be stuck or switching too much, forcing current resource for a bit more");
                        this.changedTaskTimer.reset();
                        this.prevLastGather = null;
                        this.setDebugState("Priority: FORCED, " + String.valueOf(this.lastGather));
                        return this.lastTask;
                    }
                    if (sameTask && toGather.canCache()) {
                        return this.lastTask;
                    }
                    if (!sameTask) {
                        this.taskChanges.add(0, new TaskChange(this.lastGather, toGather, mod.getPlayer().m_20183_()));
                    }
                    if (this.taskChanges.size() >= 3 && !sameTask) {
                        TaskChange t1 = this.taskChanges.get(0);
                        TaskChange t2 = this.taskChanges.get(1);
                        TaskChange t3 = this.taskChanges.get(2);
                        if (t1.original == t2.interrupt && t1.pos.m_123314_((Vec3i)t3.pos, 5.0) && t3.original == t1.interrupt) {
                            this.forcedTaskTimer.reset();
                            mod.logWarning("Probably stuck! Forcing timer...");
                            this.taskChanges.clear();
                            return this.lastTask;
                        }
                        if (this.taskChanges.size() > 3) {
                            this.taskChanges.remove(this.taskChanges.size() - 1);
                        }
                    }
                    this.prevLastGather = this.lastGather;
                    this.lastGather = toGather;
                    Task task = toGather.getTask(mod);
                    if (!sameTask) {
                        if (this.lastTask instanceof SmeltInFurnaceTask && !(task instanceof SmeltInFurnaceTask) && !mod.getItemStorage().hasItem(Items.f_41962_)) {
                            this.pickupFurnace = true;
                            this.lastGather = null;
                            this.lastTask = null;
                            return null;
                        }
                        if (this.lastTask instanceof SmeltInSmokerTask && !(task instanceof SmeltInSmokerTask) && !mod.getItemStorage().hasItem(Items.f_42769_)) {
                            this.pickupSmoker = true;
                            this.lastGather = null;
                            this.lastTask = null;
                            return null;
                        }
                        if (this.lastTask != null && task != null && !toGather.needCraftingOnStart(mod)) {
                            this.pickupCrafting = true;
                            this.lastGather = null;
                            this.lastTask = null;
                            return null;
                        }
                    }
                    this.lastTask = task;
                    this.changedTaskTimer.reset();
                    return task;
                }
                if (this.needsBuildingMaterials(mod)) {
                    this.setDebugState("Collecting building materials.");
                    return this.buildMaterialsTask;
                }
                this.setDebugState("Going to Nether");
                ItemStorageTracker itemStorageTracker1 = mod.getItemStorage();
                if (itemStorageTracker1.getItemCount(Items.f_42415_) >= 3 && !itemStorageTracker1.hasItem(Items.f_42390_, Items.f_42385_)) {
                    return TaskCatalogue.getItemTask(Items.f_42390_, 1);
                }
                if (itemStorageTracker1.getItemCount(Items.f_42416_) >= 3 && !itemStorageTracker1.hasItem(Items.f_42390_, Items.f_42385_)) {
                    return TaskCatalogue.getItemTask(Items.f_42385_, 1);
                }
                if (!itemStorageTracker1.hasItem(Items.f_42390_, Items.f_42385_, Items.f_42427_)) {
                    return TaskCatalogue.getItemTask(Items.f_42427_, 1);
                }
                if (!itemStorageTracker1.hasItem(Items.f_42390_, Items.f_42385_, Items.f_42427_, Items.f_42422_)) {
                    return TaskCatalogue.getItemTask(Items.f_42422_, 1);
                }
                this.gatherResources.clear();
                if (!(this.lastTask instanceof DefaultGoToDimensionTask)) {
                    this.goToNetherTask = new DefaultGoToDimensionTask(Dimension.NETHER);
                }
                this.lastTask = this.goToNetherTask;
                return this.goToNetherTask;
            }
            case NETHER: {
                if (BeatMinecraftTask.isTaskRunning(mod, this.safeNetherPortalTask)) {
                    return this.safeNetherPortalTask;
                }
                if (mod.getPlayer().m_287157_() != 0 && this.safeNetherPortalTask == null) {
                    this.safeNetherPortalTask = new SafeNetherPortalTask();
                    return this.safeNetherPortalTask;
                }
                mod.getInputControls().release(Input.MOVE_FORWARD);
                mod.getInputControls().release(Input.MOVE_LEFT);
                mod.getInputControls().release(Input.SNEAK);
                BlockPos pos = mod.getPlayer().m_20097_();
                if (this.escaped || !mod.getWorld().m_8055_(pos).m_60734_().equals(Blocks.f_50135_) || !mod.getWorld().m_8055_(pos.m_122029_()).m_60734_().equals(Blocks.f_50080_) && !mod.getWorld().m_8055_(pos.m_122024_()).m_60734_().equals(Blocks.f_50080_) && !mod.getWorld().m_8055_(pos.m_122019_()).m_60734_().equals(Blocks.f_50080_) && !mod.getWorld().m_8055_(pos.m_122012_()).m_60734_().equals(Blocks.f_50080_)) {
                    ItemStorageTracker itemStorage;
                    if (!this.escaped) {
                        this.escaped = true;
                        mod.getInputControls().release(Input.CLICK_LEFT);
                    }
                    if ((itemStorage = mod.getItemStorage()).getItemCount(Items.f_42415_) >= 3 && !itemStorage.hasItem(Items.f_42390_, Items.f_42385_)) {
                        return TaskCatalogue.getItemTask(Items.f_42390_, 1);
                    }
                    if (itemStorage.getItemCount(Items.f_42416_) >= 3 && !itemStorage.hasItem(Items.f_42390_, Items.f_42385_)) {
                        return TaskCatalogue.getItemTask(Items.f_42385_, 1);
                    }
                    if (!itemStorage.hasItem(Items.f_42390_, Items.f_42385_, Items.f_42427_)) {
                        return TaskCatalogue.getItemTask(Items.f_42427_, 1);
                    }
                    if (!itemStorage.hasItem(Items.f_42390_, Items.f_42385_, Items.f_42427_, Items.f_42422_)) {
                        return TaskCatalogue.getItemTask(Items.f_42422_, 1);
                    }
                    if (mod.getItemStorage().getItemCount(Items.f_42585_) * 2 + mod.getItemStorage().getItemCount(Items.f_42593_) + mod.getItemStorage().getItemCount(Items.f_42545_) >= 14) {
                        this.hasRods = true;
                    }
                    double rodDistance = mod.getBlockScanner().distanceToClosest(Blocks.f_50197_);
                    double pearlDistance = mod.getBlockScanner().distanceToClosest(Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50688_, Blocks.f_50690_);
                    if (pearlDistance == Double.POSITIVE_INFINITY && rodDistance == Double.POSITIVE_INFINITY) {
                        this.setDebugState("Neither fortress or warped forest found... wandering");
                        if (BeatMinecraftTask.isTaskRunning(mod, this.searchTask)) {
                            return this.searchTask;
                        }
                        this.searchTask = new SearchChunkForBlockTask(Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50688_, Blocks.f_50690_, Blocks.f_50197_);
                        return this.searchTask;
                    }
                    if ((!(rodDistance < pearlDistance) || this.hasRods || this.gettingPearls) && needsEnderPearls) {
                        if (!mod.getBlockScanner().anyFound(Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50688_, Blocks.f_50690_)) {
                            return new TimeoutWanderTask();
                        }
                        if (!(this.gotToBiome || this.biomePos != null && WorldHelper.inRangeXZ((Entity)mod.getPlayer(), this.biomePos, 30.0) && mod.getBaritone().getPathingBehavior().isSafeToCancel())) {
                            if (this.biomePos != null) {
                                this.setDebugState("Going to biome");
                                return new GetWithinRangeOfBlockTask(this.biomePos, 20);
                            }
                            this.gettingPearls = true;
                            this.setDebugState("Getting Ender Pearls");
                            Optional<BlockPos> closestBlock = mod.getBlockScanner().getNearestBlock(Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50688_, Blocks.f_50690_);
                            if (closestBlock.isPresent()) {
                                this.biomePos = closestBlock.get();
                            } else {
                                this.setDebugState("biome not found, wandering");
                            }
                            return new TimeoutWanderTask();
                        }
                        this.gotToBiome = true;
                        return this.getEnderPearlTask(mod, enderPearlTarget);
                    }
                    if (!this.gotToFortress) {
                        if (mod.getBlockScanner().anyFoundWithinDistance(5.0, Blocks.f_50197_)) {
                            this.gotToFortress = true;
                        } else {
                            if (!mod.getBlockScanner().anyFound(Blocks.f_50197_)) {
                                this.setDebugState("Searching for fortress");
                                return new TimeoutWanderTask();
                            }
                            if (WorldHelper.inRangeXZ(mod.getPlayer().m_20182_(), WorldHelper.toVec3d(mod.getBlockScanner().getNearestBlock(Blocks.f_50197_).get()), 2.0)) {
                                this.setDebugState("trying to get to fortress");
                                return new GetToBlockTask(mod.getBlockScanner().getNearestBlock(Blocks.f_50197_).get());
                            }
                            this.setDebugState("Getting close to fortress");
                            if ((this.cachedFortressTask != null && !this.fortressTimer.elapsed() && mod.getPlayer().m_20182_().m_82554_(WorldHelper.toVec3d(this.cachedFortressTask.blockPos)) - 1.0 > (double)this.prevPos.m_123333_((Vec3i)this.cachedFortressTask.blockPos) / 2.0 || !mod.getBaritone().getPathingBehavior().isSafeToCancel()) && this.cachedFortressTask != null) {
                                mod.log(mod.getPlayer().m_20182_().m_82554_(WorldHelper.toVec3d(this.cachedFortressTask.blockPos)) + " : " + mod.getPlayer().m_20182_().m_82554_(WorldHelper.toVec3d(this.cachedFortressTask.blockPos)));
                                return this.cachedFortressTask;
                            }
                            if (this.resetFortressTask) {
                                this.resetFortressTask = false;
                                return null;
                            }
                            this.resetFortressTask = true;
                            this.fortressTimer.reset();
                            mod.log("new");
                            this.prevPos = mod.getPlayer().m_20183_();
                            BlockPos p = mod.getBlockScanner().getNearestBlock(Blocks.f_50197_).get();
                            int distance = (int)(mod.getPlayer().m_20182_().m_82554_(WorldHelper.toVec3d(p)) / 2.0);
                            if (this.cachedFortressTask != null) {
                                distance = Math.min(this.cachedFortressTask.range - 1, distance);
                            }
                            if (distance >= 0) {
                                this.cachedFortressTask = new GetWithinRangeOfBlockTask(p, distance);
                                return this.cachedFortressTask;
                            }
                            this.gotToFortress = true;
                        }
                    }
                    this.setDebugState("Getting Blaze Rods");
                    return this.getBlazeRodsTask(mod, blazeRodTarget);
                }
                LookHelper.lookAt(mod, pos);
                mod.getInputControls().hold(Input.CLICK_LEFT);
                return null;
            }
            case END: {
                throw new UnsupportedOperationException("You're in the end. Don't collect eyes here.");
            }
        }
        return null;
    }

    static {
        openingEndPortal = false;
        ConfigHelper.loadConfig("configs/beat_minecraft.json", BeatMinecraftConfig::new, BeatMinecraftConfig.class, newConfig -> {
            config = newConfig;
        });
    }

    private class DistanceOrePriorityCalculator
    extends DistanceItemPriorityCalculator {
        private final Item oreItem;

        public DistanceOrePriorityCalculator(Item oreItem, double multiplier, double unneededMultiplier, double unneededDistanceThreshold, int minCount, int maxCount) {
            super(multiplier, unneededMultiplier, unneededDistanceThreshold, minCount, maxCount);
            this.oreItem = oreItem;
        }

        @Override
        public void update(int count) {
            super.update(BeatMinecraftTask.getCountWithCraftedFromOre(BeatMinecraftTask.this.mod, this.oreItem));
        }
    }

    private record TaskChange(PriorityTask original, PriorityTask interrupt, BlockPos pos) {
    }
}

