/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.tasks.resources.CollectFoodTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.ItemPriorityCalculator;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.slots.Slot;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.state.BlockState;

public class CollectFoodPriorityCalculator
extends ItemPriorityCalculator {
    private final PlayerEngineController mod;
    private final double foodUnits;

    public CollectFoodPriorityCalculator(PlayerEngineController mod, double foodUnits) {
        super(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.mod = mod;
        this.foodUnits = foodUnits;
    }

    @Override
    public double calculatePriority(int count) {
        double distance = this.getDistance(this.mod);
        double multiplier = 1.0;
        double foodPotential = CollectFoodTask.calculateFoodPotential(this.mod);
        if (Double.isInfinite(distance) && foodPotential < this.foodUnits) {
            return 0.1;
        }
        Optional<BlockPos> hay = this.mod.getBlockScanner().getNearestBlock(Blocks.f_50335_);
        if (hay.isPresent() && WorldHelper.inRangeXZ(hay.get(), this.mod.getPlayer().m_20183_(), 75.0) || this.mod.getEntityTracker().itemDropped(Items.f_42129_)) {
            multiplier = 50.0;
        }
        if (foodPotential > this.foodUnits) {
            if (foodPotential > this.foodUnits + 20.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return distance > 10.0 && hay.isEmpty() ? Double.NEGATIVE_INFINITY : 17.0 / distance * 30.0 / (double)count / 2.0 * multiplier;
        }
        if (foodPotential < 10.0) {
            multiplier = Math.max(11.0 / foodPotential, 22.0);
        }
        return 33.0 / distance * 37.0 * multiplier;
    }

    private double getDistance(PlayerEngineController mod) {
        double dist;
        LivingEntity clientPlayerEntity = mod.getPlayer();
        for (Item item : CollectFoodTask.ITEMS_TO_PICK_UP) {
            dist = this.pickupTaskOrNull(mod, item);
            if (dist == Double.NEGATIVE_INFINITY) continue;
            return dist;
        }
        for (CollectFoodTask.CookableFoodTarget cookableFoodTarget : CollectFoodTask.COOKABLE_FOODS) {
            dist = this.pickupTaskOrNull(mod, cookableFoodTarget.getRaw(), 20.0);
            if (dist == Double.NEGATIVE_INFINITY) {
                dist = this.pickupTaskOrNull(mod, cookableFoodTarget.getCooked(), 40.0);
            }
            if (dist == Double.NEGATIVE_INFINITY) continue;
            return dist;
        }
        double d = this.pickupBlockTaskOrNull(mod, Blocks.f_50335_, Items.f_42129_, 300.0);
        if (d != Double.NEGATIVE_INFINITY) {
            return d;
        }
        for (CollectFoodTask.CropTarget target : CollectFoodTask.CROPS) {
            double t = this.pickupBlockTaskOrNull(mod, target.cropBlock, target.cropItem, blockPos -> {
                BlockState s = mod.getWorld().m_8055_(blockPos);
                Block b = s.m_60734_();
                if (b instanceof CropBlock) {
                    boolean isWheat;
                    boolean bl = isWheat = !(b instanceof PotatoBlock) && !(b instanceof CarrotBlock) && !(b instanceof BeetrootBlock);
                    if (isWheat) {
                        if (!mod.getChunkTracker().isChunkLoaded((BlockPos)blockPos)) {
                            return false;
                        }
                        CropBlock crop = (CropBlock)b;
                        return crop.m_52307_(s);
                    }
                }
                return WorldHelper.canBreak(mod, blockPos);
            }, 96.0);
            if (t == Double.NEGATIVE_INFINITY) continue;
            return t;
        }
        double bestScore = 0.0;
        Entity bestEntity = null;
        Predicate<Entity> notBaby = entity -> {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_6162_()) {
                // empty if block
            }
            return false;
        };
        for (CollectFoodTask.CookableFoodTarget cookable : CollectFoodTask.COOKABLE_FOODS) {
            double sqDistance;
            int hungerPerformance;
            double score;
            Optional<Entity> nearest;
            if (!mod.getEntityTracker().entityFound(cookable.mobToKill) || (nearest = mod.getEntityTracker().getClosestEntity(mod.getPlayer().m_20182_(), notBaby, cookable.mobToKill)).isEmpty() || !((score = 100.0 * (double)(hungerPerformance = cookable.getCookedUnits()) / (sqDistance = nearest.get().m_20280_((Entity)mod.getPlayer()))) > bestScore)) continue;
            bestScore = score;
            bestEntity = nearest.get();
        }
        if (bestEntity != null) {
            return bestEntity.m_20270_((Entity)clientPlayerEntity);
        }
        double berryPickup = this.pickupBlockTaskOrNull(mod, Blocks.f_50685_, Items.f_42780_, 96.0);
        return berryPickup != Double.NEGATIVE_INFINITY ? berryPickup : Double.POSITIVE_INFINITY;
    }

    private double pickupBlockTaskOrNull(PlayerEngineController mod, Block blockToCheck, Item itemToGrab, double maxRange) {
        return this.pickupBlockTaskOrNull(mod, blockToCheck, itemToGrab, toAccept -> true, maxRange);
    }

    private double pickupBlockTaskOrNull(PlayerEngineController mod, Block blockToCheck, Item itemToGrab, Predicate<BlockPos> accept, double maxRange) {
        Predicate<BlockPos> acceptPlus = blockPos -> !WorldHelper.canBreak(mod, blockPos) ? false : accept.test((BlockPos)blockPos);
        Optional<Object> nearestBlock = mod.getBlockScanner().getNearestBlock(mod.getPlayer().m_20182_(), acceptPlus, blockToCheck);
        if (nearestBlock.isPresent() && !nearestBlock.get().m_203195_((Position)mod.getPlayer().m_20182_(), maxRange)) {
            nearestBlock = Optional.empty();
        }
        Optional<Object> nearestDrop = Optional.empty();
        if (mod.getEntityTracker().itemDropped(itemToGrab)) {
            nearestDrop = mod.getEntityTracker().getClosestItemDrop(mod.getPlayer().m_20182_(), itemToGrab);
        }
        if (nearestDrop.isPresent()) {
            return ((ItemEntity)nearestDrop.get()).m_20270_((Entity)mod.getPlayer());
        }
        return nearestBlock.isPresent() ? Math.sqrt(mod.getPlayer().m_20238_(WorldHelper.toVec3d((BlockPos)nearestBlock.get()))) : Double.NEGATIVE_INFINITY;
    }

    private double pickupTaskOrNull(PlayerEngineController mod, Item itemToGrab) {
        return this.pickupTaskOrNull(mod, itemToGrab, Double.POSITIVE_INFINITY);
    }

    private double pickupTaskOrNull(PlayerEngineController mod, Item itemToGrab, double maxRange) {
        Optional<Object> nearestDrop = Optional.empty();
        if (mod.getEntityTracker().itemDropped(itemToGrab)) {
            nearestDrop = mod.getEntityTracker().getClosestItemDrop(mod.getPlayer().m_20182_(), itemToGrab);
        }
        if (nearestDrop.isPresent() && ((ItemEntity)nearestDrop.get()).m_19950_((Entity)mod.getPlayer(), maxRange)) {
            ItemStack stack;
            Optional<Slot> slot;
            if (mod.getItemStorage().getSlotsThatCanFitInPlayerInventory(((ItemEntity)nearestDrop.get()).m_32055_(), false).isEmpty() && (slot = StorageHelper.getGarbageSlot(mod)).isPresent() && ItemVer.isFood((stack = StorageHelper.getItemStackInSlot(slot.get())).m_41720_())) {
                int inventoryCost = ItemVer.getFoodComponent(stack.m_41720_()).getHunger() * stack.m_41613_();
                double hunger = 0.0;
                if (ItemVer.isFood(itemToGrab)) {
                    hunger = ItemVer.getFoodComponent(itemToGrab).getHunger();
                } else if (itemToGrab.equals(Items.f_42405_)) {
                    hunger += (double)ItemVer.getFoodComponent(Items.f_42406_).getHunger() / 3.0;
                } else {
                    mod.log("unknown food item: " + String.valueOf(itemToGrab));
                }
                int groundCost = (int)(hunger * (double)((ItemEntity)nearestDrop.get()).m_32055_().m_41613_());
                if (inventoryCost > groundCost) {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            return ((ItemEntity)nearestDrop.get()).m_20270_((Entity)mod.getPlayer());
        }
        return Double.NEGATIVE_INFINITY;
    }
}

