/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class AdditionalBaritoneSettings {
    private final Object breakMutex = new Object();
    private final Object placeMutex = new Object();
    private final Object propertiesMutex = new Object();
    private final Object globalHeuristicMutex = new Object();
    private final HashSet<class_2338> blocksToAvoidBreaking = new HashSet();
    private final List<Predicate<class_2338>> breakAvoiders = new ArrayList<Predicate<class_2338>>();
    private final List<Predicate<class_2338>> placeAvoiders = new ArrayList<Predicate<class_2338>>();
    private final List<Predicate<class_2338>> forceCanWalkOn = new ArrayList<Predicate<class_2338>>();
    private final List<Predicate<class_2338>> forceAvoidWalkThrough = new ArrayList<Predicate<class_2338>>();
    private final List<BiPredicate<class_2680, class_1799>> forceSaveTool = new ArrayList<BiPredicate<class_2680, class_1799>>();
    private final List<BiPredicate<class_2680, class_1799>> forceUseTool = new ArrayList<BiPredicate<class_2680, class_1799>>();
    private final List<BiFunction<Double, class_2338, Double>> globalHeuristics = new ArrayList<BiFunction<Double, class_2338, Double>>();
    private final HashSet<class_1792> protectedItems = new HashSet();
    private boolean allowFlowingWaterPass;
    private boolean pauseInteractions;
    private boolean dontPlaceBucketButStillFall;
    private boolean allowSwimThroughLava = false;
    private boolean treatSoulSandAsOrdinaryBlock = false;
    private boolean canWalkOnEndPortal = false;

    public void canWalkOnEndPortal(boolean canWalk) {
        this.canWalkOnEndPortal = canWalk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void avoidBlockBreak(class_2338 pos) {
        Object object = this.breakMutex;
        synchronized (object) {
            this.blocksToAvoidBreaking.add(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void avoidBlockBreak(Predicate<class_2338> avoider) {
        Object object = this.breakMutex;
        synchronized (object) {
            this.breakAvoiders.add(avoider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurePlaceBucketButDontFall(boolean allow) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.dontPlaceBucketButStillFall = allow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void treatSoulSandAsOrdinaryBlock(boolean enable) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.treatSoulSandAsOrdinaryBlock = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void avoidBlockPlace(Predicate<class_2338> avoider) {
        Object object = this.placeMutex;
        synchronized (object) {
            this.placeAvoiders.add(avoider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldForceSaveTool(class_2680 state, class_1799 tool) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.forceSaveTool.stream().anyMatch(pred -> pred.test(state, tool));
        }
    }

    public boolean shouldAvoidBreaking(int x, int y, int z) {
        return this.shouldAvoidBreaking(new class_2338(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAvoidBreaking(class_2338 pos) {
        Object object = this.breakMutex;
        synchronized (object) {
            return this.blocksToAvoidBreaking.contains(pos) ? true : this.breakAvoiders.stream().anyMatch(pred -> pred.test(pos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAvoidPlacingAt(class_2338 pos) {
        Object object = this.placeMutex;
        synchronized (object) {
            return this.placeAvoiders.stream().anyMatch(pred -> pred.test(pos));
        }
    }

    public boolean shouldAvoidPlacingAt(int x, int y, int z) {
        return this.shouldAvoidPlacingAt(new class_2338(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWalkOnForce(int x, int y, int z) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.forceCanWalkOn.stream().anyMatch(pred -> pred.test(new class_2338(x, y, z)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAvoidWalkThroughForce(class_2338 pos) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.forceAvoidWalkThrough.stream().anyMatch(pred -> pred.test(pos));
        }
    }

    public boolean shouldAvoidWalkThroughForce(int x, int y, int z) {
        return this.shouldAvoidWalkThroughForce(new class_2338(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldForceUseTool(class_2680 state, class_1799 tool) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.forceUseTool.stream().anyMatch(pred -> pred.test(state, tool));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldNotPlaceBucketButStillFall() {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.dontPlaceBucketButStillFall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldTreatSoulSandAsOrdinaryBlock() {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.treatSoulSandAsOrdinaryBlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInteractionPaused() {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.pauseInteractions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInteractionPaused(boolean paused) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.pauseInteractions = paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFlowingWaterPassAllowed() {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.allowFlowingWaterPass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSwimThroughLava() {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.allowSwimThroughLava;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlowingWaterPass(boolean pass) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.allowFlowingWaterPass = pass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowSwimThroughLava(boolean allow) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.allowSwimThroughLava = allow;
        }
    }

    public double applyGlobalHeuristic(double prev, int x, int y, int z) {
        return prev;
    }

    public HashSet<class_2338> getBlocksToAvoidBreaking() {
        return this.blocksToAvoidBreaking;
    }

    public List<Predicate<class_2338>> getBreakAvoiders() {
        return this.breakAvoiders;
    }

    public List<Predicate<class_2338>> getPlaceAvoiders() {
        return this.placeAvoiders;
    }

    public List<Predicate<class_2338>> getForceWalkOnPredicates() {
        return this.forceCanWalkOn;
    }

    public List<Predicate<class_2338>> getForceAvoidWalkThroughPredicates() {
        return this.forceAvoidWalkThrough;
    }

    public List<BiPredicate<class_2680, class_1799>> getForceSaveToolPredicates() {
        return this.forceSaveTool;
    }

    public List<BiPredicate<class_2680, class_1799>> getForceUseToolPredicates() {
        return this.forceUseTool;
    }

    public List<BiFunction<Double, class_2338, Double>> getGlobalHeuristics() {
        return this.globalHeuristics;
    }

    public boolean isItemProtected(class_1792 item) {
        return this.protectedItems.contains(item);
    }

    public HashSet<class_1792> getProtectedItems() {
        return this.protectedItems;
    }

    public void protectItem(class_1792 item) {
        this.protectedItems.add(item);
    }

    public void stopProtectingItem(class_1792 item) {
        this.protectedItems.remove(item);
    }

    public Object getBreakMutex() {
        return this.breakMutex;
    }

    public Object getPlaceMutex() {
        return this.placeMutex;
    }

    public Object getPropertiesMutex() {
        return this.propertiesMutex;
    }

    public Object getGlobalHeuristicMutex() {
        return this.globalHeuristicMutex;
    }

    public boolean isCanWalkOnEndPortal() {
        return this.canWalkOnEndPortal;
    }
}

