/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.pathing.goals;

import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalXZ;
import com.player2.playerengine.automaton.api.pathing.goals.GoalYLevel;
import com.player2.playerengine.automaton.api.utils.SettingsUtil;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import java.util.Arrays;
import net.minecraft.class_2338;

public class GoalRunAway
implements Goal {
    private final class_2338[] from;
    private final int distanceSq;
    private final Integer maintainY;

    public GoalRunAway(double distance, class_2338 ... from) {
        this(distance, (Integer)null, from);
    }

    public GoalRunAway(double distance, Integer maintainY, class_2338 ... from) {
        if (from.length == 0) {
            throw new IllegalArgumentException();
        }
        this.from = from;
        this.distanceSq = (int)(distance * distance);
        this.maintainY = maintainY;
    }

    @Override
    public boolean isInGoal(int x, int y, int z) {
        if (this.maintainY != null && this.maintainY != y) {
            return false;
        }
        for (class_2338 p : this.from) {
            int diffZ;
            int diffX = x - p.method_10263();
            int distSq = diffX * diffX + (diffZ = z - p.method_10260()) * diffZ;
            if (distSq >= this.distanceSq) continue;
            return false;
        }
        return true;
    }

    @Override
    public double heuristic(int x, int y, int z) {
        double min = Double.MAX_VALUE;
        for (class_2338 p : this.from) {
            double h = GoalXZ.calculate(p.method_10263() - x, p.method_10260() - z);
            if (!(h < min)) continue;
            min = h;
        }
        min = -min;
        if (this.maintainY != null) {
            min = min * 0.6 + GoalYLevel.calculate(this.maintainY, y) * 1.5;
        }
        return min;
    }

    @Override
    public double heuristic() {
        int distance = (int)Math.ceil(Math.sqrt(this.distanceSq));
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 p : this.from) {
            minX = Math.min(minX, p.method_10263() - distance);
            minY = Math.min(minY, p.method_10264() - distance);
            minZ = Math.min(minZ, p.method_10260() - distance);
            maxX = Math.max(minX, p.method_10263() + distance);
            maxY = Math.max(minY, p.method_10264() + distance);
            maxZ = Math.max(minZ, p.method_10260() + distance);
        }
        DoubleOpenHashSet maybeAlwaysInside = new DoubleOpenHashSet();
        double minOutside = Double.POSITIVE_INFINITY;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    double h = this.heuristic(x, y, z);
                    if (h < minOutside && this.isInGoal(x, y, z)) {
                        maybeAlwaysInside.add(h);
                        continue;
                    }
                    minOutside = Math.min(minOutside, h);
                }
            }
        }
        double maxInside = Double.NEGATIVE_INFINITY;
        DoubleIterator it = maybeAlwaysInside.iterator();
        while (it.hasNext()) {
            double inside = it.nextDouble();
            if (!(inside < minOutside)) continue;
            maxInside = Math.max(maxInside, inside);
        }
        return maxInside;
    }

    public String toString() {
        return this.maintainY != null ? String.format("GoalRunAwayFromMaintainY y=%s, %s", SettingsUtil.maybeCensor(this.maintainY), Arrays.asList(this.from)) : "GoalRunAwayFrom" + String.valueOf(Arrays.asList(this.from));
    }
}

