/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4770;

public final class RotationUtils {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    private static final class_243[] BLOCK_SIDE_MULTIPLIERS = new class_243[]{new class_243(0.5, 0.0, 0.5), new class_243(0.5, 1.0, 0.5), new class_243(0.5, 0.5, 0.0), new class_243(0.5, 0.5, 1.0), new class_243(0.0, 0.5, 0.5), new class_243(1.0, 0.5, 0.5)};

    private RotationUtils() {
    }

    public static Rotation calcRotationFromCoords(class_2338 orig, class_2338 dest) {
        return RotationUtils.calcRotationFromVec3d(new class_243((double)orig.method_10263(), (double)orig.method_10264(), (double)orig.method_10260()), new class_243((double)dest.method_10263(), (double)dest.method_10264(), (double)dest.method_10260()));
    }

    public static Rotation wrapAnglesToRelative(Rotation current, Rotation target) {
        return current.yawIsReallyClose(target) ? new Rotation(current.getYaw(), target.getPitch()) : target.subtract(current).normalize().add(current);
    }

    public static Rotation calcRotationFromVec3d(class_243 orig, class_243 dest, Rotation current) {
        return RotationUtils.wrapAnglesToRelative(current, RotationUtils.calcRotationFromVec3d(orig, dest));
    }

    public static Rotation calcRotationFromVec3d(class_243 orig, class_243 dest) {
        double[] delta = new double[]{orig.field_1352 - dest.field_1352, orig.field_1351 - dest.field_1351, orig.field_1350 - dest.field_1350};
        double yaw = class_3532.method_15349((double)delta[0], (double)(-delta[2]));
        double dist = Math.sqrt(delta[0] * delta[0] + delta[2] * delta[2]);
        double pitch = class_3532.method_15349((double)delta[1], (double)dist);
        return new Rotation((float)(yaw * 57.29577951308232), (float)(pitch * 57.29577951308232));
    }

    public static class_243 calcVector3dFromRotation(Rotation rotation) {
        float f = class_3532.method_15362((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = class_3532.method_15374((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -class_3532.method_15362((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        float f3 = class_3532.method_15374((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        return new class_243((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Optional<Rotation> reachable(IEntityContext ctx, class_2338 pos) {
        return RotationUtils.reachable(ctx.entity(), pos, ctx.playerController().getBlockReachDistance());
    }

    public static Optional<Rotation> reachable(IEntityContext ctx, class_2338 pos, boolean wouldSneak) {
        return RotationUtils.reachable(ctx.entity(), pos, ctx.playerController().getBlockReachDistance(), wouldSneak);
    }

    public static Optional<Rotation> reachable(class_1309 entity, class_2338 pos, double blockReachDistance) {
        return RotationUtils.reachable(entity, pos, blockReachDistance, false);
    }

    public static Optional<Rotation> reachable(class_1309 entity, class_2338 pos, double blockReachDistance, boolean wouldSneak) {
        Optional<Rotation> possibleRotation;
        IBaritone baritone = BaritoneAPI.getProvider().getBaritone(entity);
        if (baritone.getEntityContext().isLookingAt(pos)) {
            Rotation hypothetical = new Rotation(entity.method_36454(), entity.method_36455() + 1.0E-4f);
            if (!wouldSneak) {
                return Optional.of(hypothetical);
            }
            class_239 result = RayTraceUtils.rayTraceTowards((class_1297)entity, hypothetical, blockReachDistance, true);
            if (result != null && result.method_17783() == class_239.class_240.field_1332 && ((class_3965)result).method_17777().equals((Object)pos)) {
                return Optional.of(hypothetical);
            }
        }
        if ((possibleRotation = RotationUtils.reachableCenter((class_1297)entity, pos, blockReachDistance, wouldSneak)).isPresent()) {
            return possibleRotation;
        }
        class_2680 state = entity.method_37908().method_8320(pos);
        class_265 shape = state.method_26218((class_1922)entity.method_37908(), pos);
        if (shape.method_1110()) {
            shape = class_259.method_1077();
        }
        for (class_243 sideOffset : BLOCK_SIDE_MULTIPLIERS) {
            double xDiff = shape.method_1091(class_2350.class_2351.field_11048) * sideOffset.field_1352 + shape.method_1105(class_2350.class_2351.field_11048) * (1.0 - sideOffset.field_1352);
            double yDiff = shape.method_1091(class_2350.class_2351.field_11052) * sideOffset.field_1351 + shape.method_1105(class_2350.class_2351.field_11052) * (1.0 - sideOffset.field_1351);
            double zDiff = shape.method_1091(class_2350.class_2351.field_11051) * sideOffset.field_1350 + shape.method_1105(class_2350.class_2351.field_11051) * (1.0 - sideOffset.field_1350);
            possibleRotation = RotationUtils.reachableOffset((class_1297)entity, pos, new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_1031(xDiff, yDiff, zDiff), blockReachDistance, wouldSneak);
            if (!possibleRotation.isPresent()) continue;
            return possibleRotation;
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableOffset(class_1297 entity, class_2338 pos, class_243 offsetPos, double blockReachDistance, boolean wouldSneak) {
        class_243 eyes = wouldSneak ? RayTraceUtils.inferSneakingEyePosition(entity) : entity.method_5836(1.0f);
        Rotation rotation = RotationUtils.calcRotationFromVec3d(eyes, offsetPos, new Rotation(entity.method_36454(), entity.method_36455()));
        class_239 result = RayTraceUtils.rayTraceTowards(entity, rotation, blockReachDistance, wouldSneak);
        if (result != null && result.method_17783() == class_239.class_240.field_1332) {
            if (((class_3965)result).method_17777().equals((Object)pos)) {
                return Optional.of(rotation);
            }
            if (entity.method_37908().method_8320(pos).method_26204() instanceof class_4770 && ((class_3965)result).method_17777().equals((Object)pos.method_10074())) {
                return Optional.of(rotation);
            }
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableCenter(class_1297 entity, class_2338 pos, double blockReachDistance, boolean wouldSneak) {
        return RotationUtils.reachableOffset(entity, pos, VecUtils.calculateBlockCenter(entity.method_37908(), pos), blockReachDistance, wouldSneak);
    }
}

