/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.command.defaults;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.command.Command;
import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.command.exception.CommandInvalidTypeException;
import com.player2.playerengine.automaton.api.command.helpers.Paginator;
import com.player2.playerengine.automaton.api.command.helpers.TabCompleteHelper;
import com.player2.playerengine.automaton.api.utils.SettingsUtil;
import com.player2.playerengine.automaton.command.argument.ArgConsumer;
import com.player2.playerengine.automaton.utils.SettingsLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class SetCommand
extends Command {
    public SetCommand() {
        super("set", "setting", "settings");
    }

    @Override
    public void execute(class_2168 source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
        boolean global;
        Settings settings;
        String arg;
        String string = arg = args.hasAny() ? args.getString().toLowerCase(Locale.ROOT) : "list";
        if (Arrays.asList("g", "global").contains(arg.toLowerCase(Locale.ROOT))) {
            settings = BaritoneAPI.getGlobalSettings();
            arg = args.hasAny() ? args.getString().toLowerCase(Locale.ROOT) : arg;
            global = true;
        } else {
            settings = baritone.settings();
            global = false;
        }
        if (Arrays.asList("s", "save").contains(arg)) {
            SettingsLoader.save(settings);
            this.logDirect(source, "Settings saved");
        } else {
            boolean paginate;
            boolean viewModified = Arrays.asList("m", "mod", "modified").contains(arg);
            boolean viewAll = Arrays.asList("all", "l", "list").contains(arg);
            boolean bl = paginate = viewModified || viewAll;
            if (paginate) {
                String search = args.hasAny() && args.peekAsOrNull(Integer.class) == null ? args.getString() : "";
                args.requireMax(1);
                List toPaginate = (viewModified ? SettingsUtil.modifiedSettings(settings) : settings.allSettings).stream().filter(s -> !s.getName().equals("logger")).filter(s -> s.getName().toLowerCase(Locale.US).contains(search.toLowerCase(Locale.US))).sorted((s1, s2) -> String.CASE_INSENSITIVE_ORDER.compare(s1.getName(), s2.getName())).collect(Collectors.toList());
                Paginator.paginate(args, new Paginator(source, toPaginate), () -> this.logDirect(source, !search.isEmpty() ? String.format("All %ssettings containing the string '%s':", viewModified ? "modified " : "", search) : String.format("All %ssettings:", viewModified ? "modified " : "")), settingx -> {
                    class_5250 typeComponent = class_2561.method_43470((String)String.format(" (%s)", SettingsUtil.settingTypeToString(settingx)));
                    typeComponent.method_10862(typeComponent.method_10866().method_27706(class_124.field_1063));
                    class_5250 hoverComponent = class_2561.method_43470((String)"");
                    hoverComponent.method_10862(hoverComponent.method_10866().method_27706(class_124.field_1080));
                    hoverComponent.method_27693(settingx.getName());
                    hoverComponent.method_27693(String.format("\nType: %s", SettingsUtil.settingTypeToString(settingx)));
                    hoverComponent.method_27693(String.format("\n\nValue:\n%s", SettingsUtil.settingValueToString(settingx)));
                    hoverComponent.method_27693(String.format("\n\nDefault Value:\n%s", SettingsUtil.settingDefaultToString(settingx)));
                    String commandSuggestion = "/automatone " + String.format("set %s%s ", global ? "global " : "", settingx.getName());
                    class_5250 component = class_2561.method_43470((String)settingx.getName());
                    component.method_10862(component.method_10866().method_27706(class_124.field_1080));
                    component.method_10852((class_2561)typeComponent);
                    component.method_10862(component.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverComponent)).method_10958(new class_2558(class_2558.class_2559.field_11745, commandSuggestion)));
                    return component;
                }, "/automatone set " + arg + " " + search);
            } else {
                boolean doingSomething;
                args.requireMax(1);
                boolean resetting = arg.equalsIgnoreCase("reset");
                boolean toggling = arg.equalsIgnoreCase("toggle");
                boolean bl2 = doingSomething = resetting || toggling;
                if (resetting) {
                    if (!args.hasAny()) {
                        this.logDirect(source, "Please specify 'all' as an argument to reset to confirm you'd really like to do this");
                        this.logDirect(source, "ALL settings will be reset. Use the 'set modified' or 'modified' commands to see what will be reset.");
                        this.logDirect(source, "Specify a setting name instead of 'all' to only reset one setting");
                    } else if (args.peekString().equalsIgnoreCase("all")) {
                        SettingsUtil.modifiedSettings(settings).forEach(Settings.Setting::reset);
                        this.logDirect(source, "All settings have been reset to their default values");
                        SettingsLoader.save(settings);
                        return;
                    }
                }
                if (toggling) {
                    args.requireMin(1);
                }
                String settingName = doingSomething ? args.getString() : arg;
                Settings.Setting setting = settings.allSettings.stream().filter(s -> s.getName().equalsIgnoreCase(settingName)).findFirst().orElse(null);
                if (setting == null) {
                    throw new CommandInvalidTypeException(args.consumed(), "a valid setting");
                }
                if (!doingSomething && !args.hasAny()) {
                    this.logDirect(source, String.format("Value of setting %s:", setting.getName()));
                    this.logDirect(source, SettingsUtil.settingValueToString(setting));
                } else {
                    String oldValue = SettingsUtil.settingValueToString(setting);
                    if (resetting) {
                        setting.reset();
                    } else if (toggling) {
                        Settings.Setting toggle;
                        if (setting.getValueClass() != Boolean.class) {
                            throw new CommandInvalidTypeException(args.consumed(), "a toggleable setting", "some other setting");
                        }
                        toggle.set((Boolean)(toggle = setting).get() == false);
                        this.logDirect(source, String.format("Toggled setting %s to %s", setting.getName(), setting.get()));
                    } else {
                        String newValue = args.getString();
                        try {
                            SettingsUtil.parseAndApply(settings, arg, newValue);
                        }
                        catch (Throwable var19) {
                            PlayerEngine.LOGGER.error((Object)var19);
                            throw new CommandInvalidTypeException(args.consumed(), "a valid value", var19);
                        }
                    }
                    if (!toggling) {
                        this.logDirect(source, String.format("Successfully %s %s to %s", resetting ? "reset" : "set", setting.getName(), SettingsUtil.settingValueToString(setting)));
                    }
                    class_5250 oldValueComponent = class_2561.method_43470((String)String.format("Old value: %s", oldValue));
                    oldValueComponent.method_10862(oldValueComponent.method_10866().method_27706(class_124.field_1080).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to set the setting back to this value"))).method_10958(new class_2558(class_2558.class_2559.field_11750, "/automatone " + String.format("set %s %s", setting.getName(), oldValue))));
                    this.logDirect(source, new class_2561[]{oldValueComponent});
                }
                SettingsLoader.save(settings);
            }
        }
    }

    @Override
    public Stream<String> tabComplete(String label, IArgConsumer args) throws CommandException {
        Settings settings = ((ArgConsumer)args).getBaritone().settings();
        if (args.hasAny()) {
            String arg = args.getString();
            if (Arrays.asList("g", "global").contains(arg.toLowerCase(Locale.ROOT))) {
                if (!args.hasAny()) {
                    return new TabCompleteHelper().addSettings(settings).sortAlphabetically().prepend("list", "modified", "reset", "toggle", "save").filterPrefix(arg).stream();
                }
                arg = args.getString();
            }
            if (args.hasExactlyOne() && !Arrays.asList("s", "save").contains(args.peekString().toLowerCase(Locale.ROOT))) {
                if (arg.equalsIgnoreCase("reset")) {
                    return new TabCompleteHelper().addModifiedSettings(settings).prepend("all").filterPrefix(args.getString()).stream();
                }
                if (arg.equalsIgnoreCase("toggle")) {
                    return new TabCompleteHelper().addToggleableSettings(settings).filterPrefix(args.getString()).stream();
                }
                Settings.Setting<?> setting = settings.byLowerName.get(arg.toLowerCase(Locale.US));
                if (setting != null) {
                    if (setting.getType() == Boolean.class) {
                        TabCompleteHelper helper = new TabCompleteHelper();
                        if (((Boolean)setting.get()).booleanValue()) {
                            helper.append("true", "false");
                        } else {
                            helper.append("false", "true");
                        }
                        return helper.filterPrefix(args.getString()).stream();
                    }
                    return Stream.of(SettingsUtil.settingValueToString(setting));
                }
            } else if (!args.hasAny()) {
                return new TabCompleteHelper().addSettings(settings).sortAlphabetically().prepend("list", "modified", "reset", "toggle", "save").prepend("global").filterPrefix(arg).stream();
            }
        }
        return Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "View or change settings";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("Using the set command, you can manage all of Baritone's settings. Almost every aspect is controlled by these settings - go wild!", "", "Usage:", "> set - Same as `set list`", "> set list [page] - View all settings", "> set modified [page] - View modified settings", "> set <setting> - View the current value of a setting", "> set <setting> <value> - Set the value of a setting", "> set reset all - Reset ALL SETTINGS to their defaults", "> set reset <setting> - Reset a setting to its default", "> set toggle <setting> - Toggle a boolean setting", "> set save - Save all settings (this is automatic tho)");
    }
}

