/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.process;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalBlock;
import com.player2.playerengine.automaton.api.pathing.goals.GoalComposite;
import com.player2.playerengine.automaton.api.process.IFarmProcess;
import com.player2.playerengine.automaton.api.process.PathingCommand;
import com.player2.playerengine.automaton.api.process.PathingCommandType;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.api.utils.interfaces.IGoalRenderPos;
import com.player2.playerengine.automaton.cache.WorldScanner;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.process.BuilderProcess;
import com.player2.playerengine.automaton.utils.BaritoneProcessHelper;
import com.player2.playerengine.automaton.utils.NotificationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2266;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2421;
import net.minecraft.class_243;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public final class FarmProcess
extends BaritoneProcessHelper
implements IFarmProcess {
    private boolean active;
    private List<class_2338> locations;
    private int tickCount;
    private int range;
    private class_2338 center;
    private static final List<class_1792> FARMLAND_PLANTABLE = Arrays.asList(class_1802.field_8309, class_1802.field_46250, class_1802.field_8317, class_1802.field_46249, class_1802.field_8567, class_1802.field_8179);
    private static final List<class_1792> PICKUP_DROPPED = Arrays.asList(class_1802.field_8309, class_1802.field_8186, class_1802.field_46250, class_1802.field_8497, class_2246.field_46283.method_8389(), class_1802.field_8317, class_1802.field_8861, class_1802.field_46249, class_2246.field_46282.method_8389(), class_1802.field_8567, class_1802.field_8179, class_1802.field_8790, class_2246.field_10424.method_8389(), class_2246.field_10029.method_8389());

    public FarmProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void farm(int range, class_2338 pos) {
        this.center = pos == null ? this.baritone.getEntityContext().feetPos() : pos;
        this.range = range;
        this.active = true;
        this.locations = null;
    }

    private boolean readyForHarvest(class_1937 world, class_2338 pos, class_2680 state) {
        for (Harvest harvest : Harvest.values()) {
            if (harvest.block != state.method_26204()) continue;
            return harvest.readyToHarvest(world, pos, state, this.baritone.settings());
        }
        return false;
    }

    private boolean isPlantable(class_1799 stack) {
        return FARMLAND_PLANTABLE.contains(stack.method_7909());
    }

    private boolean isBoneMeal(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909().equals(class_1802.field_8324);
    }

    private boolean isNetherWart(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909().equals(class_1802.field_8790);
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        ArrayList<class_2248> scan = new ArrayList<class_2248>();
        for (Harvest harvest : Harvest.values()) {
            scan.add(harvest.block);
        }
        if (this.baritone.settings().replantCrops.get().booleanValue()) {
            scan.add(class_2246.field_10362);
            if (this.baritone.settings().replantNetherWart.get().booleanValue()) {
                scan.add(class_2246.field_10114);
            }
        }
        if (this.baritone.settings().mineGoalUpdateInterval.get() != 0 && this.tickCount++ % this.baritone.settings().mineGoalUpdateInterval.get() == 0) {
            PlayerEngine.getExecutor().execute(() -> {
                this.locations = WorldScanner.INSTANCE.scanChunkRadius(this.ctx, scan, 256, 10, 10);
            });
        }
        if (this.locations == null) {
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<class_2338> toBreak = new ArrayList<class_2338>();
        ArrayList<class_2338> openFarmland = new ArrayList<class_2338>();
        ArrayList<class_2338> bonemealable = new ArrayList<class_2338>();
        ArrayList<class_2338> openSoulsand = new ArrayList<class_2338>();
        for (class_2338 class_23382 : this.locations) {
            class_2256 ig;
            if (this.range != 0 && class_23382.method_10262((class_2382)this.center) > (double)(this.range * this.range)) continue;
            class_2680 state = this.ctx.world().method_8320(class_23382);
            boolean airAbove = this.ctx.world().method_8320(class_23382.method_10084()).method_26204() instanceof class_2189;
            if (state.method_26204() == class_2246.field_10362) {
                if (!airAbove) continue;
                openFarmland.add(class_23382);
                continue;
            }
            if (state.method_26204() == class_2246.field_10114) {
                if (!airAbove) continue;
                openSoulsand.add(class_23382);
                continue;
            }
            if (this.readyForHarvest((class_1937)this.ctx.world(), class_23382, state)) {
                toBreak.add(class_23382);
                continue;
            }
            if (!(state.method_26204() instanceof class_2256) || !(ig = (class_2256)state.method_26204()).method_9651((class_4538)this.ctx.world(), class_23382, state) || !ig.method_9650((class_1937)this.ctx.world(), this.ctx.world().field_9229, class_23382, state)) continue;
            bonemealable.add(class_23382);
        }
        this.baritone.getInputOverrideHandler().clearAllKeys();
        for (class_2338 class_23383 : toBreak) {
            Optional<Rotation> rot = RotationUtils.reachable(this.ctx, class_23383);
            if (!rot.isPresent() || !isSafeToCancel) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            MovementHelper.switchToBestToolFor(this.ctx, this.ctx.world().method_8320(class_23383));
            if (this.ctx.isLookingAt(class_23383)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<class_2338> both = new ArrayList<class_2338>(openFarmland);
        both.addAll(openSoulsand);
        for (class_2338 posxx : both) {
            class_239 result;
            boolean soulsand = openSoulsand.contains(posxx);
            Optional<Rotation> rot = RotationUtils.reachableOffset((class_1297)this.ctx.entity(), posxx, new class_243((double)posxx.method_10263() + 0.5, (double)(posxx.method_10264() + 1), (double)posxx.method_10260() + 0.5), this.ctx.playerController().getBlockReachDistance(), false);
            if (!rot.isPresent() || !isSafeToCancel || !this.baritone.getInventoryBehavior().throwaway(true, soulsand ? this::isNetherWart : this::isPlantable) || !((result = RayTraceUtils.rayTraceTowards((class_1297)this.ctx.entity(), rot.get(), this.ctx.playerController().getBlockReachDistance())) instanceof class_3965) || ((class_3965)result).method_17780() != class_2350.field_11036) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            if (this.ctx.isLookingAt(posxx)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        for (class_2338 posxxx : bonemealable) {
            Optional<Rotation> rot = RotationUtils.reachable(this.ctx, posxxx);
            if (!rot.isPresent() || !isSafeToCancel || !this.baritone.getInventoryBehavior().throwaway(true, this::isBoneMeal)) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            if (this.ctx.isLookingAt(posxxx)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        if (calcFailed) {
            this.logDirect("Farm failed");
            if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnFarmFail.get().booleanValue()) {
                NotificationHelper.notify("Farm failed", true);
            }
            this.onLostControl();
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<IGoalRenderPos> arrayList = new ArrayList<IGoalRenderPos>();
        for (class_2338 posxxxx : toBreak) {
            arrayList.add(new BuilderProcess.GoalBreak(posxxxx));
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isPlantable)) {
            for (class_2338 posxxxx : openFarmland) {
                arrayList.add(new GoalBlock(posxxxx.method_10084()));
            }
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isNetherWart)) {
            for (class_2338 posxxxx : openSoulsand) {
                arrayList.add(new GoalBlock(posxxxx.method_10084()));
            }
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isBoneMeal)) {
            for (class_2338 posxxxx : bonemealable) {
                arrayList.add(new GoalBlock(posxxxx));
            }
        }
        for (class_1542 item : this.ctx.world().method_8390(class_1542.class, this.ctx.entity().method_5829().method_1014(30.0), class_1297::method_24828)) {
            if (!PICKUP_DROPPED.contains(item.method_6983().method_7909())) continue;
            arrayList.add(new GoalBlock(class_2338.method_49637((double)item.method_23317(), (double)(item.method_23318() + 0.1), (double)item.method_23321())));
        }
        return arrayList.isEmpty() ? new PathingCommand(null, PathingCommandType.REQUEST_PAUSE) : new PathingCommand(new GoalComposite(arrayList.toArray(new Goal[0])), PathingCommandType.SET_GOAL_AND_PATH);
    }

    @Override
    public void onLostControl() {
        this.active = false;
    }

    @Override
    public String displayName0() {
        return "Farming";
    }

    private static enum Harvest {
        WHEAT((class_2302)class_2246.field_10293),
        CARROTS((class_2302)class_2246.field_10609),
        POTATOES((class_2302)class_2246.field_10247),
        BEETROOT((class_2302)class_2246.field_10341),
        PUMPKIN(class_2246.field_46282, state -> true),
        MELON(class_2246.field_46283, state -> true),
        NETHERWART(class_2246.field_9974, state -> (Integer)state.method_11654((class_2769)class_2421.field_11306) >= 3),
        SUGARCANE(class_2246.field_10424, null){

            @Override
            public boolean readyToHarvest(class_1937 world, class_2338 pos, class_2680 state, Settings settings) {
                return settings.replantCrops.get() != false ? world.method_8320(pos.method_10074()).method_26204() instanceof class_2523 : true;
            }
        }
        ,
        CACTUS(class_2246.field_10029, null){

            @Override
            public boolean readyToHarvest(class_1937 world, class_2338 pos, class_2680 state, Settings settings) {
                return settings.replantCrops.get() != false ? world.method_8320(pos.method_10074()).method_26204() instanceof class_2266 : true;
            }
        };

        public final class_2248 block;
        public final Predicate<class_2680> readyToHarvest;

        private Harvest(class_2302 blockCrops) {
            this((class_2248)blockCrops, arg_0 -> ((class_2302)blockCrops).method_9825(arg_0));
        }

        private Harvest(class_2248 block, Predicate<class_2680> readyToHarvest) {
            this.block = block;
            this.readyToHarvest = readyToHarvest;
        }

        public boolean readyToHarvest(class_1937 world, class_2338 pos, class_2680 state, Settings settings) {
            return this.readyToHarvest.test(state);
        }
    }
}

