/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils.schematic.format.defaults;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.utils.schematic.StaticSchematic;
import com.player2.playerengine.automaton.utils.type.VarInt;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class SpongeSchematic
extends StaticSchematic {
    public SpongeSchematic(class_2487 nbt) {
        this.x = nbt.method_10550("Width");
        this.y = nbt.method_10550("Height");
        this.z = nbt.method_10550("Length");
        this.states = new class_2680[this.x][this.z][this.y];
        Int2ObjectArrayMap palette = new Int2ObjectArrayMap();
        class_2487 paletteTag = nbt.method_10562("Palette");
        for (String tag : paletteTag.method_10541()) {
            int index = paletteTag.method_10550(tag);
            SerializedBlockState serializedState = SerializedBlockState.getFromString(tag);
            if (serializedState == null) {
                throw new IllegalArgumentException("Unable to parse palette tag");
            }
            class_2680 state = serializedState.deserialize();
            if (state == null) {
                throw new IllegalArgumentException("Unable to deserialize palette tag");
            }
            palette.put(index, (Object)state);
        }
        byte[] rawBlockData = nbt.method_10547("BlockData");
        int[] blockData = new int[this.x * this.y * this.z];
        int offset = 0;
        for (int i = 0; i < blockData.length; ++i) {
            if (offset >= rawBlockData.length) {
                throw new IllegalArgumentException("No remaining bytes in BlockData for complete schematic");
            }
            VarInt varInt = VarInt.read(rawBlockData, offset);
            blockData[i] = varInt.getValue();
            offset += varInt.getSize();
        }
        for (int y = 0; y < this.y; ++y) {
            for (int z = 0; z < this.z; ++z) {
                for (int x = 0; x < this.x; ++x) {
                    int indexx = (y * this.z + z) * this.x + x;
                    class_2680 state = (class_2680)palette.get(blockData[indexx]);
                    if (state == null) {
                        throw new IllegalArgumentException("Invalid Palette Index " + indexx);
                    }
                    this.states[x][z][y] = state;
                }
            }
        }
    }

    private static final class SerializedBlockState {
        private static final Pattern REGEX = Pattern.compile("(?<location>(\\w+:)?\\w+)(\\[(?<properties>(\\w+=\\w+,?)+)])?");
        private final class_2960 resourceLocation;
        private final Map<String, String> properties;
        private class_2680 blockState;

        private SerializedBlockState(class_2960 resourceLocation, Map<String, String> properties) {
            this.resourceLocation = resourceLocation;
            this.properties = properties;
        }

        private class_2680 deserialize() {
            if (this.blockState == null) {
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(this.resourceLocation);
                this.blockState = block.method_9564();
                this.properties.keySet().stream().sorted(String::compareTo).forEachOrdered(key -> {
                    class_2769 property = block.method_9595().method_11663(key);
                    if (property != null) {
                        this.blockState = SerializedBlockState.setPropertyValue(this.blockState, property, this.properties.get(key));
                    }
                });
            }
            return this.blockState;
        }

        private static SerializedBlockState getFromString(String s) {
            Matcher m = REGEX.matcher(s);
            if (!m.matches()) {
                return null;
            }
            try {
                String location = m.group("location");
                String properties = m.group("properties");
                class_2960 resourceLocation = class_2960.method_12829((String)location);
                HashMap<String, String> propertiesMap = new HashMap<String, String>();
                if (properties != null) {
                    for (String property : properties.split(",")) {
                        String[] split = property.split("=");
                        propertiesMap.put(split[0], split[1]);
                    }
                }
                return new SerializedBlockState(resourceLocation, propertiesMap);
            }
            catch (Exception var11) {
                PlayerEngine.LOGGER.error((Object)var11);
                return null;
            }
        }

        private static <T extends Comparable<T>> class_2680 setPropertyValue(class_2680 state, class_2769<T> property, String value) {
            Optional parsed = property.method_11900(value);
            if (parsed.isPresent()) {
                return (class_2680)state.method_11657(property, (Comparable)parsed.get());
            }
            throw new IllegalArgumentException("Invalid value for property " + String.valueOf(property));
        }
    }
}

